/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNodeGroup;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.Orientation;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class PrimitiveNode
implements NodeProto,
Comparable<PrimitiveNode>,
Serializable {
    public static final int NORMAL = 0;
    public static final int SERPTRANS = 1;
    public static final int POLYGONAL = 2;
    private static final int NODESHRINK = 1;
    public static final int LOWVTBIT = 8;
    public static final int HIGHVTBIT = 16;
    public static final int NATIVEBIT = 32;
    public static final int OD18BIT = 64;
    public static final int OD25BIT = 128;
    public static final int OD33BIT = 256;
    private static final int ARCSWIPE = 512;
    private static final int NSQUARE = 1024;
    private static final int HOLDSTRACE = 2048;
    private static final int CANBEZEROSIZE = 4096;
    private static final int WIPEON1OR2 = 8192;
    private static final int LOCKEDPRIM = 16384;
    private static final int NEDGESELECT = 32768;
    private static final int ARCSHRINK = 65536;
    private static final int PARTIALCIRCLE = 131072;
    private static final int SKIPSIZEINPALETTE = 262144;
    private static final int NNOTUSED = 524288;
    public static final int CURVEPIN = 0x100000;
    public static final int CROSSCONTACT = 0x200000;
    public static final int ALIGNCONTACT = 0x400000;
    private final PrimitiveNodeId protoId;
    private final Technology tech;
    PrimitiveNodeGroup group;
    private Function function;
    private Technology.NodeLayer[] layers;
    private Technology.NodeLayer[] electricalLayers;
    private PrimitivePort[] primPorts = new PrimitivePort[0];
    private PrimitivePort[] portsByChronIndex = new PrimitivePort[0];
    private int userBits;
    private int techPrimNodeIndex = -1;
    private double[] specialValues;
    private int numMultiCuts;
    private NodeSizeRule minNodeSize;
    private final EPoint[] sizeCorrectors = new EPoint[]{EPoint.ORIGIN, EPoint.ORIGIN};
    private SizeOffset offset;
    private ERectangle baseRectangle;
    private ERectangle fullRectangle;
    private EDimension autoGrowth;
    private String spiceTemplate;
    private ImmutableNodeInst factoryDefaultInst;
    private EDimension factoryDefaultBaseDimension;
    private static final String[] nodeBits = new String[]{"NODESHRINK", null, null, "LOWVTBIT", "HIGHVTBIT", "NATIVEBIT", "OD18BIT", "OD25BIT", "OD33BIT", "ARCSWIPE", "NSQUARE", "HOLDSTRACE", "CANBEZEROSIZE", "WIPEON1OR2", "LOCKEDPRIM", "NEDGESELECT", "ARCSHRINK", "PARTIALCIRCLE", "SKIPSIZEINPALETTE", "NNOTUSED", "CURVEPIN"};

    protected PrimitiveNode(String protoName, Technology tech, EPoint fullSizeCorrector, double defWidth, double defHeight, ERectangle baseRectangle, Technology.NodeLayer[] layers) {
        this(protoName, tech, fullSizeCorrector, EPoint.fromGrid(baseRectangle.getGridWidth() >> 1, baseRectangle.getGridHeight() >> 1), null, defWidth, defHeight, ERectangle.fromGrid(-fullSizeCorrector.getGridX(), -fullSizeCorrector.getGridY(), 2L * fullSizeCorrector.getGridX(), 2L * fullSizeCorrector.getGridY()), baseRectangle, layers);
    }

    protected PrimitiveNode(String protoName, Technology tech, EPoint sizeCorrector1, EPoint sizeCorrector2, String minSizeRule, double defWidth, double defHeight, ERectangle fullRectangle, ERectangle baseRectangle, Technology.NodeLayer[] layers) {
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("PrimitiveNode name " + protoName + " is not safe to write in the JELIB");
        }
        this.protoId = tech.getId().newPrimitiveNodeId(protoName);
        this.function = Function.UNKNOWN;
        this.tech = tech;
        this.layers = layers;
        this.electricalLayers = null;
        this.userBits = 0;
        this.sizeCorrectors[0] = sizeCorrector1;
        this.sizeCorrectors[1] = sizeCorrector2;
        this.fullRectangle = fullRectangle;
        this.baseRectangle = baseRectangle;
        if (minSizeRule != null) {
            this.minNodeSize = new NodeSizeRule(minSizeRule);
        }
        assert (defWidth >= 0.0 && defHeight >= 0.0);
        double factoryExtendX = DBMath.round(0.5 * (defWidth - fullRectangle.getLambdaWidth()));
        double factoryExtendY = DBMath.round(0.5 * (defHeight - fullRectangle.getLambdaHeight()));
        EPoint factorySize = EPoint.fromLambda(factoryExtendX * 2.0, factoryExtendY * 2.0);
        this.factoryDefaultInst = ImmutableNodeInst.newInstance(0, this.protoId, this.function.getBasename(), null, Orientation.IDENT, EPoint.ORIGIN, factorySize, 0, 0, null);
        this.factoryDefaultBaseDimension = new EDimension(baseRectangle.getCoordWidth().add(factorySize.getCoordX()), baseRectangle.getCoordHeight().add(factorySize.getCoordY()));
        double lx = baseRectangle.getLambdaMinX() - fullRectangle.getLambdaMinX();
        double hx = fullRectangle.getLambdaMaxX() - baseRectangle.getLambdaMaxX();
        double ly = baseRectangle.getLambdaMinY() - fullRectangle.getLambdaMinY();
        double hy = fullRectangle.getLambdaMaxY() - baseRectangle.getLambdaMaxY();
        this.offset = new SizeOffset(lx, hx, ly, hy);
        this.autoGrowth = null;
        int numMultiCuts = 0;
        for (Technology.NodeLayer nodeLayer : layers) {
            if (nodeLayer.getRepresentation() != 3) continue;
            ++numMultiCuts;
        }
        this.numMultiCuts = numMultiCuts;
        tech.addNodeProto(this);
        this.check();
    }

    protected Object writeReplace() {
        return new PrimitiveNodeKey(this);
    }

    public static PrimitiveNode newInstance(String protoName, Technology tech, double width, double height, Technology.NodeLayer[] layers) {
        EPoint sizeCorrector = EPoint.fromLambda(0.5 * width, 0.5 * height);
        ERectangle baseRectangle = ERectangle.fromGrid(-sizeCorrector.getGridX(), -sizeCorrector.getGridY(), 2L * sizeCorrector.getGridX(), 2L * sizeCorrector.getGridY());
        return new PrimitiveNode(protoName, tech, sizeCorrector, width, height, baseRectangle, layers);
    }

    public static PrimitiveNode newInstance(String protoName, Technology tech, double width, double height, ERectangle baseRectangle, Technology.NodeLayer[] layers) {
        EPoint sizeCorrector = EPoint.fromLambda(0.5 * width, 0.5 * height);
        return new PrimitiveNode(protoName, tech, sizeCorrector, width, height, baseRectangle, layers);
    }

    @Override
    public PrimitiveNodeId getId() {
        return this.protoId;
    }

    @Override
    public String getName() {
        return this.protoId.name;
    }

    public String getFullName() {
        return this.protoId.fullName;
    }

    public void setFunction(Function function) {
        this.checkChanging();
        this.function = function;
    }

    @Override
    public Function getFunction() {
        return this.function;
    }

    public Function getGroupFunction() {
        if (this.function.isTransistor) {
            return Function.TRANS;
        }
        if (this.function.isResistor() || this.function.isCapacitor() || this.function == Function.DIODE || this.function == Function.DIODEZ || this.function == Function.INDUCT) {
            return Function.INDUCT;
        }
        if (this.function == Function.CCVS || this.function == Function.CCCS || this.function == Function.VCVS || this.function == Function.VCCS || this.function == Function.TLINE) {
            return Function.TLINE;
        }
        if (this.function == Function.BASE || this.function == Function.EMIT || this.function == Function.COLLECT) {
            return Function.COLLECT;
        }
        if (this.function == Function.BUFFER || this.function == Function.GATEAND || this.function == Function.GATEOR || this.function == Function.MUX || this.function == Function.GATEXOR) {
            return Function.GATEXOR;
        }
        if (this.function == Function.CONPOWER || this.function == Function.CONGROUND) {
            return Function.CONGROUND;
        }
        if (this.function == Function.METER || this.function == Function.SOURCE) {
            return Function.SOURCE;
        }
        if (this.function == Function.SUBSTRATE || this.function == Function.WELL) {
            return Function.CONTACT;
        }
        return this.function;
    }

    public Function getPrimitiveFunction(int techBits) {
        return this.function;
    }

    public int getPrimitiveFunctionBits(Function function) {
        return 0;
    }

    public boolean isTechSpecific() {
        return false;
    }

    public Technology.NodeLayer[] getNodeLayers() {
        return this.layers;
    }

    public Iterator<Layer> getLayerIterator() {
        return new NodeLayerIterator(this.layers);
    }

    public Technology.NodeLayer[] getElectricalLayers() {
        return this.electricalLayers;
    }

    public void setElectricalLayers(Technology.NodeLayer[] electricalLayers) {
        this.electricalLayers = electricalLayers;
    }

    public Technology.NodeLayer findNodeLayer(Layer layer, boolean electrical) {
        Technology.NodeLayer[] nodes;
        Technology.NodeLayer[] nodeLayerArray = nodes = electrical ? this.electricalLayers : this.layers;
        if (nodes != null) {
            for (int j = 0; j < nodes.length; ++j) {
                Technology.NodeLayer oneLayer = nodes[j];
                if (oneLayer.getLayer() != layer) continue;
                return oneLayer;
            }
        }
        return null;
    }

    public boolean hasMultiCuts() {
        return this.numMultiCuts > 0;
    }

    public Technology.NodeLayer findMulticut() {
        for (Technology.NodeLayer nl : this.layers) {
            if (nl.getRepresentation() != 3) continue;
            return nl;
        }
        return null;
    }

    public boolean isMulticut() {
        return this.numMultiCuts == 1;
    }

    public double getDefWidth() {
        return this.getDefWidth(EditingPreferences.getInstance());
    }

    @Override
    public double getDefWidth(EditingPreferences ep) {
        return DBMath.gridToLambda(this.fullRectangle.getGridWidth() + this.getDefSize(ep).getGridX());
    }

    public double getDefHeight() {
        return this.getDefHeight(EditingPreferences.getInstance());
    }

    @Override
    public double getDefHeight(EditingPreferences ep) {
        return DBMath.gridToLambda(this.fullRectangle.getGridHeight() + this.getDefSize(ep).getGridY());
    }

    @Override
    public EPoint getDefSize(EditingPreferences ep) {
        return this.getDefaultInst((EditingPreferences)ep).size;
    }

    public double getDefaultLambdaBaseWidth(EditingPreferences ep) {
        return DBMath.gridToLambda(this.getDefaultGridBaseWidth(ep));
    }

    public double getDefaultLambdaBaseHeight(EditingPreferences ep) {
        return DBMath.gridToLambda(this.getDefaultGridBaseHeight(ep));
    }

    public long getDefaultGridBaseWidth(EditingPreferences ep) {
        return this.baseRectangle.getGridWidth() + this.getDefaultInst((EditingPreferences)ep).size.getGridX();
    }

    public long getDefaultGridBaseHeight(EditingPreferences ep) {
        return this.baseRectangle.getGridHeight() + this.getDefaultInst((EditingPreferences)ep).size.getGridY();
    }

    public EDimension getFactoryDefaultBaseDimension() {
        return this.factoryDefaultBaseDimension;
    }

    public EPoint getFactoryDefaultSize() {
        return this.factoryDefaultInst.size;
    }

    public ImmutableNodeInst getDefaultInst(EditingPreferences ep) {
        ImmutableNodeInst defaultInst = ep.getDefaultNode(this.protoId);
        return defaultInst != null ? defaultInst : this.factoryDefaultInst;
    }

    public ImmutableNodeInst getFactoryDefaultInst() {
        return this.factoryDefaultInst;
    }

    @Override
    public SizeOffset getProtoSizeOffset() {
        return this.offset;
    }

    public ERectangle getBaseRectangle() {
        return this.baseRectangle;
    }

    public ERectangle getFullRectangle() {
        return this.fullRectangle;
    }

    EPoint getSizeCorrector(int version) {
        return this.sizeCorrectors[version];
    }

    EPoint getMinimumSize() {
        double minX = -this.baseRectangle.getWidth();
        double minY = -this.baseRectangle.getHeight();
        for (PrimitivePort pp : this.primPorts) {
            double y;
            double x;
            double lm = pp.getLeft().getMultiplier();
            double rm = pp.getRight().getMultiplier();
            assert (lm <= rm);
            if (lm < rm && (x = -pp.getRight().getAdder().subtract(pp.getLeft().getAdder()).getLambda() / (rm - lm)) > minX) {
                minX = x;
            }
            double bm = pp.getBottom().getMultiplier();
            double tm = pp.getTop().getMultiplier();
            assert (bm <= tm);
            if (!(bm < tm) || !((y = -pp.getTop().getAdder().subtract(pp.getBottom().getAdder()).getLambda() / (tm - bm)) > minY)) continue;
            minY = y;
        }
        return EPoint.fromLambda(minX, minY);
    }

    public NodeSizeRule getMinSizeRule() {
        return this.minNodeSize;
    }

    public void setMinSize(double minWidth, double minHeight, String minSizeRule) {
        this.setSizeCorrector(minWidth, minHeight);
        this.minNodeSize = DBMath.areEquals(minWidth, minHeight) ? new NodeSizeRule(minSizeRule) : new AsymmetricNodeSizeRule(minSizeRule);
        this.check();
    }

    private void setSizeCorrector(double refWidth, double refHeight) {
        long extendX = DBMath.lambdaToGrid(0.5 * refWidth);
        long extendY = DBMath.lambdaToGrid(0.5 * refHeight);
        this.sizeCorrectors[0] = EPoint.fromGrid(extendX, extendY);
        this.fullRectangle = ERectangle.fromGrid(-extendX, -extendY, 2L * extendX, 2L * extendY);
        long lx = this.fullRectangle.getGridMinX() + this.offset.getLowXGridOffset();
        long hx = this.fullRectangle.getGridMaxX() - this.offset.getHighXGridOffset();
        long ly = this.fullRectangle.getGridMinY() + this.offset.getLowYGridOffset();
        long hy = this.fullRectangle.getGridMaxY() - this.offset.getHighYGridOffset();
        this.baseRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
        this.sizeCorrectors[1] = EPoint.fromGrid(this.baseRectangle.getGridWidth() >> 1, this.baseRectangle.getGridHeight() >> 1);
        this.check();
    }

    public void setSizeOffset(SizeOffset offset) {
        this.offset = offset;
        long lx = this.fullRectangle.getGridMinX() + offset.getLowXGridOffset();
        long hx = this.fullRectangle.getGridMaxX() - offset.getHighXGridOffset();
        long ly = this.fullRectangle.getGridMinY() + offset.getLowYGridOffset();
        long hy = this.fullRectangle.getGridMaxY() - offset.getHighYGridOffset();
        this.baseRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
        this.sizeCorrectors[1] = EPoint.fromGrid(this.baseRectangle.getGridWidth() >> 1, this.baseRectangle.getGridHeight() >> 1);
        this.check();
    }

    public void setAutoGrowth(double dX, double dY) {
        this.autoGrowth = new EDimension(dX, dY);
    }

    public EDimension getAutoGrowth() {
        return this.autoGrowth;
    }

    public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
        Technology.NodeLayer[] eLayers;
        assert (n.protoId == this.getId());
        if (b.isWipePins()) {
            if (this.isArcsWipe() && b.isWiped(n)) {
                return;
            }
            if (this.isWipeOn1or2() && b.pinUseCount(n)) {
                return;
            }
        }
        Technology.NodeLayer[] primLayers = this.getNodeLayers();
        if (b.isElectrical() && (eLayers = this.getElectricalLayers()) != null) {
            primLayers = eLayers;
        }
        b.genShapeOfNode(n, this, primLayers, null);
    }

    public void genBounds(ImmutableNodeInst n, long[] gridCoords) {
        long gridH2;
        long gridW2;
        ERectangle full = this.getFullRectangle();
        if (full.getGridMinX() != -full.getGridMaxX() || full.getGridMinY() != -full.getGridMaxY()) {
            long halfSizeX = n.size.getGridX() >> 1;
            long halfSizeY = n.size.getGridY() >> 1;
            gridCoords[0] = full.getGridMinX() - halfSizeX;
            gridCoords[1] = full.getGridMinY() - halfSizeY;
            gridCoords[2] = full.getGridMaxX() + halfSizeX;
            gridCoords[3] = full.getGridMaxY() + halfSizeY;
            n.orient.rectangleBounds(gridCoords);
            long anchorX = n.anchor.getGridX();
            long anchorY = n.anchor.getGridY();
            gridCoords[0] = gridCoords[0] + anchorX;
            gridCoords[1] = gridCoords[1] + anchorY;
            gridCoords[2] = gridCoords[2] + anchorX;
            gridCoords[3] = gridCoords[3] + anchorY;
            return;
        }
        long gridWidth = n.size.getGridX() + full.getGridWidth();
        long gridHeight = n.size.getGridY() + full.getGridHeight();
        if (gridWidth == 0L && gridHeight == 0L) {
            gridCoords[0] = gridCoords[2] = n.anchor.getGridX();
            gridCoords[1] = gridCoords[3] = n.anchor.getGridY();
            return;
        }
        if (n.orient.isManhattan()) {
            gridCoords[0] = gridWidth >> 1;
            gridCoords[1] = gridHeight >> 1;
            n.orient.transformPoints(1, gridCoords);
            gridW2 = Math.abs(gridCoords[0]);
            gridH2 = Math.abs(gridCoords[1]);
        } else {
            long fixpW2 = gridWidth << 19;
            long fixpH2 = gridHeight << 19;
            long[] fixpCoords = gridCoords;
            fixpCoords[0] = -fixpW2;
            fixpCoords[1] = -fixpH2;
            fixpCoords[2] = fixpW2;
            fixpCoords[3] = fixpH2;
            n.orient.rectangleBounds(fixpCoords);
            gridW2 = -(fixpCoords[0] >> 20);
            gridH2 = -(fixpCoords[0] >> 20);
        }
        long gridAnchorX = n.anchor.getGridX();
        long gridAnchorY = n.anchor.getGridY();
        gridCoords[0] = gridAnchorX - gridW2;
        gridCoords[1] = gridAnchorY - gridH2;
        gridCoords[2] = gridAnchorX + gridW2;
        gridCoords[3] = gridAnchorY + gridH2;
    }

    public void genElibBounds(CellBackup cellBackup, ImmutableNodeInst n, long[] gridCoords) {
        ERectangle full = this.getFullRectangle();
        if (full.getGridMinX() == -full.getGridMaxX() && full.getGridMinY() == -full.getGridMaxY()) {
            CellRevision cellRevision;
            long gridWidth = n.size.getGridX() + full.getGridWidth();
            long gridHeight = n.size.getGridY() + full.getGridHeight();
            if (gridWidth == 0L && gridHeight == 0L) {
                gridCoords[0] = gridCoords[2] = n.anchor.getGridX();
                gridCoords[1] = gridCoords[3] = n.anchor.getGridY();
                return;
            }
            if (this.isWipeOn1or2() && cellBackup != null && !(cellRevision = cellBackup.cellRevision).hasExportsOnNode(n) && cellRevision.pinUseCount(n)) {
                gridCoords[0] = gridCoords[2] = n.anchor.getGridX();
                gridCoords[1] = gridCoords[3] = n.anchor.getGridY();
                return;
            }
        }
        this.genBounds(n, gridCoords);
    }

    public void setSpiceTemplate(String st) {
        this.spiceTemplate = st;
    }

    public String getSpiceTemplate() {
        return this.spiceTemplate;
    }

    @Override
    public Technology getTechnology() {
        return this.tech;
    }

    public PrimitiveNodeGroup getPrimitiveNodeGroup() {
        return this.group;
    }

    public void addPrimitivePorts(PrimitivePort ... ports) {
        assert (ports.length == this.primPorts.length);
        for (int i = 0; i < this.primPorts.length; ++i) {
            assert (this.primPorts[i] == ports[i]);
            assert (this.primPorts[i].getPortIndex() == i);
            assert (this.primPorts[i].getId().externalId.isEmpty() == (ports.length == 1));
        }
        this.check();
    }

    void addPrimitivePort(PrimitivePort pp) {
        assert (pp.getParent() == this);
        assert (pp.getPortIndex() == this.primPorts.length);
        PrimitivePort[] newPrimPorts = new PrimitivePort[this.primPorts.length + 1];
        System.arraycopy(this.primPorts, 0, newPrimPorts, 0, this.primPorts.length);
        newPrimPorts[pp.getPortIndex()] = pp;
        this.primPorts = newPrimPorts;
        PrimitivePortId primitivePortId = pp.getId();
        if (primitivePortId.chronIndex >= this.portsByChronIndex.length) {
            PrimitivePort[] newPortsByChronIndex = new PrimitivePort[primitivePortId.chronIndex + 1];
            System.arraycopy(this.portsByChronIndex, 0, newPortsByChronIndex, 0, this.portsByChronIndex.length);
            this.portsByChronIndex = newPortsByChronIndex;
        }
        this.portsByChronIndex[primitivePortId.chronIndex] = pp;
    }

    @Override
    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    @Override
    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.primPorts.length; ++i) {
            PrimitivePort pp = this.primPorts[i];
            if (pp.getNameKey() != name) continue;
            return pp;
        }
        return null;
    }

    PrimitivePort getPrimitivePortByChronIndex(int chronIndex) {
        return chronIndex < this.portsByChronIndex.length ? this.portsByChronIndex[chronIndex] : null;
    }

    @Override
    public Iterator<PortProto> getPorts() {
        return ArrayIterator.iterator((PortProto[])this.primPorts);
    }

    public Iterator<PrimitivePort> getPrimitivePorts() {
        return ArrayIterator.iterator(this.primPorts);
    }

    @Override
    public int getNumPorts() {
        return this.primPorts.length;
    }

    @Override
    public final PrimitivePort getPort(int portIndex) {
        return this.primPorts[portIndex];
    }

    @Override
    public PrimitivePort getPort(PortProtoId portProtoId) {
        if (portProtoId.getParentId() != this.protoId) {
            throw new IllegalArgumentException();
        }
        int chronIndex = portProtoId.chronIndex;
        return chronIndex < this.portsByChronIndex.length ? this.portsByChronIndex[chronIndex] : null;
    }

    public PrimitivePort connectsTo(ArcProto arc) {
        for (int i = 0; i < this.primPorts.length; ++i) {
            PrimitivePort pp = this.primPorts[i];
            if (!pp.connectsTo(arc)) continue;
            return pp;
        }
        return null;
    }

    public int getSpecialType() {
        return 0;
    }

    public static String getSpecialTypeName(int t) {
        if (t == 0) {
            return "normal";
        }
        if (t == 1) {
            return "serp-trans";
        }
        if (t == 2) {
            return "outline";
        }
        return "?";
    }

    public double[] getSpecialValues() {
        return this.specialValues;
    }

    public EPoint getMulticut2Size() {
        Technology.NodeLayer cutLayer = this.findMulticut();
        assert (cutLayer.getLeftEdge().getMultiplier() == -0.5);
        assert (cutLayer.getBottomEdge().getMultiplier() == -0.5);
        assert (cutLayer.getRightEdge().getMultiplier() == 0.5);
        assert (cutLayer.getTopEdge().getMultiplier() == 0.5);
        double x = cutLayer.getMulticutSizeX().add(cutLayer.getMulticutSep2D()).add(cutLayer.getLeftEdge().getAdder()).subtract(cutLayer.getRightEdge().getAdder()).getLambda();
        double y = cutLayer.getMulticutSizeY().add(cutLayer.getMulticutSep2D()).add(cutLayer.getBottomEdge().getAdder()).subtract(cutLayer.getTopEdge().getAdder()).getLambda();
        return EPoint.fromLambda(x += this.fullRectangle.getLambdaWidth(), y += this.fullRectangle.getLambdaHeight());
    }

    public void setSpecialValues(double[] specialValues) {
        if (specialValues.length != 6) {
            throw new IndexOutOfBoundsException("Invalid number of values in setSpecialValues");
        }
        this.specialValues = specialValues;
    }

    public boolean isPin() {
        return this.getFunction().isPin();
    }

    @Override
    public String describe(boolean withQuotes) {
        String name = "";
        if (this.tech != Technology.getCurrent()) {
            name = name + this.tech.getTechName() + ":";
        }
        name = name + this.getName();
        return withQuotes ? "'" + name + "'" : name;
    }

    @Override
    public String libDescribe() {
        return this.getFullName();
    }

    @Override
    public String noLibDescribe() {
        return this.getName();
    }

    public boolean isNodeBitOn(int bit) {
        assert (bit == 8 || bit == 16 || bit == 32 || bit == 64 || bit == 128 || bit == 256 || bit == 0x100000);
        return (this.userBits & bit) != 0;
    }

    public void setNodeBit(int bit) {
        this.checkChanging();
        this.userBits |= bit;
    }

    public void setSkipSizeInPalette() {
        this.checkChanging();
        this.userBits |= 0x40000;
    }

    public boolean isSkipSizeInPalette() {
        return (this.userBits & 0x40000) != 0;
    }

    public void setCanShrink() {
        this.checkChanging();
        this.userBits |= 1;
    }

    public void clearCanShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFFFFFE;
    }

    public boolean canShrink() {
        return (this.userBits & 1) != 0;
    }

    public void setArcsWipe() {
        this.checkChanging();
        this.userBits |= 0x200;
    }

    public void clearArcsWipe() {
        this.checkChanging();
        this.userBits &= 0xFFFFFDFF;
    }

    public boolean isArcsWipe() {
        return (this.userBits & 0x200) != 0;
    }

    public void setSquare() {
        this.checkChanging();
        this.userBits |= 0x400;
    }

    public void clearSquare() {
        this.checkChanging();
        this.userBits &= 0xFFFFFBFF;
    }

    public boolean isSquare() {
        return (this.userBits & 0x400) != 0;
    }

    public void setHoldsOutline() {
        this.checkChanging();
        this.userBits |= 0x800;
    }

    public void clearHoldsOutline() {
        this.checkChanging();
        this.userBits &= 0xFFFFF7FF;
    }

    public boolean isHoldsOutline() {
        return (this.userBits & 0x800) != 0;
    }

    public void setCanBeZeroSize() {
        this.checkChanging();
        this.userBits |= 0x1000;
    }

    public void clearCanBeZeroSize() {
        this.checkChanging();
        this.userBits &= 0xFFFFEFFF;
    }

    public boolean isCanBeZeroSize() {
        return (this.userBits & 0x1000) != 0;
    }

    public void setWipeOn1or2() {
        this.checkChanging();
        this.userBits |= 0x2000;
    }

    public void clearWipeOn1or2() {
        this.checkChanging();
        this.userBits &= 0xFFFFDFFF;
    }

    public boolean isWipeOn1or2() {
        return (this.userBits & 0x2000) != 0;
    }

    public void setLockedPrim() {
        this.checkChanging();
        this.userBits |= 0x4000;
    }

    public void clearLockedPrim() {
        this.checkChanging();
        this.userBits &= 0xFFFFBFFF;
    }

    public boolean isLockedPrim() {
        return (this.userBits & 0x4000) != 0;
    }

    public void setEdgeSelect() {
        this.checkChanging();
        this.userBits |= 0x8000;
    }

    public void clearEdgeSelect() {
        this.checkChanging();
        this.userBits &= 0xFFFF7FFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x8000) != 0;
    }

    public void setPartialCircle() {
        this.checkChanging();
        this.userBits |= 0x20000;
    }

    public void clearPartialCircle() {
        this.checkChanging();
        this.userBits &= 0xFFFDFFFF;
    }

    public boolean isPartialCircle() {
        return (this.userBits & 0x20000) != 0;
    }

    public void setArcsShrink() {
        this.checkChanging();
        this.userBits |= 0x10000;
    }

    public void clearArcsShrink() {
        this.checkChanging();
        this.userBits &= 0xFFFEFFFF;
    }

    public boolean isArcsShrink() {
        return (this.userBits & 0x10000) != 0;
    }

    public void setNotUsed(boolean set) {
        this.checkChanging();
        this.userBits = set ? (this.userBits |= 0x80000) : (this.userBits &= 0xFFF7FFFF);
    }

    public boolean isNotUsed() {
        return (this.userBits & 0x80000) != 0;
    }

    public void setCurvedPin() {
        this.checkChanging();
        this.userBits |= 0x100000;
    }

    public boolean isCurvedPin() {
        return (this.userBits & 0x100000) != 0;
    }

    public boolean isPureWellNode() {
        if (this.function != Function.NODE) {
            return false;
        }
        if (this.layers.length != 1) {
            return false;
        }
        Layer layer = this.layers[0].getLayer();
        return layer.getFunction().isWell();
    }

    public boolean isPureSubstrateNode() {
        if (this.function != Function.NODE) {
            return false;
        }
        if (this.layers.length != 1) {
            return false;
        }
        Layer layer = this.layers[0].getLayer();
        return layer.getFunction().isSubstrate();
    }

    public final int getPrimNodeInddexInTech() {
        return this.techPrimNodeIndex;
    }

    public void setPrimNodeIndexInTech(int index) {
        this.techPrimNodeIndex = index;
        assert (this.techPrimNodeIndex == this.protoId.chronIndex);
    }

    @Override
    public int compareTo(PrimitiveNode that) {
        int cmp;
        if (this.tech != that.tech && (cmp = this.tech.compareTo(that.tech)) != 0) {
            return cmp;
        }
        return this.techPrimNodeIndex - that.techPrimNodeIndex;
    }

    public String toString() {
        return "node " + this.describe(true);
    }

    protected void dump(PrintWriter out) {
        out.print("PrimitiveNode " + this.getName() + " " + (Object)((Object)this.getFunction()));
        if (this.isNotUsed()) {
            out.println(" NOTUSED");
            return;
        }
        Technology.printlnBits(out, nodeBits, this.userBits);
        out.print("\tspecialType=" + this.getSpecialType() + " numMultiCuts=" + this.numMultiCuts);
        if (this.specialValues != null) {
            for (double v : this.specialValues) {
                out.print(" " + v);
            }
        }
        out.println();
        if (this.offset != null) {
            out.println("\t" + this.offset);
        }
        out.println("\tfullRectangle=" + this.fullRectangle);
        out.println("\tbaseRectangle=" + this.baseRectangle);
        if (this.minNodeSize != null) {
            out.println("\tminNodeSize w=" + this.minNodeSize.getWidth() + " h=" + this.minNodeSize.getHeight() + " rule=" + this.minNodeSize.getRuleName());
        }
        if (this.autoGrowth != null) {
            out.println("\tautoGrowth " + this.autoGrowth);
        }
        Technology.printlnPref(out, 1, "DefaultExtendXFor" + this.getName() + "IN" + this.tech.getTechName(), this.factoryDefaultInst.size.getLambdaX() * 0.5);
        Technology.printlnPref(out, 1, "DefaultExtendYFor" + this.getName() + "IN" + this.tech.getTechName(), this.factoryDefaultInst.size.getLambdaY() * 0.5);
        for (int techVersion = 0; techVersion < 2; ++techVersion) {
            EPoint sizeCorrector = this.getSizeCorrector(techVersion);
            String diskOffset = "diskOffset" + (techVersion + 1);
            double x = sizeCorrector.getLambdaX();
            double y = sizeCorrector.getLambdaY();
            out.println("\t" + diskOffset + "=" + x + "," + y);
        }
        out.println("\tlayers:");
        boolean isSerp = this.getSpecialType() == 1;
        this.dumpNodeLayers(out, this.layers, isSerp);
        if (this.electricalLayers != null) {
            out.println("\telectricalLayers:");
            this.dumpNodeLayers(out, this.electricalLayers, isSerp);
        }
        for (PrimitivePort pp : this.primPorts) {
            pp.dump(out);
        }
    }

    protected void dumpNodeLayers(PrintWriter out, Technology.NodeLayer[] layers, boolean isSerp) {
        EPoint correction = EPoint.fromGrid(this.fullRectangle.getGridWidth(), this.fullRectangle.getGridHeight());
        for (Technology.NodeLayer nl : layers) {
            nl.dump(out, correction, isSerp);
        }
    }

    protected Xml.PrimitiveNodeGroup makeXml(Map<Object, Map<String, Object>> additionalAttributes) {
        List<Technology.NodeLayer> nodeLayers;
        EPoint p2;
        Xml.PrimitiveNodeGroup ng = new Xml.PrimitiveNodeGroup();
        ng.isSingleton = true;
        Xml.PrimitiveNode n = new Xml.PrimitiveNode();
        ng.nodes.add(n);
        n.name = this.getName();
        for (Map.Entry<String, PrimitiveNode> e : this.tech.getOldNodeNames().entrySet()) {
            if (e.getValue() != this) continue;
            assert (n.oldName == null);
            n.oldName = e.getKey();
        }
        n.function = this.getFunction();
        ng.shrinkArcs = this.isArcsShrink();
        ng.partialCircle = this.isPartialCircle();
        ng.square = this.isSquare();
        ng.canBeZeroSize = this.isCanBeZeroSize();
        ng.wipes = this.isWipeOn1or2();
        ng.lockable = this.isLockedPrim();
        ng.edgeSelect = this.isEdgeSelect();
        ng.skipSizeInPalette = this.isSkipSizeInPalette();
        ng.notUsed = this.isNotUsed();
        n.lowVt = this.isNodeBitOn(8);
        n.highVt = this.isNodeBitOn(16);
        n.nativeBit = this.isNodeBitOn(32);
        n.od18 = this.isNodeBitOn(64);
        n.od25 = this.isNodeBitOn(128);
        n.od33 = this.isNodeBitOn(256);
        n.curvePin = this.isNodeBitOn(0x100000);
        NodeSizeRule nodeSizeRule = this.getMinSizeRule();
        EPoint minFullSize = EPoint.fromGrid((this.fullRectangle.getGridWidth() + 1L) / 2L, (this.fullRectangle.getGridHeight() + 1L) / 2L);
        ng.baseLX.value = this.baseRectangle.getLambdaMinX();
        ng.baseHX.value = this.baseRectangle.getLambdaMaxX();
        ng.baseLY.value = this.baseRectangle.getLambdaMinY();
        ng.baseHY.value = this.baseRectangle.getLambdaMaxY();
        EPoint p1 = this.getSizeCorrector(0);
        if (!p1.equals(p2 = this.getSizeCorrector(1))) {
            ng.diskOffset.put(1, p1);
        }
        if (!p2.equals(EPoint.ORIGIN)) {
            ng.diskOffset.put(2, p2);
        }
        ng.defaultWidth.addLambda(this.getFactoryDefaultSize().getLambdaX());
        ng.defaultHeight.addLambda(this.getFactoryDefaultSize().getLambdaY());
        List<Technology.NodeLayer> electricalNodeLayers = nodeLayers = Arrays.asList(this.getNodeLayers());
        if (this.getElectricalLayers() != null) {
            electricalNodeLayers = Arrays.asList(this.getElectricalLayers());
        }
        boolean isSerp = this.getSpecialType() == 1;
        int m = 0;
        for (Technology.NodeLayer nld : electricalNodeLayers) {
            int j = nodeLayers.indexOf(nld);
            if (j < 0) {
                ng.nodeLayers.add(nld.makeXml(isSerp, false, true, additionalAttributes));
                continue;
            }
            while (m < j) {
                ng.nodeLayers.add(nodeLayers.get(m++).makeXml(isSerp, true, false, additionalAttributes));
            }
            ng.nodeLayers.add(nodeLayers.get(m++).makeXml(isSerp, true, true, additionalAttributes));
        }
        while (m < nodeLayers.size()) {
            ng.nodeLayers.add(nodeLayers.get(m++).makeXml(isSerp, true, false, additionalAttributes));
        }
        Iterator<PrimitivePort> pit = this.getPrimitivePorts();
        while (pit.hasNext()) {
            PrimitivePort pp = pit.next();
            ng.ports.add(pp.makeXml());
        }
        ng.specialType = this.getSpecialType();
        if (this.getSpecialValues() != null) {
            ng.specialValues = (double[])this.getSpecialValues().clone();
        }
        if (nodeSizeRule != null) {
            ng.nodeSizeRule = new Xml.NodeSizeRule();
            ng.nodeSizeRule.width = nodeSizeRule.getWidth();
            ng.nodeSizeRule.height = nodeSizeRule.getHeight();
            ng.nodeSizeRule.rule = nodeSizeRule.getRuleName();
        }
        ng.spiceTemplate = this.getSpiceTemplate();
        return ng;
    }

    public boolean getZValues(double[] array) {
        boolean foundValue = false;
        for (int j = 0; j < this.layers.length; ++j) {
            Layer layer = this.layers[j].getLayer();
            if (layer.getTechnology() instanceof Generic) continue;
            foundValue = true;
            double distance = layer.getDistance();
            double thickness = layer.getThickness();
            double z = distance + thickness;
            array[0] = array[0] > distance ? distance : array[0];
            array[1] = array[1] < z ? z : array[1];
        }
        return foundValue;
    }

    private void checkChanging() {
    }

    protected void check() {
        assert (this.fullRectangle.getGridMinX() == this.baseRectangle.getGridMinX() - this.offset.getLowXGridOffset());
        assert (this.fullRectangle.getGridMaxX() == this.baseRectangle.getGridMaxX() + this.offset.getHighXGridOffset());
        assert (this.fullRectangle.getGridMinY() == this.baseRectangle.getGridMinY() - this.offset.getLowYGridOffset());
        assert (this.fullRectangle.getGridMaxY() == this.baseRectangle.getGridMaxY() + this.offset.getHighYGridOffset());
        EPoint minimumSize = this.getMinimumSize();
        assert (minimumSize.getX() <= 0.0 && minimumSize.getY() <= 0.0);
    }

    public class AsymmetricNodeSizeRule
    extends NodeSizeRule {
        AsymmetricNodeSizeRule(String r) {
            super(r);
        }

        @Override
        public String getRuleName() {
            if (this.ruleName != null) {
                return this.ruleName;
            }
            return PrimitiveNode.this.getName() + " Asymmetric Min. Size";
        }

        @Override
        public List<NodeSizeRule.NodeSizeRuleError> checkSize(PrimitiveNodeSize size2) {
            double diffMax;
            double longVal;
            double shortVal;
            String longMsg;
            double longest;
            String shortMsg;
            double shortest;
            ArrayList<NodeSizeRule.NodeSizeRuleError> list = null;
            double lambdaX = size2.getDoubleAlongX();
            double lambdaY = size2.getDoubleAlongY();
            double sizeX = PrimitiveNode.this.baseRectangle.getLambdaWidth();
            double sizeY = PrimitiveNode.this.baseRectangle.getLambdaHeight();
            if (DBMath.isLessThan(lambdaX, lambdaY)) {
                shortest = lambdaX;
                shortMsg = "X axis";
                longest = lambdaY;
                longMsg = "Y axis";
            } else {
                shortest = lambdaY;
                shortMsg = "Y axis";
                longest = lambdaX;
                longMsg = "X axis";
            }
            if (DBMath.isLessThan(sizeX, sizeY)) {
                shortVal = sizeX;
                longVal = sizeY;
            } else {
                shortVal = sizeY;
                longVal = sizeX;
            }
            double diffMin = shortVal - shortest;
            if (DBMath.isGreaterThan(diffMin, 0.0)) {
                NodeSizeRule.NodeSizeRuleError error = new NodeSizeRule.NodeSizeRuleError(shortMsg, shortest, shortVal);
                list = new ArrayList<NodeSizeRule.NodeSizeRuleError>(2);
                list.add(error);
            }
            if (DBMath.isGreaterThan(diffMax = longVal - longest, 0.0)) {
                NodeSizeRule.NodeSizeRuleError error = new NodeSizeRule.NodeSizeRuleError(longMsg, longVal, longest);
                if (list == null) {
                    list = new ArrayList(2);
                }
                list.add(error);
            }
            return list;
        }
    }

    public class NodeSizeRule {
        protected final String ruleName;

        private NodeSizeRule(String r) {
            this.ruleName = r;
        }

        public String getRuleName() {
            if (this.ruleName != null) {
                return this.ruleName;
            }
            return PrimitiveNode.this.getName() + " Min. Size";
        }

        public double getWidth() {
            return PrimitiveNode.this.fullRectangle.getLambdaWidth();
        }

        public double getHeight() {
            return PrimitiveNode.this.fullRectangle.getLambdaHeight();
        }

        public List<NodeSizeRuleError> checkSize(PrimitiveNodeSize size2) {
            NodeSizeRuleError error;
            double minSize;
            ArrayList<NodeSizeRuleError> list = null;
            double base = PrimitiveNode.this.baseRectangle.getLambdaWidth();
            double diff2 = base - (minSize = size2.getDoubleAlongX());
            if (DBMath.isGreaterThan(diff2, 0.0)) {
                error = new NodeSizeRuleError("X axis", base, minSize);
                list = new ArrayList<NodeSizeRuleError>(2);
                list.add(error);
            }
            if (DBMath.isGreaterThan(diff2 = (base = PrimitiveNode.this.baseRectangle.getLambdaHeight()) - (minSize = size2.getDoubleAlongY()), 0.0)) {
                error = new NodeSizeRuleError("Y axis", base, minSize);
                list = new ArrayList(2);
                list.add(error);
            }
            return list;
        }

        public class NodeSizeRuleError {
            public String message;
            public double actual;
            public double minSize;

            NodeSizeRuleError(String msg, double a, double s2) {
                this.message = msg;
                this.actual = a;
                this.minSize = s2;
            }
        }
    }

    private static class NodeLayerIterator
    implements Iterator<Layer> {
        Technology.NodeLayer[] array;
        int pos;

        public NodeLayerIterator(Technology.NodeLayer[] a) {
            this.array = a;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.array.length;
        }

        @Override
        public Layer next() throws NoSuchElementException {
            if (this.pos >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.pos++].getLayer();
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    static class Serpentine
    extends PrimitiveNode {
        Serpentine(String protoName, Technology tech, EPoint sizeCorrector1, EPoint sizeCorrector2, String minSizeRule, double width, double height, ERectangle fullRectangle, ERectangle baseRectangle, Technology.NodeLayer[] layers, double[] specialValues) {
            super(protoName, tech, sizeCorrector1, sizeCorrector2, minSizeRule, width, height, fullRectangle, baseRectangle, layers);
            this.setHoldsOutline();
            this.setCanShrink();
            this.setSpecialValues(specialValues);
        }

        @Override
        public int getSpecialType() {
            return 1;
        }

        @Override
        public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
            Technology.NodeLayer[] eLayers;
            assert (n.protoId == this.getId());
            assert (!this.isArcsWipe() && !this.isWipeOn1or2());
            Technology.NodeLayer[] primLayers = this.getNodeLayers();
            if (b.isElectrical() && (eLayers = this.getElectricalLayers()) != null) {
                primLayers = eLayers;
            }
            AbstractShapeBuilder.SerpentineTrans std = b.newSerpentineTrans(n, this, primLayers);
            if (std.layersTotal > 0) {
                b.setCurNode(n);
                std.initTransPolyFilling();
                for (int i = 0; i < std.layersTotal; ++i) {
                    std.fillTransPoly();
                }
                return;
            }
            b.genShapeOfNode(n, this, primLayers, null);
        }
    }

    static class Polygonal
    extends PrimitiveNode {
        private final Technology.NodeLayer primLayer;

        Polygonal(String protoName, Technology tech, EPoint fullSizeCorrector, double defWidth, double defHeight, ERectangle baseRectangle, Technology.NodeLayer[] layers) {
            super(protoName, tech, fullSizeCorrector, defWidth, defHeight, baseRectangle, layers);
            this.setHoldsOutline();
            this.primLayer = layers[0];
            this.check();
        }

        Polygonal(String protoName, Technology tech, EPoint sizeCorrector1, EPoint sizeCorrector2, String minSizeRule, double width, double height, ERectangle fullRectangle, ERectangle baseRectangle, Technology.NodeLayer[] layers) {
            super(protoName, tech, sizeCorrector1, sizeCorrector2, minSizeRule, width, height, fullRectangle, baseRectangle, layers);
            this.setHoldsOutline();
            this.primLayer = layers[0];
            this.check();
        }

        @Override
        protected void check() {
            assert (!this.isArcsWipe() && !this.isWipeOn1or2());
            assert (this.getNodeLayers().length == 1);
            assert (this.getElectricalLayers() == null);
            Technology.NodeLayer nl = this.getNodeLayers()[0];
            assert (nl.getRepresentation() == 1);
            assert (!nl.getLayer().isCarbonNanotubeLayer());
            assert (!nl.getStyle().isText());
            super.check();
        }

        @Override
        public int getSpecialType() {
            return 2;
        }

        @Override
        public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
            assert (n.protoId == this.getId());
            Layer layer = this.primLayer.getLayer();
            if (b.skipLayer(layer)) {
                return;
            }
            Poly.Type style = this.primLayer.getStyle();
            PrimitivePort pp = this.primLayer.getPort(this);
            b.setCurNode(n);
            EPoint[] outline = n.getTrace();
            if (outline != null) {
                boolean removeSameStartEnd;
                boolean removeCoincidentPoints;
                switch (style) {
                    case FILLED: 
                    case CLOSED: {
                        removeCoincidentPoints = true;
                        removeSameStartEnd = true;
                        break;
                    }
                    case OPENED: 
                    case OPENEDT1: 
                    case OPENEDT2: 
                    case OPENEDT3: {
                        removeCoincidentPoints = true;
                        removeSameStartEnd = false;
                    }
                    default: {
                        removeCoincidentPoints = false;
                        removeSameStartEnd = false;
                    }
                }
                int startPoint = 0;
                for (int i = 1; i < outline.length; ++i) {
                    boolean breakPoint;
                    boolean bl = breakPoint = i == outline.length - 1 || outline[i] == null;
                    if (!breakPoint) continue;
                    if (i == outline.length - 1) {
                        ++i;
                    }
                    b.pushOutlineSegment(outline, startPoint, i - startPoint, removeCoincidentPoints, removeSameStartEnd);
                    b.pushPoly(style, layer, null, pp);
                    startPoint = i + 1;
                }
            } else {
                EdgeH leftEdge = this.primLayer.getLeftEdge();
                EdgeH rightEdge = this.primLayer.getRightEdge();
                EdgeV topEdge = this.primLayer.getTopEdge();
                EdgeV bottomEdge = this.primLayer.getBottomEdge();
                long portLowX = leftEdge.getFixpValue(n.size);
                long portHighX = rightEdge.getFixpValue(n.size);
                long portLowY = bottomEdge.getFixpValue(n.size);
                long portHighY = topEdge.getFixpValue(n.size);
                b.pushPoint(portLowX, portLowY);
                b.pushPoint(portHighX, portLowY);
                b.pushPoint(portHighX, portHighY);
                b.pushPoint(portLowX, portHighY);
                b.pushPoly(style, layer, null, pp);
            }
        }

        @Override
        public void genBounds(ImmutableNodeInst n, long[] gridCoords) {
            EPoint[] trace = n.getTrace();
            if (trace != null) {
                long lx = trace[0].getGridX();
                long ly = trace[0].getGridY();
                long hx = lx;
                long hy = ly;
                for (int i = 1; i < trace.length; ++i) {
                    EPoint p = trace[i];
                    if (p == null) continue;
                    long x = p.getGridX();
                    long y = p.getGridY();
                    lx = Math.min(lx, x);
                    ly = Math.min(ly, y);
                    hx = Math.max(hx, x);
                    hy = Math.max(hy, y);
                }
                long anchorX = n.anchor.getGridX();
                long anchorY = n.anchor.getGridY();
                gridCoords[0] = anchorX + lx;
                gridCoords[1] = anchorY + ly;
                gridCoords[2] = anchorX + hx;
                gridCoords[3] = anchorY + hy;
                return;
            }
            super.genBounds(n, gridCoords);
        }
    }

    private static class PrimitiveNodeKey
    extends EObjectInputStream.Key<PrimitiveNode> {
        public PrimitiveNodeKey() {
        }

        private PrimitiveNodeKey(PrimitiveNode pn) {
            super(pn);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, PrimitiveNode pn) throws IOException {
            out.writeObject(pn.getTechnology());
            out.writeInt(pn.getId().chronIndex);
        }

        @Override
        public PrimitiveNode readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int chronIndex;
            Technology tech = (Technology)in.readObject();
            PrimitiveNode pn = tech.getPrimitiveNodeByChronIndex(chronIndex = in.readInt());
            if (pn == null) {
                throw new InvalidObjectException("primitive node not found");
            }
            return pn;
        }
    }

    public static enum Function {
        UNKNOWN("unknown", "node", false, false),
        PIN("pin", "pin", false, false),
        CONTACT("contact", "contact", false, false),
        NODE("pure-layer-node", "plnode", false, false),
        CONNECT("connection", "conn", false, false),
        TRANMOS("nMOS-transistor", "nmos", true, false),
        TRAPMOS("pMOS-transistor", "pmos", true, false),
        TRADMOS("depletion-nMOS-transistor", "nmos-d", true, false),
        TRAPMOSD("depletion-pMOS-transistor", "pmos-d", true, false),
        TRANMOSNT("native-nMOS-transistor", "nmos-nt", true, false),
        TRAPMOSNT("native-pMOS-transistor", "pmos-nt", true, false),
        TRANMOSFG("floating-gate-nMOS-transistor", "nmos-fg", true, false),
        TRAPMOSFG("floating-gate-pMOS-transistor", "pmos-fg", true, false),
        TRANMOSCN("carbon-nanotube-nMOS-transistor", "nmos-cn", true, false),
        TRAPMOSCN("carbon-nanotube-pMOS-transistor", "pmos-cn", true, false),
        TRANMOSVTL("low-threshold-nMOS-transistor", "nmos-vtl", true, false),
        TRAPMOSVTL("low-threshold-pMOS-transistor", "pmos-vtl", true, false),
        TRANMOSVTH("high-threshold-nMOS-transistor", "nmos-vth", true, false),
        TRAPMOSVTH("high-threshold-pMOS-transistor", "pmos-vth", true, false),
        TRANMOSHV1("high-voltage-1-nMOS-transistor", "nmos-hv1", true, false),
        TRAPMOSHV1("high-voltage-1-pMOS-transistor", "pmos-hv1", true, false),
        TRANMOSHV2("high-voltage-2-nMOS-transistor", "nmos-hv2", true, false),
        TRAPMOSHV2("high-voltage-2-pMOS-transistor", "pmos-hv2", true, false),
        TRANMOSHV3("high-voltage-3-nMOS-transistor", "nmos-hv3", true, false),
        TRAPMOSHV3("high-voltage-3-pMOS-transistor", "pmos-hv3", true, false),
        TRANMOSNTHV1("native-high-voltage-1-nMOS-transistor", "nmos-nt-hv1", true, false),
        TRAPMOSNTHV1("native-high-voltage-1-pMOS-transistor", "pmos-nt-hv1", true, false),
        TRANMOSNTHV2("native-high-voltage-2-nMOS-transistor", "nmos-nt-hv2", true, false),
        TRAPMOSNTHV2("native-high-voltage-2-pMOS-transistor", "pmos-nt-hv2", true, false),
        TRANMOSNTHV3("native-high-voltage-3-nMOS-transistor", "nmos-nt-hv3", true, false),
        TRAPMOSNTHV3("native-high-voltage-3-pMOS-transistor", "pmos-nt-hv3", true, false),
        TRANPN("NPN-transistor", "npn", true, false),
        TRAPNP("PNP-transistor", "pnp", true, false),
        TRANJFET("n-type-JFET-transistor", "njfet", true, false),
        TRAPJFET("p-type-JFET-transistor", "pjfet", true, false),
        TRADMES("depletion-mesfet", "dmes", true, false),
        TRAEMES("enhancement-mesfet", "emes", true, false),
        TRANSREF("prototype-defined-transistor", "tref", true, false),
        TRANS("transistor", "trans", true, false),
        TRA4NMOS("nMOS-4-port-transistor", "nmos-4", true, false),
        TRA4PMOS("pMOS-4-port-transistor", "pmos-4", true, false),
        TRA4DMOS("depletion-nMOS-4-port-transistor", "nmos-d-4", true, false),
        TRA4PMOSD("depletion-pMOS-4-port-transistor", "pmos-d-4", true, false),
        TRA4NMOSNT("native-nMOS-4-port-transistor", "nmos-nt-4", true, false),
        TRA4PMOSNT("native-pMOS-4-port-transistor", "pmos-nt-4", true, false),
        TRA4NMOSFG("floating-gate-nMOS-4-port-transistor", "nmos-fg-4", true, false),
        TRA4PMOSFG("floating-gate-pMOS-4-port-transistor", "pmos-fg-4", true, false),
        TRA4NMOSCN("carbon-nanotube-nMOS-4-port-transistor", "nmos-cn-4", true, false),
        TRA4PMOSCN("carbon-nanotube-pMOS-4-port-transistor", "pmos-cn-4", true, false),
        TRA4NMOSVTL("low-threshold-nMOS-4-port-transistor", "nmos-vtl-4", true, false),
        TRA4PMOSVTL("low-threshold-pMOS-4-port-transistor", "pmos-vtl-4", true, false),
        TRA4NMOSVTH("high-threshold-nMOS-4-port-transistor", "nmos-vth-4", true, false),
        TRA4PMOSVTH("high-threshold-pMOS-4-port-transistor", "pmos-vth-4", true, false),
        TRA4NMOSHV1("high-voltage-1-nMOS-4-port-transistor", "nmos-hv1-4", true, false),
        TRA4PMOSHV1("high-voltage-1-pMOS-4-port-transistor", "pmos-hv1-4", true, false),
        TRA4NMOSHV2("high-voltage-2-nMOS-4-port-transistor", "nmos-hv2-4", true, false),
        TRA4PMOSHV2("high-voltage-2-pMOS-4-port-transistor", "pmos-hv2-4", true, false),
        TRA4NMOSHV3("high-voltage-3-nMOS-4-port-transistor", "nmos-hv3-4", true, false),
        TRA4PMOSHV3("high-voltage-3-pMOS-4-port-transistor", "pmos-hv3-4", true, false),
        TRA4NMOSNTHV1("native-high-voltage-1-nMOS-4-port-transistor", "nmos-nt-hv1-4", true, false),
        TRA4PMOSNTHV1("native-high-voltage-1-pMOS-4-port-transistor", "pmos-nt-hv1-4", true, false),
        TRA4NMOSNTHV2("native-high-voltage-2-nMOS-4-port-transistor", "nmos-nt-hv2-4", true, false),
        TRA4PMOSNTHV2("native-high-voltage-2-pMOS-4-port-transistor", "pmos-nt-hv2-4", true, false),
        TRA4NMOSNTHV3("native-high-voltage-3-nMOS-4-port-transistor", "nmos-nt-hv3-4", true, false),
        TRA4PMOSNTHV3("native-high-voltage-3-pMOS-4-port-transistor", "pmos-nt-hv3-4", true, false),
        TRA4NPN("NPN-4-port-transistor", "npn-4", true, false),
        TRA4PNP("PNP-4-port-transistor", "pnp-4", true, false),
        TRA4NJFET("n-type-JFET-4-port-transistor", "njfet-4", true, false),
        TRA4PJFET("p-type-JFET-4-port-transistor", "pjfet-4", true, false),
        TRA4DMES("4-port-depletion-mesfet", "dmes-4", true, false),
        TRA4EMES("4-port-enhancement-mesfet", "emes-4", true, false),
        TRANS4("4-port-transistor", "trans-4", true, false),
        RESIST("resistor", "res", false, false),
        PRESIST("poly-resistor", "pres", false, false),
        RESHIRESPOLY2("hi-res-poly2-resistor", "p2res", false, false),
        RESNPOLY("n-type-poly-resistor", "resnpoly", false, false),
        RESPPOLY("p-type-poly-resistor", "resppoly", false, false),
        RESNPOLYM("n-type-poly-resistor-m", "resnpolym", false, false),
        RESPPOLYM("p-type-poly-resistor-m", "resppolym", false, false),
        RESNNSPOLY("n-type-no-silicide-poly-resistor", "resnnspoly", false, false),
        RESPNSPOLY("p-type-no-silicide-poly-resistor", "respnspoly", false, false),
        WRESIST("well-resistor", "wres", false, false),
        RESNWELL("n-type-well-resistor", "resnwell", false, false),
        RESPWELL("p-type-well-resistor", "respwell", false, false),
        RESNACTIVE("n-type-active-resistor", "resnactive", false, false),
        RESPACTIVE("p-type-active-resistor", "respactive", false, false),
        ESDDEVICE("esd-device", "esdd", false, false),
        CAPAC("capacitor", "cap", false, false),
        ECAPAC("electrolytic-capacitor", "ecap", false, false),
        POLY2CAPAC("poly2-capacitor", "poly2cap", false, false),
        DIODE("diode", "diode", false, false),
        DIODEZ("zener-diode", "zdiode", false, false),
        INDUCT("inductor", "ind", false, false),
        METER("meter", "meter", false, false),
        BASE("base", "base", false, false),
        EMIT("emitter", "emit", false, false),
        COLLECT("collector", "coll", false, false),
        BUFFER("buffer", "buf", false, false),
        GATEAND("AND-gate", "and", false, false),
        GATEOR("OR-gate", "or", false, false),
        GATEXOR("XOR-gate", "xor", false, false),
        FLIPFLOPRSMS("flip-flop-RS-MS", "ffRSms", false, true),
        FLIPFLOPRSP("flip-flop-RS-P", "ffRSp", false, true),
        FLIPFLOPRSN("flip-flop-RS-N", "ffRSn", false, true),
        FLIPFLOPJKMS("flip-flop-JK-MS", "ffJKms", false, true),
        FLIPFLOPJKP("flip-flop-JK-P", "ffJKp", false, true),
        FLIPFLOPJKN("flip-flop-JK-N", "ffJKn", false, true),
        FLIPFLOPDMS("flip-flop-D-MS", "ffDms", false, true),
        FLIPFLOPDP("flip-flop-D-P", "ffDp", false, true),
        FLIPFLOPDN("flip-flop-D-N", "ffDn", false, true),
        FLIPFLOPTMS("flip-flop-T-MS", "ffTms", false, true),
        FLIPFLOPTP("flip-flop-T-P", "ffTp", false, true),
        FLIPFLOPTN("flip-flop-T-N", "ffTn", false, true),
        MUX("multiplexor", "mux", false, false),
        CONPOWER("power", "pwr", false, false),
        CONGROUND("ground", "gnd", false, false),
        SOURCE("source", "source", false, false),
        SUBSTRATE("substrate", "substr", false, false),
        WELL("well", "well", false, false),
        ART("artwork", "art", false, false),
        ARRAY("array", "array", false, false),
        ALIGN("align", "align", false, false),
        CCVS("ccvs", "ccvs", false, false),
        CCCS("cccs", "cccs", false, false),
        VCVS("vcvs", "vcvs", false, false),
        VCCS("vccs", "vccs", false, false),
        TLINE("transmission-line", "transm", false, false);

        private final String name;
        private final String shortName;
        private final Name basename;
        private final boolean isTransistor;
        private final boolean isFlipFlop;

        private Function(String name, String shortName, boolean isTransistor, boolean isFlipFlop) {
            this.name = name;
            this.shortName = shortName;
            this.basename = Name.findName(TextUtils.canonicString(shortName) + "@0").getBasename();
            this.isTransistor = isTransistor;
            this.isFlipFlop = isFlipFlop;
        }

        public static List<Function> getFunctions() {
            return Arrays.asList(Function.class.getEnumConstants());
        }

        public static Function findType(String typeName) {
            List<Function> allFuncs = Function.getFunctions();
            for (Function fun : allFuncs) {
                if (!fun.enumName().equalsIgnoreCase(typeName)) continue;
                return fun;
            }
            return null;
        }

        public static Function findName(String name) {
            List<Function> allFuncs = Function.getFunctions();
            for (Function fun : allFuncs) {
                if (!fun.name.equalsIgnoreCase(name)) continue;
                return fun;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getConstantName() {
            return this.name();
        }

        public String getShortName() {
            return this.shortName;
        }

        public Name getBasename() {
            return this.basename;
        }

        public boolean isContact() {
            return this == CONTACT;
        }

        public boolean isPin() {
            return this == PIN;
        }

        public boolean isCapacitor() {
            return this == CAPAC || this == ECAPAC || this == POLY2CAPAC;
        }

        public boolean isResistor() {
            return this == RESIST || this.isComplexResistor();
        }

        public boolean isComplexResistor() {
            return this == PRESIST || this == WRESIST || this == RESHIRESPOLY2 || this == RESNPOLY || this == RESPPOLY || this == RESNPOLYM || this == RESPPOLYM || this == RESNNSPOLY || this == RESPNSPOLY || this == RESNWELL || this == RESPWELL || this == RESNACTIVE || this == RESPACTIVE;
        }

        public boolean isESDDevice() {
            return this == ESDDEVICE;
        }

        public boolean isTransistor() {
            return this.isTransistor;
        }

        public boolean isCNTransistor() {
            return this == TRANMOSCN || this == TRA4NMOSCN || this == TRAPMOSCN || this == TRA4PMOSCN;
        }

        public boolean isFET() {
            return this == TRANMOS || this == TRA4NMOS || this == TRAPMOS || this == TRA4PMOS || this == TRADMOS || this == TRA4DMOS || this == TRAPMOSD || this == TRA4PMOSD || this == TRANMOSNT || this == TRA4NMOSNT || this == TRAPMOSNT || this == TRA4PMOSNT || this == TRANMOSFG || this == TRA4NMOSFG || this == TRAPMOSFG || this == TRA4PMOSFG || this == TRANMOSCN || this == TRA4NMOSCN || this == TRAPMOSCN || this == TRA4PMOSCN || this == TRANMOSVTL || this == TRA4NMOSVTL || this == TRAPMOSVTL || this == TRA4PMOSVTL || this == TRANMOSVTH || this == TRA4NMOSVTH || this == TRAPMOSVTH || this == TRA4PMOSVTH || this == TRANMOSHV1 || this == TRA4NMOSHV1 || this == TRAPMOSHV1 || this == TRA4PMOSHV1 || this == TRANMOSHV2 || this == TRA4NMOSHV2 || this == TRAPMOSHV2 || this == TRA4PMOSHV2 || this == TRANMOSHV3 || this == TRA4NMOSHV3 || this == TRAPMOSHV3 || this == TRA4PMOSHV3 || this == TRANMOSNTHV1 || this == TRA4NMOSNTHV1 || this == TRAPMOSNTHV1 || this == TRA4PMOSNTHV1 || this == TRANMOSNTHV2 || this == TRA4NMOSNTHV2 || this == TRAPMOSNTHV2 || this == TRA4PMOSNTHV2 || this == TRANMOSNTHV3 || this == TRA4NMOSNTHV3 || this == TRAPMOSNTHV3 || this == TRA4PMOSNTHV3 || this == TRANJFET || this == TRA4NJFET || this == TRAPJFET || this == TRA4PJFET || this == TRADMES || this == TRA4DMES || this == TRAEMES || this == TRA4EMES;
        }

        public Function make3PortTransistor() {
            if (!this.isTransistor) {
                return null;
            }
            if (this == TRA4NMOS) {
                return TRANMOS;
            }
            if (this == TRA4PMOS) {
                return TRAPMOS;
            }
            if (this == TRA4DMOS) {
                return TRADMOS;
            }
            if (this == TRA4PMOSD) {
                return TRAPMOSD;
            }
            if (this == TRA4NMOSNT) {
                return TRANMOSNT;
            }
            if (this == TRA4PMOSNT) {
                return TRAPMOSNT;
            }
            if (this == TRA4NMOSFG) {
                return TRANMOSFG;
            }
            if (this == TRA4PMOSFG) {
                return TRAPMOSFG;
            }
            if (this == TRA4NMOSCN) {
                return TRANMOSCN;
            }
            if (this == TRA4PMOSCN) {
                return TRAPMOSCN;
            }
            if (this == TRA4NMOSVTL) {
                return TRANMOSVTL;
            }
            if (this == TRA4PMOSVTL) {
                return TRAPMOSVTL;
            }
            if (this == TRA4NMOSVTH) {
                return TRANMOSVTH;
            }
            if (this == TRA4PMOSVTH) {
                return TRAPMOSVTH;
            }
            if (this == TRA4NMOSHV1) {
                return TRANMOSHV1;
            }
            if (this == TRA4PMOSHV1) {
                return TRAPMOSHV1;
            }
            if (this == TRA4NMOSHV2) {
                return TRANMOSHV2;
            }
            if (this == TRA4PMOSHV2) {
                return TRAPMOSHV2;
            }
            if (this == TRA4NMOSHV3) {
                return TRANMOSHV3;
            }
            if (this == TRA4PMOSHV3) {
                return TRAPMOSHV3;
            }
            if (this == TRA4NMOSNTHV1) {
                return TRANMOSNTHV1;
            }
            if (this == TRA4PMOSNTHV1) {
                return TRAPMOSNTHV1;
            }
            if (this == TRA4NMOSNTHV2) {
                return TRANMOSNTHV2;
            }
            if (this == TRA4PMOSNTHV2) {
                return TRAPMOSNTHV2;
            }
            if (this == TRA4NMOSNTHV3) {
                return TRANMOSNTHV3;
            }
            if (this == TRA4PMOSNTHV3) {
                return TRAPMOSNTHV3;
            }
            if (this == TRA4NPN) {
                return TRANPN;
            }
            if (this == TRA4PNP) {
                return TRAPNP;
            }
            if (this == TRA4NJFET) {
                return TRANJFET;
            }
            if (this == TRA4PJFET) {
                return TRAPJFET;
            }
            if (this == TRA4DMES) {
                return TRADMES;
            }
            if (this == TRA4EMES) {
                return TRAEMES;
            }
            if (this == TRANS4) {
                return TRANS;
            }
            return null;
        }

        public boolean isNTypeTransistor() {
            return this == TRANMOS || this == TRA4NMOS || this == TRADMOS || this == TRA4DMOS || this == TRANMOSNT || this == TRA4NMOSNT || this == TRANMOSFG || this == TRA4NMOSFG || this == TRANMOSCN || this == TRA4NMOSCN || this == TRANMOSVTL || this == TRA4NMOSVTL || this == TRANMOSVTH || this == TRA4NMOSVTH || this == TRANMOSHV1 || this == TRA4NMOSHV1 || this == TRANMOSHV2 || this == TRA4NMOSHV2 || this == TRANMOSHV3 || this == TRA4NMOSHV3 || this == TRANMOSNTHV1 || this == TRA4NMOSNTHV1 || this == TRANMOSNTHV2 || this == TRA4NMOSNTHV2 || this == TRANMOSNTHV3 || this == TRA4NMOSNTHV3 || this == TRADMES || this == TRA4DMES || this == TRAEMES || this == TRA4EMES;
        }

        public boolean isPTypeTransistor() {
            return this == TRAPMOS || this == TRA4PMOS || this == TRAPMOSD || this == TRA4PMOSD || this == TRAPMOSNT || this == TRA4PMOSNT || this == TRAPMOSFG || this == TRA4PMOSFG || this == TRAPMOSCN || this == TRA4PMOSCN || this == TRAPMOSVTL || this == TRA4PMOSVTL || this == TRAPMOSVTH || this == TRA4PMOSVTH || this == TRAPMOSHV1 || this == TRA4PMOSHV1 || this == TRAPMOSHV2 || this == TRA4PMOSHV2 || this == TRAPMOSHV3 || this == TRA4PMOSHV3 || this == TRAPMOSNTHV1 || this == TRA4PMOSNTHV1 || this == TRAPMOSNTHV2 || this == TRA4PMOSNTHV2 || this == TRAPMOSNTHV3 || this == TRA4PMOSNTHV3;
        }

        public boolean isBipolar() {
            return this == TRANPN || this == TRA4NPN || this == TRAPNP || this == TRA4PNP;
        }

        public boolean isFlipFlop() {
            return this.isFlipFlop;
        }

        public String toString() {
            return this.name;
        }

        public String enumName() {
            return super.toString();
        }
    }
}

