/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Pref;
import com.sun.electric.tool.io.FileType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;

public class CellModelPrefs {
    public static final CellModelPrefs spiceModelPrefs = new CellModelPrefs("Spice", FileType.SPICE, true);
    public static final CellModelPrefs verilogModelPrefs = new CellModelPrefs("Verilog", FileType.VERILOG, false);
    private final String type;
    private final FileType fileType;
    private final boolean canLayoutFromNetlist;

    private CellModelPrefs(String type, FileType fileType, boolean canLayoutFromNetlist) {
        this.type = type;
        this.fileType = fileType;
        this.canLayoutFromNetlist = canLayoutFromNetlist;
    }

    public String getType() {
        return this.type;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean isCanLayoutFromNetlist() {
        return this.canLayoutFromNetlist;
    }

    public boolean isUseModelFromFile(Cell cell) {
        return CellModelPrefs.isUseModelFromFile(this.getModelFileUnfiltered(cell));
    }

    public static boolean isUseModelFromFile(String unfilteredFileName) {
        return unfilteredFileName != null && unfilteredFileName.length() > 0 && !unfilteredFileName.startsWith("-----") && !unfilteredFileName.startsWith("+++++") && !unfilteredFileName.startsWith("=====");
    }

    public boolean isUseLayoutView(Cell cell) {
        return CellModelPrefs.isUseLayoutView(this.getModelFileUnfiltered(cell));
    }

    public static boolean isUseLayoutView(String unfilteredFileName) {
        return unfilteredFileName != null && unfilteredFileName.length() > 0 && unfilteredFileName.startsWith("+++++");
    }

    public boolean isUseVerilogView(Cell cell) {
        String unfilteredFileName = this.getModelFileUnfiltered(cell);
        if (this.fileType != FileType.VERILOG) {
            return CellModelPrefs.isUseVerilogView(unfilteredFileName);
        }
        Cell verilogView = cell.otherView(View.VERILOG);
        if ((unfilteredFileName == null || unfilteredFileName.length() == 0) && verilogView != null) {
            return true;
        }
        return CellModelPrefs.isUseVerilogView(unfilteredFileName);
    }

    public static boolean isUseVerilogView(String unfilteredFileName) {
        return unfilteredFileName != null && unfilteredFileName.length() > 0 && unfilteredFileName.startsWith("=====");
    }

    public String getModelFile(Cell cell) {
        return CellModelPrefs.getModelFile(this.getModelFileUnfiltered(cell));
    }

    public static String getModelFile(String unfilteredFileName) {
        if (unfilteredFileName != null && unfilteredFileName.length() > 0 && (unfilteredFileName.startsWith("+++++") || unfilteredFileName.startsWith("-----") || unfilteredFileName.startsWith("====="))) {
            return unfilteredFileName.substring(5);
        }
        return unfilteredFileName;
    }

    public void setModelFile(Cell cell, String fileName, boolean useModelFromFile, boolean useLayoutView, boolean useVerilogView) {
        assert (!useModelFromFile || !useLayoutView && !useVerilogView);
        assert (!useLayoutView || !useVerilogView);
        if (!useModelFromFile) {
            fileName = useLayoutView ? "+++++" + fileName : (useVerilogView ? "=====" + fileName : "-----" + fileName);
        }
        Preferences libPrefs = Pref.getLibraryPreferences(cell.getId().libId);
        String key = this.getPrefKey(cell);
        if (fileName.length() == 0) {
            libPrefs.remove(key);
        } else {
            libPrefs.put(key, fileName);
        }
    }

    public Map<Cell, String> getUnfilteredFileNames(EDatabase database) {
        HashMap<Cell, String> m = new HashMap<Cell, String>();
        Iterator<Library> lit = database.getLibraries();
        while (lit.hasNext()) {
            Library lib = lit.next();
            Preferences libPrefs = Pref.getLibraryPreferences(lib.getId());
            Iterator<Cell> cit = lib.getCells();
            while (cit.hasNext()) {
                Cell cell = cit.next();
                String unfilteredFileName = libPrefs.get(this.getPrefKey(cell), "");
                if (unfilteredFileName.length() == 0) continue;
                m.put(cell, unfilteredFileName);
            }
        }
        return m;
    }

    private String getModelFileUnfiltered(Cell cell) {
        return Pref.getLibraryPreferences(cell.getId().libId).get(this.getPrefKey(cell), "");
    }

    public void factoryResetModelFile(Cell cell) {
        Pref.getLibraryPreferences(cell.getId().libId).remove(this.getPrefKey(cell));
    }

    private String getPrefKey(Cell cell) {
        return this.type + "ModelFileFor_" + cell.getLibrary().getName() + "_" + cell.getName() + "_" + cell.getView().getAbbreviation();
    }
}

