/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoutingMetric<T> {
    private static Logger logger = LoggerFactory.getLogger(RoutingMetric.class);

    public abstract T calculate(Cell var1);

    protected T processNets(Cell cell, T startValue) {
        T result2 = startValue;
        boolean debug = false;
        if (cell == null) {
            return result2;
        }
        Iterator<Network> it = cell.getNetlist().getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (debug) {
                logger.trace("process net: " + net.getName());
            }
            result2 = this.reduce(result2, net);
        }
        return result2;
    }

    protected T reduce(T result2, ArcInst instance, Network net) {
        throw new UnsupportedOperationException();
    }

    protected T reduce(T result2, Network net) {
        throw new UnsupportedOperationException();
    }
}

