/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.Job;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PrimitiveNodeGroup {
    private final Technology tech;
    private final Technology.NodeLayer[] nodeLayers;
    private final List<PrimitiveNode> nodes = new ArrayList<PrimitiveNode>();
    private final List<PrimitiveNode> unmodifiableNodes = Collections.unmodifiableList(this.nodes);
    private Xml.PrimitiveNodeGroup ng;
    private final EPoint sizeCorrector1;
    private final EPoint sizeCorrector2;
    private final String minSizeRule;
    private final double defaultWidth;
    private final double defaultHeight;
    private final EPoint fullSize;
    private final ERectangle fullRectangle;
    private final ERectangle baseRectangle;
    private final EdgeH[] elx;
    private final EdgeH[] ehx;
    private final EdgeV[] ely;
    private final EdgeV[] ehy;
    private final ArcProto[][] fullConnections;

    public List<PrimitiveNode> getNodes() {
        return this.unmodifiableNodes;
    }

    private PrimitiveNodeGroup(Technology tech, Xml.PrimitiveNodeGroup ng, Map<String, Layer> layers, Map<String, ArcProto> arcs) {
        Xml.NodeLayer nl;
        int i;
        long ly;
        long hy;
        long lx;
        long hx;
        this.tech = tech;
        this.ng = ng;
        EPoint sizeCorrector1 = ng.diskOffset.get(1);
        EPoint sizeCorrector2 = ng.diskOffset.get(2);
        if (sizeCorrector2 == null) {
            sizeCorrector2 = EPoint.ORIGIN;
        }
        if (sizeCorrector1 == null) {
            sizeCorrector1 = sizeCorrector2;
        }
        this.sizeCorrector1 = sizeCorrector1;
        this.sizeCorrector2 = sizeCorrector2;
        if (ng.nodeSizeRule != null) {
            hx = DBMath.lambdaToGrid(0.5 * ng.nodeSizeRule.width);
            lx = -hx;
            hy = DBMath.lambdaToGrid(0.5 * ng.nodeSizeRule.height);
            ly = -hy;
            this.minSizeRule = ng.nodeSizeRule.rule;
        } else {
            lx = Long.MAX_VALUE;
            hx = Long.MIN_VALUE;
            ly = Long.MAX_VALUE;
            hy = Long.MIN_VALUE;
            for (i = 0; i < ng.nodeLayers.size(); ++i) {
                long y;
                long x2;
                nl = ng.nodeLayers.get(i);
                if (nl.representation == 1 || nl.representation == 3) {
                    x2 = DBMath.lambdaToGrid(nl.lx.value);
                    lx = Math.min(lx, x2);
                    hx = Math.max(hx, x2);
                    x2 = DBMath.lambdaToGrid(nl.hx.value);
                    lx = Math.min(lx, x2);
                    hx = Math.max(hx, x2);
                    y = DBMath.lambdaToGrid(nl.ly.value);
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                    y = DBMath.lambdaToGrid(nl.hy.value);
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                    continue;
                }
                if (nl.style == Poly.Type.DISC || nl.style == Poly.Type.CIRCLE) {
                    long radius;
                    Technology.TechPoint c = nl.techPoints.get(0);
                    Technology.TechPoint r = nl.techPoints.get(1);
                    long cx = c.getX().getAdder().getGrid();
                    long cy = c.getY().getAdder().getGrid();
                    long rx = r.getX().getAdder().getGrid();
                    long ry = r.getY().getAdder().getGrid();
                    if (cx == rx) {
                        radius = Math.abs(ry - cy);
                    } else if (cy == ry) {
                        radius = Math.abs(rx - cx);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    lx = Math.min(lx, cx - radius);
                    hx = Math.max(hx, cx + radius);
                    ly = Math.min(ly, cy - radius);
                    hy = Math.max(hy, cy + radius);
                    continue;
                }
                if (nl.style == Poly.Type.CIRCLEARC || nl.style == Poly.Type.THICKCIRCLEARC || nl.style.isText()) {
                    throw new UnsupportedOperationException();
                }
                for (Technology.TechPoint p : nl.techPoints) {
                    x2 = p.getX().getAdder().getGrid();
                    lx = Math.min(lx, x2);
                    hx = Math.max(hx, x2);
                    y = p.getY().getAdder().getGrid();
                    ly = Math.min(ly, y);
                    hy = Math.max(hy, y);
                }
            }
            this.minSizeRule = null;
        }
        this.fullRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
        this.fullSize = EPoint.fromGrid((hx - lx + 1L) / 2L, (hy - ly + 1L) / 2L);
        this.nodeLayers = new Technology.NodeLayer[ng.nodeLayers.size()];
        for (i = 0; i < ng.nodeLayers.size(); ++i) {
            Technology.TechPoint[] techPoints;
            nl = ng.nodeLayers.get(i);
            Layer layer = layers.get(nl.layer);
            if (nl.representation == 1 || nl.representation == 3) {
                techPoints = new Technology.TechPoint[2];
                if (!(nl.lx.k <= nl.hx.k) || !(nl.ly.k <= nl.hy.k)) {
                    throw new IllegalArgumentException("In " + layer);
                }
                if (Job.getDebug() && (nl.lx.value > nl.hx.value || nl.ly.value > nl.hy.value)) {
                    System.out.println("Negative-size polygon in primitive node " + tech.getTechName() + ":" + ng.nodes.get((int)0).name + ", layer " + layer.getName());
                }
                techPoints[0] = Technology.makeTechPoint(nl.lx, nl.ly);
                techPoints[1] = Technology.makeTechPoint(nl.hx, nl.hy);
            } else {
                techPoints = nl.techPoints.toArray(new Technology.TechPoint[nl.techPoints.size()]);
            }
            if (ng.shrinkArcs) {
                if (layer.getPseudoLayer() == null) {
                    layer.makePseudo();
                }
                layer = layer.getPseudoLayer();
            }
            Technology.NodeLayer nodeLayer = nl.representation == 3 ? Technology.NodeLayer.makeMulticut(layer, nl.portNum, nl.style, techPoints, nl.sizex, nl.sizey, nl.sep1d, nl.sep2d) : (ng.specialType == 1 ? new Technology.NodeLayer(layer, nl.portNum, nl.style, nl.representation, techPoints, ECoord.fromLambdaRoundGrid(nl.lWidth), ECoord.fromLambdaRoundGrid(nl.rWidth), ECoord.fromLambdaRoundGrid(nl.tExtent), ECoord.fromLambdaRoundGrid(nl.bExtent)) : new Technology.NodeLayer(layer, nl.portNum, nl.style, nl.representation, techPoints));
            this.nodeLayers[i] = nodeLayer;
        }
        lx = DBMath.lambdaToGrid(ng.baseLX.value);
        hx = DBMath.lambdaToGrid(ng.baseHX.value);
        ly = DBMath.lambdaToGrid(ng.baseLY.value);
        hy = DBMath.lambdaToGrid(ng.baseHY.value);
        this.baseRectangle = ERectangle.fromGrid(lx, ly, hx - lx, hy - ly);
        if (this.baseRectangle.getWidth() < 0.0 || this.baseRectangle.getHeight() < 0.0) {
            Xml.PrimitiveNode n = ng.nodes.get(0);
            throw new IllegalArgumentException("Node '" + ng.nodes.get((int)0).name + "' has negative base rectangle");
        }
        this.defaultWidth = DBMath.round(ng.defaultWidth.value + 2.0 * this.fullSize.getLambdaX());
        this.defaultHeight = DBMath.round(ng.defaultHeight.value + 2.0 * this.fullSize.getLambdaY());
        this.elx = new EdgeH[ng.ports.size()];
        this.ehx = new EdgeH[ng.ports.size()];
        this.ely = new EdgeV[ng.ports.size()];
        this.ehy = new EdgeV[ng.ports.size()];
        this.fullConnections = new ArcProto[ng.ports.size()][];
        for (i = 0; i < ng.ports.size(); ++i) {
            Xml.PrimitivePort p = ng.ports.get(i);
            if (p.lx.value > p.hx.value || p.lx.k > p.hx.k || p.ly.value > p.hy.value || p.ly.k > p.hy.k) {
                double lX = p.lx.value - this.fullSize.getLambdaX() * p.lx.k;
                double hX = p.hx.value - this.fullSize.getLambdaX() * p.hx.k;
                double lY = p.ly.value - this.fullSize.getLambdaY() * p.ly.k;
                double hY = p.hy.value - this.fullSize.getLambdaY() * p.hy.k;
                String explain = " (LX=" + TextUtils.formatDouble(p.lx.k / 2.0) + "W";
                if (lX >= 0.0) {
                    explain = explain + "+";
                }
                explain = explain + TextUtils.formatDouble(lX) + ", HX=" + TextUtils.formatDouble(p.hx.k / 2.0) + "W";
                if (hX >= 0.0) {
                    explain = explain + "+";
                }
                explain = explain + TextUtils.formatDouble(hX) + ", LY=" + TextUtils.formatDouble(p.ly.k / 2.0) + "H";
                if (lY >= 0.0) {
                    explain = explain + "+";
                }
                explain = explain + TextUtils.formatDouble(lY) + ", HY=" + TextUtils.formatDouble(p.hy.k / 2.0) + "H";
                if (hY >= 0.0) {
                    explain = explain + "+";
                }
                explain = explain + TextUtils.formatDouble(hY);
                explain = explain + " but size is " + this.fullSize.getLambdaX() * 2.0 + "x" + this.fullSize.getLambdaY() * 2.0 + ")";
                throw new IllegalArgumentException("port " + p.name + " in primitive " + tech.getTechName() + ":" + ng.nodes.get((int)0).name + " has negative size" + explain);
            }
            this.elx[i] = Technology.makeEdgeH(p.lx);
            this.ehx[i] = Technology.makeEdgeH(p.hx);
            this.ely[i] = Technology.makeEdgeV(p.ly);
            this.ehy[i] = Technology.makeEdgeV(p.hy);
            this.fullConnections[i] = Technology.makeConnections(ng.nodes.get((int)0).name, p.name, p.portArcs, arcs);
        }
    }

    private PrimitiveNode makePrimitiveNode(int nodeIndex) {
        PrimitiveNode pnp;
        Xml.PrimitiveNode n = this.ng.nodes.get(nodeIndex);
        boolean needElectricalLayers = false;
        assert (this.nodeLayers.length == this.ng.nodeLayers.size());
        ArrayList<Technology.NodeLayer> visualNodeLayers = new ArrayList<Technology.NodeLayer>();
        ArrayList<Technology.NodeLayer> electricalNodeLayers = new ArrayList<Technology.NodeLayer>();
        for (int i = 0; i < this.ng.nodeLayers.size(); ++i) {
            Xml.NodeLayer nl = this.ng.nodeLayers.get(i);
            Technology.NodeLayer nodeLayer = this.nodeLayers[i];
            if (nl.inNodes != null && !nl.inNodes.get(nodeIndex)) continue;
            if (!nl.inLayers || !nl.inElectricalLayers) {
                needElectricalLayers = true;
            }
            if (nl.inLayers) {
                visualNodeLayers.add(nodeLayer);
            }
            if (!nl.inElectricalLayers) continue;
            electricalNodeLayers.add(nodeLayer);
        }
        switch (this.ng.specialType) {
            case 2: {
                pnp = new PrimitiveNode.Polygonal(n.name, this.tech, this.sizeCorrector1, this.sizeCorrector2, this.minSizeRule, this.defaultWidth, this.defaultHeight, this.fullRectangle, this.baseRectangle, visualNodeLayers.toArray(new Technology.NodeLayer[visualNodeLayers.size()]));
                break;
            }
            case 1: {
                pnp = new PrimitiveNode.Serpentine(n.name, this.tech, this.sizeCorrector1, this.sizeCorrector2, this.minSizeRule, this.defaultWidth, this.defaultHeight, this.fullRectangle, this.baseRectangle, visualNodeLayers.toArray(new Technology.NodeLayer[visualNodeLayers.size()]), this.ng.specialValues);
                break;
            }
            default: {
                pnp = this.tech.newPrimitiveNode(n.name, this.sizeCorrector1, this.sizeCorrector2, this.minSizeRule, this.defaultWidth, this.defaultHeight, this.fullRectangle, this.baseRectangle, visualNodeLayers.toArray(new Technology.NodeLayer[visualNodeLayers.size()]));
            }
        }
        if (pnp == null) {
            return null;
        }
        if (n.oldName != null) {
            this.tech.oldNodeNames.put(n.oldName, pnp);
        }
        pnp.setFunction(n.function);
        if (needElectricalLayers) {
            pnp.setElectricalLayers(electricalNodeLayers.toArray(new Technology.NodeLayer[electricalNodeLayers.size()]));
        }
        if (this.ng.shrinkArcs) {
            pnp.setArcsWipe();
            pnp.setArcsShrink();
        }
        if (this.ng.square) {
            pnp.setSquare();
        }
        if (this.ng.canBeZeroSize) {
            pnp.setCanBeZeroSize();
        }
        if (this.ng.wipes) {
            pnp.setWipeOn1or2();
        }
        if (this.ng.lockable) {
            pnp.setLockedPrim();
        }
        if (this.ng.edgeSelect) {
            pnp.setEdgeSelect();
        }
        if (this.ng.skipSizeInPalette) {
            pnp.setSkipSizeInPalette();
        }
        if (this.ng.notUsed) {
            pnp.setNotUsed(true);
        }
        if (n.lowVt) {
            pnp.setNodeBit(8);
        }
        if (n.highVt) {
            pnp.setNodeBit(16);
        }
        if (n.nativeBit) {
            pnp.setNodeBit(32);
        }
        if (n.od18) {
            pnp.setNodeBit(64);
        }
        if (n.od25) {
            pnp.setNodeBit(128);
        }
        if (n.od33) {
            pnp.setNodeBit(256);
        }
        PrimitivePort[] ports = new PrimitivePort[this.ng.ports.size()];
        for (int i = 0; i < ports.length; ++i) {
            PrimitivePort pp;
            Xml.PrimitivePort p = this.ng.ports.get(i);
            switch (this.ng.specialType) {
                case 2: {
                    pp = new PrimitivePort.Polygonal(pnp, this.fullConnections[i], p.name, ports.length == 1, p.portAngle, p.portRange, p.portTopology, this.elx[i], this.ely[i], this.ehx[i], this.ehy[i]);
                    break;
                }
                case 1: {
                    pp = new PrimitivePort.Serpentine(pnp, this.fullConnections[i], p.name, ports.length == 1, p.portAngle, p.portRange, p.portTopology, this.elx[i], this.ely[i], this.ehx[i], this.ehy[i]);
                    break;
                }
                default: {
                    pp = PrimitivePort.newInstance(pnp, this.fullConnections[i], p.name, ports.length == 1, p.portAngle, p.portRange, p.portTopology, PortCharacteristic.UNKNOWN, false, false, this.elx[i], this.ely[i], this.ehx[i], this.ehy[i]);
                }
            }
            ports[i] = pp;
        }
        pnp.addPrimitivePorts(ports);
        if (n.function == PrimitiveNode.Function.NODE) {
            System.out.println("ERROR: Node " + n.name + " must not be a Pure-Layer Node");
            assert (n.function != PrimitiveNode.Function.NODE);
        }
        if (this.ng.spiceTemplate != null) {
            pnp.setSpiceTemplate(this.ng.spiceTemplate);
        }
        pnp.check();
        return pnp;
    }

    static void makePrimitiveNodes(Technology tech, Xml.PrimitiveNodeGroup ng, Map<String, Layer> layers, Map<String, ArcProto> arcs) {
        PrimitiveNodeGroup group = new PrimitiveNodeGroup(tech, ng, layers, arcs);
        for (int i = 0; i < ng.nodes.size(); ++i) {
            PrimitiveNode pnp = group.makePrimitiveNode(i);
            if (ng.isSingleton) continue;
            group.nodes.add(pnp);
            pnp.group = group;
        }
        if (!ng.isSingleton) {
            tech.primitiveNodeGroups.add(group);
        }
    }

    Xml.PrimitiveNodeGroup makeXml() {
        return this.ng;
    }
}

