/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.btree.EquivalenceClasses;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.EvalJython;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.compaction.Compaction;
import com.sun.electric.tool.drc.AssuraDrcErrors;
import com.sun.electric.tool.drc.CalibreDrcErrors;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.MTDRCLayoutTool;
import com.sun.electric.tool.erc.ERCAntenna;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.extract.Connectivity;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.extract.ParasiticTool;
import com.sun.electric.tool.generator.PadGenerator;
import com.sun.electric.tool.generator.ROMGenerator;
import com.sun.electric.tool.generator.cmosPLA.PLA;
import com.sun.electric.tool.generator.layout.GateLayoutGenerator;
import com.sun.electric.tool.generator.layout.fill.StitchFillJob;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.SimulationData;
import com.sun.electric.tool.io.output.GDS;
import com.sun.electric.tool.io.output.GenerateVHDL;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LETool;
import com.sun.electric.tool.ncc.AllSchemNamesToLay;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccCrossProbing;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.PassedNcc;
import com.sun.electric.tool.ncc.SchemNamesToLay;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NccResults;
import com.sun.electric.tool.ncc.result.equivalence.Equivalence;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.routing.Maze;
import com.sun.electric.tool.routing.MimicStitch;
import com.sun.electric.tool.routing.River;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.sc.GetNetlist;
import com.sun.electric.tool.sc.Maker;
import com.sun.electric.tool.sc.Place;
import com.sun.electric.tool.sc.Route;
import com.sun.electric.tool.sc.SilComp;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.irsim.IRSIM;
import com.sun.electric.tool.user.CompileVHDL;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.FastHenryArc;
import com.sun.electric.tool.user.dialogs.FillGenDialog;
import com.sun.electric.tool.user.dialogs.LanguageScripts;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ncc.HighlightEquivalent;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolMenu {
    private static EMenu languageMenu = null;
    private static EMenu expRoutingMenu = null;
    private static final double COEFFICIENTMETAL = 0.25;
    private static final double COEFFICIENTPOLY = 0.25;
    private static final double COEFFICIENTDIFF = 0.7;
    private static final double SQSIZE = 0.4;
    private static final int CONVERT_TO_VHDL = 1;
    private static final int COMPILE_VHDL_FOR_SC = 2;
    private static final int PLACE_AND_ROUTE = 4;
    private static final int SHOW_CELL = 8;

    static EMenu makeMenu() {
        languageMenu = new EMenu("Lang_uages", new EMenuItem("Run Java _Bean Shell Script..."){

            public void run() {
                ToolMenu.javaBshScriptCommand();
            }
        }, EvalJython.hasJython() ? new EMenuItem("Run _Jython Script..."){

            public void run() {
                ToolMenu.jythonScriptCommand();
            }
        } : null, new EMenuItem("Manage _Scripts..."){

            public void run() {
                new LanguageScripts();
            }
        }, EMenuItem.SEPARATOR);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolMenu.setDynamicLanguageMenu();
            }
        });
        RoutingFrame[] expRouters = RoutingFrame.getRoutingAlgorithms();
        expRoutingMenu = new EMenu("Experimental Routers", expRouters.length > 0 ? new DynamicExperimentalRoutingMenuItem(expRouters[0]) : null, expRouters.length > 1 ? new DynamicExperimentalRoutingMenuItem(expRouters[1]) : null, expRouters.length > 2 ? new DynamicExperimentalRoutingMenuItem(expRouters[2]) : null, expRouters.length > 3 ? new DynamicExperimentalRoutingMenuItem(expRouters[3]) : null, expRouters.length > 4 ? new DynamicExperimentalRoutingMenuItem(expRouters[4]) : null, expRouters.length > 5 ? new DynamicExperimentalRoutingMenuItem(expRouters[5]) : null, expRouters.length > 6 ? new DynamicExperimentalRoutingMenuItem(expRouters[6]) : null, expRouters.length > 7 ? new DynamicExperimentalRoutingMenuItem(expRouters[7]) : null);
        return new EMenu("_Tools", new EMenu("_DRC", new EMenuItem("Check _Hierarchically", KeyStroke.getKeyStroke(116, 0)){

            public void run() {
                DRC.DRCPreferences dp = new DRC.DRCPreferences(false);
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (dp.isMultiThreaded && cell.isLayout()) {
                    new MTDRCLayoutTool(dp, cell, true, null).startJob();
                } else {
                    DRC.checkDRCHierarchically(dp, cell, null, null, GeometryHandler.GHMode.ALGO_SWEEP, false);
                }
            }
        }, new EMenuItem("Check _Selection Hierarchically"){

            public void run() {
                EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
                if (wnd == null) {
                    return;
                }
                DRC.DRCPreferences dp = new DRC.DRCPreferences(false);
                DRC.checkDRCHierarchically(dp, wnd.getCell(), wnd.getHighlightedEObjs(true, true), wnd.getHighlightedArea(), GeometryHandler.GHMode.ALGO_SWEEP, false);
            }
        }, new EMenuItem("Add _Skip Annotation to Cell"){

            public void run() {
                DRC.makeDRCAnnotation();
            }
        }, new EMenuItem("Check Area _Coverage"){

            public void run() {
                LayerCoverageTool.layerCoverageCommand(WindowFrame.needCurCell(), GeometryHandler.GHMode.ALGO_SWEEP, true, new LayerCoverageTool.LayerCoveragePreferences(false));
            }
        }, new EMenuItem("_List Layer Coverage on Cell"){

            public void run() {
                ToolMenu.layerCoverageCommand(LayerCoverageTool.LCMode.AREA, GeometryHandler.GHMode.ALGO_SWEEP);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Import _Assura DRC Errors for Current Cell..."){

            public void run() {
                ToolMenu.importAssuraDrcErrors();
            }
        }, new EMenuItem("Import Calibre _DRC Errors for Current Cell..."){

            public void run() {
                ToolMenu.importCalibreDrcErrors();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Export DRC Deck..."){

            public void run() {
                ToolMenu.exportDRCDeck();
            }
        }, new EMenuItem("Import DRC Deck..."){

            public void run() {
                ToolMenu.importDRCDeck();
            }
        }), new EMenu("Simulation (Built-in)", IRSIM.hasIRSIM() ? new EMenuItem("IRSI_M: Simulate Current Cell"){

            public void run() {
                SimulationTool.startSimulation(1, null, null, null, false);
            }
        } : null, IRSIM.hasIRSIM() ? new EMenuItem("IRSIM: _Write Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.IRSIM, true);
            }
        } : null, IRSIM.hasIRSIM() ? new EMenuItem("_IRSIM: Simulate Deck..."){

            public void run() {
                SimulationTool.startSimulation(1, "", null, null, false);
            }
        } : null, IRSIM.hasIRSIM() ? EMenuItem.SEPARATOR : null, new EMenuItem("_ALS: Simulate Current Cell"){

            public void run() {
                SimulationTool.startSimulation(0, null, null, null, false);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Set Signal _High at Main Time", KeyStroke.getKeyStroke(86, 0)){

            public void run() {
                SimulationTool.setSignalHigh();
            }
        }, new EMenuItem("Set Signal _Low at Main Time", KeyStroke.getKeyStroke(71, 0)){

            public void run() {
                SimulationTool.setSignalLow();
            }
        }, new EMenuItem("Set Signal Un_defined at Main Time", KeyStroke.getKeyStroke(88, 0)){

            public void run() {
                SimulationTool.setSignalX();
            }
        }, new EMenuItem("Set Clock on Selected Signal..."){

            public void run() {
                SimulationTool.setClock();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Update Simulation Window"){

            public void run() {
                SimulationTool.update();
            }
        }, new EMenuItem("_Get Information about Selected Signals"){

            public void run() {
                SimulationTool.showSignalInfo();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Clear Selected Stimuli"){

            public void run() {
                SimulationTool.removeSelectedStimuli();
            }
        }, new EMenuItem("Clear All Stimuli _on Selected Signals"){

            public void run() {
                SimulationTool.removeStimuliFromSignal();
            }
        }, new EMenuItem("Clear All S_timuli"){

            public void run() {
                SimulationTool.removeAllStimuli();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Save Stimuli to Disk..."){

            public void run() {
                SimulationTool.saveStimuli();
            }
        }, new EMenuItem("_Restore Stimuli from Disk..."){

            public void run() {
                SimulationTool.restoreStimuli(null);
            }
        }), new EMenu("Simulation (_Spice)", new EMenuItem("Write Spice _Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.SPICE, true);
            }
        }, new EMenuItem("Write _CDL Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.CDL, true);
            }
        }, new EMenuItem("Plot Simulation _Output, Choose File..."){

            public void run() {
                ToolMenu.plotChosen();
            }
        }, new EMenuItem("Plot Simulation Output, _Guess File"){

            public void run() {
                UserInterface ui = Job.getUserInterface();
                Cell cell = ui.needCurrentCell();
                if (cell == null) {
                    return;
                }
                SimulationData.plotGuessed(cell, null);
            }
        }, new EMenuItem("Set Spice _Model..."){

            public void run() {
                SimulationTool.setSpiceModel();
            }
        }, new EMenuItem("Add M_ultiplier"){

            public void run() {
                ToolMenu.addMultiplierCommand();
            }
        }, new EMenuItem("Add Flat Cod_e"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_CODE_FLAT_KEY);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Set Generic Spice _Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set Spice _2 Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_2_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set Spice _3 Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_3_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set _HSpice Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_H_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set _PSpice Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_P_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set G_nuCap Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_GC_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set _SmartSpice Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_SM_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set _Assura CDL Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_A_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set Ca_libre Spice Template"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_C_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set Netlist Cell From _File"){

            public void run() {
                ToolMenu.makeTemplate(Spice.SPICE_NETLIST_FILE_KEY);
            }
        }), new EMenu("Simulation (_Verilog)", new EMenuItem("Write _Verilog Deck..."){

            public void run() {
                SimulationTool.setVerilogStopAtStandardCells(false);
                SimulationTool.setVerilogNetlistNonstandardCells(true);
                FileMenu.exportCommand(FileType.VERILOG, true);
            }
        }, new EMenuItem("Write Verilog_A Deck..."){

            public void run() {
                SimulationTool.setVerilogStopAtStandardCells(false);
                FileMenu.exportCommand(FileType.VERILOGA, true);
            }
        }, new EMenuItem("Plot Simulation _Output, Choose File..."){

            public void run() {
                ToolMenu.plotChosen();
            }
        }, new EMenuItem("Plot Simulation Output, _Guess File"){

            public void run() {
                UserInterface ui = Job.getUserInterface();
                Cell cell = ui.needCurrentCell();
                if (cell == null) {
                    return;
                }
                SimulationData.plotGuessed(cell, null);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Set Verilog _Template"){

            public void run() {
                ToolMenu.makeTemplate(Verilog.VERILOG_TEMPLATE_KEY);
            }
        }, new EMenuItem("Set Verilog Default _Parameter"){

            public void run() {
                ToolMenu.makeTemplate(Verilog.VERILOG_DEFPARAM_KEY);
            }
        }, EMenuItem.SEPARATOR, new EMenu("Set Verilog _Wire", new EMenuItem("_Wire"){

            public void run() {
                SimulationTool.setVerilogWireCommand(0);
            }
        }, new EMenuItem("_Trireg"){

            public void run() {
                SimulationTool.setVerilogWireCommand(1);
            }
        }, new EMenuItem("_Default"){

            public void run() {
                SimulationTool.setVerilogWireCommand(2);
            }
        }), new EMenu("Transistor _Strength", new EMenuItem("_Weak"){

            public void run() {
                SimulationTool.setTransistorStrengthCommand(true);
            }
        }, new EMenuItem("_Normal"){

            public void run() {
                SimulationTool.setTransistorStrengthCommand(false);
            }
        })), new EMenu("Simulation (_Others)", new EMenuItem("Write _Maxwell Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.MAXWELL, true);
            }
        }, new EMenuItem("Write _Tegas Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.TEGAS, true);
            }
        }, new EMenuItem("Write _SILOS Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.SILOS, true);
            }
        }, new EMenuItem("Write _PAL Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.PAL, true);
            }
        }, EMenuItem.SEPARATOR, !IRSIM.hasIRSIM() ? new EMenuItem("Write _IRSIM Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.IRSIM, true);
            }
        } : null, new EMenuItem("Write _ESIM/RNL Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.ESIM, true);
            }
        }, new EMenuItem("Write _RSIM Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.RSIM, true);
            }
        }, new EMenuItem("Write _COSMOS Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.COSMOS, true);
            }
        }, new EMenuItem("Write M_OSSIM Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.MOSSIM, true);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Write _FastHenry Deck..."){

            public void run() {
                FileMenu.exportCommand(FileType.FASTHENRY, true);
            }
        }, new EMenuItem("Fast_Henry Arc Properties..."){

            public void run() {
                FastHenryArc.showFastHenryArcDialog();
            }
        }), new EMenu("_ERC", new EMenuItem("Check _Wells"){

            public void run() {
                ERCWellCheck.analyzeCurCell();
            }
        }, new EMenuItem("_Antenna Check"){

            public void run() {
                ERCAntenna.doAntennaCheck();
            }
        }), new EMenu("_NCC", new EMenuItem("Schematic and Layout Views of Cell in _Current Window"){

            public void run() {
                new NccJob(1);
            }
        }, new EMenuItem("Cells from _Two Windows"){

            public void run() {
                new NccJob(2);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Copy Schematic _User Names to Layout"){

            public void run() {
                new SchemNamesToLay.RenameJob();
            }
        }, new EMenuItem("Copy All Schematic _Names to Layout"){

            public void run() {
                new AllSchemNamesToLay.RenameJob();
            }
        }, new EMenuItem("Highlight _Equivalent"){

            public void run() {
                HighlightEquivalent.highlight();
            }
        }, new EMenuItem("Run NCC for Schematic Cross-_Probing"){

            public void run() {
                ToolMenu.runNccSchematicCrossProbing();
            }
        }, new EMenu("Add NCC _Annotation to Cell", new EMenuItem("Exports Connected by Parent _vdd"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("exportsConnectedByParent vdd /vdd_[0-9]+/");
            }
        }, new EMenuItem("Exports Connected By Parent _gnd"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("exportsConnectedByParent gnd /gnd_[0-9]+/");
            }
        }, new EMenuItem("Exports To _Ignore"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("exportsToIgnore /E[0-9]+/");
            }
        }, new EMenuItem("_Skip NCC"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("skipNCC <comment explaining why>");
            }
        }, new EMenuItem("_Not a Subcircuit"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("notSubcircuit <comment explaining why>");
            }
        }, new EMenuItem("_Flatten Instances"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("flattenInstances <list of instance names>");
            }
        }, new EMenuItem("_Join Group"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("joinGroup <cell name>");
            }
        }, new EMenuItem("_Transistor Type"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("transistorType <typeName>");
            }
        }, new EMenuItem("_Resistor Type"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("resistorType <typeName>");
            }
        }, new EMenuItem("Force _Part Match"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("forcePartMatch <Part name shared by schematic and layout>");
            }
        }, new EMenuItem("Force _Wire Match"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("forceWireMatch <Wire name shared by schematic and layout>");
            }
        }, new EMenuItem("_Black Box"){

            public void run() {
                NccCellAnnotations.makeNCCAnnotationMenuCommand("blackBox <comment explaining why>");
            }
        })), new EMenu("Net_work", new EMenuItem("Show _Network", 'K'){

            public void run() {
                ToolMenu.showNetworkCommand();
            }
        }, new EMenuItem("_List Networks"){

            public void run() {
                ToolMenu.listNetworksCommand();
            }
        }, new EMenuItem("List _Connections on Network"){

            public void run() {
                ToolMenu.listConnectionsOnNetworkCommand();
            }
        }, new EMenuItem("List _Exports on Network"){

            public void run() {
                ToolMenu.listExportsOnNetworkCommand();
            }
        }, new EMenuItem("List Exports _below Network"){

            public void run() {
                ToolMenu.listExportsBelowNetworkCommand();
            }
        }, new EMenuItem("List _Geometry on Network"){

            public void run() {
                ToolMenu.listGeometryOnNetworkCommand(GeometryHandler.GHMode.ALGO_SWEEP);
            }
        }, new EMenuItem("Show _All Networks"){

            public void run() {
                ToolMenu.showAllNetworksCommand();
            }
        }, new EMenuItem("List _Total Wire Lengths on All Networks"){

            public void run() {
                ToolMenu.listGeomsAllNetworksCommand();
            }
        }, new EMenuItem("Show Undriven Networks"){

            public void run() {
                ToolMenu.showUndrivenNetworks();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("E_xtract Current Cell"){

            public void run() {
                Connectivity.extractCurCell(false);
            }
        }, new EMenuItem("Extract Current _Hierarchy"){

            public void run() {
                Connectivity.extractCurCell(true);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Show _Power and Ground"){

            public void run() {
                ToolMenu.showPowerAndGround();
            }
        }, new EMenuItem("_Validate Power and Ground"){

            public void run() {
                ToolMenu.validatePowerAndGround(false);
            }
        }, new EMenuItem("_Repair Power and Ground"){

            public void run() {
                new RepairPowerAndGround();
            }
        }), new EMenu("_Logical Effort", new EMenuItem("_Optimize for Equal Gate Delays"){

            public void run() {
                ToolMenu.optimizeEqualGateDelaysCommand(true);
            }
        }, new EMenuItem("Optimize for Equal Gate Delays (no _caching)"){

            public void run() {
                ToolMenu.optimizeEqualGateDelaysCommand(false);
            }
        }, new EMenuItem("List _Info for Selected Node"){

            public void run() {
                ToolMenu.printLEInfoCommand();
            }
        }, new EMenuItem("_Back Annotate Wire Lengths for Current Cell"){

            public void run() {
                ToolMenu.backAnnotateCommand();
            }
        }, new EMenuItem("Clear Sizes on Selected _Node(s)"){

            public void run() {
                ToolMenu.clearSizesNodableCommand();
            }
        }, new EMenuItem("Clear Sizes in _all Libraries"){

            public void run() {
                ToolMenu.clearSizesCommand();
            }
        }, new EMenuItem("_Estimate Delays"){

            public void run() {
                ToolMenu.estimateDelaysCommand();
            }
        }, new EMenuItem("Add LE Attribute to Selected Export"){

            public void run() {
                ToolMenu.addLEAttribute();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Load Logical Effort Libraries (Purple, Red, and Orange)"){

            public void run() {
                ToolMenu.loadLogicalEffortLibraries();
            }
        }), new EMenu("_Placement", new EMenuItem("_Place Current Cell"){

            public void run() {
                Placement.placeCurrentCell();
            }
        }), new EMenu("_Routing", new EMenuItem.CheckBox("Enable _Auto-Stitching"){

            public boolean isSelected() {
                return Routing.isAutoStitchOn();
            }

            public void setSelected(boolean b) {
                Routing.setAutoStitchOn(b);
                System.out.println("Auto-stitching " + (b ? "enabled" : "disabled"));
            }
        }, new EMenuItem("Auto-_Stitch Now"){

            public void run() {
                AutoStitch.autoStitch(false, true);
            }
        }, new EMenuItem("Auto-Stitch _Highlighted Now", KeyStroke.getKeyStroke(113, 0)){

            public void run() {
                AutoStitch.autoStitch(true, true);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem.CheckBox("Enable _Mimic-Stitching"){

            public boolean isSelected() {
                return Routing.isMimicStitchOn();
            }

            public void setSelected(boolean b) {
                Routing.setMimicStitchOn(b);
                System.out.println("Mimic-stitching " + (b ? "enabled" : "disabled"));
            }
        }, new EMenuItem("Mimic-Stitch _Now", KeyStroke.getKeyStroke(112, 0)){

            public void run() {
                MimicStitch.mimicStitch(true);
            }
        }, new EMenuItem("Mimic S_elected"){

            public void run() {
                Routing.getRoutingTool().mimicSelected();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Ma_ze Route"){

            public void run() {
                Maze.mazeRoute();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_River-Route"){

            public void run() {
                River.riverRoute();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Sea-Of-_Gates Route"){

            public void run() {
                SeaOfGates.seaOfGatesRoute();
            }
        }, EMenuItem.SEPARATOR, expRoutingMenu, Routing.hasSunRouter() ? EMenuItem.SEPARATOR : null, Routing.hasSunRouter() ? new EMenuItem("Sun _Lava Router"){

            public void run() {
                Routing.sunRouteCurrentCell();
            }
        } : null, EMenuItem.SEPARATOR, new EMenuItem("_Unroute"){

            public void run() {
                Routing.unrouteCurrent();
            }
        }, new EMenuItem("Get Unrouted _Wire"){

            public void run() {
                ToolMenu.getUnroutedArcCommand();
            }
        }, new EMenuItem("_Copy Routing Topology"){

            public void run() {
                Routing.copyRoutingTopology();
            }
        }, new EMenuItem("Pas_te Routing Topology"){

            public void run() {
                Routing.pasteRoutingTopology();
            }
        }), new EMenu("_Generation", new EMenuItem("_Coverage Implants Generator"){

            public void run() {
                ToolMenu.layerCoverageCommand(LayerCoverageTool.LCMode.IMPLANT, GeometryHandler.GHMode.ALGO_SWEEP);
            }
        }, new EMenuItem("_Pad Frame Generator..."){

            public void run() {
                ToolMenu.padFrameGeneratorCommand();
            }
        }, new EMenuItem("_ROM Generator..."){

            public void run() {
                ROMGenerator.generateROM();
            }
        }, new EMenuItem("MOSIS CMOS P_LA Generator..."){

            public void run() {
                PLA.generate();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Stitch-Based Fill Generator from doc input"){

            public void run() {
                Cell cell = WindowFrame.getCurrentCell();
                new StitchFillJob(cell, cell.getLibrary(), false);
            }
        }, new EMenuItem("Stitch-Based Fill Generator from open windows"){

            public void run() {
                new StitchFillJob(null, null, false);
            }
        }, new EMenuItem("_Fill (MoCMOS)..."){

            public void run() {
                FillGenDialog.openFillGeneratorDialog(Technology.getMocmosTechnology());
            }
        }, Technology.getTSMC180Technology() != null ? new EMenuItem("Fi_ll (TSMC180)..."){

            public void run() {
                FillGenDialog.openFillGeneratorDialog(Technology.getTSMC180Technology());
            }
        } : null, Technology.getCMOS90Technology() != null ? new EMenuItem("F_ill (CMOS90)..."){

            public void run() {
                FillGenDialog.openFillGeneratorDialog(Technology.getCMOS90Technology());
            }
        } : null, EMenuItem.SEPARATOR, new EMenuItem("Generate gate layouts (_MoCMOS)"){

            public void run() {
                GateLayoutGenerator.generateFromSchematicsJob(Technology.getMocmosTechnology());
            }
        }, Technology.getTSMC180Technology() != null ? new EMenuItem("Generate gate layouts (T_SMC180)"){

            public void run() {
                GateLayoutGenerator.generateFromSchematicsJob(Technology.getTSMC180Technology());
            }
        } : null, Technology.getCMOS90Technology() != null ? new EMenuItem("Generate gate layouts (CM_OS90)"){

            public void run() {
                GateLayoutGenerator.generateFromSchematicsJob(Technology.getCMOS90Technology());
            }
        } : null, Job.getDebug() ? new EMenuItem("Generate gate layouts (c_urrent tech)"){

            public void run() {
                GateLayoutGenerator.generateFromSchematicsJob(Schematics.getDefaultSchematicTechnology());
            }
        } : null), new EMenu("Silicon Co_mpiler", new EMenuItem("_Convert Current Cell to Layout"){

            public void run() {
                ToolMenu.doSiliconCompilation(WindowFrame.needCurCell(), false);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Compile VHDL to _Netlist View"){

            public void run() {
                ToolMenu.compileVHDL();
            }
        }), new EMenu("_Compaction", new EMenuItem("Do _Compaction"){

            public void run() {
                Cell cell = WindowFrame.getCurrentCell();
                if (cell == null) {
                    return;
                }
                Compaction.compactNow(cell, Compaction.isAllowsSpreading());
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("List _Tools"){

            public void run() {
                ToolMenu.listToolsCommand();
            }
        }, languageMenu);
    }

    public static void optimizeEqualGateDelaysCommand(boolean newAlg) {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        LETool letool = LETool.getLETool();
        if (letool == null) {
            System.out.println("Logical Effort tool not found");
            return;
        }
        curEdit.setCell(curEdit.getCell(), VarContext.globalContext, null);
        if (curEdit.getCell() == null) {
            System.out.println("No current cell");
            return;
        }
        letool.optimizeEqualGateDelays(curEdit.getCell(), curEdit.getVarContext(), newAlg);
    }

    public static void printLEInfoCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        VarContext context = wnd.getVarContext();
        if (highlighter.getNumHighlights() == 0) {
            System.out.println("Nothing highlighted");
            return;
        }
        for (Highlight h : highlighter.getHighlights()) {
            if (!h.isHighlightEOBJ()) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            LETool.printResults(ni, context);
        }
    }

    public static void backAnnotateCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        BackAnnotateJob job = new BackAnnotateJob(cell);
        job.startJob();
    }

    public static void layerCoverageCommand(LayerCoverageTool.LCMode func, GeometryHandler.GHMode mode) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        LayerCoverageTool.layerCoverageCommand(func, mode, curCell, true, new LayerCoverageTool.LayerCoveragePreferences(false));
    }

    public static void clearSizesNodableCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter.getNumHighlights() == 0) {
            System.out.println("Nothing highlighted");
            return;
        }
        for (Highlight h : highlighter.getHighlights()) {
            if (!h.isHighlightEOBJ()) continue;
            ElectricObject eobj = h.getElectricObject();
            if (eobj instanceof PortInst) {
                PortInst pi = (PortInst)eobj;
                pi.getInfo();
                eobj = pi.getNodeInst();
            }
            if (!(eobj instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)eobj;
            LETool.clearStoredSizesJob(ni);
        }
        System.out.println("Sizes cleared");
    }

    public static void clearSizesCommand() {
        for (Library lib : Library.getVisibleLibraries()) {
            LETool.clearStoredSizesJob(lib);
        }
        System.out.println("Sizes cleared");
    }

    public static void estimateDelaysCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        System.out.println("Delay estimation for each network is a ratio of the following:");
        System.out.println("  Numerator is the sum of these layers on the network:");
        System.out.println("    Transistor widths");
        System.out.println("    Diffusion half-perimeter, weighted by 0.7");
        System.out.println("    Polysilicon half-perimeter, weighted by 0.25");
        System.out.println("    Metal half-perimeter, weighted by 0.25");
        System.out.println("  Denominator is the width of transistors on the network");
        System.out.println("    Separate results are computed for N and P transistors, as well as their sum");
        System.out.println("-----------------------------------------------------------------------------");
        Netlist nl = cell.getNetlist();
        Iterator<Network> it = nl.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            HashSet<Network> nets = new HashSet<Network>();
            nets.add(net);
            LayerCoverageTool.GeometryOnNetwork geoms = LayerCoverageTool.listGeometryOnNetworks(cell, nets, false, GeometryHandler.GHMode.ALGO_SWEEP, new LayerCoverageTool.LayerCoveragePreferences(false));
            LayerCoverageTool.TransistorInfo p_gate = geoms.getPGate();
            LayerCoverageTool.TransistorInfo n_gate = geoms.getNGate();
            LayerCoverageTool.TransistorInfo p_active = geoms.getPActive();
            LayerCoverageTool.TransistorInfo n_active = geoms.getNActive();
            double numerator = p_gate.width + n_gate.width;
            if (numerator == 0.0) continue;
            System.out.println("Network " + net.describe(true) + " ratio computation:");
            System.out.println("   N Gate width = " + n_gate.width + ", P Gate width = " + p_gate.width);
            List<Layer> layers = geoms.getLayers();
            List<Double> halfPerimeters = geoms.getHalfPerimeters();
            for (int i = 0; i < layers.size(); ++i) {
                Layer layer = layers.get(i);
                Layer.Function fun = layer.getFunction();
                if (!fun.isDiff() && !fun.isMetal() && !fun.isPoly() || fun.isGatePoly()) continue;
                Double halfPerimeter = halfPerimeters.get(i);
                double coefficient = 0.7;
                if (fun.isMetal()) {
                    coefficient = 0.25;
                }
                if (fun.isPoly()) {
                    coefficient = 0.25;
                }
                double result2 = halfPerimeter * coefficient;
                System.out.println("   Layer " + layer.getName() + " half-perimeter is " + TextUtils.formatDistance(halfPerimeter) + " x " + coefficient + " = " + TextUtils.formatDouble(result2));
                numerator += result2;
            }
            System.out.println("   Numerator is the sum of these factors (" + TextUtils.formatDouble(numerator) + ")");
            double pdenominator = p_active.width;
            double ndenominator = n_active.width;
            if (ndenominator == 0.0) {
                System.out.println("   N denominator undefined");
            } else {
                System.out.println("   N denominator = " + ndenominator + ", ratio = " + TextUtils.formatDouble(numerator / ndenominator));
            }
            if (pdenominator == 0.0) {
                System.out.println("   P denominator undefined");
            } else {
                System.out.println("   P denominator = " + pdenominator + ", ratio = " + TextUtils.formatDouble(numerator / pdenominator));
            }
            if (ndenominator + pdenominator == 0.0) {
                System.out.println("   N+P Denominator undefined");
                continue;
            }
            System.out.println("   N+P Denominator = " + (ndenominator + pdenominator) + ", ratio = " + TextUtils.formatDouble(numerator / (ndenominator + pdenominator)));
        }
    }

    public static void addLEAttribute() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List<DisplayedText> textlist = highlighter.getHighlightedText(true);
        for (DisplayedText text2 : textlist) {
            if (!(text2.getElectricObject() instanceof Export)) continue;
            new AddLEAttribute((Export)text2.getElectricObject());
            return;
        }
    }

    public static void loadLogicalEffortLibraries() {
        if (Library.findLibrary("purpleGeneric180") != null) {
            return;
        }
        URL url = LibFile.getLibFile("purpleGeneric180.jelib");
        new FileMenu.ReadLibrary(url, FileType.JELIB, null);
    }

    public static void showNetworkCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        highlighter.showNetworks(cell);
        WindowFrame.show3DHighlight();
        highlighter.finished();
    }

    public static void listNetworksCommand() {
        Cell cell = WindowFrame.getCurrentCell();
        if (cell == null) {
            return;
        }
        Netlist netlist = cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted netlist display (network information unavailable).  Please try again");
            return;
        }
        Map<Network, ArcInst[]> arcMap = null;
        if (cell.getView() != View.SCHEMATIC) {
            arcMap = netlist.getArcInstsByNetwork();
        }
        int total = 0;
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            String netName = net.describe(false);
            if (netName.length() == 0) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append("'" + netName + "'");
            boolean connected = false;
            ArcInst[] arcsOnNet = null;
            if (arcMap != null) {
                arcsOnNet = arcMap.get(net);
            } else {
                ArrayList<ArcInst> arcList = new ArrayList<ArcInst>();
                Iterator<ArcInst> aIt = net.getArcs();
                while (aIt.hasNext()) {
                    arcList.add(aIt.next());
                }
                arcsOnNet = arcList.toArray(new ArcInst[0]);
            }
            for (ArcInst ai : arcsOnNet) {
                if (!connected) {
                    connected = true;
                    infstr.append(", on arcs:");
                }
                infstr.append(" " + ai.describe(true));
            }
            boolean exported = false;
            Iterator<Export> eIt = net.getExports();
            while (eIt.hasNext()) {
                Export pp = eIt.next();
                if (!exported) {
                    exported = true;
                    infstr.append(", with exports:");
                }
                infstr.append(" " + pp.getName());
            }
            System.out.println(infstr.toString());
            ++total;
        }
        if (total == 0) {
            System.out.println("There are no networks in this cell");
        }
    }

    public static void listConnectionsOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set<Network> nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
            return;
        }
        if (nets.isEmpty()) {
            System.out.println("No network selected in list of connections on network");
            return;
        }
        for (Network net : nets) {
            System.out.println("Network " + net.describe(true) + ":");
            int total = 0;
            Iterator<Nodable> nIt = netlist.getNodables();
            while (nIt.hasNext()) {
                HashSet ports;
                Nodable no = nIt.next();
                NodeProto np = no.getProto();
                HashMap<Network, HashSet<PortProto>> portNets = new HashMap<Network, HashSet<PortProto>>();
                Iterator<PortProto> pIt = np.getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = pIt.next();
                    if (pp instanceof PrimitivePort && ((PrimitivePort)pp).isIsolated()) {
                        NodeInst ni = (NodeInst)no;
                        Iterator<Connection> cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Connection con = cIt.next();
                            ArcInst ai = con.getArc();
                            Network oNet = netlist.getNetwork(ai, 0);
                            HashSet<PortProto> ports2 = (HashSet<PortProto>)portNets.get(oNet);
                            if (ports2 == null) {
                                ports2 = new HashSet<PortProto>();
                                portNets.put(oNet, ports2);
                            }
                            ports2.add(pp);
                        }
                        continue;
                    }
                    int width = 1;
                    if (pp instanceof Export) {
                        Export e = (Export)pp;
                        width = netlist.getBusWidth(e);
                    }
                    for (int i = 0; i < width; ++i) {
                        Network oNet = netlist.getNetwork(no, pp, i);
                        HashSet<PortProto> ports3 = (HashSet<PortProto>)portNets.get(oNet);
                        if (ports3 == null) {
                            ports3 = new HashSet<PortProto>();
                            portNets.put(oNet, ports3);
                        }
                        ports3.add(pp);
                    }
                }
                if (portNets.size() <= 1 || (ports = (HashSet)portNets.get(net)) == null) continue;
                if (total == 0) {
                    System.out.println("  Connects to:");
                }
                String name = null;
                name = no instanceof NodeInst ? ((NodeInst)no).describe(false) : no.getName();
                for (Object obj : ports) {
                    PortProto pp = (PortProto)obj;
                    System.out.println("    Node " + name + ", port " + pp.getName());
                    ++total;
                }
            }
            if (total != 0) continue;
            System.out.println("  Not connected");
        }
    }

    public static void listExportsOnNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set<Network> nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
            return;
        }
        for (Network net : nets) {
            System.out.println("Network " + net.describe(true) + ":");
            HashSet<Export> listedExports = new HashSet<Export>();
            System.out.println("  Going up the hierarchy from " + cell + ":");
            if (ToolMenu.findPortsUp(netlist, net, cell, listedExports)) break;
            System.out.println("  Going down the hierarchy from " + cell + ":");
            if (!ToolMenu.findPortsDown(netlist, net, listedExports)) continue;
            break;
        }
    }

    public static void listExportsBelowNetworkCommand() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Set<Network> nets = highlighter.getHighlightedNetworks();
        Netlist netlist = cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
            return;
        }
        for (Network net : nets) {
            System.out.println("Network " + net.describe(true) + ":");
            if (!ToolMenu.findPortsDown(netlist, net, new HashSet<Export>())) continue;
            break;
        }
    }

    private static boolean findPortsUp(Netlist netlist, Network net, Cell cell, HashSet<Export> listedExports) {
        EDatabase database = cell.getDatabase();
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                Network ppNet = netlist.getNetwork(pp, i);
                if (ppNet != net || listedExports.contains(pp)) continue;
                listedExports.add(pp);
                System.out.println("    Export " + pp.getName() + " in " + cell);
                Cell instanceCell = cell.iconView();
                if (instanceCell == null) {
                    instanceCell = cell;
                }
                Iterator<CellUsage> uIt = instanceCell.getUsagesOf();
                while (uIt.hasNext()) {
                    CellUsage u = uIt.next();
                    Cell superCell = u.getParent(database);
                    Netlist superNetlist = cell.getNetlist();
                    if (superNetlist == null) {
                        System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
                        return true;
                    }
                    Iterator<Nodable> nIt = superNetlist.getNodables();
                    while (nIt.hasNext()) {
                        Network superNet;
                        Nodable no = nIt.next();
                        if (no.getProto() != cell || !ToolMenu.findPortsUp(superNetlist, superNet = superNetlist.getNetwork(no, pp, i), superCell, listedExports)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean findPortsDown(Netlist netlist, Network net, HashSet<Export> listedExports) {
        Iterator<Nodable> it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            if (!no.isCellInstance()) continue;
            Cell subCell = (Cell)no.getProto();
            Iterator<PortProto> pIt = subCell.getPorts();
            while (pIt.hasNext()) {
                Export pp = (Export)pIt.next();
                int width = netlist.getBusWidth(pp);
                for (int i = 0; i < width; ++i) {
                    Network oNet = netlist.getNetwork(no, pp, i);
                    if (oNet != net || listedExports.contains(pp)) continue;
                    listedExports.add(pp);
                    System.out.println("    Export " + pp.getName() + " in " + subCell);
                    Netlist subNetlist = subCell.getNetlist();
                    if (subNetlist == null) {
                        System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
                        return true;
                    }
                    Network subNet = subNetlist.getNetwork(pp, i);
                    if (!ToolMenu.findPortsDown(subNetlist, subNet, listedExports)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void listGeometryOnNetworkCommand(GeometryHandler.GHMode mode) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        HashSet nets = (HashSet)wnd.getHighlighter().getHighlightedNetworks();
        if (nets.isEmpty()) {
            System.out.println("No network in " + cell + " selected");
            return;
        }
        LayerCoverageTool.listGeometryOnNetworks(cell, nets, true, mode, new LayerCoverageTool.LayerCoveragePreferences(false));
    }

    private static void showAllNetworksCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        wnd.clearHighlighting();
        Netlist nl = cell.getNetlist();
        Map<Network, ArcInst[]> arcMap = null;
        if (cell.getView() != View.SCHEMATIC) {
            arcMap = nl.getArcInstsByNetwork();
        }
        int colors = nl.getNumNetworks();
        Color[] netColors = ToolMenu.makeUniqueColors(colors);
        int index2 = 0;
        Highlighter h = wnd.getHighlighter();
        Iterator<Network> it = nl.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            ArcInst[] arcsOnNet = null;
            if (arcMap != null) {
                arcsOnNet = arcMap.get(net);
            } else {
                ArrayList<ArcInst> arcList = new ArrayList<ArcInst>();
                Iterator<ArcInst> aIt = net.getArcs();
                while (aIt.hasNext()) {
                    arcList.add(aIt.next());
                }
                arcsOnNet = arcList.toArray(new ArcInst[0]);
            }
            if (arcsOnNet.length == 0) continue;
            Color col = netColors[index2++];
            for (ArcInst ai : arcsOnNet) {
                EPoint ctr;
                Point2D[] points = new Point2D[]{ai.getHeadLocation(), ai.getTailLocation()};
                Poly poly = new Poly(points);
                poly.setStyle(Poly.Type.OPENED);
                h.addPoly(poly, cell, col);
                if (ai.getHeadPortInst().getNodeInst().isCellInstance()) {
                    points = new Point2D[4];
                    ctr = ai.getHeadLocation();
                    points[0] = new EPoint(ctr.getX() - 0.4, ctr.getY() - 0.4);
                    points[1] = new EPoint(ctr.getX() - 0.4, ctr.getY() + 0.4);
                    points[2] = new EPoint(ctr.getX() + 0.4, ctr.getY() + 0.4);
                    points[3] = new EPoint(ctr.getX() + 0.4, ctr.getY() - 0.4);
                    poly = new Poly(points);
                    poly.setStyle(Poly.Type.CLOSED);
                    h.addPoly(poly, cell, col);
                }
                if (!ai.getTailPortInst().getNodeInst().isCellInstance()) continue;
                points = new Point2D[4];
                ctr = ai.getTailLocation();
                points[0] = new EPoint(ctr.getX() - 0.4, ctr.getY() - 0.4);
                points[1] = new EPoint(ctr.getX() - 0.4, ctr.getY() + 0.4);
                points[2] = new EPoint(ctr.getX() + 0.4, ctr.getY() + 0.4);
                points[3] = new EPoint(ctr.getX() + 0.4, ctr.getY() - 0.4);
                poly = new Poly(points);
                poly.setStyle(Poly.Type.CLOSED);
                h.addPoly(poly, cell, col);
            }
        }
        wnd.finishedHighlighting();
    }

    private static Color[] makeUniqueColors(int numColors) {
        int numRuns = (numColors + 29) / 30;
        Color[] colors = new Color[numColors];
        int index2 = 0;
        for (int i = 0; i < numRuns; ++i) {
            int c1 = 255 - 255 / numRuns * i;
            int c2 = c1 / 2;
            int c3 = c2 / 2;
            int c4 = (c1 + c2) / 2;
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, 0, 0);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(0, c1, 0);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(0, 0, c1);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, c1, 0);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(0, c1, c1);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, 0, c1);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, c2, 0);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, 0, c2);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, c2, c2);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c2, c1, 0);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(0, c1, c2);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c2, c1, c2);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c2, 0, c1);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(0, c2, c1);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c2, c2, c1);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, c2, c3);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, c3, c2);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c2, c1, c3);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c3, c1, c2);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c2, c3, c1);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c3, c2, c1);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, c2, c4);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c1, c4, c2);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c2, c1, c4);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c4, c1, c2);
            }
            if (index2 < numColors) {
                colors[index2++] = new Color(c2, c4, c1);
            }
            if (index2 >= numColors) continue;
            colors[index2++] = new Color(c4, c2, c1);
        }
        return colors;
    }

    public static void listGeomsAllNetworksCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        new ListGeomsAllNetworksJob(cell);
    }

    private static void showUndrivenNetworks() {
        final ErrorLogger errorLogger = ErrorLogger.newInstance("Undriven networks");
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        final HashSet visited = new HashSet();
        final Object DRIVEN = new Object();
        final EquivalenceClasses protoConnections = new EquivalenceClasses();
        HierarchyEnumerator.Visitor visitor = new HierarchyEnumerator.Visitor(){

            public HierarchyEnumerator.CellInfo newCellInfo() {
                return new HierarchyEnumerator.CellInfo();
            }

            public boolean enterCell(HierarchyEnumerator.CellInfo cellInfo) {
                Cell cell = cellInfo.getCell();
                if (cell.getView() == View.ICON) {
                    return false;
                }
                if (visited.contains(cell)) {
                    return false;
                }
                visited.add(cell);
                return true;
            }

            public void exitCell(HierarchyEnumerator.CellInfo cellInfo) {
                Cell cell = cellInfo.getCell();
                EquivalenceClasses<Object> instanceConnections = new EquivalenceClasses<Object>();
                for (Network net : ArrayIterator.i2i(cell.getNetlist().getNetworks())) {
                    for (Export e : ArrayIterator.i2i(net.getExports())) {
                        instanceConnections.merge(net, e);
                        if (!e.isNamedGround() && !e.isNamedPower() && e.getCharacteristic() != PortCharacteristic.GND && e.getCharacteristic() != PortCharacteristic.PWR) continue;
                        instanceConnections.merge(e, DRIVEN);
                    }
                    PortInst[] portsOnNet = null;
                    Map<Network, PortInst[]> portMap = null;
                    if (cell.getView() != View.SCHEMATIC) {
                        portMap = cell.getNetlist().getPortInstsByNetwork();
                    }
                    if (portMap != null) {
                        portsOnNet = portMap.get(net);
                    } else {
                        ArrayList<PortInst> portList = new ArrayList<PortInst>();
                        Iterator<PortInst> pIt = net.getPorts();
                        while (pIt.hasNext()) {
                            portList.add(pIt.next());
                        }
                        portsOnNet = portList.toArray(new PortInst[0]);
                    }
                    for (PortInst pi : portsOnNet) {
                        instanceConnections.merge(net, pi);
                        NodeInst ni = pi.getNodeInst();
                        PortProto pp = pi.getPortProto();
                        if (ni.isCellInstance() && ((Cell)ni.getProto()).getView() == View.ICON) {
                            pp = ((Export)pp).findEquivalent(((Cell)ni.getProto()).contentsView());
                        }
                        if (protoConnections.isEquivalent(pp, DRIVEN)) {
                            instanceConnections.merge(pi, DRIVEN);
                        }
                        for (PortInst pi2 : ArrayIterator.i2i(ni.getPortInsts())) {
                            if (!protoConnections.isEquivalent(pp, pi2.getPortProto())) continue;
                            instanceConnections.merge(pi, pi2);
                        }
                        if (!(ni.getProto() instanceof PrimitiveNode)) continue;
                        PrimitiveNode np = (PrimitiveNode)ni.getProto();
                        if (np.getFunction().isResistor()) {
                            for (PortInst pi2 : ArrayIterator.i2i(ni.getPortInsts())) {
                                instanceConnections.merge(pi, pi2);
                            }
                        } else if (np.getFunction().isTransistor() && (pi == ni.getTransistorDrainPort() || pi == ni.getTransistorSourcePort())) {
                            instanceConnections.merge(net, DRIVEN);
                        }
                        if (np.getFunction() != PrimitiveNode.Function.CONGROUND && np.getFunction() != PrimitiveNode.Function.CONPOWER) continue;
                        instanceConnections.merge(net, DRIVEN);
                    }
                }
                block6: for (Network net : ArrayIterator.i2i(cell.getNetlist().getNetworks())) {
                    if (instanceConnections.isEquivalent(net, DRIVEN)) continue;
                    for (Export e : ArrayIterator.i2i(net.getExports())) {
                        if (e.getCharacteristic() != PortCharacteristic.IN && e.getCharacteristic() != PortCharacteristic.BIDIR) continue;
                        continue block6;
                    }
                    ArrayList<Object> arcsOnNet = null;
                    Map<Network, ArcInst[]> arcMap = null;
                    if (cell.getView() != View.SCHEMATIC) {
                        arcMap = cell.getNetlist().getArcInstsByNetwork();
                    }
                    if (arcMap != null) {
                        arcsOnNet = new ArrayList<Object>(Arrays.asList((Object[])arcMap.get(net)));
                    } else {
                        arcsOnNet = new ArrayList();
                        Iterator<ArcInst> aIt = net.getArcs();
                        while (aIt.hasNext()) {
                            arcsOnNet.add(aIt.next());
                        }
                    }
                    if (arcsOnNet.size() > 0) {
                        errorLogger.logMessage("Undriven network", arcsOnNet, cell, 0, true);
                        continue;
                    }
                    PortInst[] portsOnNet = null;
                    Map<Network, PortInst[]> portMap = null;
                    if (cell.getView() != View.SCHEMATIC) {
                        portMap = cell.getNetlist().getPortInstsByNetwork();
                    }
                    if (portMap != null) {
                        portsOnNet = portMap.get(net);
                    } else {
                        ArrayList<PortInst> portList = new ArrayList<PortInst>();
                        Iterator<PortInst> pIt = net.getPorts();
                        while (pIt.hasNext()) {
                            portList.add(pIt.next());
                        }
                        portsOnNet = portList.toArray(new PortInst[0]);
                    }
                    if (portsOnNet.length <= 0) continue;
                    PortInst pi = portsOnNet[0];
                    errorLogger.logMessage("Undriven network on node " + pi.getNodeInst().describe(false) + ", port " + pi.getPortProto().getName(), null, null, cell, 0, true);
                }
                for (Export e : ArrayIterator.i2i(cell.getExports())) {
                    if (instanceConnections.isEquivalent(e, DRIVEN)) {
                        protoConnections.merge(e, DRIVEN);
                    }
                    for (Export e2 : ArrayIterator.i2i(cell.getExports())) {
                        if (!instanceConnections.isEquivalent(e, e2)) continue;
                        protoConnections.merge(e, e2);
                    }
                }
            }

            public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
                NodeProto np = ni.getNodeInst().getProto();
                if (!(np instanceof Cell)) {
                    return false;
                }
                Cell cell = (Cell)np;
                return !visited.contains(cell);
            }
        };
        HierarchyEnumerator.enumerateCell(wnd.getCell(), wnd.getVarContext(), visitor);
        errorLogger.termLogging(true);
    }

    public static void showPowerAndGround() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Netlist netlist = cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted query (network information unavailable).  Please try again");
            return;
        }
        HashSet<Network> pAndG = new HashSet<Network>();
        Iterator<Object> it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            if (!pp.isPower() && !pp.isGround()) continue;
            int width = netlist.getBusWidth(pp);
            for (int i = 0; i < width; ++i) {
                Network net = netlist.getNetwork(pp, i);
                pAndG.add(net);
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun != PrimitiveNode.Function.CONPOWER && fun != PrimitiveNode.Function.CONGROUND) continue;
            Iterator<Connection> cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = cIt.next();
                ArcInst ai = con.getArc();
                int width = netlist.getBusWidth(ai);
                for (int i = 0; i < width; ++i) {
                    Network net = netlist.getNetwork(ai, i);
                    pAndG.add(net);
                }
            }
        }
        highlighter.clear();
        for (Network net : pAndG) {
            highlighter.addNetwork(net, cell);
        }
        highlighter.finished();
        if (pAndG.size() == 0) {
            System.out.println("This cell has no Power or Ground networks");
        }
    }

    public static void validatePowerAndGround(boolean repair) {
        if (repair) {
            System.out.println("Repairing power and ground exports");
        } else {
            System.out.println("Validating power and ground exports");
        }
        int total = 0;
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = lIt.next();
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                Iterator<PortProto> pIt = cell.getPorts();
                while (pIt.hasNext()) {
                    Export pp = (Export)pIt.next();
                    if (pp.isNamedGround() && pp.getCharacteristic() != PortCharacteristic.GND) {
                        System.out.println("Cell " + cell.describe(true) + ", export " + pp.getName() + ": does not have 'GROUND' characteristic");
                        if (repair) {
                            pp.setCharacteristic(PortCharacteristic.GND);
                        }
                        ++total;
                    }
                    if (!pp.isNamedPower() || pp.getCharacteristic() == PortCharacteristic.PWR) continue;
                    System.out.println("Cell " + cell.describe(true) + ", export " + pp.getName() + ": does not have 'POWER' characteristic");
                    if (repair) {
                        pp.setCharacteristic(PortCharacteristic.PWR);
                    }
                    ++total;
                }
            }
        }
        if (total == 0) {
            System.out.println("No problems found");
        } else if (repair) {
            System.out.println("Fixed " + total + " export problems");
        } else {
            System.out.println("Found " + total + " export problems");
        }
    }

    public static void addMultiplierCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        new AddMultiplier(ni);
    }

    public static void makeTemplate(Variable.Key templateKey) {
        new MakeTemplate(templateKey);
    }

    public static void makeTemplate(Variable.Key templateKey, Cell tgtCell) {
        new MakeTemplate(templateKey, tgtCell);
    }

    public static void makeTemplate(Variable.Key templateKey, Cell tgtCell, Object value2) {
        new MakeTemplate(templateKey, tgtCell, value2);
    }

    public static void getUnroutedArcCommand() {
        User.getUserTool().setCurrentArcProto(Generic.tech().unrouted_arc);
    }

    public static void padFrameGeneratorCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.PADARR, null);
        if (fileName != null) {
            PadGenerator.makePadFrame(Library.getCurrent(), fileName);
        }
    }

    public static void listToolsCommand() {
        System.out.println("Tools in Electric:");
        Iterator<Tool> it = Tool.getTools();
        while (it.hasNext()) {
            Tool tool = it.next();
            StringBuffer infstr = new StringBuffer();
            if (tool.isOn()) {
                infstr.append("On");
            } else {
                infstr.append("Off");
            }
            if (tool.isBackground()) {
                infstr.append(", Background");
            }
            if (tool.isFixErrors()) {
                infstr.append(", Correcting");
            }
            if (tool.isIncremental()) {
                infstr.append(", Incremental");
            }
            if (tool.isAnalysis()) {
                infstr.append(", Analysis");
            }
            if (tool.isSynthesis()) {
                infstr.append(", Synthesis");
            }
            System.out.println(tool.getName() + ": " + infstr.toString());
        }
    }

    public static void javaBshScriptCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.JAVA, null);
        if (fileName != null) {
            EvalJavaBsh.runScript(fileName);
        }
    }

    private static void jythonScriptCommand() {
        if (!EvalJython.hasJython()) {
            System.out.println("Jython is not installed");
            return;
        }
        String fileName = OpenFile.chooseInputFile(FileType.JYTHON, null);
        if (fileName != null) {
            EvalJython.runScript(fileName);
        }
    }

    public static void setDynamicLanguageMenu() {
        for (EMenuBar.Instance menuBarInstance : TopLevel.getMenuBars()) {
            JMenu menu = (JMenu)menuBarInstance.findMenuItem(languageMenu.getPath());
            while (menu.getMenuComponentCount() > 3) {
                menu.remove(menu.getMenuComponentCount() - 1);
            }
            for (LanguageScripts.ScriptBinding script : LanguageScripts.getScripts()) {
                String menuName = script.fileName;
                int lastColon = menuName.lastIndexOf(58);
                int lastSlash = menuName.lastIndexOf(47);
                int lastBS = menuName.lastIndexOf(92);
                int finalPos = Math.max(lastColon, Math.max(lastSlash, lastBS));
                menuName = menuName.substring(finalPos + 1);
                FileType type = FileType.JAVA;
                if (menuName.toLowerCase().endsWith(".bsh")) {
                    menuName = menuName.substring(0, menuName.length() - 4);
                } else if (menuName.toLowerCase().endsWith(".py") || menuName.toLowerCase().endsWith(".jy")) {
                    menuName = menuName.substring(0, menuName.length() - 3);
                    type = FileType.JYTHON;
                }
                if (script.mnemonic != '\u0000') {
                    menuName = "_" + script.mnemonic + ": " + menuName;
                }
                DynamicLanguageMenuItem elem2 = new DynamicLanguageMenuItem(menuName, script.fileName, type);
                JMenuItem item = elem2.genMenu();
                menu.add(item);
            }
        }
    }

    public static void doSiliconCompilation(Cell cell, boolean doItNow) {
        if (cell == null) {
            return;
        }
        int activities = 12;
        if (cell.getView() != View.NETLISTQUISC) {
            if (cell.isSchematic()) {
                Cell vhdlCell = cell.otherView(View.VHDL);
                if (vhdlCell != null && vhdlCell.getRevisionDate().after(cell.getRevisionDate())) {
                    cell = vhdlCell;
                } else {
                    activities |= 3;
                }
            }
            if (cell.getView() == View.VHDL) {
                Cell netListCell = cell.otherView(View.NETLISTQUISC);
                if (netListCell != null && netListCell.getRevisionDate().after(cell.getRevisionDate())) {
                    cell = netListCell;
                } else {
                    activities |= 2;
                }
            }
        }
        if (Library.findLibrary("sclib") == null) {
            if (doItNow) {
                ReadSCLibraryJob.performTaskNoJob();
            } else {
                new ReadSCLibraryJob();
            }
        }
        ToolMenu.doSilCompActivityNoJob(cell, activities, doItNow);
    }

    public static void compileVHDL() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (cell.getView() != View.VHDL) {
            System.out.println("Must be editing a VHDL cell before compiling it");
            return;
        }
        new DoSilCompActivity(cell, 10, new SilComp.SilCompPrefs(false), new GenerateVHDL.VHDLPreferences(false));
    }

    public static void makeVHDL() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        new DoSilCompActivity(cell, 9, new SilComp.SilCompPrefs(false), new GenerateVHDL.VHDLPreferences(false));
    }

    public static boolean doSilCompActivityNoJob(Cell cell, int activities, boolean doItNow) {
        SilComp.SilCompPrefs prefs = new SilComp.SilCompPrefs(doItNow);
        GenerateVHDL.VHDLPreferences vp = new GenerateVHDL.VHDLPreferences(doItNow);
        if (doItNow) {
            ArrayList<Cell> textCellsToRedraw = new ArrayList<Cell>();
            try {
                DoSilCompActivity.performTaskNoJob(cell, textCellsToRedraw, activities, prefs, vp);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        } else {
            new DoSilCompActivity(cell, activities, prefs, vp);
        }
        return true;
    }

    public static void parasiticCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        Highlighter highlighter = wnd.getHighlighter();
        Set<Network> nets = highlighter.getHighlightedNetworks();
        for (Network net : nets) {
            ParasiticTool.getParasiticTool().netwokParasitic(net, cell);
        }
    }

    public static void importAssuraDrcErrors() {
        String fileName = OpenFile.chooseInputFile(FileType.ERR, null);
        if (fileName == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        HashMap<Cell, String> mangledNames = new HashMap<Cell, String>();
        GDS.buildUniqueNames(cell, mangledNames, IOTool.getGDSCellNameLenMax(), IOTool.isGDSOutUpperCase());
        AssuraDrcErrors.importErrors(fileName, mangledNames, "DRC");
    }

    public static void importCalibreDrcErrors() {
        String fileName = OpenFile.chooseInputFile(FileType.DB, null);
        if (fileName == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            System.out.println("No current cell to import data in '" + fileName + "' to");
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No current cell to import data in '" + fileName + "' to");
            return;
        }
        HashMap<Cell, String> mangledNames = new HashMap<Cell, String>();
        GDS.buildUniqueNames(cell, mangledNames, IOTool.getGDSCellNameLenMax(), IOTool.isGDSOutUpperCase());
        CalibreDrcErrors.importErrors(fileName, mangledNames, "DRC", false);
    }

    static void exportDRCDeck() {
        String fileName = OpenFile.chooseOutputFile(FileType.XML, "Save XML DRC deck for foundry '" + Technology.getCurrent().getSelectedFoundry() + "'", null);
        if (fileName == null) {
            return;
        }
        DRCTemplate.exportDRCDecks(fileName, Technology.getCurrent());
    }

    public static void importDRCDeck() {
        String fileName = OpenFile.chooseInputFile(FileType.XML, "Open XML DRC deck", false);
        if (fileName == null) {
            return;
        }
        Technology tech = Technology.getCurrent();
        DRCTemplate.DRCXMLParser parser = DRCTemplate.importDRCDeck(TextUtils.makeURLToFile(fileName), tech.getXmlTech(), true);
        String message = "Deck file '" + fileName + "' loaded ";
        message = message + (parser.isParseOK() ? "without errors." : " with errors. No rules loaded.");
        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), message, "Import DRC Deck", parser.isParseOK() ? 2 : 0);
        if (!parser.isParseOK()) {
            return;
        }
        new ImportDRCDeckJob(parser.getRules(), tech);
    }

    public static void runNccSchematicCrossProbing() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        NccCrossProbing.runNccSchematicCrossProbing(cell, wnd.getVarContext());
    }

    private static void plotChosen() {
        String fileName = OpenFile.chooseInputFile(null, null);
        if (fileName == null) {
            return;
        }
        URL fileURL = TextUtils.makeURLToFile(fileName);
        String cellName = TextUtils.getFileNameWithoutExtension(fileURL);
        Library curLib = Library.getCurrent();
        Cell cell = curLib.findNodeProto(cellName);
        if (cell == null) {
            CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), true, CellBrowser.DoAction.selectCellToAssoc);
            dialog.setVisible(true);
            cell = dialog.getSelectedCell();
            if (cell == null) {
                return;
            }
        }
        SimulationData.plot(cell, fileURL, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportDRCDeckJob
    extends Job {
        private List<DRCTemplate.DRCXMLBucket> rules;
        private Technology tech;
        private DRC.DRCPreferences dp = new DRC.DRCPreferences(false);

        public ImportDRCDeckJob(List<DRCTemplate.DRCXMLBucket> rules, Technology tech) {
            super("ImportDRCDeck", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.rules = rules;
            this.tech = tech;
            this.startJob();
        }

        @Override
        public boolean doIt() {
            for (DRCTemplate.DRCXMLBucket bucket : this.rules) {
                boolean done = false;
                Iterator<Foundry> itF = this.tech.getFoundries();
                while (itF.hasNext()) {
                    Foundry f = itF.next();
                    if (!f.getType().getName().equalsIgnoreCase(bucket.foundry)) continue;
                    f.setRules(bucket.drcRules);
                    System.out.println("New DRC rules for foundry '" + f.getType().getName() + "' were loaded in '" + this.tech.getTechName() + "'");
                    DRC.cleanCellsDueToFoundryChanges(this.tech, f, this.dp);
                    if (f == this.tech.getSelectedFoundry()) {
                        this.tech.setCachedRules(null);
                    }
                    done = true;
                    break;
                }
                if (done) continue;
                Job.getUserInterface().showErrorMessage("'" + bucket.foundry + "' is not a valid foundry in '" + this.tech.getTechName() + "'", "Importing DRC Deck");
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoSilCompActivity
    extends Job {
        private Cell cell;
        private int activities;
        private List<Cell> textCellsToRedraw;
        private SilComp.SilCompPrefs prefs;
        private GenerateVHDL.VHDLPreferences vp;

        private DoSilCompActivity(Cell cell, int activities, SilComp.SilCompPrefs prefs, GenerateVHDL.VHDLPreferences vp) {
            super("Silicon-Compiler activity", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.activities = activities;
            this.prefs = prefs;
            this.vp = vp;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.fieldVariableChanged("cell");
            this.textCellsToRedraw = new ArrayList<Cell>();
            this.fieldVariableChanged("textCellsToRedraw");
            this.cell = DoSilCompActivity.performTaskNoJob(this.cell, this.textCellsToRedraw, this.activities, this.prefs, this.vp);
            if (this.cell == null) {
                this.activities = 0;
                this.fieldVariableChanged("activities");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            for (Cell cell : this.textCellsToRedraw) {
                TextWindow.updateText(cell);
            }
            if ((this.activities & 8) != 0) {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                if (User.isShowCellsInNewWindow()) {
                    wf = null;
                }
                if (wf == null) {
                    wf = WindowFrame.createEditWindow(this.cell);
                }
                wf.setCellWindow(this.cell, null);
            }
        }

        public static Cell performTaskNoJob(Cell cell, List<Cell> textCellsToRedraw, int activities, SilComp.SilCompPrefs prefs, GenerateVHDL.VHDLPreferences vp) throws JobException {
            Library destLib = cell.getLibrary();
            textCellsToRedraw = new ArrayList<Cell>();
            if ((activities & 1) != 0) {
                System.out.print("Generating VHDL from " + cell + " ...");
                List<String> vhdlStrings = GenerateVHDL.convertCell(cell, vp);
                if (vhdlStrings == null) {
                    System.out.println("No VHDL produced");
                    return null;
                }
                String cellName = cell.getName() + "{vhdl}";
                Cell vhdlCell = cell.getLibrary().findNodeProto(cellName);
                if (vhdlCell == null && (vhdlCell = Cell.makeInstance(cell.getLibrary(), cellName)) == null) {
                    return null;
                }
                String[] array = new String[vhdlStrings.size()];
                for (int i = 0; i < vhdlStrings.size(); ++i) {
                    array[i] = vhdlStrings.get(i);
                }
                vhdlCell.setTextViewContents(array);
                textCellsToRedraw.add(vhdlCell);
                System.out.println(" Done, created " + vhdlCell);
                cell = vhdlCell;
            }
            if ((activities & 2) != 0) {
                System.out.print("Compiling VHDL in " + cell + " ...");
                CompileVHDL c = new CompileVHDL(cell);
                if (c.hasErrors()) {
                    System.out.println("ERRORS during compilation, no netlist produced");
                    return null;
                }
                List<String> netlistStrings = c.getQUISCNetlist(destLib);
                if (netlistStrings == null) {
                    System.out.println("No netlist produced");
                    return null;
                }
                String cellName = cell.getName() + "{net.quisc}";
                Cell netlistCell = cell.getLibrary().findNodeProto(cellName);
                if (netlistCell == null && (netlistCell = Cell.makeInstance(cell.getLibrary(), cellName)) == null) {
                    return null;
                }
                String[] array = new String[netlistStrings.size()];
                for (int i = 0; i < netlistStrings.size(); ++i) {
                    array[i] = netlistStrings.get(i);
                }
                netlistCell.setTextViewContents(array);
                textCellsToRedraw.add(netlistCell);
                System.out.println(" Done, created " + netlistCell);
                cell = netlistCell;
            }
            if ((activities & 4) != 0) {
                System.out.println("Reading netlist in " + cell);
                GetNetlist gnl = new GetNetlist();
                if (gnl.readNetCurCell(cell)) {
                    System.out.println("Error compiling netlist");
                    return null;
                }
                System.out.println("Placing cells");
                Place place = new Place(prefs);
                String err2 = place.placeCells(gnl);
                if (err2 != null) {
                    System.out.println(err2);
                    return null;
                }
                System.out.println("Routing cells");
                Route route = new Route(prefs);
                err2 = route.routeCells(gnl);
                if (err2 != null) {
                    System.out.println(err2);
                    return null;
                }
                System.out.println("Generating layout");
                Maker maker = new Maker(prefs);
                Object result2 = maker.makeLayout(destLib, gnl);
                if (result2 instanceof String) {
                    System.out.println((String)result2);
                    if (Technology.getCurrent() == Schematics.tech()) {
                        System.out.println("Should switch to a layout technology first (currently in Schematics)");
                        return null;
                    }
                }
                if (!(result2 instanceof Cell)) {
                    return null;
                }
                cell = (Cell)result2;
                System.out.println("Created " + cell);
            }
            return cell;
        }
    }

    private static class ReadSCLibraryJob
    extends Job {
        private ReadSCLibraryJob() {
            super("Read Silicon Compiler Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public static boolean performTaskNoJob() {
            System.out.println("Reading Standard Cell Library 'sclib'");
            URL fileURL = LibFile.getLibFile("sclib.jelib");
            LibraryFiles.readLibrary(fileURL, null, FileType.JELIB, true);
            return true;
        }

        public boolean doIt() throws JobException {
            return ReadSCLibraryJob.performTaskNoJob();
        }
    }

    private static class DoExperimentalRoutingJob
    extends Job {
        private String algorithmName;
        private Cell cell;
        private RoutingFrame.RoutingPrefs routingOptions = new RoutingFrame.RoutingPrefs(false);

        private DoExperimentalRoutingJob(RoutingFrame rf, Cell cell) {
            super("Routing", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.algorithmName = rf.getAlgorithmName();
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            for (RoutingFrame rf : RoutingFrame.getRoutingAlgorithms()) {
                if (!this.algorithmName.equals(rf.getAlgorithmName())) continue;
                int numDone = rf.doRouting(this.cell, this.routingOptions);
                return numDone != 0;
            }
            return false;
        }
    }

    private static class DynamicExperimentalRoutingMenuItem
    extends EMenuItem {
        private RoutingFrame rf;

        public DynamicExperimentalRoutingMenuItem(RoutingFrame router) {
            super(router.getAlgorithmName());
            this.rf = router;
        }

        public String getDescription() {
            return "Experimental Routers";
        }

        protected void updateButtons() {
        }

        public void run() {
            Cell cell = Job.getUserInterface().needCurrentCell();
            if (cell == null) {
                return;
            }
            new DoExperimentalRoutingJob(this.rf, cell);
        }
    }

    private static class DynamicLanguageMenuItem
    extends EMenuItem {
        private String fileName;
        private FileType type;

        public DynamicLanguageMenuItem(String menuName, String fileName, FileType type) {
            super(menuName);
            this.fileName = fileName;
            this.type = type;
        }

        public String getDescription() {
            return "Language Scripts";
        }

        protected void updateButtons() {
        }

        public void run() {
            if (this.type == FileType.JAVA) {
                System.out.println("Executing commands in Bean Shell Script: " + this.fileName);
                EvalJavaBsh.runScript(this.fileName);
            } else if (this.type == FileType.JYTHON) {
                System.out.println("Executing commands in Python Script: " + this.fileName);
                EvalJython.runScript(this.fileName);
            }
        }
    }

    private static class MakeTemplate
    extends Job {
        private Variable.Key templateKey;
        private Cell tgtCell;
        private Object value;

        protected MakeTemplate(Variable.Key templateKey) {
            super("Make template", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.templateKey = templateKey;
            this.tgtCell = Job.getUserInterface().needCurrentCell();
            this.startJob();
        }

        protected MakeTemplate(Variable.Key templateKey, Cell tgtCell) {
            super("Make template", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.templateKey = templateKey;
            if (tgtCell == null) {
                tgtCell = Job.getUserInterface().needCurrentCell();
            }
            this.tgtCell = tgtCell;
            this.startJob();
        }

        protected MakeTemplate(Variable.Key templateKey, Cell tgtCell, Object value2) {
            super("Make template", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.templateKey = templateKey;
            if (tgtCell == null) {
                tgtCell = Job.getUserInterface().needCurrentCell();
            }
            this.tgtCell = tgtCell;
            this.value = value2;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Variable templateVar = this.tgtCell.getVar(this.templateKey);
            if (templateVar != null) {
                System.out.println("This cell already has a template");
                return false;
            }
            Point2D offset = this.tgtCell.newVarOffset();
            TextDescriptor td = TextDescriptor.getCellTextDescriptor().withInterior(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE).withOff(offset.getX(), offset.getY());
            if (this.value == null) {
                this.tgtCell.newVar(this.templateKey, (Object)"*Undefined", td);
            } else {
                this.tgtCell.newVar(this.templateKey, this.value, td);
            }
            return true;
        }
    }

    private static class AddMultiplier
    extends Job {
        private NodeInst ni;

        protected AddMultiplier(NodeInst ni) {
            super("Add Spice Multiplier", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE).withOff(-1.5, -1.0);
            this.ni.newVar(SimulationTool.M_FACTOR_KEY, (Object)new Double(1.0), td);
            return true;
        }
    }

    private static class RepairPowerAndGround
    extends Job {
        protected RepairPowerAndGround() {
            super("Repair Power and Ground", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() throws JobException {
            ToolMenu.validatePowerAndGround(true);
            return true;
        }
    }

    private static class ListGeomsAllNetworksJob
    extends Job {
        private Cell cell;
        private LayerCoverageTool.LayerCoveragePreferences lcp = new LayerCoverageTool.LayerCoveragePreferences(false);

        public ListGeomsAllNetworksJob(Cell cell) {
            super("ListGeomsAllNetworks", User.getUserTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Netlist netlist = this.cell.getNetlist();
            ArrayList<Network> networks = new ArrayList<Network>();
            Iterator<Network> it = netlist.getNetworks();
            while (it.hasNext()) {
                networks.add(it.next());
            }
            Collections.sort(networks, new TextUtils.NetworksByName());
            for (Network net : networks) {
                HashSet<Network> nets = new HashSet<Network>();
                nets.add(net);
                LayerCoverageTool.GeometryOnNetwork geoms = LayerCoverageTool.listGeometryOnNetworks(this.cell, nets, false, GeometryHandler.GHMode.ALGO_SWEEP, this.lcp);
                if (geoms.getTotalWireLength() == 0.0) continue;
                System.out.println("Network " + net + " has wire length " + geoms.getTotalWireLength());
            }
            return true;
        }
    }

    private static class AddLEAttribute
    extends Job {
        private Export ex;

        protected AddLEAttribute(Export ex) {
            super("Add LE Attribute", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ex = ex;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            TextDescriptor td = TextDescriptor.getAnnotationTextDescriptor().withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE).withOff(-1.5, -1.0);
            this.ex.newVar(LENetlister.ATTR_le, (Object)new Double(1.0), td);
            return true;
        }
    }

    private static class BackAnnotateJob
    extends Job {
        private Cell cell;
        private LayerCoverageTool.LayerCoveragePreferences lcp = new LayerCoverageTool.LayerCoveragePreferences(false);

        public BackAnnotateJob(Cell cell) {
            super("BackAnnotate", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
        }

        public boolean doIt() throws JobException {
            NccOptions options;
            NccResults results;
            NccResult result2;
            Cell[] schLayCells = NccUtils.findSchematicAndLayout(this.cell);
            if (schLayCells == null) {
                System.out.println("Could not find schematic and layout cells for " + this.cell.describe(true));
                return false;
            }
            if (this.cell.getView() == View.LAYOUT) {
                schLayCells[1] = this.cell;
            }
            if (!(result2 = (results = Ncc.compare(schLayCells[0], null, schLayCells[1], null, new PassedNcc(), options = new NccOptions(), this)).getResultFromRootCells()).match()) {
                System.out.println("Ncc failed, can't back-annotate");
                return false;
            }
            int wiresUpdated = 0;
            ArrayList<Network> networks = new ArrayList<Network>();
            HashMap<Network, NodeInst> map2 = new HashMap<Network, NodeInst>();
            Iterator<NodeInst> it = schLayCells[0].getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                Variable var = ni.getParameterOrVariable(LENetlister.ATTR_LEWIRE);
                if (var == null) continue;
                var = ni.getParameterOrVariable(LENetlister.ATTR_L);
                if (var == null) {
                    System.out.println("No attribute L on wire model " + ni.describe(true) + ", ignoring it.");
                    continue;
                }
                PortInst pi = ni.getPortInst(0);
                if (pi == null) continue;
                Netlist netlist = schLayCells[0].getNetlist(NccNetlist.SHORT_RESISTORS);
                Network schNet = netlist.getNetwork(pi);
                networks.add(schNet);
                map2.put(schNet, ni);
            }
            Collections.sort(networks, new TextUtils.NetworksByName());
            for (Network schNet : networks) {
                Equivalence equiv = result2.getEquivalence();
                HierarchyEnumerator.NetNameProxy proxy = equiv.findEquivalentNet(VarContext.globalContext, schNet);
                if (proxy == null) {
                    System.out.println("No matching network in layout for " + schNet.getName() + ", ignoring");
                    continue;
                }
                Network layNet = proxy.getNet();
                Cell netcell = layNet.getParent();
                HashSet<Network> nets = new HashSet<Network>();
                nets.add(layNet);
                LayerCoverageTool.GeometryOnNetwork geoms = LayerCoverageTool.listGeometryOnNetworks(netcell, nets, false, GeometryHandler.GHMode.ALGO_SWEEP, this.lcp);
                double length = geoms.getTotalWireLength();
                NodeInst ni = (NodeInst)map2.get(schNet);
                ni.updateVar(LENetlister.ATTR_L, new Double(length));
                ++wiresUpdated;
                System.out.println("Updated wire model " + ni.getName() + " on layout network " + proxy.toString() + " to: " + length + " lambda");
            }
            System.out.println("Updated " + wiresUpdated + " wire models in " + schLayCells[0] + " from layout " + schLayCells[1]);
            return true;
        }
    }
}

