/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Set;

public class GeometryConnection {
    private GeometryConnection() {
    }

    public static boolean checkCellConnectivity(NodeInst cellA, NodeInst cellB) {
        Rectangle2D cellBounds = (Rectangle2D)cellA.getBounds().clone();
        AffineTransform rTransI = cellB.rotateIn(cellB.translateIn());
        AffineTransform cellUp = cellB.transformOut();
        DBMath.transformRect(cellBounds, rTransI);
        Netlist topNetlist = cellA.getParent().getNetlist();
        if (cellB.isCellInstance() && cellA.isCellInstance()) {
            Cell cellBProto = (Cell)cellB.getProto();
            AffineTransform subTrans = cellA.rotateIn(cellA.translateIn());
            Iterator<RTBounds> it = cellBProto.searchIterator(cellBounds);
            while (it.hasNext()) {
                Geometric nGeom = (Geometric)it.next();
                if (!(nGeom instanceof NodeInst)) continue;
                Rectangle2D rect = (Rectangle2D)nGeom.getBounds().clone();
                DBMath.transformRect(rect, cellUp);
                DBMath.transformRect(rect, subTrans);
                ConnectionEnumerator check2 = new ConnectionEnumerator(cellA, nGeom, rect, cellBProto.getNetlist(), topNetlist);
                HierarchyEnumerator.enumerateCell(cellA.getParent(), VarContext.globalContext, (HierarchyEnumerator.Visitor)check2);
                if (!check2.found) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean searchInExportNetwork(Netlist netlist1, Network net1, Netlist netlist2, Network net2) {
        Iterator<Export> it = net1.getExports();
        while (it.hasNext()) {
            Export exp1 = it.next();
            Network tmpNet1 = netlist1.getNetwork(exp1.getOriginalPort());
            Iterator<Export> otherIt = net2.getExports();
            while (otherIt.hasNext()) {
                Export exp2 = otherIt.next();
                Network tmpNet2 = netlist2.getNetwork(exp2.getOriginalPort());
                if (tmpNet2 != tmpNet1) continue;
                return true;
            }
        }
        return false;
    }

    private static class ConnectionEnumerator
    extends HierarchyEnumerator.Visitor {
        private Geometric geomA;
        private Geometric geomB;
        private Rectangle2D geomBBnd;
        public boolean found;
        private Set netsB;
        private Netlist topNetlist;
        private Cell topCell;

        public ConnectionEnumerator(Geometric geomA, Geometric geomB, Rectangle2D cellABnds, Netlist netlistB, Netlist topNetlist) {
            this.geomA = geomA;
            this.geomB = geomB;
            this.geomBBnd = cellABnds;
            this.found = false;
            this.netsB = NetworkTool.getNetworks(geomB, netlistB, null);
            this.topNetlist = topNetlist;
            this.topCell = geomA.getParent();
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (cell == this.geomA.getParent()) {
                return true;
            }
            Set<Network> nets = null;
            Iterator<RTBounds> it = cell.searchIterator(this.geomBBnd);
            while (it.hasNext()) {
                Geometric nGeom = (Geometric)it.next();
                System.out.println(nGeom.toString());
                if (nGeom.isConnected(this.geomB)) {
                    this.found = true;
                    return false;
                }
                nets = NetworkTool.getNetworks(nGeom, info.getNetlist(), nets);
                if (nets.containsAll(this.netsB)) {
                    System.out.println("Found net");
                    continue;
                }
                if (nets.size() != 1 || this.netsB.size() != 1) continue;
                Iterator<PortProto> pIt = this.topCell.getPorts();
                while (pIt.hasNext()) {
                    PortProto port = pIt.next();
                    System.out.println("Port " + port);
                }
                if (!GeometryConnection.searchInExportNetwork(this.topNetlist, (Network)this.netsB.toArray()[0], this.topNetlist, (Network)nets.toArray()[0])) continue;
                System.out.println("Found net paretn");
            }
            return false;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }
}

