/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Network;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class SpiceExemptedNets {
    private Map<Cell, List<Net>> netsByCell = new HashMap<Cell, List<Net>>();
    private Set<Integer> exemptedNetIDs = new TreeSet<Integer>();

    public SpiceExemptedNets(File file) {
        try {
            String line;
            FileReader reader = new FileReader(file);
            BufferedReader br = new BufferedReader(reader);
            int lineno = 1;
            System.out.println("Using exempted nets file " + file.getAbsolutePath());
            while ((line = br.readLine()) != null) {
                this.processLine(line, lineno);
                ++lineno;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return;
        }
    }

    private void processLine(String line, int lineno) {
        List<Net> list;
        if (line == null) {
            return;
        }
        if (line.trim().equals("")) {
            return;
        }
        if (line.startsWith("#")) {
            return;
        }
        String[] parts = line.trim().split("\\s+");
        if (parts.length < 3) {
            System.out.println("Error on line " + lineno + ": Expected 'LibraryName CellName NetName', but was " + line);
            return;
        }
        Cell cell = this.getCell(parts[0], parts[1]);
        if (cell == null) {
            return;
        }
        double cap = 0.0;
        if (parts.length > 3) {
            try {
                cap = Double.parseDouble(parts[3]);
            }
            catch (NumberFormatException e) {
                System.out.println("Error on line " + lineno + " " + e.getMessage());
            }
        }
        if ((list = this.netsByCell.get(cell)) == null) {
            list = new ArrayList<Net>();
            this.netsByCell.put(cell, list);
        }
        Net n = new Net();
        n.name = parts[2];
        n.replacementCap = cap;
        list.add(n);
    }

    private Cell getCell(String library, String cell) {
        Library lib = Library.findLibrary(library);
        if (lib == null) {
            System.out.println("Could not find library " + library);
            return null;
        }
        Cell c = lib.findNodeProto(cell);
        if (c == null) {
            System.out.println("Could not find cell " + cell + " in library " + library);
            return null;
        }
        return c;
    }

    public void setExemptedNets(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        List<Net> netNames = this.netsByCell.get(cell);
        if (netNames == null) {
            return;
        }
        for (Net n : netNames) {
            String netName = n.name;
            Network net = this.findNetwork(info, netName);
            if (net == null) {
                System.out.println("Cannot find network " + netName + " in cell " + cell.describe(true));
                continue;
            }
            System.out.println("exemptedNets: specified net " + cell.describe(false) + " " + netName);
            int netID = info.getNetID(net);
            this.exemptedNetIDs.add(new Integer(netID));
        }
    }

    private Network findNetwork(HierarchyEnumerator.CellInfo info, String name) {
        Iterator<Network> it = info.getNetlist().getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (!net.hasName(name)) continue;
            return net;
        }
        return null;
    }

    public boolean isExempted(int netID) {
        return this.exemptedNetIDs.contains(new Integer(netID));
    }

    public double getReplacementCap(Cell cell, Network net) {
        List<Net> netNames = this.netsByCell.get(cell);
        if (netNames == null) {
            return 0.0;
        }
        for (Net n : netNames) {
            if (!net.hasName(n.name)) continue;
            return n.replacementCap;
        }
        return 0.0;
    }

    private static class Net {
        private String name;
        private double replacementCap;

        private Net() {
        }
    }
}

