/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JelibParser {
    Version version;
    Variable[] libVars;
    final LinkedHashMap<LibId, String> externalLibIds = new LinkedHashMap();
    final LinkedHashMap<CellId, Rectangle2D> externalCells = new LinkedHashMap();
    final LinkedHashMap<ExportId, EPoint> externalExports = new LinkedHashMap();
    final LinkedHashMap<TechId, Variable[]> techIds = new LinkedHashMap();
    final LinkedHashMap<PrimitiveNodeId, Variable[]> primitiveNodeIds = new LinkedHashMap();
    final LinkedHashMap<PrimitivePortId, Variable[]> primitivePortIds = new LinkedHashMap();
    final LinkedHashMap<ArcProtoId, Variable[]> arcProtoIds = new LinkedHashMap();
    final LinkedHashMap<String, Variable[]> tools = new LinkedHashMap();
    final LinkedHashMap<CellId, CellContents> allCells = new LinkedHashMap();
    final LinkedHashSet<String> delibCellFiles = new LinkedHashSet();
    private static String[] revisions = new String[]{"8.01aw", "8.04l"};
    private static final Version newDelibHeaderVersion = Version.parseVersion("8.04n");
    private static int defaultArcFlags = ImmutableArcInst.DEFAULT_FLAGS;
    final URL fileURL;
    private final FileType fileType;
    private final IdManager idManager;
    private final LibId libId;
    private final String filePath;
    private LineNumberReader lineReader;
    private final LineNumberReader delibHeaderReader;
    private int revision = revisions.length;
    private final ErrorLogger errorLogger;
    private final MutableTextDescriptor mtd = new MutableTextDescriptor();
    private final ArrayList<Variable> variablesBuf = new ArrayList();
    private final HashMap<String, ArrayList<CellContents>> cellsWithProtoName = new HashMap();
    private final TransitiveRelation<String> transitiveProtoNames = new TransitiveRelation();
    private HashMap<String, TextDescriptorAndCode> parsedDescriptorsF = new HashMap();
    private HashMap<String, TextDescriptorAndCode> parsedDescriptorsT = new HashMap();
    private char escapeChar = (char)92;
    private String curLibName;
    private String curReadFile;
    private LibId curExternalLibId = null;
    private CellId curExternalCellId = null;
    private TechId curTechId = null;
    private PrimitiveNodeId curPrimId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JelibParser(LibId libId, URL fileURL, FileType fileType, boolean onlyProjectSettings, ErrorLogger errorLogger) throws IOException {
        InputStream inputStream;
        this.idManager = libId.idManager;
        this.libId = libId;
        this.fileURL = fileURL;
        this.fileType = fileType;
        this.filePath = fileURL.getFile();
        this.errorLogger = errorLogger;
        if (fileType == FileType.JELIB) {
            URLConnection urlCon = fileURL.openConnection();
            urlCon.setConnectTimeout(10000);
            urlCon.setReadTimeout(1000);
            this.curReadFile = this.filePath;
            inputStream = urlCon.getInputStream();
        } else if (fileType == FileType.DELIB) {
            this.curReadFile = this.filePath + File.separator + "header";
            inputStream = new FileInputStream(this.curReadFile);
        } else {
            throw new IllegalArgumentException("fileType");
        }
        InputStreamReader is = new InputStreamReader(inputStream, "UTF-8");
        this.lineReader = new LineNumberReader(is);
        this.delibHeaderReader = fileType == FileType.DELIB ? this.lineReader : null;
        try {
            this.readFromFile(onlyProjectSettings);
            this.collectCellGroups();
        }
        catch (Exception e) {
            this.logError("Exception " + e.getMessage());
        }
        finally {
            this.lineReader.close();
        }
    }

    private void collectCellGroups() {
        Iterator<Set<String>> git = this.transitiveProtoNames.getSetsOfRelatives();
        while (git.hasNext()) {
            Set<String> protoNames = git.next();
            ArrayList<CellContents> cellsInGroup = new ArrayList<CellContents>();
            for (String protoName : protoNames) {
                ArrayList<CellContents> list = this.cellsWithProtoName.get(protoName);
                if (list == null) {
                    this.logError("No cells for group name " + protoName);
                    continue;
                }
                cellsInGroup.addAll(list);
            }
            ArrayList<CellName> cellNamesInGroup = new ArrayList<CellName>();
            for (CellContents cc : cellsInGroup) {
                cellNamesInGroup.add(cc.cellId.cellName);
            }
            CellName groupName = Snapshot.makeCellGroupName(cellNamesInGroup);
            for (CellContents cc : cellsInGroup) {
                cc.groupName = groupName;
            }
        }
    }

    public static JelibParser parse(LibId libId, URL fileURL, FileType fileType, boolean onlyProjectSettings, ErrorLogger errorLogger) throws IOException {
        return new JelibParser(libId, fileURL, fileType, onlyProjectSettings, errorLogger);
    }

    private void readFromFile(boolean onlyProjectSettings) throws IOException {
        String line;
        boolean ignoreCvsMergedContent = false;
        while ((line = this.lineReader.readLine()) != null) {
            Variable[] vars;
            List<String> pieces;
            char first;
            if (line.length() == 0 || (first = line.charAt(0)) == '#') continue;
            if (line.startsWith("<<<<<<<")) {
                ignoreCvsMergedContent = true;
                this.logError("CVS conflicts found: " + line);
                continue;
            }
            if (ignoreCvsMergedContent && line.startsWith("=======")) {
                ignoreCvsMergedContent = false;
                continue;
            }
            if (line.startsWith(">>>>>>>") || ignoreCvsMergedContent || onlyProjectSettings && first != 'H' && first != 'O' && first != 'T') continue;
            if (first == 'C') {
                if (this.lineReader == this.delibHeaderReader) {
                    this.readDelibCell(line);
                    continue;
                }
                this.readCell(line);
                continue;
            }
            if (first == 'L') {
                pieces = this.parseLine(line);
                if (pieces.size() != 2) {
                    this.logError("External library declaration needs 2 fields: " + line);
                    continue;
                }
                String libName = this.unQuote(pieces.get(0));
                this.curExternalLibId = this.idManager.newLibId(libName);
                String libFileName = this.unQuote(pieces.get(1));
                if (this.externalLibIds.containsKey(this.curExternalLibId)) continue;
                this.externalLibIds.put(this.curExternalLibId, libFileName);
                continue;
            }
            if (first == 'R') {
                int numPieces;
                pieces = this.parseLine(line);
                int n = numPieces = this.revision == 1 ? 7 : 5;
                if (pieces.size() != numPieces) {
                    this.logError("External cell declaration needs " + numPieces + " fields: " + line);
                    continue;
                }
                double lowX = JelibParser.readDouble(pieces.get(1));
                double highX = JelibParser.readDouble(pieces.get(2));
                double lowY = JelibParser.readDouble(pieces.get(3));
                double highY = JelibParser.readDouble(pieces.get(4));
                if (this.revision == 1) {
                    Long.parseLong(pieces.get(5));
                    Long.parseLong(pieces.get(6));
                }
                Rectangle2D.Double bounds = new Rectangle2D.Double(lowX, lowY, highX - lowX, highY - lowY);
                String cellName = this.unQuote(pieces.get(0));
                this.curExternalCellId = this.curExternalLibId.newCellId(CellName.parseName(cellName));
                if (this.externalCells.containsKey(this.curExternalCellId)) continue;
                this.externalCells.put(this.curExternalCellId, bounds);
                continue;
            }
            if (first == 'F') {
                pieces = this.parseLine(line);
                if (pieces.size() != 3) {
                    this.logError("External export declaration needs 3 fields: " + line);
                    continue;
                }
                String exportName = this.unQuote(pieces.get(0));
                double posX = JelibParser.readDouble(pieces.get(1));
                double posY = JelibParser.readDouble(pieces.get(1));
                ExportId exportId = this.curExternalCellId.newPortId(exportName);
                this.externalExports.put(exportId, EPoint.fromLambda(posX, posY));
                continue;
            }
            if (first == 'H') {
                pieces = this.parseLine(line);
                if (pieces.size() < 2) {
                    this.logError("Library declaration needs 2 fields: " + line);
                    continue;
                }
                this.version = Version.parseVersion(pieces.get(1));
                if (this.version == null) {
                    this.logError("Badly formed version: " + pieces.get(1));
                    continue;
                }
                this.revision = 0;
                while (this.revision < revisions.length && this.version.compareTo(Version.parseVersion(revisions[this.revision])) >= 0) {
                    ++this.revision;
                }
                this.escapeChar = (char)(this.revision < 1 ? 94 : 92);
                pieces = this.parseLine(line);
                this.curLibName = this.unQuote(pieces.get(0));
                if (this.version.compareTo(Version.getVersion()) > 0) {
                    this.logWarning("Library " + this.curLibName + " comes from a NEWER version of Electric (" + this.version + ")");
                }
                this.libVars = this.readVariables(pieces, 2);
                continue;
            }
            if (first == 'O') {
                pieces = this.parseLine(line);
                String toolName = this.unQuote(pieces.get(0));
                Variable[] vars2 = this.readVariables(pieces, 1);
                if (this.tools.containsKey(toolName)) continue;
                this.tools.put(toolName, vars2);
                continue;
            }
            if (first == 'V') {
                String viewAbbr;
                pieces = this.parseLine(line);
                String viewName = this.unQuote(pieces.get(0));
                View view = View.findView(viewName);
                if (view == null && (view = View.newInstance(viewName, viewAbbr = this.unQuote(pieces.get(1)))) == null) {
                    this.logError("Cannot create view " + viewName);
                    continue;
                }
                vars = this.readVariables(pieces, 2);
                continue;
            }
            if (first == 'T') {
                pieces = this.parseLine(line);
                String techName = this.unQuote(pieces.get(0));
                this.curTechId = this.idManager.newTechId(techName);
                this.curPrimId = null;
                Variable[] vars3 = this.readVariables(pieces, 1);
                if (this.techIds.containsKey(this.curTechId)) continue;
                this.techIds.put(this.curTechId, vars3);
                continue;
            }
            if (first == 'D') {
                pieces = this.parseLine(line);
                String primName = this.unQuote(pieces.get(0));
                if (this.curTechId == null) {
                    this.logError("Primitive node " + primName + " has no technology before it");
                    continue;
                }
                this.curPrimId = this.curTechId.newPrimitiveNodeId(primName);
                Variable[] vars4 = this.readVariables(pieces, 1);
                if (this.primitiveNodeIds.containsKey(this.curPrimId)) continue;
                this.primitiveNodeIds.put(this.curPrimId, vars4);
                continue;
            }
            if (first == 'P') {
                pieces = this.parseLine(line);
                String primPortName = this.unQuote(pieces.get(0));
                if (this.curPrimId == null) {
                    this.logError("Primitive port " + primPortName + " has no primitive node before it");
                    continue;
                }
                PrimitivePortId primitivePortId = this.curPrimId.newPortId(primPortName);
                vars = this.readVariables(pieces, 1);
                if (this.primitivePortIds.containsKey(primitivePortId)) continue;
                this.primitivePortIds.put(primitivePortId, vars);
                continue;
            }
            if (first == 'W') {
                pieces = this.parseLine(line);
                String arcName = this.unQuote(pieces.get(0));
                if (this.curTechId == null) {
                    this.logError("Primitive arc " + arcName + " has no technology before it");
                    continue;
                }
                ArcProtoId arcProtoId = this.curTechId.newArcProtoId(arcName);
                vars = this.readVariables(pieces, 1);
                if (this.arcProtoIds.containsKey(arcProtoId)) continue;
                this.arcProtoIds.put(arcProtoId, vars);
                continue;
            }
            if (first == 'G') {
                pieces = this.parseLine(line);
                String firstProtoName = null;
                for (int i = 0; i < pieces.size(); ++i) {
                    CellName cellName;
                    String cellNameString = this.unQuote(pieces.get(i));
                    if (cellNameString.length() == 0) continue;
                    int colonPos = cellNameString.indexOf(58);
                    if (colonPos >= 0) {
                        cellNameString = cellNameString.substring(colonPos + 1);
                    }
                    if ((cellName = CellName.parseName(cellNameString)) == null) {
                        this.logError("Bad cell name " + cellNameString);
                        continue;
                    }
                    if (this.cellsWithProtoName.get(cellName.getName()) == null) {
                        this.logError("Unknown cell " + cellName);
                        continue;
                    }
                    String protoName = cellName.getName();
                    if (firstProtoName == null) {
                        firstProtoName = protoName;
                        continue;
                    }
                    this.transitiveProtoNames.theseAreRelated(firstProtoName, protoName);
                }
                continue;
            }
            this.logError("Unrecognized line: " + line);
        }
    }

    private void readDelibCell(String line) throws IOException {
        String cellFile = line.substring(1, line.length());
        if (this.version.compareTo(newDelibHeaderVersion) >= 0) {
            File delibDir;
            if (cellFile.equals("____SEARCH_FOR_CELL_FILES____") && (delibDir = new File(this.filePath)).exists() && delibDir.isDirectory()) {
                for (File file : delibDir.listFiles()) {
                    View view;
                    String name;
                    int dot;
                    if (file.isDirectory() || (dot = (name = file.getName()).lastIndexOf(46)) < 0 || (view = View.findView(name.substring(dot + 1))) == null) continue;
                    try {
                        this.readDelibFile(file);
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        Input.errorLogger.logError("Exception reading file " + file, -1);
                    }
                }
            }
            return;
        }
        cellFile = cellFile.replace('/', File.separatorChar);
        File cellFD = new File(this.filePath, cellFile);
        this.readDelibFile(cellFD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDelibFile(File cellFD) throws IOException {
        LineNumberReader cellReader;
        try {
            FileInputStream fin = new FileInputStream(cellFD);
            InputStreamReader is = new InputStreamReader(fin);
            cellReader = new LineNumberReader(is);
        }
        catch (IOException e) {
            System.out.println("Error opening file " + cellFD + ": " + e.getMessage());
            return;
        }
        Version savedVersion = this.version;
        int savedRevision = this.revision;
        char savedEscapeChar = this.escapeChar;
        String savedCurLibName = this.curLibName;
        this.lineReader = cellReader;
        this.curReadFile = cellFD.getAbsolutePath();
        try {
            this.readFromFile(false);
            this.delibCellFiles.add(this.curReadFile);
        }
        finally {
            this.version = savedVersion;
            this.revision = savedRevision;
            this.escapeChar = savedEscapeChar;
            this.curLibName = savedCurLibName;
            this.lineReader.close();
            this.lineReader = this.delibHeaderReader;
            this.curReadFile = this.filePath;
        }
    }

    private void readCell(String line) throws IOException {
        String nextLine;
        String name;
        int numPieces;
        List<String> pieces = this.parseLine(line);
        int n = this.revision >= 2 ? 6 : (numPieces = this.revision == 1 ? 5 : 7);
        if (pieces.size() < numPieces) {
            this.logError("Cell declaration needs " + numPieces + " fields: " + line);
            return;
        }
        int fieldIndex = 0;
        String groupName = null;
        if (this.revision >= 1) {
            String s;
            name = this.unQuote(pieces.get(fieldIndex++));
            if (this.revision >= 2 && (s = pieces.get(fieldIndex++)).length() > 0) {
                groupName = this.unQuote(s);
            }
        } else {
            name = this.unQuote(pieces.get(fieldIndex++));
            String viewAbbrev = pieces.get(fieldIndex++);
            String versionString = pieces.get(fieldIndex++);
            name = name + ";" + versionString + "{" + viewAbbrev + "}";
        }
        CellName cellName = CellName.parseName(name);
        CellContents cc = new CellContents(this.version);
        cc.fileName = this.curReadFile;
        cc.lineNumber = this.lineReader.getLineNumber() + 1;
        cc.cellId = this.libId.newCellId(cellName);
        String techName = this.unQuote(pieces.get(fieldIndex++));
        cc.techId = this.idManager.newTechId(techName);
        cc.creationDate = Long.parseLong(pieces.get(fieldIndex++));
        cc.revisionDate = Long.parseLong(pieces.get(fieldIndex++));
        String stateInfo = pieces.get(fieldIndex++);
        block13: for (int i = 0; i < stateInfo.length(); ++i) {
            switch (stateInfo.charAt(i)) {
                case 'E': {
                    cc.expanded = true;
                    continue block13;
                }
                case 'L': {
                    cc.allLocked = true;
                    continue block13;
                }
                case 'I': {
                    cc.instLocked = true;
                    continue block13;
                }
                case 'C': {
                    cc.cellLib = true;
                    continue block13;
                }
                case 'T': {
                    cc.techLib = true;
                }
            }
        }
        assert (fieldIndex == numPieces);
        cc.vars = this.readVariables(pieces, numPieces);
        while ((nextLine = this.lineReader.readLine()) != null) {
            if (nextLine.length() == 0) continue;
            char nextFirst = nextLine.charAt(0);
            if (nextFirst == 'X') break;
            switch (nextFirst) {
                case '#': {
                    break;
                }
                case 'I': 
                case 'N': {
                    this.parseNode(nextLine, cc);
                    break;
                }
                case 'E': {
                    this.parseExport(nextLine, cc);
                    break;
                }
                case 'A': {
                    this.parseArc(nextLine, cc);
                    break;
                }
            }
        }
        if (cc.version == null) {
            this.logError("Version for Cell '" + cc.cellId.cellName + "' is null");
            return;
        }
        if (this.allCells.containsKey(cc.cellId)) {
            this.logError("Duplicate cell " + cc.cellId);
            return;
        }
        String protoName = cellName.getName();
        if (groupName == null) {
            groupName = protoName;
        }
        this.transitiveProtoNames.theseAreRelated(protoName, groupName);
        this.allCells.put(cc.cellId, cc);
        ArrayList<CellContents> list = this.cellsWithProtoName.get(protoName);
        if (list == null) {
            list = new ArrayList();
            this.cellsWithProtoName.put(protoName, list);
        }
        list.add(cc);
    }

    private void parseNode(String cellString, CellContents cc) {
        String stateInfo;
        String orientString;
        int lastQuote;
        int numPieces;
        NodeContents n = new NodeContents();
        n.line = this.lineReader.getLineNumber();
        List<String> pieces = this.parseLine(cellString);
        char firstChar = cellString.charAt(0);
        int n2 = this.revision < 1 ? 10 : (numPieces = firstChar == 'N' ? 9 : 8);
        if (pieces.size() < numPieces) {
            this.logError("Node instance needs " + numPieces + " fields: " + cellString, cc.cellId);
            return;
        }
        String protoName = this.unQuote(pieces.get(0));
        String diskNodeName = this.revision >= 1 ? pieces.get(1) : this.unQuote(pieces.get(1));
        String nodeName = diskNodeName;
        if (nodeName.charAt(0) == '\"' && (lastQuote = nodeName.lastIndexOf(34)) > 1) {
            nodeName = nodeName.substring(1, lastQuote);
            if (this.revision >= 1) {
                nodeName = this.unQuote(nodeName);
            }
        }
        n.nodeName = nodeName;
        String nameTextDescriptorInfo = pieces.get(2);
        double x = JelibParser.readDouble(pieces.get(3));
        double y = JelibParser.readDouble(pieces.get(4));
        LibId libId = cc.cellId.libId;
        String prefixName = libId.libName;
        int colonPos = protoName.indexOf(58);
        if (colonPos < 0) {
            n.protoId = firstChar == 'I' || this.revision < 1 ? libId.newCellId(CellName.parseName(protoName)) : cc.techId.newPrimitiveNodeId(protoName);
        } else {
            prefixName = protoName.substring(0, colonPos);
            protoName = protoName.substring(colonPos + 1);
            if (firstChar == 'I' || this.revision < 1 && protoName.indexOf(123) >= 0) {
                if (!prefixName.equals(this.curLibName)) {
                    libId = this.idManager.newLibId(prefixName);
                }
                n.protoId = libId.newCellId(CellName.parseName(protoName));
            } else {
                n.protoId = this.idManager.newTechId(prefixName).newPrimitiveNodeId(protoName);
            }
        }
        n.size = EPoint.ORIGIN;
        boolean flipX = false;
        boolean flipY = false;
        String textDescriptorInfo = "";
        if (firstChar == 'N' || this.revision < 1) {
            double wid = JelibParser.readDouble(pieces.get(5));
            if (this.revision < 1 && (wid < 0.0 || wid == 0.0 && 1.0 / wid < 0.0)) {
                flipX = true;
                wid = -wid;
            }
            double hei = JelibParser.readDouble(pieces.get(6));
            if (this.revision < 1 && (hei < 0.0 || hei == 0.0 && 1.0 / hei < 0.0)) {
                flipY = true;
                hei = -hei;
            }
            if (n.protoId instanceof PrimitiveNodeId) {
                n.size = EPoint.fromLambda(wid, hei);
            }
            orientString = pieces.get(7);
            stateInfo = pieces.get(8);
            if (this.revision < 1) {
                textDescriptorInfo = pieces.get(9);
            }
        } else {
            orientString = pieces.get(5);
            stateInfo = pieces.get(6);
            textDescriptorInfo = pieces.get(7);
        }
        int angle = 0;
        for (int i = 0; i < orientString.length(); ++i) {
            char ch = orientString.charAt(i);
            if (ch == 'X') {
                flipX = !flipX;
                continue;
            }
            if (ch == 'Y') {
                flipY = !flipY;
                continue;
            }
            if (ch == 'R') {
                angle += 900;
                continue;
            }
            angle += Integer.valueOf(orientString.substring(i)).intValue();
            break;
        }
        TextDescriptorAndCode nameTdC = this.loadTextDescriptor(nameTextDescriptorInfo, false);
        n.nameTextDescriptor = nameTdC.td;
        int flags = 0;
        int techBits = 0;
        block11: for (int i = 0; i < stateInfo.length(); ++i) {
            char chr = stateInfo.charAt(i);
            switch (chr) {
                case 'E': {
                    continue block11;
                }
                case 'L': {
                    flags = ImmutableNodeInst.LOCKED.set(flags, true);
                    continue block11;
                }
                case 'S': {
                    continue block11;
                }
                case 'V': {
                    flags = ImmutableNodeInst.VIS_INSIDE.set(flags, true);
                    continue block11;
                }
                case 'W': {
                    continue block11;
                }
                case 'A': {
                    flags = ImmutableNodeInst.HARD_SELECT.set(flags, true);
                    continue block11;
                }
                default: {
                    if (!Character.isDigit(chr)) continue block11;
                    stateInfo = stateInfo.substring(i);
                    try {
                        techBits = Integer.parseInt(stateInfo);
                    }
                    catch (NumberFormatException e) {
                        this.logError("(" + cc.cellId + ") bad node bits" + stateInfo, cc.cellId);
                    }
                    break block11;
                }
            }
        }
        n.flags = flags;
        n.techBits = techBits;
        TextDescriptorAndCode protoTdC = this.loadTextDescriptor(textDescriptorInfo, false);
        n.protoTextDescriptor = protoTdC.td;
        n.orient = Orientation.fromJava(angle, flipX, flipY);
        n.anchor = EPoint.fromLambda(x, y);
        n.vars = this.readVariables(pieces, numPieces);
        cc.nodes.add(n);
        cc.diskName.put(diskNodeName, n);
    }

    private void parseExport(String cellString, CellContents cc) {
        PortCharacteristic ch;
        String s;
        int numPieces;
        ExportContents e = new ExportContents();
        e.line = this.lineReader.getLineNumber();
        List<String> pieces = this.parseLine(cellString);
        if (this.revision >= 2 && pieces.size() == 1) {
            String exportName = this.unQuote(pieces.get(0));
            cc.cellId.newPortId(exportName);
            return;
        }
        int n = this.revision >= 2 ? 6 : (numPieces = this.revision == 1 ? 5 : 7);
        if (pieces.size() < numPieces) {
            this.logError("Export needs " + numPieces + " fields, has " + pieces.size() + ": " + cellString, cc.cellId);
            return;
        }
        int fieldIndex = 0;
        String exportName = this.unQuote(pieces.get(fieldIndex++));
        String exportUserName = null;
        if (this.revision >= 2 && (s = pieces.get(fieldIndex++)).length() != 0) {
            exportUserName = this.unQuote(s);
        }
        if (exportUserName == null || exportName.equals(exportUserName)) {
            exportName = Name.findName(exportName).toString();
        }
        e.exportId = cc.cellId.newPortId(exportName);
        e.exportUserName = exportUserName;
        String textDescriptorInfo = pieces.get(fieldIndex++);
        String nodeName = this.revision >= 1 ? pieces.get(fieldIndex++) : this.unQuote(pieces.get(fieldIndex++));
        e.originalNode = cc.diskName.get(nodeName);
        String portName = this.unQuote(pieces.get(fieldIndex++));
        e.originalPort = e.originalNode.protoId.newPortId(portName);
        Point2D.Double pos = null;
        if (this.revision < 1) {
            double x = JelibParser.readDouble(pieces.get(fieldIndex++));
            double y = JelibParser.readDouble(pieces.get(fieldIndex++));
            pos = new Point2D.Double(x, y);
        }
        e.pos = pos;
        String userBits = pieces.get(fieldIndex++);
        assert (fieldIndex == numPieces);
        TextDescriptorAndCode nameTdC = this.loadTextDescriptor(textDescriptorInfo, false);
        e.nameTextDescriptor = nameTdC.td;
        int slashPos = userBits.indexOf(47);
        if (slashPos >= 0) {
            String extras = userBits.substring(slashPos);
            userBits = userBits.substring(0, slashPos);
            while (extras.length() > 0) {
                switch (extras.charAt(1)) {
                    case 'A': {
                        e.alwaysDrawn = true;
                        break;
                    }
                    case 'B': {
                        e.bodyOnly = true;
                    }
                }
                extras = extras.substring(2);
            }
        }
        e.ch = (ch = PortCharacteristic.findCharacteristicShort(userBits)) != null ? ch : PortCharacteristic.UNKNOWN;
        e.vars = this.readVariables(pieces, numPieces);
        cc.exports.add(e);
    }

    private void parseArc(String cellString, CellContents cc) {
        int lastQuote;
        ArcContents a = new ArcContents();
        a.line = this.lineReader.getLineNumber();
        List<String> pieces = this.parseLine(cellString);
        if (pieces.size() < 13) {
            this.logError("Arc instance needs 13 fields: " + cellString, cc.cellId);
            return;
        }
        TechId techId = cc.techId;
        String protoName = this.unQuote(pieces.get(0));
        int indexOfColon = protoName.indexOf(58);
        if (indexOfColon >= 0) {
            techId = this.idManager.newTechId(protoName.substring(0, indexOfColon));
            protoName = protoName.substring(indexOfColon + 1);
        }
        a.arcProtoId = techId.newArcProtoId(protoName);
        String diskArcName = this.revision >= 1 ? pieces.get(1) : this.unQuote(pieces.get(1));
        String arcName = diskArcName;
        if (arcName.charAt(0) == '\"' && (lastQuote = arcName.lastIndexOf(34)) > 1) {
            arcName = arcName.substring(1, lastQuote);
            if (this.revision >= 1) {
                arcName = this.unQuote(arcName);
            }
        }
        a.arcName = arcName;
        a.diskWidth = JelibParser.readDouble(pieces.get(3));
        String headNodeName = this.revision >= 1 ? pieces.get(5) : this.unQuote(pieces.get(5));
        String headPortName = this.unQuote(pieces.get(6));
        double headX = JelibParser.readDouble(pieces.get(7));
        double headY = JelibParser.readDouble(pieces.get(8));
        a.headNode = cc.diskName.get(headNodeName);
        a.headPort = a.headNode.protoId.newPortId(headPortName);
        a.headPoint = EPoint.fromLambda(headX, headY);
        String tailNodeName = this.revision >= 1 ? pieces.get(9) : this.unQuote(pieces.get(9));
        String tailPortName = this.unQuote(pieces.get(10));
        double tailX = JelibParser.readDouble(pieces.get(11));
        double tailY = JelibParser.readDouble(pieces.get(12));
        a.tailNode = cc.diskName.get(tailNodeName);
        a.tailPort = a.tailNode.protoId.newPortId(tailPortName);
        a.tailPoint = EPoint.fromLambda(tailX, tailY);
        String stateInfo = pieces.get(4);
        boolean extended = true;
        boolean directional = false;
        boolean reverseEnds = false;
        boolean skipHead = false;
        boolean skipTail = false;
        boolean tailNotExtended = false;
        boolean headNotExtended = false;
        boolean tailArrowed = false;
        boolean headArrowed = false;
        boolean bodyArrowed = false;
        int flags = defaultArcFlags;
        int angle = 0;
        block18: for (int i = 0; i < stateInfo.length(); ++i) {
            char chr = stateInfo.charAt(i);
            switch (chr) {
                case 'R': {
                    flags = ImmutableArcInst.RIGID.set(flags, true);
                    continue block18;
                }
                case 'F': {
                    flags = ImmutableArcInst.FIXED_ANGLE.set(flags, false);
                    continue block18;
                }
                case 'S': {
                    flags = ImmutableArcInst.SLIDABLE.set(flags, true);
                    continue block18;
                }
                case 'A': {
                    flags = ImmutableArcInst.HARD_SELECT.set(flags, true);
                    continue block18;
                }
                case 'N': {
                    flags = ImmutableArcInst.TAIL_NEGATED.set(flags, true);
                    continue block18;
                }
                case 'G': {
                    flags = ImmutableArcInst.HEAD_NEGATED.set(flags, true);
                    continue block18;
                }
                case 'X': {
                    headArrowed = true;
                    continue block18;
                }
                case 'Y': {
                    tailArrowed = true;
                    continue block18;
                }
                case 'B': {
                    bodyArrowed = true;
                    continue block18;
                }
                case 'I': {
                    headNotExtended = true;
                    continue block18;
                }
                case 'J': {
                    tailNotExtended = true;
                    continue block18;
                }
                case 'E': {
                    extended = false;
                    continue block18;
                }
                case 'D': {
                    directional = true;
                    continue block18;
                }
                case 'V': {
                    reverseEnds = true;
                    continue block18;
                }
                case 'H': {
                    skipHead = true;
                    continue block18;
                }
                case 'T': {
                    skipTail = true;
                    continue block18;
                }
                default: {
                    if ('0' > chr || chr > '9') continue block18;
                    angle = Integer.valueOf(stateInfo.substring(i));
                    break block18;
                }
            }
        }
        if (!extended || directional) {
            if (!extended) {
                tailNotExtended = true;
                headNotExtended = true;
            }
            if (directional) {
                if (reverseEnds) {
                    tailArrowed = true;
                } else {
                    headArrowed = true;
                }
                bodyArrowed = true;
            }
            if (skipHead) {
                headNotExtended = false;
                headArrowed = false;
            }
            if (skipTail) {
                tailNotExtended = false;
                tailArrowed = false;
            }
        }
        flags = ImmutableArcInst.HEAD_EXTENDED.set(flags, !headNotExtended);
        flags = ImmutableArcInst.TAIL_EXTENDED.set(flags, !tailNotExtended);
        flags = ImmutableArcInst.HEAD_ARROWED.set(flags, headArrowed);
        flags = ImmutableArcInst.TAIL_ARROWED.set(flags, tailArrowed);
        flags = ImmutableArcInst.BODY_ARROWED.set(flags, bodyArrowed);
        a.angle = angle;
        a.flags = flags;
        String nameTextDescriptorInfo = pieces.get(2);
        TextDescriptorAndCode nameTdC = this.loadTextDescriptor(nameTextDescriptorInfo, false);
        a.nameTextDescriptor = nameTdC.td;
        a.vars = this.readVariables(pieces, 13);
        cc.arcs.add(a);
    }

    private List<String> parseLine(String line) {
        ArrayList<String> stringPieces = new ArrayList<String>();
        int len = line.length();
        int pos = 1;
        int startPos = 1;
        boolean inQuote = false;
        while (pos < len) {
            char chr;
            if ((chr = line.charAt(pos++)) == this.escapeChar) {
                ++pos;
                continue;
            }
            if (chr == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (chr != '|' || inQuote) continue;
            stringPieces.add(line.substring(startPos, pos - 1));
            startPos = pos;
        }
        if (pos > len) {
            pos = len;
        }
        stringPieces.add(line.substring(startPos, pos));
        return stringPieces;
    }

    private String unQuote(String line) {
        int len = line.length();
        if (this.revision >= 1) {
            if (len < 2 || line.charAt(0) != '\"') {
                return line;
            }
            int lastQuote = line.lastIndexOf(34);
            if (lastQuote != len - 1) {
                return this.unQuote(line.substring(0, lastQuote + 1)) + line.substring(lastQuote + 1);
            }
            line = line.substring(1, len - 1);
            len -= 2;
        } else if (line.indexOf(this.escapeChar) < 0) {
            return line;
        }
        StringBuffer sb = new StringBuffer();
        assert (len == line.length());
        for (int i = 0; i < len; ++i) {
            char chr = line.charAt(i);
            if (chr == this.escapeChar) {
                if (++i >= len) break;
                chr = line.charAt(i);
                if (chr == 'n' && this.revision >= 1) {
                    chr = '\n';
                }
                if (chr == 'r' && this.revision >= 1) {
                    chr = '\r';
                }
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    private Variable[] readVariables(List<String> pieces, int position) {
        this.variablesBuf.clear();
        int total = pieces.size();
        block21: for (int i = position; i < total; ++i) {
            int openPos;
            String piece = pieces.get(i);
            boolean inQuote = false;
            for (openPos = 0; openPos < piece.length(); ++openPos) {
                char chr = piece.charAt(openPos);
                if (chr == this.escapeChar) {
                    ++openPos;
                    continue;
                }
                if (chr == '\"') {
                    boolean bl = inQuote = !inQuote;
                }
                if (chr == '(' && !inQuote) break;
            }
            if (openPos >= piece.length()) {
                this.logError("Badly formed variable (no open parenthesis): " + piece);
                continue;
            }
            String varName = this.unQuote(piece.substring(0, openPos));
            Variable.Key varKey = Variable.newKey(varName);
            int closePos = piece.indexOf(41, openPos);
            if (closePos < 0) {
                this.logError("Badly formed variable (no close parenthesis): " + piece);
                continue;
            }
            String varBits = piece.substring(openPos + 1, closePos);
            int objectPos = closePos + 1;
            if (objectPos >= piece.length()) {
                this.logError("Variable type missing: " + piece);
                continue;
            }
            char varType = piece.charAt(objectPos++);
            switch (varType) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'O': 
                case 'P': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'V': 
                case 'Y': {
                    break;
                }
                default: {
                    this.logError("Variable type invalid: " + piece);
                    continue block21;
                }
            }
            Object[] obj = null;
            if (objectPos >= piece.length()) continue;
            if (piece.charAt(objectPos) == '[') {
                Object[] objArray;
                ArrayList<Object> objList = new ArrayList<Object>();
                ++objectPos;
                while (objectPos < piece.length()) {
                    int start = objectPos;
                    inQuote = false;
                    while (objectPos < piece.length()) {
                        if (inQuote) {
                            if (piece.charAt(objectPos) == this.escapeChar) {
                                ++objectPos;
                            } else if (piece.charAt(objectPos) == '\"') {
                                inQuote = false;
                            }
                            ++objectPos;
                            continue;
                        }
                        if (piece.charAt(objectPos) == ',' || piece.charAt(objectPos) == ']') break;
                        if (piece.charAt(objectPos) == '\"') {
                            inQuote = true;
                        }
                        ++objectPos;
                    }
                    Object oneObj = this.getVariableValue(piece.substring(start, objectPos), varType);
                    objList.add(oneObj);
                    if (piece.charAt(objectPos) == ']') break;
                    ++objectPos;
                }
                if (objectPos >= piece.length()) {
                    this.logError("Badly formed array (no closed bracket): " + piece);
                    continue;
                }
                if (objectPos < piece.length() - 1) {
                    this.logError("Badly formed array (extra characters after closed bracket): " + piece);
                    continue;
                }
                int limit = objList.size();
                switch (varType) {
                    case 'B': {
                        objArray = new Boolean[limit];
                        break;
                    }
                    case 'C': {
                        objArray = new CellId[limit];
                        break;
                    }
                    case 'D': {
                        objArray = new Double[limit];
                        break;
                    }
                    case 'E': {
                        objArray = new ExportId[limit];
                        break;
                    }
                    case 'F': {
                        objArray = new Float[limit];
                        break;
                    }
                    case 'G': {
                        objArray = new Long[limit];
                        break;
                    }
                    case 'H': {
                        objArray = new Short[limit];
                        break;
                    }
                    case 'I': {
                        objArray = new Integer[limit];
                        break;
                    }
                    case 'L': {
                        objArray = new LibId[limit];
                        break;
                    }
                    case 'O': {
                        objArray = new Tool[limit];
                        break;
                    }
                    case 'P': {
                        objArray = new PrimitiveNodeId[limit];
                        break;
                    }
                    case 'R': {
                        objArray = new ArcProtoId[limit];
                        break;
                    }
                    case 'S': {
                        objArray = new String[limit];
                        break;
                    }
                    case 'T': {
                        objArray = new TechId[limit];
                        break;
                    }
                    case 'V': {
                        objArray = new EPoint[limit];
                        break;
                    }
                    case 'Y': {
                        objArray = new Byte[limit];
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                for (int j = 0; j < limit; ++j) {
                    objArray[j] = objList.get(j);
                }
                obj = objArray;
            } else {
                obj = this.getVariableValue(piece.substring(objectPos), varType);
                if (obj == null) continue;
            }
            TextDescriptorAndCode tdc = this.loadTextDescriptor(varBits, true);
            obj = Variable.withCode(obj, tdc.code);
            Variable d = Variable.newInstance(varKey, obj, tdc.td);
            this.variablesBuf.add(d);
        }
        return this.variablesBuf.toArray(Variable.NULL_ARRAY);
    }

    private TextDescriptorAndCode loadTextDescriptor(String varBits, boolean onVar) {
        HashMap<String, TextDescriptorAndCode> parsedDescriptors = onVar ? this.parsedDescriptorsT : this.parsedDescriptorsF;
        TextDescriptorAndCode tdc = parsedDescriptors.get(varBits);
        if (tdc != null) {
            return tdc;
        }
        boolean error = false;
        this.mtd.setCBits(0, 0, 0);
        CodeExpression.Code code = CodeExpression.Code.NONE;
        if (!onVar) {
            this.mtd.setDisplay(AbstractTextDescriptor.Display.SHOWN);
        }
        double xoff = 0.0;
        double yoff = 0.0;
        block36: for (int j = 0; j < varBits.length(); ++j) {
            char varBit = varBits.charAt(j);
            switch (varBit) {
                case 'D': 
                case 'd': {
                    this.mtd.setDisplay(varBit == 'D' ? AbstractTextDescriptor.Display.SHOWN : AbstractTextDescriptor.Display.HIDDEN);
                    if (++j >= varBits.length()) {
                        this.logError("Incorrect display specification: " + varBits);
                        error = true;
                        continue block36;
                    }
                    switch (varBits.charAt(j)) {
                        case '5': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.CENT);
                            break;
                        }
                        case '8': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.UP);
                            break;
                        }
                        case '2': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.DOWN);
                            break;
                        }
                        case '4': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.LEFT);
                            break;
                        }
                        case '6': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.RIGHT);
                            break;
                        }
                        case '7': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.UPLEFT);
                            break;
                        }
                        case '9': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.UPRIGHT);
                            break;
                        }
                        case '1': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.DOWNLEFT);
                            break;
                        }
                        case '3': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.DOWNRIGHT);
                            break;
                        }
                        case '0': {
                            this.mtd.setPos(AbstractTextDescriptor.Position.BOXED);
                        }
                    }
                    continue block36;
                }
                case 'N': {
                    this.mtd.setDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                    continue block36;
                }
                case 'A': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad absolute size (semicolon missing): " + varBits);
                        error = true;
                        continue block36;
                    }
                    this.mtd.setAbsSize(Integer.valueOf(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block36;
                }
                case 'G': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad relative size (semicolon missing): " + varBits);
                        error = true;
                        continue block36;
                    }
                    this.mtd.setRelSize(JelibParser.readDouble(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block36;
                }
                case 'X': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad X offset (semicolon missing): " + varBits);
                        error = true;
                        continue block36;
                    }
                    xoff = JelibParser.readDouble(varBits.substring(j + 1, semiPos));
                    j = semiPos;
                    continue block36;
                }
                case 'Y': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad Y offset (semicolon missing): " + varBits);
                        error = true;
                        continue block36;
                    }
                    yoff = JelibParser.readDouble(varBits.substring(j + 1, semiPos));
                    j = semiPos;
                    continue block36;
                }
                case 'B': {
                    this.mtd.setBold(true);
                    continue block36;
                }
                case 'I': {
                    this.mtd.setItalic(true);
                    continue block36;
                }
                case 'L': {
                    this.mtd.setUnderline(true);
                    continue block36;
                }
                case 'F': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad font (semicolon missing): " + varBits);
                        error = true;
                        continue block36;
                    }
                    AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(varBits.substring(j + 1, semiPos));
                    if (af != null) {
                        this.mtd.setFace(af.getIndex());
                    }
                    j = semiPos;
                    continue block36;
                }
                case 'C': {
                    int semiPos = varBits.indexOf(59, j);
                    if (semiPos < 0) {
                        this.logError("Bad color (semicolon missing): " + varBits);
                        error = true;
                        continue block36;
                    }
                    this.mtd.setColorIndex(Integer.valueOf(varBits.substring(j + 1, semiPos)));
                    j = semiPos;
                    continue block36;
                }
                case 'R': {
                    AbstractTextDescriptor.Rotation rot = AbstractTextDescriptor.Rotation.ROT90;
                    if (j + 1 < varBits.length() && varBits.charAt(j + 1) == 'R') {
                        rot = AbstractTextDescriptor.Rotation.ROT180;
                        ++j;
                    }
                    if (j + 1 < varBits.length() && varBits.charAt(j + 1) == 'R') {
                        rot = AbstractTextDescriptor.Rotation.ROT270;
                        ++j;
                    }
                    this.mtd.setRotation(rot);
                    continue block36;
                }
                case 'H': {
                    this.mtd.setInherit(true);
                    continue block36;
                }
                case 'T': {
                    this.mtd.setInterior(true);
                    continue block36;
                }
                case 'P': {
                    this.mtd.setParam(true);
                    continue block36;
                }
                case 'O': {
                    if (++j >= varBits.length()) {
                        this.logError("Bad language specification: " + varBits);
                        error = true;
                        continue block36;
                    }
                    char codeLetter = varBits.charAt(j);
                    if (!onVar) {
                        this.logError("Illegal use of language specification: " + varBits);
                        error = true;
                        continue block36;
                    }
                    switch (codeLetter) {
                        case 'J': {
                            code = CodeExpression.Code.JAVA;
                            continue block36;
                        }
                        case 'L': {
                            code = CodeExpression.Code.SPICE;
                            continue block36;
                        }
                        case 'T': {
                            code = CodeExpression.Code.TCL;
                            continue block36;
                        }
                    }
                    this.logError("Unknown language specification: " + varBits);
                    error = true;
                    continue block36;
                }
                case 'U': {
                    if (++j >= varBits.length()) {
                        this.logError("Bad units specification: " + varBits);
                        error = true;
                        continue block36;
                    }
                    char unitsLetter = varBits.charAt(j);
                    if (unitsLetter == 'R') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.RESISTANCE);
                        continue block36;
                    }
                    if (unitsLetter == 'C') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.CAPACITANCE);
                        continue block36;
                    }
                    if (unitsLetter == 'I') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.INDUCTANCE);
                        continue block36;
                    }
                    if (unitsLetter == 'A') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.CURRENT);
                        continue block36;
                    }
                    if (unitsLetter == 'V') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.VOLTAGE);
                        continue block36;
                    }
                    if (unitsLetter == 'D') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.DISTANCE);
                        continue block36;
                    }
                    if (unitsLetter == 'T') {
                        this.mtd.setUnit(AbstractTextDescriptor.Unit.TIME);
                        continue block36;
                    }
                    this.logError("Unknown units specification: " + varBits);
                    error = true;
                }
            }
        }
        this.mtd.setOff(xoff, yoff);
        TextDescriptor td = TextDescriptor.newTextDescriptor(this.mtd);
        tdc = new TextDescriptorAndCode(td, code);
        if (!error) {
            parsedDescriptors.put(varBits, tdc);
        }
        return tdc;
    }

    private Object getVariableValue(String piece, char varType) {
        if (piece.length() == 0) {
            return null;
        }
        if (this.revision >= 1) {
            piece = this.unQuote(piece);
        }
        switch (varType) {
            case 'B': {
                return new Boolean(piece.charAt(0) == 'T');
            }
            case 'C': {
                if (piece.length() == 0) {
                    return null;
                }
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    this.logError("Badly formed Cell (missing colon): " + piece);
                    break;
                }
                String libName = piece.substring(0, colonPos);
                LibId libId = this.idManager.newLibId(libName);
                String cellName = piece.substring(colonPos + 1);
                int commaPos = cellName.indexOf(44);
                if (commaPos >= 0) {
                    cellName = cellName.substring(0, commaPos);
                }
                return libId.newCellId(CellName.parseName(cellName));
            }
            case 'D': {
                return Double.valueOf(piece);
            }
            case 'E': {
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    this.logError("Badly formed Export (missing library colon): " + piece);
                    break;
                }
                String libName = piece.substring(0, colonPos);
                LibId libId = this.idManager.newLibId(libName);
                int secondColonPos = piece.indexOf(58, colonPos + 1);
                if (secondColonPos < 0) {
                    this.logError("Badly formed Export (missing cell colon): " + piece);
                    break;
                }
                String cellName = piece.substring(colonPos + 1, secondColonPos);
                CellId cellId = libId.newCellId(CellName.parseName(cellName));
                String exportName = piece.substring(secondColonPos + 1);
                int commaPos = exportName.indexOf(44);
                if (commaPos >= 0) {
                    exportName = exportName.substring(0, commaPos);
                }
                return cellId.newPortId(exportName);
            }
            case 'F': {
                return Float.valueOf(piece);
            }
            case 'G': {
                return Long.valueOf(piece);
            }
            case 'H': {
                return Short.valueOf(piece);
            }
            case 'I': {
                return Integer.valueOf(piece);
            }
            case 'L': {
                String libName = piece;
                int commaPos = libName.indexOf(44);
                if (commaPos >= 0) {
                    libName = libName.substring(0, commaPos);
                }
                return this.idManager.newLibId(libName);
            }
            case 'O': {
                Tool tool;
                String toolName = piece;
                int commaPos = toolName.indexOf(44);
                if (commaPos >= 0) {
                    toolName = toolName.substring(0, commaPos);
                }
                if ((tool = Tool.findTool(toolName)) == null) {
                    this.logError("Unknown Tool: " + piece);
                }
                return tool;
            }
            case 'P': {
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    this.logError("Badly formed PrimitiveNode (missing colon): " + piece);
                    break;
                }
                String techName = piece.substring(0, colonPos);
                TechId techId = this.idManager.newTechId(techName);
                String nodeName = piece.substring(colonPos + 1);
                int commaPos = nodeName.indexOf(44);
                if (commaPos >= 0) {
                    nodeName = nodeName.substring(0, commaPos);
                }
                return techId.newPrimitiveNodeId(nodeName);
            }
            case 'R': {
                int colonPos = piece.indexOf(58);
                if (colonPos < 0) {
                    this.logError("Badly formed ArcProto (missing colon): " + piece);
                    break;
                }
                String techName = piece.substring(0, colonPos);
                TechId techId = this.idManager.newTechId(techName);
                String arcName = piece.substring(colonPos + 1);
                int commaPos = arcName.indexOf(44);
                if (commaPos >= 0) {
                    arcName = arcName.substring(0, commaPos);
                }
                return techId.newArcProtoId(arcName);
            }
            case 'S': {
                if (this.revision >= 1) {
                    return piece;
                }
                if (piece.charAt(0) != '\"') {
                    this.logError("Badly formed string variable (missing open quote): " + piece);
                    break;
                }
                StringBuffer sb = new StringBuffer();
                int len = piece.length();
                int objectPos = 0;
                while (objectPos < len && piece.charAt(++objectPos) != '\"') {
                    if (piece.charAt(objectPos) == '^' && ++objectPos <= len - 2 && piece.charAt(objectPos) == '\\' && piece.charAt(objectPos + 1) == 'n') {
                        sb.append('\n');
                        ++objectPos;
                        continue;
                    }
                    sb.append(piece.charAt(objectPos));
                }
                return sb.toString();
            }
            case 'T': {
                String techName = piece;
                int commaPos = techName.indexOf(44);
                if (commaPos >= 0) {
                    techName = techName.substring(0, commaPos);
                }
                return this.idManager.newTechId(techName);
            }
            case 'V': {
                int slashPos = piece.indexOf(47);
                if (slashPos < 0) {
                    this.logError("Badly formed Point2D variable (missing slash): " + piece);
                    break;
                }
                double x = Double.valueOf(piece.substring(0, slashPos));
                double y = Double.valueOf(piece.substring(slashPos + 1));
                return new EPoint(x, y);
            }
            case 'Y': {
                return Byte.valueOf(piece);
            }
        }
        return null;
    }

    private static double readDouble(String s) {
        return s.length() > 0 ? Double.parseDouble(s) : 0.0;
    }

    private void logError(String message) {
        String s = this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", " + message;
        this.errorLogger.logError(s, -1);
    }

    private void logWarning(String message) {
        String s = this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", " + message;
        this.errorLogger.logWarning(s, null, -1);
    }

    private void logError(String message, CellId cellId) {
        String s = this.curReadFile + ", line " + this.lineReader.getLineNumber() + ", " + message;
        this.errorLogger.logError(s, cellId, -1);
    }

    static {
        defaultArcFlags = ImmutableArcInst.HARD_SELECT.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.BODY_ARROWED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.FIXED_ANGLE.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.HEAD_NEGATED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.HEAD_EXTENDED.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.TAIL_EXTENDED.set(defaultArcFlags, true);
        defaultArcFlags = ImmutableArcInst.TAIL_NEGATED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.RIGID.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.SLIDABLE.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.HEAD_ARROWED.set(defaultArcFlags, false);
        defaultArcFlags = ImmutableArcInst.TAIL_ARROWED.set(defaultArcFlags, false);
    }

    private static class TextDescriptorAndCode {
        private final TextDescriptor td;
        private final CodeExpression.Code code;

        TextDescriptorAndCode(TextDescriptor td, CodeExpression.Code code) {
            this.td = td;
            this.code = code;
        }
    }

    static class ArcContents {
        int line;
        ArcProtoId arcProtoId;
        String arcName;
        TextDescriptor nameTextDescriptor;
        double diskWidth;
        NodeContents headNode;
        PortProtoId headPort;
        EPoint headPoint;
        NodeContents tailNode;
        PortProtoId tailPort;
        EPoint tailPoint;
        int angle;
        int flags;
        Variable[] vars;

        ArcContents() {
        }
    }

    static class ExportContents {
        int line;
        ExportId exportId;
        String exportUserName;
        NodeContents originalNode;
        PortProtoId originalPort;
        TextDescriptor nameTextDescriptor;
        PortCharacteristic ch;
        boolean alwaysDrawn;
        boolean bodyOnly;
        Variable[] vars;
        Point2D pos;

        ExportContents() {
        }
    }

    static class NodeContents {
        int line;
        NodeProtoId protoId;
        String nodeName;
        TextDescriptor nameTextDescriptor;
        EPoint anchor;
        Orientation orient;
        EPoint size;
        TextDescriptor protoTextDescriptor;
        int flags;
        int techBits;
        Variable[] vars;
        NodeInst ni;

        NodeContents() {
        }
    }

    class CellContents {
        final Version version;
        boolean filledIn;
        String fileName;
        int lineNumber;
        CellId cellId;
        CellName groupName;
        long creationDate;
        long revisionDate;
        TechId techId;
        boolean expanded;
        boolean allLocked;
        boolean instLocked;
        boolean cellLib;
        boolean techLib;
        Variable[] vars;
        List<NodeContents> nodes = new ArrayList<NodeContents>();
        List<ExportContents> exports = new ArrayList<ExportContents>();
        List<ArcContents> arcs = new ArrayList<ArcContents>();
        HashMap<String, NodeContents> diskName = new HashMap();

        CellContents(Version version) {
            this.version = version;
            this.filledIn = false;
        }
    }
}

