/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.LibId;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Version;
import com.sun.electric.tool.io.output.JELIB;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DELIB
extends JELIB {
    private HashMap<String, CellFileState> cellFileMap = new HashMap();
    private List<String> deletedCellFiles = new ArrayList<String>();
    private String headerFile;
    private boolean wroteSearchForCells = false;
    private boolean writeHeaderOnly;
    private static final String lastSubdirVersion = "8.04m";
    public static final String newHeaderVersion = "8.04n";
    public static final String SEARCH_FOR_CELL_FILES = "____SEARCH_FOR_CELL_FILES____";
    public static final char PLATFORM_INDEPENDENT_FILE_SEPARATOR = '/';

    DELIB(boolean writeHeaderOnly) {
        this.writeHeaderOnly = writeHeaderOnly;
    }

    protected boolean writeLib(Snapshot snapshot, LibId libId, Set<String> oldCellFiles) {
        File delibDir = new File(this.filePath);
        File parent = delibDir.getParentFile();
        if (parent.getName().endsWith(".delib")) {
            System.out.println("Error: Cannot write " + snapshot.getLib((LibId)libId).d.libId.libName + " inside of another DELIB directory");
            return true;
        }
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null || cellBackup.d.libId != libId) continue;
            String cellFile = DELIB.getCellFile(cellBackup);
            String file = this.filePath + File.separator + cellFile;
            CellFileState state = this.cellFileMap.get(file);
            if (state == null) {
                state = new CellFileState();
                this.cellFileMap.put(file, state);
            }
            File fd = new File(file);
            if (!cellBackup.modified && fd.exists()) continue;
            state.modified = true;
        }
        boolean b = super.writeLib(snapshot, libId, null, false);
        if (!b && !this.writeHeaderOnly) {
            this.deletedCellFiles.clear();
            if (Version.getVersion().compareTo(Version.parseVersion(lastSubdirVersion)) > 0) {
                for (File file : delibDir.listFiles()) {
                    this.checkIfDeleted(file, oldCellFiles);
                }
            } else {
                for (File subdir : delibDir.listFiles()) {
                    if (!subdir.isDirectory()) continue;
                    for (File file : subdir.listFiles()) {
                        this.checkIfDeleted(file, oldCellFiles);
                    }
                }
            }
            if (oldCellFiles != null) {
                oldCellFiles.clear();
                oldCellFiles.addAll(this.cellFileMap.keySet());
            }
        }
        return b;
    }

    private void checkIfDeleted(File cellFile, Set<String> oldCellFiles) {
        if (this.cellFileMap.containsKey(cellFile.getAbsolutePath())) {
            return;
        }
        String name = cellFile.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return;
        }
        View view = View.findView(name.substring(dot + 1));
        if (view == null) {
            return;
        }
        if (oldCellFiles == null || !oldCellFiles.contains(cellFile.getAbsolutePath())) {
            return;
        }
        System.out.println("Renaming unlinked (possibly deleted) cell file " + name + " to " + name + ".deleted");
        this.deletedCellFiles.add(cellFile.getAbsolutePath());
        File deletedFileName = new File(cellFile.getAbsolutePath() + ".deleted");
        if (!cellFile.renameTo(deletedFileName)) {
            System.out.println("  Error: Unable to rename unlinked cell file " + name + " to " + name + ".deleted!");
        }
    }

    @Override
    void writeCell(CellBackup cellBackup) {
        if (this.writeHeaderOnly) {
            return;
        }
        if (Version.getVersion().compareTo(Version.parseVersion(lastSubdirVersion)) <= 0) {
            String cellDir = DELIB.getCellSubDir(cellBackup);
            File cellFD = new File(this.filePath + File.separator + cellDir);
            if (cellFD.exists()) {
                if (!cellFD.isDirectory()) {
                    System.out.println("Error, file " + cellFD + " is not a directory, moving it to " + cellDir + ".old");
                    if (!cellFD.renameTo(new File(cellDir + ".old"))) {
                        System.out.println("Error, unable to rename file " + cellFD + " to " + cellDir + ".old, skipping cell " + cellBackup.d.cellName);
                        return;
                    }
                }
            } else if (!cellFD.mkdir()) {
                System.out.println("Failed to make directory: " + cellFD + ", skipping cell " + cellBackup.d.cellName);
                return;
            }
        }
        String cellFile = DELIB.getCellFile(cellBackup);
        String cellFileAbs = this.filePath + File.separator + cellFile;
        CellFileState state = this.cellFileMap.get(cellFileAbs);
        boolean append = state.appendFile;
        if (state.modified) {
            PrintWriter headerWriter = this.printWriter;
            try {
                this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(cellFileAbs, append)));
            }
            catch (IOException e) {
                System.out.println("Error opening " + cellFileAbs + ", skipping cell: " + e.getMessage());
                this.printWriter = headerWriter;
                return;
            }
            BitSet usedLibs = new BitSet();
            HashMap<CellId, BitSet> usedExports = new HashMap<CellId, BitSet>();
            cellBackup.gatherUsages(usedLibs, usedExports);
            this.gatherLibs(usedLibs, usedExports);
            LibId libId = cellBackup.d.libId;
            this.printWriter.println("H" + this.convertString(this.snapshot.getLib((LibId)libId).d.libId.libName) + "|" + Version.getVersion());
            super.writeExternalLibraryInfo(libId, usedLibs, usedExports);
            super.writeCell(cellBackup);
            this.printWriter.close();
            this.printWriter = headerWriter;
        }
        if (!append) {
            state.appendFile = true;
        }
        if (Version.getVersion().compareTo(Version.parseVersion(newHeaderVersion)) >= 0) {
            if (!this.wroteSearchForCells) {
                this.printWriter.println("C____SEARCH_FOR_CELL_FILES____");
                this.wroteSearchForCells = true;
            }
        } else {
            cellFile = cellFile.replace(File.separatorChar, '/');
            if (!append) {
                this.printWriter.println("C" + cellFile);
            }
        }
    }

    @Override
    void writeExternalLibraryInfo(LibId libId, BitSet usedLibs, HashMap<CellId, BitSet> usedExports) {
    }

    @Override
    void writeCellGroup(JELIB.CellGroup group) {
        if (Version.getVersion().compareTo(Version.parseVersion(newHeaderVersion)) < 0) {
            super.writeCellGroup(group);
        }
    }

    @Override
    protected boolean openTextOutputStream(String filePath) {
        File f = new File(filePath);
        this.filePath = filePath;
        if (f.exists()) {
            if (!f.isDirectory()) {
                System.out.println("Error, file " + f + " is not a directory");
                return true;
            }
        } else if (!f.mkdir()) {
            System.out.println("Failed to make directory: " + f);
            return true;
        }
        this.headerFile = filePath + File.separator + DELIB.getHeaderFile();
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.headerFile)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + this.headerFile + ": " + e.getMessage());
            return true;
        }
        return false;
    }

    public List<String> getDeletedCellFiles() {
        return this.deletedCellFiles;
    }

    public List<String> getWrittenCellFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (String s : this.cellFileMap.keySet()) {
            files.add(s);
        }
        return files;
    }

    public static String getCellSubDir(CellBackup cellBackup) {
        if (Version.getVersion().compareTo(Version.parseVersion(lastSubdirVersion)) > 0) {
            return "";
        }
        return cellBackup.d.cellName.getName();
    }

    private static String getCellFile(CellBackup cellBackup) {
        if (Version.getVersion().compareTo(Version.parseVersion(lastSubdirVersion)) > 0) {
            String cellName = cellBackup.d.cellName.getName();
            View view = cellBackup.d.cellName.getView();
            return cellName + "." + view.getAbbreviation();
        }
        String dir = DELIB.getCellSubDir(cellBackup);
        String cellName = cellBackup.d.cellName.getName();
        View view = cellBackup.d.cellName.getView();
        return dir + File.separator + cellName + "." + view.getAbbreviation();
    }

    public static String getCellFile(Cell cell) {
        Library lib = cell.getLibrary();
        if (lib.getVersion() == null) {
            return DELIB.getCellFile(cell.backup());
        }
        if (lib.getVersion().compareTo(Version.parseVersion(lastSubdirVersion)) > 0) {
            return DELIB.getCellFile(cell.backup());
        }
        CellBackup cellBackup = cell.backup();
        String dir = cellBackup.d.cellName.getName();
        String cellName = cellBackup.d.cellName.getName();
        View view = cellBackup.d.cellName.getView();
        return dir + File.separator + cellName + "." + view.getAbbreviation();
    }

    public static final String getHeaderFile() {
        return "header";
    }

    private static class CellFileState {
        public boolean modified = false;
        public boolean appendFile = false;

        private CellFileState() {
        }
    }
}

