/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PrintingTab
extends PreferencePanel {
    private int initialPrintArea;
    private boolean initialPrintDate;
    private boolean initialPrintEncapsulated;
    private boolean initialPrintPlotter;
    private double initialPrintWidth;
    private double initialPrintHeight;
    private double initialPrintMargin;
    private int initialPrintRotation;
    private int initialPrintColorMethod;
    private Cell initialCell;
    private double initialEPSScale;
    private String initialEPSSyncFile;
    private String initialPrinter;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JSeparator jSeparator1;
    private JLabel printCellName;
    private JComboBox printDefaultPrinter;
    private JTextField printEPSScale;
    private JLabel printEPSScaleLabel;
    private JCheckBox printEncapsulated;
    private JRadioButton printHPGL1;
    private JRadioButton printHPGL2;
    private JRadioButton printHPGLFillsPage;
    private JRadioButton printHPGLFixedScale;
    private JTextField printHPGLScale;
    private JTextField printHeight;
    private JTextField printMargin;
    private JCheckBox printPlotDateInCorner;
    private JRadioButton printPlotDisplayedWindow;
    private JRadioButton printPlotEntireCell;
    private JRadioButton printPlotHighlightedArea;
    private JComboBox printPostScriptStyle;
    private JTextField printResolution;
    private JComboBox printRotation;
    private JButton printSetEPSSync;
    private JTextField printSyncFileName;
    private JLabel printSynchLabel;
    private JRadioButton printUsePlotter;
    private JRadioButton printUsePrinter;
    private JTextField printWidth;
    private JPanel printing;
    private ButtonGroup printingHPGL;
    private ButtonGroup printingHPGLScale;
    private ButtonGroup printingPlotArea;
    private ButtonGroup printingPlotOrPrint;

    public PrintingTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.printing;
    }

    public String getName() {
        return "Printing";
    }

    public void init() {
        this.initialPrintArea = IOTool.getPlotArea();
        switch (this.initialPrintArea) {
            case 0: {
                this.printPlotEntireCell.setSelected(true);
                break;
            }
            case 1: {
                this.printPlotHighlightedArea.setSelected(true);
                break;
            }
            case 2: {
                this.printPlotDisplayedWindow.setSelected(true);
            }
        }
        this.initialPrintDate = IOTool.isPlotDate();
        this.printPlotDateInCorner.setSelected(this.initialPrintDate);
        this.initialPrinter = IOTool.getPrinterName();
        if (this.initialPrinter == null) {
            this.initialPrinter = "";
        }
        new FindPrintersThread(this);
        this.initialPrintEncapsulated = IOTool.isPrintEncapsulated();
        this.printEncapsulated.setSelected(this.initialPrintEncapsulated);
        this.initialPrintPlotter = IOTool.isPrintForPlotter();
        if (this.initialPrintPlotter) {
            this.printUsePlotter.setSelected(true);
        } else {
            this.printUsePrinter.setSelected(true);
        }
        this.initialPrintWidth = IOTool.getPrintWidth();
        this.printWidth.setText(Double.toString(this.initialPrintWidth));
        this.initialPrintHeight = IOTool.getPrintHeight();
        this.printHeight.setText(Double.toString(this.initialPrintHeight));
        this.initialPrintMargin = IOTool.getPrintMargin();
        this.printMargin.setText(Double.toString(this.initialPrintMargin));
        this.printRotation.addItem("No Rotation");
        this.printRotation.addItem("Rotate plot 90 degrees");
        this.printRotation.addItem("Auto-rotate plot to fit");
        this.initialPrintRotation = IOTool.getPrintRotation();
        this.printRotation.setSelectedIndex(this.initialPrintRotation);
        this.printPostScriptStyle.addItem("Black&White");
        this.printPostScriptStyle.addItem("Color");
        this.printPostScriptStyle.addItem("Color Stippled");
        this.printPostScriptStyle.addItem("Color Merged");
        this.initialPrintColorMethod = IOTool.getPrintColorMethod();
        this.printPostScriptStyle.setSelectedIndex(this.initialPrintColorMethod);
        this.initialCell = WindowFrame.getCurrentCell();
        this.initialEPSScale = 1.0;
        this.initialEPSSyncFile = "";
        if (this.initialCell != null) {
            this.printCellName.setText("For cell: " + this.initialCell.describe());
            this.initialEPSScale = IOTool.getPrintEPSScale(this.initialCell);
            this.initialEPSSyncFile = IOTool.getPrintEPSSynchronizeFile(this.initialCell);
            this.printSyncFileName.setText(this.initialEPSSyncFile);
            this.printSetEPSSync.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PrintingTab.this.printSetEPSSyncActionPerformed();
                }
            });
        } else {
            this.printCellName.setEnabled(false);
            this.printEPSScaleLabel.setEnabled(false);
            this.printEPSScale.setEditable(false);
            this.printSynchLabel.setEnabled(false);
            this.printSyncFileName.setEditable(false);
            this.printSetEPSSync.setEnabled(false);
        }
        this.printEPSScale.setText(Double.toString(this.initialEPSScale));
        this.printResolution.setEditable(false);
        this.printHPGL1.setEnabled(false);
        this.printHPGL2.setEnabled(false);
        this.printHPGLFillsPage.setEnabled(false);
        this.printHPGLFixedScale.setEnabled(false);
        this.printHPGLScale.setEditable(false);
    }

    private void printSetEPSSyncActionPerformed() {
        String fileName = OpenFile.chooseInputFile(OpenFile.Type.POSTSCRIPT, null);
        if (fileName == null) {
            return;
        }
        this.printSyncFileName.setText(fileName);
    }

    public void term() {
        int colorMethod;
        int rotation;
        double margin;
        double height;
        double width;
        boolean plotter;
        boolean encapsulated;
        String printer;
        boolean plotDate;
        int printArea = 0;
        if (this.printPlotHighlightedArea.isSelected()) {
            printArea = 1;
        } else if (this.printPlotDisplayedWindow.isSelected()) {
            printArea = 2;
        }
        if (printArea != this.initialPrintArea) {
            IOTool.setPlotArea(printArea);
        }
        if ((plotDate = this.printPlotDateInCorner.isSelected()) != this.initialPrintDate) {
            IOTool.setPlotDate(plotDate);
        }
        if (!(printer = (String)this.printDefaultPrinter.getSelectedItem()).equals(this.initialPrinter)) {
            IOTool.setPrinterName(printer);
        }
        if ((encapsulated = this.printEncapsulated.isSelected()) != this.initialPrintEncapsulated) {
            IOTool.setPrintEncapsulated(encapsulated);
        }
        if ((plotter = this.printUsePlotter.isSelected()) != this.initialPrintPlotter) {
            IOTool.setPrintForPlotter(plotter);
        }
        if ((width = TextUtils.atof(this.printWidth.getText())) != this.initialPrintWidth) {
            IOTool.setPrintWidth(width);
        }
        if ((height = TextUtils.atof(this.printHeight.getText())) != this.initialPrintHeight) {
            IOTool.setPrintHeight(height);
        }
        if ((margin = TextUtils.atof(this.printMargin.getText())) != this.initialPrintMargin) {
            IOTool.setPrintMargin(margin);
        }
        if ((rotation = this.printRotation.getSelectedIndex()) != this.initialPrintRotation) {
            IOTool.setPrintRotation(rotation);
        }
        if ((colorMethod = this.printPostScriptStyle.getSelectedIndex()) != this.initialPrintColorMethod) {
            IOTool.setPrintColorMethod(colorMethod);
        }
        if (this.initialCell != null) {
            String currentEPSSyncFile;
            double currentEPSScale = TextUtils.atof(this.printEPSScale.getText());
            if (currentEPSScale != this.initialEPSScale && currentEPSScale != 0.0) {
                IOTool.setPrintEPSScale(this.initialCell, currentEPSScale);
            }
            if (!(currentEPSSyncFile = this.printSyncFileName.getText()).equals(this.initialEPSSyncFile)) {
                IOTool.setPrintEPSSynchronizeFile(this.initialCell, currentEPSSyncFile);
            }
        }
    }

    private void initComponents() {
        this.printingPlotArea = new ButtonGroup();
        this.printingPlotOrPrint = new ButtonGroup();
        this.printingHPGL = new ButtonGroup();
        this.printingHPGLScale = new ButtonGroup();
        this.printing = new JPanel();
        this.jPanel4 = new JPanel();
        this.printPlotEntireCell = new JRadioButton();
        this.printPlotDateInCorner = new JCheckBox();
        this.printPlotHighlightedArea = new JRadioButton();
        this.jLabel18 = new JLabel();
        this.printPlotDisplayedWindow = new JRadioButton();
        this.printDefaultPrinter = new JComboBox();
        this.jLabel19 = new JLabel();
        this.printResolution = new JTextField();
        this.jPanel5 = new JPanel();
        this.jLabel26 = new JLabel();
        this.printHPGL1 = new JRadioButton();
        this.printHPGL2 = new JRadioButton();
        this.printHPGLFillsPage = new JRadioButton();
        this.printHPGLFixedScale = new JRadioButton();
        this.printHPGLScale = new JTextField();
        this.jLabel27 = new JLabel();
        this.jPanel6 = new JPanel();
        this.printEncapsulated = new JCheckBox();
        this.printPostScriptStyle = new JComboBox();
        this.printUsePrinter = new JRadioButton();
        this.printUsePlotter = new JRadioButton();
        this.jLabel21 = new JLabel();
        this.printWidth = new JTextField();
        this.jLabel22 = new JLabel();
        this.printHeight = new JTextField();
        this.jLabel23 = new JLabel();
        this.printMargin = new JTextField();
        this.printRotation = new JComboBox();
        this.printCellName = new JLabel();
        this.printEPSScaleLabel = new JLabel();
        this.printEPSScale = new JTextField();
        this.jLabel20 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.printSyncFileName = new JTextField();
        this.printSynchLabel = new JLabel();
        this.printSetEPSSync = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PrintingTab.this.closeDialog(evt);
            }
        });
        this.printing.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("For all printing"));
        this.printPlotEntireCell.setText("Plot Entire Cell");
        this.printingPlotArea.add(this.printPlotEntireCell);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel4.add((Component)this.printPlotEntireCell, gridBagConstraints);
        this.printPlotDateInCorner.setText("Plot Date In Corner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel4.add((Component)this.printPlotDateInCorner, gridBagConstraints);
        this.printPlotHighlightedArea.setText("Plot only Highlighted Area");
        this.printingPlotArea.add(this.printPlotHighlightedArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel4.add((Component)this.printPlotHighlightedArea, gridBagConstraints);
        this.jLabel18.setHorizontalAlignment(0);
        this.jLabel18.setText("Default printer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel4.add((Component)this.jLabel18, gridBagConstraints);
        this.printPlotDisplayedWindow.setText("Plot only Displayed Window");
        this.printingPlotArea.add(this.printPlotDisplayedWindow);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel4.add((Component)this.printPlotDisplayedWindow, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel4.add((Component)this.printDefaultPrinter, gridBagConstraints);
        this.jLabel19.setText("Print and Copy resolution factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.jLabel19, gridBagConstraints);
        this.printResolution.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.printResolution, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.printing.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(new TitledBorder("For HPGL printing"));
        this.jLabel26.setText("HPGL Level:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.jLabel26, gridBagConstraints);
        this.printHPGL1.setText("HPGL");
        this.printingHPGL.add(this.printHPGL1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.printHPGL1, gridBagConstraints);
        this.printHPGL2.setText("HPGL/2");
        this.printingHPGL.add(this.printHPGL2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel5.add((Component)this.printHPGL2, gridBagConstraints);
        this.printHPGLFillsPage.setText("HPGL/2 plot fills page");
        this.printingHPGLScale.add(this.printHPGLFillsPage);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel5.add((Component)this.printHPGLFillsPage, gridBagConstraints);
        this.printHPGLFixedScale.setText("HPGL/2 plot fixed at:");
        this.printingHPGLScale.add(this.printHPGLFixedScale);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel5.add((Component)this.printHPGLFixedScale, gridBagConstraints);
        this.printHPGLScale.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel5.add((Component)this.printHPGLScale, gridBagConstraints);
        this.jLabel27.setText("grid units per pixel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel5.add((Component)this.jLabel27, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.printing.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel6.setBorder(new TitledBorder("For PostScript printing"));
        this.printEncapsulated.setText("Encapsulated");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printEncapsulated, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printPostScriptStyle, gridBagConstraints);
        this.printUsePrinter.setText("Printer");
        this.printingPlotOrPrint.add(this.printUsePrinter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printUsePrinter, gridBagConstraints);
        this.printUsePlotter.setText("Plotter");
        this.printingPlotOrPrint.add(this.printUsePlotter);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.printUsePlotter, gridBagConstraints);
        this.jLabel21.setText("Width (in):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jLabel21, gridBagConstraints);
        this.printWidth.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printWidth, gridBagConstraints);
        this.jLabel22.setText("Height (in):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.jLabel22, gridBagConstraints);
        this.printHeight.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printHeight, gridBagConstraints);
        this.jLabel23.setText("Margin (in):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel6.add((Component)this.jLabel23, gridBagConstraints);
        this.printMargin.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printMargin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printRotation, gridBagConstraints);
        this.printCellName.setText("For cell:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printCellName, gridBagConstraints);
        this.printEPSScaleLabel.setText("EPS Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.jPanel6.add((Component)this.printEPSScaleLabel, gridBagConstraints);
        this.printEPSScale.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printEPSScale, gridBagConstraints);
        this.jLabel20.setText("Rotation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jLabel20, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        this.jPanel6.add((Component)this.jSeparator1, gridBagConstraints);
        this.printSyncFileName.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.printSyncFileName, gridBagConstraints);
        this.printSynchLabel.setText("Synchronize to file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.jPanel6.add((Component)this.printSynchLabel, gridBagConstraints);
        this.printSetEPSSync.setText("Set");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        this.jPanel6.add((Component)this.printSetEPSSync, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.printing.add((Component)this.jPanel6, gridBagConstraints);
        this.getContentPane().add((Component)this.printing, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class FindPrintersThread
    extends Thread {
        PrintingTab dialog;

        FindPrintersThread(PrintingTab dialog) {
            super("Database");
            this.dialog = dialog;
            this.start();
        }

        public void run() {
            PrintService[] printers = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < printers.length; ++i) {
                this.dialog.printDefaultPrinter.addItem(printers[i].getName());
            }
            this.dialog.printDefaultPrinter.setSelectedItem(this.dialog.initialPrinter);
        }
    }
}

