/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import java.util.HashSet;
import java.util.Iterator;

class ScanHierForNccAnnot
extends HierarchyEnumerator.Visitor {
    private HashSet enteredCells = new HashSet();

    ScanHierForNccAnnot() {
    }

    private void printAnn(Cell cell) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cell);
        if (ann == null) {
            return;
        }
        System.out.println("  Cell: " + NccUtils.fullName(cell) + " annotations:");
        Iterator it = ann.getAnnotationText();
        while (it.hasNext()) {
            System.out.println("    " + it.next());
        }
    }

    private void scanForAnnot(Cell cell) {
        Cell.CellGroup g = cell.getCellGroup();
        Iterator it = g.getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (c.getView() != View.SCHEMATIC && c.getView() != View.LAYOUT) continue;
            this.printAnn(c);
        }
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        if (this.enteredCells.contains(cell)) {
            return false;
        }
        this.scanForAnnot(cell);
        this.enteredCells.add(cell);
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        return true;
    }
}

