/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LESizer;
import com.sun.electric.tool.user.ui.EditWindow;
import java.util.Iterator;
import java.util.Stack;

public class LETool
extends Tool {
    public static LETool tool = new LETool();
    private static final boolean DEBUG = false;
    private static double DEFAULT_GLOBALFANOUT = 4.7;
    private static double DEFAULT_EPSILON = 0.001;
    private static int DEFAULT_MAXITER = 30;
    private static double DEFAULT_GATECAP = 0.4;
    private static double DEFAULT_WIRERATIO = 0.16;
    private static double DEFAULT_DIFFALPHA = 0.7;
    private static double DEFAULT_KEEPERRATIO = 0.1;
    private static Pref cacheUseLocalSettings = Pref.makeBooleanPref("UseLocalSettings", LETool.tool.prefs, true);
    private static Pref cacheHighlightComponents = Pref.makeBooleanPref("HighlightComponents", LETool.tool.prefs, false);
    private static Pref cacheShowIntermediateCapacitances = Pref.makeBooleanPref("ShowIntermediateCapacitances", LETool.tool.prefs, false);
    private static Pref cacheGlobalFanout = Pref.makeDoublePref("GlobalFanout", LETool.tool.prefs, DEFAULT_GLOBALFANOUT);
    private static Pref cacheConvergenceEpsilon = Pref.makeDoublePref("Epsilon", LETool.tool.prefs, DEFAULT_EPSILON);
    private static Pref cacheMaxIterations = Pref.makeIntPref("MaxIterations", LETool.tool.prefs, DEFAULT_MAXITER);
    private static Pref cacheGateCapacitance = Pref.makeDoublePref("GateCapfFPerLambda", LETool.tool.prefs, DEFAULT_GATECAP);
    private static Pref cacheWireRatio = Pref.makeDoublePref("WireRatio", LETool.tool.prefs, DEFAULT_WIRERATIO);
    private static Pref cacheDiffAlpha = Pref.makeDoublePref("DiffusionAlpha", LETool.tool.prefs, DEFAULT_DIFFALPHA);
    private static Pref cacheKeeperRatio = Pref.makeDoublePref("KeeperRatio", LETool.tool.prefs, DEFAULT_KEEPERRATIO);

    private LETool() {
        super("logeffort");
    }

    public static LETool getLETool() {
        return tool;
    }

    public void init() {
        EvalJavaBsh.evalJavaBsh.setVariable("LE", tool);
    }

    public Object getdrive() throws EvalJavaBsh.IgnorableException {
        Object info = EvalJavaBsh.evalJavaBsh.getCurrentInfo();
        if (!(info instanceof Nodable)) {
            return "Not enough hierarchy";
        }
        VarContext context = EvalJavaBsh.evalJavaBsh.getCurrentContext();
        if (context == null) {
            return "null VarContext";
        }
        Nodable ni = (Nodable)info;
        Variable var = this.getLEDRIVE(ni, context.push(ni));
        if (var == null) {
            var = this.getLEDRIVE_old(ni, context);
        }
        if (var == null) {
            throw new EvalJavaBsh.IgnorableException("getdrive() var not found");
        }
        Object val = var.getObject();
        if (val == null) {
            throw new EvalJavaBsh.IgnorableException("getdrive() value null");
        }
        return val;
    }

    public Object subdrive(String nodeName, String parName) {
        VarContext context;
        Object info = EvalJavaBsh.evalJavaBsh.getCurrentInfo();
        if (!(info instanceof Nodable)) {
            return "subdrive(): Not enough hierarchy information";
        }
        Nodable no = (Nodable)info;
        if (no == null) {
            return "subdrive(): Not enough hierarchy information";
        }
        if (no instanceof NodeInst) {
            NodeInst ni = (NodeInst)no;
            Cell parent = no.getParent();
            if (parent == null) {
                return "subdrive(): null parent";
            }
            int arrayIndex = 0;
            no = Netlist.getNodableFor(ni, arrayIndex);
            if (no == null) {
                return "subdrive(): can't get equivalent schematic";
            }
        }
        if ((context = EvalJavaBsh.evalJavaBsh.getCurrentContext()) == null) {
            return "subdrive(): null context";
        }
        NodeProto np = no.getProto();
        if (np == null) {
            return "subdrive(): null nodeProto";
        }
        if (!(np instanceof Cell)) {
            return "subdrive(): NodeProto not a Cell";
        }
        Cell cell = (Cell)np;
        NodeInst ni = cell.findNode(nodeName);
        if (ni == null) {
            return "subdrive(): no nodeInst of name " + nodeName;
        }
        Variable var = ni.getVar(parName);
        if (var == null) {
            var = ni.getVar("ATTR_" + parName);
        }
        if (var == null) {
            return "?";
        }
        return context.push(no).evalVar(var, ni);
    }

    private Variable getLEDRIVE_old(Nodable no, VarContext context) {
        String drive = LETool.makeDriveStrOLDRecurse(context);
        Variable var = null;
        while (!drive.equals("")) {
            var = no.getVar("LEDRIVE_" + drive + ";0;S");
            if (var != null) {
                return var;
            }
            int i = drive.indexOf(59);
            if (i == -1) break;
            drive = drive.substring(i + 1);
        }
        if ((var = no.getVar("LEDRIVE_0;S")) != null) {
            return var;
        }
        return null;
    }

    private Variable getLEDRIVE(Nodable no, VarContext context) {
        String drive = context.getInstPath(".");
        Variable var = null;
        while (!drive.equals("")) {
            var = no.getVar("LEDRIVE_" + drive);
            if (var != null) {
                return var;
            }
            int i = drive.indexOf(46);
            if (i == -1) {
                return null;
            }
            drive = drive.substring(i + 1);
        }
        return null;
    }

    private static String makeDriveStr(VarContext context) {
        return "LEDRIVE_" + context.getInstPath(".");
    }

    private static String makeDriveStrOLD(VarContext context) {
        String s = "LEDRIVE_" + LETool.makeDriveStrOLDRecurse(context) + ";0;S";
        return s;
    }

    private static String makeDriveStrOLDRecurse(VarContext context) {
        if (context == VarContext.globalContext) {
            return "";
        }
        String prefix = context.pop() == VarContext.globalContext ? "" : LETool.makeDriveStrOLDRecurse(context.pop());
        Nodable no = context.getNodable();
        if (no == null) {
            System.out.println("VarContext.getInstPath: context with null NodeInst?");
        }
        String me = no instanceof NodeInst ? no.getName() + ",0" : no.getName() + ",0";
        if (prefix.equals("")) {
            return me;
        }
        return prefix + ";" + me;
    }

    public void optimizeEqualGateDelays(Cell cell, VarContext context, EditWindow wnd) {
        AnalyzeCell acjob = new AnalyzeCell(LESizer.Alg.EQUALGATEDELAYS, cell, context, wnd);
    }

    public static void printResults(Nodable no) {
        Job job;
        Iterator it = Job.getAllJobs();
        Stack<Job> stack = new Stack<Job>();
        while (it.hasNext()) {
            job = (Job)it.next();
            if (!(job instanceof AnalyzeCell)) continue;
            stack.push(job);
        }
        while (!stack.isEmpty()) {
            LENetlister netlister;
            job = (AnalyzeCell)stack.pop();
            if (job.getAborted() || !(netlister = ((AnalyzeCell)job).getNetlister()).printResults(no)) continue;
            return;
        }
        System.out.println("No existing completed sizing jobs contain info about " + no.getName());
    }

    public void clearStoredSizes(Nodable no) {
        Iterator it = no.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            String name = var.getKey().getName();
            if (!name.startsWith("LEDRIVE_")) continue;
            no.delVar(var.getKey());
        }
    }

    public void clearStoredSizes(Cell cell) {
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            this.clearStoredSizes((Nodable)it.next());
        }
    }

    public void clearStoredSizes(Library lib) {
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            this.clearStoredSizes((Cell)it.next());
        }
    }

    public static boolean isUseLocalSettings() {
        return cacheUseLocalSettings.getBoolean();
    }

    public static void setUseLocalSettings(boolean on) {
        cacheUseLocalSettings.setBoolean(on);
    }

    public static boolean isHighlightComponents() {
        return cacheHighlightComponents.getBoolean();
    }

    public static void setHighlightComponents(boolean on) {
        cacheHighlightComponents.setBoolean(on);
    }

    public static boolean isShowIntermediateCapacitances() {
        return cacheShowIntermediateCapacitances.getBoolean();
    }

    public static void setShowIntermediateCapacitances(boolean on) {
        cacheShowIntermediateCapacitances.setBoolean(on);
    }

    public static double getGlobalFanout() {
        return cacheGlobalFanout.getDouble();
    }

    public static void setGlobalFanout(double fo) {
        cacheGlobalFanout.setDouble(fo);
    }

    public static double getConvergenceEpsilon() {
        return cacheConvergenceEpsilon.getDouble();
    }

    public static void setConvergenceEpsilon(double ep) {
        cacheConvergenceEpsilon.setDouble(ep);
    }

    public static int getMaxIterations() {
        return cacheMaxIterations.getInt();
    }

    public static void setMaxIterations(int it) {
        cacheMaxIterations.setInt(it);
    }

    public static double getGateCapacitance() {
        return cacheGateCapacitance.getDouble();
    }

    public static void setGateCapacitance(double gc) {
        cacheGateCapacitance.setDouble(gc);
    }

    public static double getWireRatio() {
        return cacheWireRatio.getDouble();
    }

    public static void setWireRatio(double wr) {
        cacheWireRatio.setDouble(wr);
    }

    public static double getDiffAlpha() {
        return cacheDiffAlpha.getDouble();
    }

    public static void setDiffAlpha(double da) {
        cacheDiffAlpha.setDouble(da);
    }

    public static double getKeeperRatio() {
        return cacheKeeperRatio.getDouble();
    }

    public static void setKeeperRatio(double kr) {
        cacheKeeperRatio.setDouble(kr);
    }

    private static class UpdateSizes
    extends Job {
        private LENetlister netlister;
        private EditWindow wnd;

        private UpdateSizes(LENetlister netlister, Cell cell, EditWindow wnd) {
            super("Update LE Sizes", tool, Job.Type.CHANGE, null, cell, Job.Priority.USER);
            this.netlister = netlister;
            this.wnd = wnd;
            this.startJob();
        }

        public boolean doIt() {
            this.netlister.updateSizes();
            this.wnd.repaintContents(null);
            return true;
        }
    }

    protected class AnalyzeCell
    extends Job {
        private String progress;
        private Cell cell;
        private VarContext context;
        private EditWindow wnd;
        private LESizer.Alg algorithm;
        private LENetlister netlister;

        protected AnalyzeCell(LESizer.Alg algorithm, Cell cell, VarContext context, EditWindow wnd) {
            super("Analyze Cell " + cell.describe(), tool, Job.Type.EXAMINE, null, cell, Job.Priority.USER);
            this.progress = null;
            this.algorithm = algorithm;
            this.cell = cell;
            this.context = context;
            this.wnd = wnd;
            this.startJob(true, false);
        }

        public boolean doIt() {
            this.setProgress("building equations");
            System.out.print("Building equations...");
            this.netlister = new LENetlister(this.algorithm, this);
            this.netlister.netlist(this.cell, this.context);
            long equationsDone = System.currentTimeMillis();
            String elapsed = TextUtils.getElapsedTime(equationsDone - this.startTime);
            System.out.println("done (" + elapsed + ")");
            if (this.checkAbort(null)) {
                return false;
            }
            System.out.println("Starting iterations: ");
            this.setProgress("iterating");
            boolean success = this.netlister.size();
            if (this.checkAbort(null)) {
                return false;
            }
            if (success) {
                UpdateSizes job = new UpdateSizes(this.netlister, this.cell, this.wnd);
                this.netlister.printStatistics();
            } else {
                System.out.println("Sizing failed, sizes unchanged");
            }
            return true;
        }

        protected boolean checkAbort(String msg) {
            if (this.getScheduledToAbort()) {
                if (msg != null) {
                    System.out.println("LETool aborted: " + msg);
                } else {
                    System.out.println("LETool aborted: no changes made");
                }
                this.setAborted();
                return true;
            }
            return false;
        }

        public String getInfo() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.getInfo());
            if (this.getScheduledToAbort()) {
                buf.append("  Job aborted, no changes made\n");
            } else {
                buf.append("  Gates sized: " + this.netlister.getNumGates() + "\n");
                buf.append("  Total Drive Strength: " + this.netlister.getTotalSize() + "\n");
            }
            return buf.toString();
        }

        protected LENetlister getNetlister() {
            return this.netlister;
        }
    }
}

