/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class LayoutLib {
    public static final double DEF_SIZE = Double.POSITIVE_INFINITY;

    public static void error(boolean errorHasOccurred, String msg) {
        if (!errorHasOccurred) {
            return;
        }
        RuntimeException e = new RuntimeException(msg);
        e.printStackTrace();
        throw e;
    }

    public static boolean osIsWindows() {
        Properties props = System.getProperties();
        String osName = ((String)props.get("os.name")).toLowerCase();
        return osName.indexOf("windows") != -1;
    }

    public static String userName() {
        Properties props = System.getProperties();
        String name = (String)props.get("user.name");
        return name;
    }

    public static Library openLibForRead(String libName, String libFileName) {
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            URL libFileURL = TextUtils.makeURLToFile(libFileName);
            lib = Input.readLibrary(libFileURL, OpenFile.Type.ELIB);
        }
        LayoutLib.error(lib == null, "can't open Library for reading: " + libFileName);
        return lib;
    }

    public static Library openLibForWrite(String libName, String libFileName) {
        Library lib = Library.findLibrary(libName);
        if (lib != null) {
            return lib;
        }
        URL libFileURL = TextUtils.makeURLToFile(libFileName);
        lib = Library.newInstance(libName, libFileURL);
        LayoutLib.error(lib == null, "can't open Library for modify: " + libName);
        return lib;
    }

    public static void writeLibrary(Library lib) {
        Output.writeLibrary(lib, OpenFile.Type.ELIB, false);
    }

    public static double getArcInstWidth(ArcInst ai) {
        return ai.getWidth() - ai.getProto().getWidthOffset();
    }

    public static double getNodeProtoWidth(NodeProto np) {
        SizeOffset so = np.getProtoSizeOffset();
        return np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
    }

    public static double getNodeProtoHeight(NodeProto np) {
        SizeOffset so = np.getProtoSizeOffset();
        return np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
    }

    public static double widestWireWidth(PortInst port) {
        NodeInst ni = port.getNodeInst();
        PortProto pp = port.getPortProto();
        double maxWid = -1.0;
        Iterator arcs = LayoutLib.getArcInstsOnPortInst(port);
        while (arcs.hasNext()) {
            ArcInst ai = (ArcInst)arcs.next();
            maxWid = Math.max(maxWid, LayoutLib.getArcInstWidth(ai));
        }
        if (pp instanceof Export) {
            double check = LayoutLib.widestWireWidth(((Export)pp).getOriginalPort());
            maxWid = Math.max(maxWid, check);
        }
        return maxWid;
    }

    public static Iterator getArcInstsOnPortInst(PortInst pi) {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        NodeInst ni = pi.getNodeInst();
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection c = (Connection)it.next();
            if (c.getPortInst() != pi) continue;
            arcs.add(c.getArc());
        }
        return arcs.iterator();
    }

    public static NodeInst newNodeInst(NodeProto np, double x, double y, double width, double height, double angle, Cell parent) {
        if (np instanceof Cell) {
            width = (double)(width < 0.0 ? -1 : 1) * np.getDefWidth();
            height = (double)(height < 0.0 ? -1 : 1) * np.getDefHeight();
        } else {
            double signH;
            double signW;
            SizeOffset so = np.getProtoSizeOffset();
            double d = signW = width < 0.0 ? -1.0 : 1.0;
            if (width == Double.POSITIVE_INFINITY || width == Double.NEGATIVE_INFINITY) {
                width = signW * np.getDefWidth();
            } else {
                double hi = so.getHighXOffset();
                double lo = so.getLowXOffset();
                LayoutLib.error(lo != hi, "asymmetric X offset");
                width = signW * (Math.abs(width) + hi + lo);
            }
            double d2 = signH = height < 0.0 ? -1.0 : 1.0;
            if (height == Double.POSITIVE_INFINITY || height == Double.NEGATIVE_INFINITY) {
                height = signH * np.getDefHeight();
            } else {
                double hi = so.getHighYOffset();
                double lo = so.getLowYOffset();
                LayoutLib.error(lo != hi, "asymmetric Y offset");
                height = signH * (Math.abs(height) + hi + lo);
            }
        }
        NodeInst ni = NodeInst.newInstance(np, new Point2D.Double(x, y), width, height, (int)Math.round(angle * 10.0), parent, null);
        LayoutLib.error(ni == null, "newNodeInst failed");
        if (np instanceof Cell) {
            Point2D ref = LayoutLib.getPosition(ni);
            ni.modifyInstance(x - ref.getX(), y - ref.getY(), 0.0, 0.0, 0);
        }
        return ni;
    }

    public static void modNodeInst(NodeInst ni, double dx, double dy, double dw, double dh, boolean mirrorAboutYAxis, boolean mirrorAboutXAxis, double dAngle) {
        boolean oldMirX = ni.isMirroredAboutXAxis();
        boolean oldMirY = ni.isMirroredAboutYAxis();
        double oldXS = ni.getXSize() * (double)(oldMirY ? -1 : 1);
        double oldYS = ni.getYSize() * (double)(oldMirX ? -1 : 1);
        double newX = LayoutLib.getPosition(ni).getX() + dx;
        double newY = LayoutLib.getPosition(ni).getY() + dy;
        double newW = Math.max(ni.getXSize() + dw, 0.0);
        double newH = Math.max(ni.getYSize() + dh, 0.0);
        boolean newMirX = oldMirX ^ mirrorAboutXAxis;
        boolean newMirY = oldMirY ^ mirrorAboutYAxis;
        double newXS = newW * (double)(newMirY ? -1 : 1);
        double newYS = newH * (double)(newMirX ? -1 : 1);
        ni.modifyInstance(0.0, 0.0, newXS - oldXS, newYS - oldYS, (int)Math.rint(dAngle * 10.0));
        ni.modifyInstance(newX - LayoutLib.getPosition(ni).getX(), newY - LayoutLib.getPosition(ni).getY(), 0.0, 0.0, 0);
    }

    public static Point2D getPosition(NodeInst ni) {
        NodeProto np = ni.getProto();
        if (np instanceof Cell) {
            AffineTransform xForm = ni.transformOut();
            return xForm.transform(new Point2D.Double(0.0, 0.0), null);
        }
        return ni.getAnchorCenter();
    }

    public static ArcInst newArcInst(ArcProto ap, double width, PortInst head, double hX, double hY, PortInst tail, double tX, double tY) {
        width = width == Double.POSITIVE_INFINITY ? ap.getDefaultWidth() : (width += ap.getWidthOffset());
        ArcInst ai = ArcInst.newInstance(ap, width, head, new Point2D.Double(hX, hY), tail, new Point2D.Double(tX, tY), null);
        ai.setFixedAngle();
        LayoutLib.error(ai == null, "newArcInst failed");
        return ai;
    }

    public static ArcInst newArcInst(ArcProto ap, double width, PortInst head, PortInst tail) {
        ArcInst ai;
        double hX = head.getBounds().getCenterX();
        double hY = head.getBounds().getCenterY();
        double tX = tail.getBounds().getCenterX();
        double tY = tail.getBounds().getCenterY();
        if (hX == tX || hY == tY) {
            ai = LayoutLib.newArcInst(ap, width, head, hX, hY, tail, tX, tY);
        } else {
            Cell parent = head.getNodeInst().getParent();
            PrimitiveNode pinProto = ((PrimitiveArc)ap).findOverridablePinProto();
            PortInst pin = LayoutLib.newNodeInst(pinProto, tX, hY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent).getOnlyPortInst();
            ai = LayoutLib.newArcInst(ap, width, head, pin);
            ai.setFixedAngle();
            ai = LayoutLib.newArcInst(ap, width, pin, tail);
        }
        ai.setFixedAngle();
        return ai;
    }

    public static Export newExport(Cell cell, String name, PortProto.Characteristic role, ArcProto ap, double w, double x, double y) {
        PrimitiveNode np = ((PrimitiveArc)ap).findOverridablePinProto();
        LayoutLib.error(np == null, "LayoutLib.newExport: This layer has no layer-pin");
        double defSz = Double.POSITIVE_INFINITY;
        NodeInst ni = LayoutLib.newNodeInst(np, x, y, defSz, defSz, 0.0, cell);
        LayoutLib.newArcInst(ap, w, ni.getOnlyPortInst(), ni.getOnlyPortInst());
        Export e = Export.newInstance(cell, ni.getOnlyPortInst(), name);
        e.setCharacteristic(role);
        return e;
    }

    public static Rectangle2D getBounds(NodeInst node) {
        Rectangle2D bounds = node.findEssentialBounds();
        if (bounds != null) {
            return bounds;
        }
        return node.getBounds();
    }

    public static Rectangle2D getBounds(Cell c) {
        Rectangle2D bounds = c.findEssentialBounds();
        if (bounds != null) {
            return bounds;
        }
        return c.getBounds();
    }

    public static void abutLeft(NodeInst node, double leftX, double originY) {
        double cY = LayoutLib.getPosition(node).getY();
        Rectangle2D bd = node.findEssentialBounds();
        LayoutLib.error(bd == null, "can't abut NodeInsts that don't have essential-bounds");
        LayoutLib.modNodeInst(node, leftX - bd.getX(), originY - cY, 0.0, 0.0, false, false, 0.0);
    }

    public static void abutLeftRight(double leftX, double originY, ArrayList nodeInsts) {
        for (int i = 0; i < nodeInsts.size(); ++i) {
            NodeInst ni = (NodeInst)nodeInsts.get(i);
            if (i == 0) {
                LayoutLib.abutLeft(ni, leftX, originY);
                continue;
            }
            LayoutLib.abutLeftRight((NodeInst)nodeInsts.get(i - 1), ni);
        }
    }

    public static void abutLeftRight(NodeInst leftNode, NodeInst rightNode) {
        LayoutLib.abutLeft(rightNode, LayoutLib.getBounds(leftNode).getMaxX(), LayoutLib.getPosition(leftNode).getY());
    }

    public static void abutLeftRight(ArrayList nodeInsts) {
        for (int i = 1; i < nodeInsts.size(); ++i) {
            LayoutLib.abutLeftRight((NodeInst)nodeInsts.get(i - 1), (NodeInst)nodeInsts.get(i));
        }
    }

    public static void abutBottom(NodeInst node, double originX, double botY) {
        double cX = LayoutLib.getPosition(node).getX();
        Rectangle2D eb = node.findEssentialBounds();
        LayoutLib.error(eb == null, "can't abut a NodeInst that doesn't have Essential Bounds");
        LayoutLib.modNodeInst(node, originX - cX, botY - eb.getMinY(), 0.0, 0.0, false, false, 0.0);
    }

    public static void abutBottomTop(NodeInst bottomNode, NodeInst topNode) {
        LayoutLib.abutBottom(topNode, LayoutLib.getPosition(bottomNode).getX(), LayoutLib.getBounds(bottomNode).getMaxY());
    }

    public static void abutBottomTop(double originX, double botY, ArrayList nodeInsts) {
        for (int i = 0; i < nodeInsts.size(); ++i) {
            NodeInst ni = (NodeInst)nodeInsts.get(i);
            if (i == 0) {
                LayoutLib.abutBottom(ni, originX, botY);
                continue;
            }
            LayoutLib.abutBottomTop((NodeInst)nodeInsts.get(i - 1), ni);
        }
    }

    public static void abutBottomTop(ArrayList nodeInsts) {
        for (int i = 1; i < nodeInsts.size(); ++i) {
            LayoutLib.abutBottomTop((NodeInst)nodeInsts.get(i - 1), (NodeInst)nodeInsts.get(i));
        }
    }
}

