/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.util.ArrayList;
import java.util.Iterator;

public class JNetwork {
    private Netlist netlist;
    private int netIndex;
    private ArrayList names = new ArrayList();
    private int exportedNamesCount;

    public JNetwork(Netlist netlist, int netIndex) {
        this.netlist = netlist;
        this.netIndex = netIndex;
    }

    public void addName(String nm, boolean exported) {
        if (nm != null) {
            this.names.add(nm);
            if (exported) {
                if (this.exportedNamesCount != this.names.size() - 1) {
                    throw new IllegalStateException("exported names should go first");
                }
                this.exportedNamesCount = this.names.size();
            }
        }
    }

    public Cell getParent() {
        return this.netlist.netCell.cell;
    }

    public int getNetIndex() {
        return this.netIndex;
    }

    public Iterator getNames() {
        return this.names.iterator();
    }

    public Iterator getExportedNames() {
        return this.names.subList(0, this.exportedNamesCount).iterator();
    }

    public boolean hasNames() {
        return this.names.size() > 0;
    }

    public boolean hasName(String nm) {
        return this.names.contains(nm);
    }

    public Iterator getPorts() {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        Iterator it = this.getParent().getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Iterator pit = ni.getPortInsts();
            while (pit.hasNext()) {
                PortInst pi = (PortInst)pit.next();
                if (this.netlist.getNetwork(pi) != this) continue;
                ports.add(pi);
            }
        }
        return ports.iterator();
    }

    public Iterator getExports() {
        ArrayList<Export> exports = new ArrayList<Export>();
        Iterator it = this.getParent().getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            if (this.netlist.getNetwork(e, 0) != this) continue;
            exports.add(e);
        }
        return exports.iterator();
    }

    public Iterator getArcs() {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        Iterator it = this.getParent().getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (this.netlist.getNetwork(ai, 0) != this) continue;
            arcs.add(ai);
        }
        return arcs.iterator();
    }

    public String describe() {
        if (this.names.size() > 0) {
            Iterator it = this.names.iterator();
            String name = (String)it.next();
            while (it.hasNext()) {
                name = name + "/" + (String)it.next();
            }
            return name;
        }
        Iterator it = this.getParent().getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (this.netlist.getNetwork(ai, 0) != this) continue;
            return ai.getName();
        }
        return "";
    }

    public String toString() {
        return "Network " + this.describe();
    }
}

