/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ITopic;
import org.xmind.core.audio.AudioValues;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.AudioNotesUtils;
import org.xmind.ui.internal.audionotes.IAudioNotesAgentListener;
import org.xmind.ui.internal.audionotes.ITopicAudioClient;
import org.xmind.ui.internal.audionotes.Messages;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.TextFormatter;
import org.xmind.ui.viewers.ImageButton;

public class AudioNotesViewer
implements ICoreEventListener,
IAudioNotesAgentListener {
    public static final int TITLE = 1;
    public static final int TIME = 2;
    public static final int CONTROL = 4;
    public static final int LEVEL = 8;
    public static final int CONTENT = 16;
    public static final int ALL = 31;
    private static final String PATH = "/icons/";
    private static final String IMG_BUTTON_REC = "/icons/record.png";
    private static final String IMG_BUTTON_REC_P = "/icons/record_p.png";
    private static final String IMG_BUTTON_REC_D = "/icons/record_d.png";
    private static final String IMG_BUTTON_STOP = "/icons/recording.png";
    private static final String IMG_BUTTON_STOP_P = "/icons/recording_p.png";
    private static final String EMPTY_DURATION = "00:00";
    private Composite container;
    private Composite controlPanel;
    private ImageButton controlButton;
    private RotatableWrapLabel titleText;
    private Label timeLabel;
    private Control playButton;
    private ProgressBar levelMeter;
    private ITopic sourceTopic;
    private ICoreEventRegister eventRegister;
    private TreeViewer contentViewer;
    private Control noContentControl;
    private Composite contentContainer;
    private boolean showContent;
    private ISelectionProvider sourceSelectionProvider;
    private FigureCanvas canvas;

    public AudioNotesViewer(boolean showContent) {
        this.showContent = showContent;
    }

    public Control getControl() {
        return this.container;
    }

    public void createControl(Composite parent) {
        parent.setBackground(parent.getDisplay().getSystemColor(25));
        this.container = new Composite(parent, 0);
        this.container.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        this.container.setLayout((Layout)layout);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createControlPanel(this.container);
        this.createContent(this.container);
        AudioNotesPlugin.getDefault().getAgent().addAudioListener(this);
    }

    private void createControlPanel(Composite parent) {
        this.controlPanel = new Composite(parent, 0);
        this.controlPanel.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 10;
        layout.marginHeight = 15;
        layout.verticalSpacing = 1;
        layout.horizontalSpacing = 10;
        this.controlPanel.setLayout((Layout)layout);
        this.controlPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createControlButton(this.controlPanel);
        this.createTitleText(this.controlPanel);
        this.createLevelMeter(this.controlPanel);
        this.createTimeLabel(this.controlPanel);
    }

    private void createControlButton(Composite parent) {
        this.controlButton = new ImageButton(parent, 8);
        this.controlButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom(IMG_BUTTON_REC));
        this.controlButton.setDisabledImageDescriptor(AudioNotesPlugin.imageFrom(IMG_BUTTON_REC_D));
        this.controlButton.setPressedImageDescriptor(AudioNotesPlugin.imageFrom(IMG_BUTTON_REC_P));
        this.controlButton.addOpenListener((IOpenListener)new ControlButtonOpenListener());
        Control control = this.controlButton.getControl();
        control.setEnabled(false);
        control.setBackground(parent.getBackground());
        GridData layoutData = new GridData(0x1000000, 0x1000008, false, true);
        layoutData.verticalSpan = 2;
        control.setLayoutData((Object)layoutData);
    }

    private void createTitleText(Composite parent) {
        this.canvas = new FigureCanvas(parent);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, false));
        this.canvas.setVisible(true);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(parent.getBackground());
        this.titleText = new RotatableWrapLabel(0);
        this.titleText.setBackgroundColor(parent.getBackground());
        this.titleText.setForegroundColor(parent.getDisplay().getSystemColor(24));
        this.titleText.setSingleLine(true);
        this.titleText.setAbbreviated(true);
        this.titleText.setText(Messages.SelectTopic);
        this.canvas.setContents((IFigure)this.titleText);
        this.canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                AudioNotesViewer.this.titleText.setPrefWidth(((AudioNotesViewer)AudioNotesViewer.this).canvas.getSize().x);
            }
        });
    }

    private void createTimeLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        ToolBarManager toolBar = new ToolBarManager(0x800000);
        toolBar.add((IAction)new PlayAction());
        toolBar.createControl(composite);
        this.playButton = toolBar.getControl();
        this.playButton.setBackground(composite.getBackground());
        this.playButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.playButton.getLayoutData()).exclude = true;
        this.playButton.setVisible(false);
        this.timeLabel = new Label(composite, 16384);
        this.timeLabel.setBackground(composite.getBackground());
        this.timeLabel.setEnabled(false);
        this.timeLabel.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)17));
        this.timeLabel.setForeground(parent.getDisplay().getSystemColor(24));
        this.timeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
    }

    private void createLevelMeter(Composite parent) {
        this.levelMeter = new ProgressBar(parent, 512);
        this.levelMeter.setBackground(parent.getBackground());
        this.levelMeter.setMaximum(100);
        this.levelMeter.setMinimum(0);
        this.levelMeter.setSelection(0);
        this.levelMeter.setEnabled(false);
        Point volumeSize = this.levelMeter.computeSize(-1, -1);
        int wHint = Math.max(1, volumeSize.x * 2 / 3);
        GridData layoutData = new GridData(0x1000008, 4, false, true);
        layoutData.widthHint = wHint;
        layoutData.heightHint = 5;
        layoutData.verticalSpan = 2;
        this.levelMeter.setLayoutData((Object)layoutData);
    }

    private void createContent(Composite parent) {
        if (!this.showContent) {
            return;
        }
        this.contentContainer = new Composite(parent, 0);
        this.contentContainer.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.contentContainer.setLayout((Layout)layout);
        this.contentContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite noContentComposite = new Composite(this.contentContainer, 0);
        noContentComposite.setBackground(this.contentContainer.getBackground());
        GridLayout noContentLayout = new GridLayout(1, false);
        noContentLayout.marginHeight = 10;
        noContentLayout.marginWidth = 10;
        noContentComposite.setLayout((Layout)noContentLayout);
        noContentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fillNoContentContainer(noContentComposite);
        this.noContentControl = noContentComposite;
        this.createContentViewer(this.contentContainer);
        ((GridData)this.contentViewer.getControl().getLayoutData()).exclude = true;
        this.contentViewer.getControl().setVisible(false);
    }

    private void createContentViewer(Composite parent) {
        this.contentViewer = new TreeViewer(parent, 66068);
        this.contentViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        final Tree tree = this.contentViewer.getTree();
        tree.setBackground(this.contentContainer.getBackground());
        tree.setLinesVisible(false);
        tree.setHeaderVisible(false);
        final TreeColumn col1 = new TreeColumn(tree, 16384);
        final TreeColumn col2 = new TreeColumn(tree, 16384);
        Point size = tree.computeSize(-1, -1);
        col1.setWidth(size.x / 2);
        col2.setWidth(size.x / 2);
        tree.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle s = tree.getClientArea();
                col1.setWidth(s.width / 2);
                col2.setWidth(s.width / 2);
            }
        });
        this.contentViewer.setContentProvider((IContentProvider)new AudioNotesContentProvider());
        this.contentViewer.setLabelProvider((IBaseLabelProvider)new AudioNotesLabelProvider());
        this.contentViewer.setAutoExpandLevel(-1);
        AudioListEventHandler listener = new AudioListEventHandler();
        tree.addListener(3, (Listener)listener);
        tree.addListener(4, (Listener)listener);
        tree.addListener(5, (Listener)listener);
        tree.addListener(8, (Listener)listener);
    }

    private void fillNoContentContainer(Composite parent) {
        Label noContentTitle = new Label(parent, 64);
        Label noContentMessage = new Label(parent, 64);
        noContentTitle.setText(Messages.NoAudioNotes_title);
        noContentMessage.setText(Messages.NoAudioNotes_message);
        noContentTitle.setBackground(this.contentContainer.getBackground());
        noContentMessage.setBackground(noContentTitle.getBackground());
        if ("win32".equals(SWT.getPlatform())) {
            noContentTitle.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
            noContentMessage.setFont(noContentTitle.getFont());
        }
        noContentTitle.setForeground(parent.getDisplay().getSystemColor(16));
        noContentMessage.setForeground(noContentTitle.getForeground());
        GridData noContentLayoutData = new GridData(4, 4, true, false);
        noContentLayoutData.widthHint = 100;
        noContentTitle.setLayoutData((Object)noContentLayoutData);
        GridData noContentLayoutData2 = new GridData(4, 4, true, false);
        noContentLayoutData2.widthHint = 100;
        noContentMessage.setLayoutData((Object)noContentLayoutData2);
    }

    public void dispose() {
        AudioNotesPlugin.getDefault().getAgent().removeAudioListener(this);
        this.setSourceTopic(null);
        this.sourceSelectionProvider = null;
        this.container = null;
        this.controlPanel = null;
        this.controlButton = null;
        this.canvas = null;
        this.titleText = null;
        this.timeLabel = null;
        this.levelMeter = null;
        this.contentViewer = null;
        this.playButton = null;
        this.noContentControl = null;
        this.contentContainer = null;
    }

    public void setFocus() {
        if (this.contentViewer != null && !this.contentViewer.getControl().isDisposed() && this.contentViewer.getControl().isVisible() && this.contentViewer.getControl().isEnabled()) {
            this.contentViewer.getControl().setFocus();
        } else if (this.canvas != null && !this.canvas.isDisposed() && !this.canvas.setFocus()) {
            this.container.setFocus();
        }
    }

    public void setSelection(ISelection selection, ISelectionProvider selectionProvider) {
        this.setSourceTopic(this.findTopic(selection));
        this.sourceSelectionProvider = selectionProvider;
        this.update(31, null);
    }

    private ITopic findTopic(ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ITopic) {
            return (ITopic)o;
        }
        return null;
    }

    public void setSourceTopic(ITopic topic) {
        if (topic == this.sourceTopic) {
            return;
        }
        ITopic oldTopic = this.sourceTopic;
        this.sourceTopic = topic;
        if (oldTopic != null) {
            this.unhookTopic(oldTopic);
        }
        if (topic != null) {
            this.hookTopic(topic);
        }
    }

    private void hookTopic(ITopic topic) {
        if (this.eventRegister == null) {
            this.eventRegister = new CoreEventRegister();
            this.eventRegister.setNextListener((ICoreEventListener)this);
        }
        this.eventRegister.setNextSourceFrom((Object)topic);
        this.eventRegister.register("titleText");
        ITopic parent = topic.getParent();
        if (this.eventRegister == null) {
            this.eventRegister = new CoreEventRegister();
            this.eventRegister.setNextListener((ICoreEventListener)this);
        }
        this.eventRegister.setNextSourceFrom((Object)parent);
        this.eventRegister.register("titleText");
    }

    private void unhookTopic(ITopic topic) {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
        }
    }

    public void update(int flag, AudioValues values) {
        boolean hasAudioNotes = AudioNotesViewer.hasAudioNotes(this.sourceTopic);
        if ((flag & 1) != 0 && this.titleText != null) {
            String text = AudioNotesUtils.formatTitle(this.sourceTopic, hasAudioNotes);
            this.titleText.setText(TextFormatter.removeNewLineCharacter((String)text));
            this.titleText.setEnabled(this.sourceTopic != null);
        }
        boolean playing = AudioNotesViewer.isPlaying();
        boolean recording = AudioNotesViewer.isRecording();
        if ((flag & 2) != 0 && this.timeLabel != null && !this.timeLabel.isDisposed()) {
            String timeText = null;
            if (values != null) {
                long time = values.time;
                long duration = values.duration;
                if (time >= 0L && duration >= 0L && !recording) {
                    timeText = String.format("%s/%s", AudioNotesUtils.formatTime(time), AudioNotesUtils.formatTime(duration));
                } else if (time >= 0L) {
                    timeText = AudioNotesUtils.formatTime(time);
                } else if (duration >= 0L) {
                    timeText = AudioNotesUtils.formatTime(duration);
                }
            } else if (hasAudioNotes && (timeText = AudioNotesUtils.getDuration(this.sourceTopic)) != null) {
                timeText = AudioNotesUtils.formatTime(timeText);
            }
            if (timeText == null) {
                timeText = EMPTY_DURATION;
            }
            this.timeLabel.setText(timeText);
            this.timeLabel.setEnabled(values != null);
        }
        if ((flag & 8) != 0 && this.levelMeter != null && !this.levelMeter.isDisposed()) {
            this.levelMeter.setEnabled(values != null);
            if (values == null || values.level < 0) {
                this.levelMeter.setSelection(0);
            } else {
                this.levelMeter.setSelection(values.level);
            }
        }
        if ((flag & 0x10) != 0 || (flag & 1) != 0 && (playing || recording)) {
            boolean hasContent;
            if (this.contentViewer != null && !this.contentViewer.getControl().isDisposed()) {
                this.contentViewer.setInput((Object)this.sourceTopic);
                hasContent = this.contentViewer.getTree().getItems().length > 0;
                ((GridData)this.contentViewer.getControl().getLayoutData()).exclude = !hasContent;
                this.contentViewer.getControl().setVisible(hasContent);
            } else {
                hasContent = false;
            }
            if (this.noContentControl != null && !this.noContentControl.isDisposed()) {
                ((GridData)this.noContentControl.getLayoutData()).exclude = hasContent;
                this.noContentControl.setVisible(!hasContent);
            }
            if (this.contentContainer != null && !this.contentContainer.isDisposed()) {
                this.contentContainer.layout();
            }
        }
        if ((flag & 4) != 0) {
            if (this.controlButton != null && !this.controlButton.getControl().isDisposed()) {
                if (playing || recording) {
                    this.controlButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom(IMG_BUTTON_STOP));
                    this.controlButton.setPressedImageDescriptor(AudioNotesPlugin.imageFrom(IMG_BUTTON_STOP_P));
                    this.controlButton.setDisabledImageDescriptor(null);
                    this.controlButton.getControl().setEnabled(true);
                    if (playing) {
                        this.controlButton.getControl().setToolTipText(Messages.StopPlayingButton_toolTip);
                    } else {
                        this.controlButton.getControl().setToolTipText(Messages.StopRecordingButton_toolTip);
                    }
                } else {
                    this.controlButton.setNormalImageDescriptor(AudioNotesPlugin.imageFrom(IMG_BUTTON_REC));
                    this.controlButton.setDisabledImageDescriptor(AudioNotesPlugin.imageFrom(IMG_BUTTON_REC_D));
                    this.controlButton.setPressedImageDescriptor(AudioNotesPlugin.imageFrom(IMG_BUTTON_REC_P));
                    this.controlButton.getControl().setEnabled(this.sourceTopic != null);
                    this.controlButton.getControl().setToolTipText(Messages.RecordButton_toolTip);
                }
            }
            if (this.playButton != null && !this.playButton.isDisposed()) {
                boolean showPlayButton = !playing && !recording && hasAudioNotes;
                ((GridData)this.playButton.getLayoutData()).exclude = !showPlayButton;
                this.playButton.setVisible(showPlayButton);
                this.playButton.getParent().layout();
            }
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("titleText".equals(type)) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    AudioNotesViewer.this.update(1, null);
                }
            });
        }
    }

    public void started(ITopic topic, boolean recordOrPlayback) {
        boolean sourceChanged;
        boolean isParent = false;
        if (this.sourceTopic != null) {
            for (ITopic t : this.sourceTopic.getAllChildren()) {
                if (!t.equals(topic)) continue;
                isParent = true;
                break;
            }
        }
        boolean bl = sourceChanged = !isParent && topic != this.sourceTopic;
        if (sourceChanged) {
            this.setSourceTopic(topic);
            this.sourceSelectionProvider = null;
        }
        this.update(31, null);
    }

    public void stopped(ITopic topic, boolean recordOrPlayback) {
        this.update(31, null);
    }

    public void valuesChanged(ITopic topic, AudioValues values, boolean recordOrPlayback) {
        this.update(10, values);
    }

    private void startPlayingTopic(ITopic topic) {
        if (topic == null || AudioNotesViewer.isRecording()) {
            return;
        }
        if (AudioNotesViewer.isPlaying()) {
            AudioNotesPlugin.getDefault().getAgent().stop();
        }
        if (topic != null) {
            AudioNotesPlugin.getDefault().getAgent().startPlay(topic);
        }
    }

    private static boolean isRecording() {
        return AudioNotesPlugin.getDefault().getAgent().isRecording();
    }

    private static boolean isPlaying() {
        return AudioNotesPlugin.getDefault().getAgent().isPlaying();
    }

    private static boolean hasAudioNotes(ITopic topic) {
        return topic != null && AudioNotesUtils.getAudioEntryPath(topic) != null;
    }

    private class AudioListEventHandler
    implements Listener {
        private ITopic toPlay = null;

        private AudioListEventHandler() {
        }

        public void handleEvent(Event event) {
            Object data;
            Tree tree;
            TreeItem item;
            if (event.type == 3) {
                Rectangle imgBounds;
                Object data2;
                Tree tree2;
                TreeItem item2;
                if (event.button == 1 && (item2 = (tree2 = (Tree)event.widget).getItem(new Point(event.x, event.y))) != null && (data2 = item2.getData()) instanceof ITopic && (imgBounds = item2.getImageBounds(0)).contains(event.x, event.y)) {
                    this.toPlay = (ITopic)data2;
                    return;
                }
                this.toPlay = null;
            } else if (event.type == 4) {
                if (this.toPlay != null) {
                    ITopic topic = this.toPlay;
                    this.toPlay = null;
                    AudioNotesViewer.this.startPlayingTopic(topic);
                }
            } else if (event.type == 5) {
                if (event.button != 0 || (event.stateMask & SWT.BUTTON_MASK) != 0) {
                    this.toPlay = null;
                }
            } else if (event.type == 8 && event.button == 1 && (item = (tree = (Tree)event.widget).getItem(new Point(event.x, event.y))) != null && (data = item.getData()) instanceof ITopic) {
                AudioNotesViewer.this.startPlayingTopic((ITopic)data);
            }
        }
    }

    private class AudioNotesContentProvider
    implements ITreeContentProvider {
        private AudioNotesContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITopic) {
                ITopic topic = (ITopic)inputElement;
                List children = topic.getChildren("attached");
                ArrayList<PropertyProvider> elements = new ArrayList<PropertyProvider>(children.size() + 5);
                if (AudioNotesViewer.isRecording()) {
                    elements.add(new TopicPropertyProvider(topic));
                    elements.add(new LabelPropertyProvider(topic));
                    elements.add(new StartTimePropertyProvider(topic));
                } else if (AudioNotesViewer.isPlaying() || AudioNotesViewer.this.sourceTopic != null && AudioNotesViewer.hasAudioNotes(topic)) {
                    elements.add(new TopicPropertyProvider(topic));
                    elements.add(new LabelPropertyProvider(topic));
                    elements.add(new RecordTimePropertyProvider(topic));
                    elements.add(new DurationPropertyProvider(topic));
                    elements.add(new FileSizePropertyProvider(topic));
                }
                for (ITopic c : children) {
                    if (!AudioNotesViewer.hasAudioNotes(c)) continue;
                    elements.add((PropertyProvider)c);
                }
                return elements.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITopic) {
                ITopic topic = (ITopic)parentElement;
                return new Object[]{new RecordTimePropertyProvider(topic), new DurationPropertyProvider(topic)};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ITopic) {
                return ((ITopic)element).getParent();
            }
            if (element instanceof PropertyProvider) {
                return ((PropertyProvider)element).getTopic();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ITopic;
        }

        public void dispose() {
        }
    }

    private class AudioNotesLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private Image playImage;

        private AudioNotesLabelProvider() {
        }

        public Image getPlayImage() {
            if (this.playImage == null) {
                this.playImage = AudioNotesPlugin.imageFrom("icons/e/play.png").createImage(false, (Device)Display.getCurrent());
            }
            return this.playImage;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ITopic && columnIndex == 0) {
                return this.getPlayImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PropertyProvider) {
                PropertyProvider p = (PropertyProvider)element;
                if (columnIndex == 0) {
                    return p.getName();
                }
                if (columnIndex == 1) {
                    return p.getValue();
                }
            } else if (element instanceof ITopic && columnIndex == 0) {
                ITopic topic = (ITopic)element;
                return TextFormatter.removeNewLineCharacter((String)(topic != null ? topic.getTitleText() : ""));
            }
            return element == null || columnIndex != 0 ? "" : element.toString();
        }

        public void dispose() {
            if (this.playImage != null) {
                this.playImage.dispose();
                this.playImage = null;
            }
            super.dispose();
        }
    }

    private class ControlButtonOpenListener
    implements IOpenListener {
        private ControlButtonOpenListener() {
        }

        public void open(OpenEvent event) {
            if (AudioNotesViewer.isPlaying() || AudioNotesViewer.isRecording()) {
                AudioNotesPlugin.getDefault().getAgent().stop();
            } else {
                ITopic topic = AudioNotesViewer.this.sourceTopic;
                if (topic != null) {
                    AudioNotesPlugin.getDefault().getAgent().startRecord(topic);
                }
            }
        }
    }

    private static class DurationPropertyProvider
    extends PropertyProvider {
        public DurationPropertyProvider(ITopic topic) {
            super(Messages.Property_Duration, topic);
        }

        public String getValue() {
            String duration = null;
            if (this.topic != null) {
                duration = AudioNotesUtils.getDuration(this.topic);
            }
            return duration == null ? "" : AudioNotesUtils.formatTime(duration);
        }
    }

    private static class FileSizePropertyProvider
    extends PropertyProvider {
        public FileSizePropertyProvider(ITopic topic) {
            super(Messages.Property_FileSize, topic);
        }

        public String getValue() {
            String size = null;
            if (this.topic != null) {
                size = AudioNotesUtils.getFileSize(this.topic);
            }
            return size == null ? "" : AudioNotesUtils.formatFileSize(size);
        }
    }

    private static class LabelPropertyProvider
    extends PropertyProvider {
        public LabelPropertyProvider(ITopic topic) {
            super(Messages.Property_Label, topic);
        }

        public String getValue() {
            return TextFormatter.removeNewLineCharacter((String)(this.topic != null ? this.topic.getTitleText() : ""));
        }
    }

    private class PlayAction
    extends Action {
        public PlayAction() {
            super(Messages.PlayAction_text, AudioNotesPlugin.imageFrom("icons/e/play.png"));
            this.setToolTipText(Messages.PlayAction_toolTip);
            this.setDisabledImageDescriptor(AudioNotesPlugin.imageFrom("icons/d/play.png"));
        }

        public void run() {
            AudioNotesViewer.this.startPlayingTopic(AudioNotesViewer.this.sourceTopic);
        }
    }

    private static abstract class PropertyProvider {
        protected ITopic topic;
        private String name;

        public PropertyProvider(String name, ITopic topic) {
            this.name = name;
            this.topic = topic;
        }

        public String getName() {
            return this.name;
        }

        public ITopic getTopic() {
            return this.topic;
        }

        public abstract String getValue();
    }

    private static class RecordTimePropertyProvider
    extends PropertyProvider {
        public RecordTimePropertyProvider(ITopic topic) {
            super(Messages.Property_RecordTime, topic);
        }

        public String getValue() {
            String recordTime = AudioNotesUtils.getRecordTime(this.topic);
            return recordTime == null ? "" : recordTime;
        }
    }

    private static class StartTimePropertyProvider
    extends PropertyProvider {
        public StartTimePropertyProvider(ITopic topic) {
            super(Messages.Property_StartTime, topic);
        }

        public String getValue() {
            long startTime;
            ITopicAudioClient client = AudioNotesPlugin.getDefault().getAgent().getCurrentClient();
            if (client != null && this.topic.getAllChildren().contains(client.getTopic()) && (startTime = client.getStartTime()) > 0L) {
                return String.format("%1$tr", startTime);
            }
            return "";
        }
    }

    private static class TopicPropertyProvider
    extends PropertyProvider {
        public TopicPropertyProvider(ITopic topic) {
            super(Messages.Property_Topic, topic);
        }

        public String getValue() {
            ITopic parent;
            if ((AudioNotesViewer.isRecording() || AudioNotesViewer.isPlaying() || AudioNotesViewer.hasAudioNotes(this.topic)) && (parent = this.topic.getParent()) != null) {
                return TextFormatter.removeNewLineCharacter((String)parent.getTitleText());
            }
            return TextFormatter.removeNewLineCharacter((String)this.topic.getTitleText());
        }
    }
}

