/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.ui.internal.audionotes.AudioNotesAgent;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.AudioNotesViewer2;
import org.xmind.ui.internal.audionotes.InsertAudioNotesDialog;
import org.xmind.ui.internal.audionotes.Messages;
import org.xmind.ui.tabfolder.DelegatedSelectionProvider;

public class AudioNotesPropertiesDialog
extends Dialog
implements IPartListener,
ISelectionChangedListener {
    private static final int NEW_AUDIO_BUTTON_ID = 1025;
    private AudioNotesViewer2 viewer;
    private IWorkbenchWindow activeWindow;
    private IWorkbenchPage thisPage;
    private IWorkbenchPart contributingPart;
    private Button newAudioButton;

    protected AudioNotesPropertiesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AudioNotesPropertiesDialog_Title);
    }

    protected void initializeBounds() {
        Rectangle rect = this.getParentShell().getBounds();
        this.getShell().setBounds(rect.x + rect.width * 3 / 5, rect.y + rect.height / 7, 410, 340);
        super.initializeBounds();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginTop = 10;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 255;
        composite.setLayoutData((Object)data);
        this.viewer = new AudioNotesViewer2();
        this.viewer.createControl(composite);
        this.thisPage = this.activeWindow.getActivePage();
        this.thisPage.addPartListener((IPartListener)this);
        this.partActivated((IWorkbenchPart)this.thisPage.getActiveEditor());
        return composite;
    }

    public void setContributedWorkbenchWindow(IWorkbenchWindow activeWindow) {
        this.activeWindow = activeWindow;
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.contributingPart == null && part instanceof IEditorPart) {
            this.setContributingPart((IEditorPart)part);
        }
    }

    private void setContributingPart(IEditorPart part) {
        DelegatedSelectionProvider selectionProvider;
        if (part == this.contributingPart) {
            return;
        }
        if (this.contributingPart != null && (selectionProvider = (DelegatedSelectionProvider)this.contributingPart.getSite().getSelectionProvider()) != null) {
            selectionProvider.removeAsyncSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.contributingPart = part;
        if (this.contributingPart != null && (selectionProvider = (DelegatedSelectionProvider)this.contributingPart.getSite().getSelectionProvider()) != null) {
            selectionProvider.addAsyncSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setSelection(this.getSelection(part), part == null ? null : part.getEditorSite().getSelectionProvider());
        }
    }

    private ISelection getSelection(IEditorPart part) {
        ISelectionProvider selectionProvider;
        if (part != null && (selectionProvider = part.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.contributingPart) {
            this.setContributingPart(null);
            AudioNotesPlugin.getDefault().getAgent().stop();
            this.close();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setSelection(event.getSelection(), event.getSelectionProvider());
            if (this.newAudioButton != null && !this.newAudioButton.isDisposed()) {
                if (AudioNotesViewer2.findTopic(event.getSelection()) == null) {
                    this.newAudioButton.setEnabled(false);
                } else {
                    this.newAudioButton.setEnabled(true);
                }
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.newAudioButton = this.createButton(parent, 1025, Messages.AudioNotesPropertiesDialog_Button_New_Audio, false);
        if (this.viewer.getSourceTopic() == null) {
            this.newAudioButton.setEnabled(false);
        }
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
        agent.stop();
        final IWorkbenchWindow window = this.activeWindow;
        final Shell shell = this.getParentShell();
        Display display = this.getShell().getDisplay();
        this.viewer.dispose();
        this.close();
        if (1025 == buttonId) {
            display.asyncExec(new Runnable(){

                public void run() {
                    InsertAudioNotesDialog dialog = new InsertAudioNotesDialog(shell);
                    dialog.setContributedWorkbenchWindow(window);
                    dialog.open();
                }
            });
            agent.pauseAt = -1.0;
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = (Composite)super.createButtonBar(parent);
        GridLayout layout = (GridLayout)buttonBar.getLayout();
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.horizontalSpacing = 15;
        layout.marginHeight = 0;
        layout.marginRight = 15;
        GridData data = (GridData)buttonBar.getLayoutData();
        data.heightHint = 50;
        return buttonBar;
    }

    public int open() {
        AudioNotesPlugin.getDefault().getAgent().windowOpened = true;
        return super.open();
    }

    public boolean close() {
        AudioNotesPlugin.getDefault().getAgent().windowOpened = false;
        this.thisPage.removePartListener((IPartListener)this);
        return super.close();
    }
}

