/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ITitled;
import org.xmind.gef.command.Command;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.gantt.GanttDialogPart;
import org.xmind.ui.gantt2.viewer.TaskTreeEditableTracker;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.resources.FontUtils;

public class TaskTreeTitleEditableTracker
extends TaskTreeEditableTracker {
    public TaskTreeTitleEditableTracker(IFigure target, FigureCanvas canvas, TaskTreeItemPart host) {
        super(target, canvas, host);
    }

    protected void edit() {
        this.editTitleText();
    }

    private void editTitleText() {
        Object obj;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MPart part = E4Utils.findPart((IWorkbenchWindow)window, (String)"org.xmind.ui.dialogPart.gantt");
        GanttDialogPart dialogPart = null;
        if (part != null && (obj = part.getObject()) instanceof GanttDialogPart) {
            dialogPart = (GanttDialogPart)((Object)obj);
            dialogPart.deactivateGlobalActionHanlders();
        }
        final Text text = new Text((Composite)this.canvas, 2052);
        text.setCursor(Display.getCurrent().getSystemCursor(19));
        this.locateEditor((Control)text, this.target, this.canvas.getViewport());
        this.setActiveEditor((Control)text);
        text.setFont(FontUtils.getRelativeHeight((Font)this.host.getTitle().getFont(), (int)-2));
        text.setText(this.topic.getTitleText());
        text.setFocus();
        text.selectAll();
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TaskTreeTitleEditableTracker.this.modifyTitleText(text.getText());
                TaskTreeTitleEditableTracker.this.preCancelEditing();
                e.display.asyncExec(new Runnable(){

                    public void run() {
                        text.dispose();
                    }
                });
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '\u001b': {
                        TaskTreeTitleEditableTracker.this.preCancelEditing();
                        e.display.asyncExec(new Runnable(){

                            public void run() {
                                text.dispose();
                            }
                        });
                        break;
                    }
                    case '\r': {
                        TaskTreeTitleEditableTracker.this.modifyTitleText(text.getText());
                        TaskTreeTitleEditableTracker.this.preCancelEditing();
                        e.display.asyncExec(new Runnable(){

                            public void run() {
                                text.dispose();
                            }
                        });
                    }
                }
            }
        });
        final GanttDialogPart dialogPart_0 = dialogPart;
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (dialogPart_0 != null) {
                    dialogPart_0.activateGlobalActionHandlers();
                }
            }
        });
    }

    protected void modifyTitleText(String newValue) {
        ModifyTitleTextCommand command = new ModifyTitleTextCommand((ITitled)this.topic, newValue);
        command.setLabel(CommandMessages.Command_ModifyTopicTitle);
        this.getCommandStack().execute((Command)command);
    }
}

