/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.gantt2.viewer.BackgroundLayout;

public class TaskBarBackgroundLayout
extends BackgroundLayout {
    public static final Object CONSTRAINT_TOP_LEFT = 9;
    public static final Object CONSTRAINT_TOP_RIGHT = 12;
    private IFigure topLeft = null;
    private IFigure topRight = null;

    public void setConstraint(IFigure child, Object constraint) {
        if (CONSTRAINT_TOP_LEFT.equals(constraint)) {
            this.topLeft = child;
        } else if (CONSTRAINT_TOP_RIGHT.equals(constraint)) {
            this.topRight = child;
        } else {
            super.setConstraint(child, constraint);
        }
    }

    public void remove(IFigure child) {
        if (child == this.topLeft) {
            this.topLeft = null;
        } else if (child == this.topRight) {
            this.topRight = null;
        }
        super.remove(child);
    }

    protected Rectangle getContentsArea(IFigure container) {
        int viewportWidth = 0;
        Viewport viewport = this.getViewport(container);
        if (viewport != null) {
            viewportWidth = viewport.getBounds().width;
        }
        Rectangle r = super.getContentsArea(container);
        r.x -= 100;
        r.width += 100 + viewportWidth / 2;
        return r;
    }

    protected void layoutChildren(Rectangle contentsArea, Rectangle viewportArea, int left, int top, int width, int height) {
        if (this.topLeft != null) {
            RECT.setSize(1, 1);
            RECT.setLocation(left, contentsArea.y);
            this.topLeft.setBounds(RECT);
        }
        if (this.topRight != null) {
            RECT.setSize(1, 1);
            RECT.setLocation(left + width - 1, contentsArea.y);
            this.topRight.setBounds(RECT);
        }
        super.layoutChildren(contentsArea, viewportArea, left, top, width, height);
    }
}

