/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.IFileEntry;
import org.xmind.core.IResourceRef;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.dialogs.DialogMessages;

public class SaveAudioNoteAsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Program p;
        ITopic topic = this.getSourceTopic(event);
        final IFileEntry entry = this.getAudioFileEntry(topic);
        if (entry == null) {
            return null;
        }
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String ext = FileUtils.getExtension((String)entry.getPath());
        dialog.setFilterExtensions(new String[]{"*" + ext, "*.*"});
        String extension = ext;
        if (ext != null && (p = Program.findProgram((String)ext)) != null) {
            extension = p.getName();
        }
        dialog.setFilterNames(new String[]{extension, NLS.bind((String)"{0} (*.*)", (Object)DialogMessages.AllFilesFilterName)});
        String fileName = topic.getTitleText();
        if (fileName != null && !fileName.endsWith(ext)) {
            fileName = String.valueOf(fileName) + ext;
        }
        if (fileName != null) {
            dialog.setFileName(fileName);
        }
        dialog.setOverwrite(true);
        final String filePath = dialog.open();
        if (filePath == null) {
            return null;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                InputStream is = entry.openInputStream();
                try {
                    FileOutputStream os = new FileOutputStream(filePath);
                    try {
                        FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    is.close();
                }
            }
        });
        return null;
    }

    private ITopic getSourceTopic(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof ITopic)) continue;
                return (ITopic)element;
            }
        }
        return null;
    }

    private IFileEntry getAudioFileEntry(ITopic topic) {
        if (topic == null) {
            return null;
        }
        String entryPath = this.getAudioEntryPath(topic);
        if (entryPath == null) {
            return null;
        }
        return topic.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
    }

    private String getAudioEntryPath(ITopic topic) {
        List resourceRefs;
        ITopicExtension extension = topic.getExtension("org.xmind.ui.audionotes");
        if (extension != null && !(resourceRefs = extension.getResourceRefs()).isEmpty()) {
            for (IResourceRef ref : resourceRefs) {
                String entryPath;
                if (!"file-entry".equals(ref.getType()) || (entryPath = ref.getResourceId()) == null) continue;
                return entryPath;
            }
        }
        return null;
    }
}

