/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.editor.DialogPane;
import org.xmind.ui.mindmap.MindMapUI;

public class DecryptionDialogPane
extends DialogPane {
    private Text messageBoard;
    private Text passwordInputBox;
    private Label iconLabel;
    private String password;
    private String message = null;
    private boolean errorOccurred = false;

    @Override
    protected Control createDialogContents(Composite parent) {
        Composite composite = (Composite)super.createDialogContents(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createMessageArea(composite);
        this.createPasswordInputBox(composite);
        return composite;
    }

    @Override
    protected void createButtonsForButtonBar(Composite buttonBar) {
        this.createOkButton(buttonBar);
        this.createCloseButton(buttonBar);
    }

    private void createOkButton(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void createCloseButton(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createPasswordInputBox(Composite parent) {
        this.passwordInputBox = new Text(parent, 0x400804);
        this.applyFont((Control)this.passwordInputBox);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        this.passwordInputBox.setLayoutData((Object)gridData);
        this.hookText(this.passwordInputBox);
        this.addRefreshDefaultButtonListener((Control)this.passwordInputBox);
        this.addTriggerDefaultButtonListener((Control)this.passwordInputBox, 14);
    }

    private void createMessageArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        area.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 10;
        area.setLayout((Layout)gridLayout);
        this.createIcon(area);
        this.createMessageBoard(area);
    }

    private void createIcon(Composite parent) {
        this.iconLabel = new Label(parent, 0);
        this.iconLabel.setBackground(parent.getBackground());
        this.iconLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.iconLabel.setImage(this.getImage((Control)this.iconLabel));
    }

    private Image getImage(Control control) {
        if (this.errorOccurred) {
            return control.getDisplay().getSystemImage(1);
        }
        ImageDescriptor image = MindMapUI.getImages().get("unlock.gif", true);
        if (image != null) {
            return image.createImage((Device)control.getDisplay());
        }
        return null;
    }

    private void createMessageBoard(Composite parent) {
        this.messageBoard = new Text(parent, 74);
        this.messageBoard.setBackground(parent.getBackground());
        this.applyFont((Control)this.messageBoard);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        this.messageBoard.setLayoutData((Object)gridData);
        if (this.message != null) {
            this.messageBoard.setText(this.message);
        }
    }

    @Override
    protected boolean cancelPressed() {
        this.setReturnCode(1);
        this.close();
        return true;
    }

    @Override
    protected boolean okPressed() {
        this.password = this.passwordInputBox.getText();
        this.setReturnCode(0);
        this.close();
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.passwordInputBox = null;
        this.messageBoard = null;
    }

    @Override
    public void setFocus() {
        if (this.passwordInputBox != null && !this.passwordInputBox.isDisposed()) {
            this.passwordInputBox.setFocus();
        }
    }

    public void setContent(String message, boolean errorOrWarning) {
        this.message = message;
        this.errorOccurred = errorOrWarning;
        if (this.messageBoard != null && !this.messageBoard.isDisposed()) {
            this.messageBoard.setText(message);
        }
        if (this.iconLabel != null && !this.iconLabel.isDisposed()) {
            this.iconLabel.setImage(this.getImage((Control)this.iconLabel));
        }
        this.relayout();
    }

    @Override
    protected void escapeKeyPressed() {
        this.triggerButton(12);
    }

    public String getPassword() {
        return this.password;
    }
}

