/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.core.Core;
import org.xmind.core.IExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.slide.IPresentationEventListener;
import org.xmind.ui.internal.presentation.slide.PresentationEvent;
import org.xmind.ui.internal.presentation.slide.PresentationStory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationStoryManager {
    public static final PresentationStoryManager instance = new PresentationStoryManager();
    private Map<IWorkbook, List<PresentationStory>> storiesMap = new HashMap<IWorkbook, List<PresentationStory>>();
    private List<IPresentationEventListener> listeners = new ArrayList<IPresentationEventListener>();

    private PresentationStoryManager() {
    }

    public List<PresentationStory> getStories(IWorkbook workbook) {
        if (workbook != null) {
            List<PresentationStory> stories = this.storiesMap.get(workbook);
            if (stories == null) {
                stories = new ArrayList<PresentationStory>();
                IWorkbookExtensionElement storiesEle = PresentationStoryManager.getStoriesElement(workbook);
                List storyEles = storiesEle.getChildren("story");
                for (IWorkbookExtensionElement storyEle : storyEles) {
                    PresentationStory story = new PresentationStory(storyEle);
                    stories.add(story);
                }
                this.storiesMap.put(workbook, stories);
            }
            return stories;
        }
        return Collections.emptyList();
    }

    public PresentationStory getStory(IWorkbook workbook, String id) {
        if (workbook != null) {
            for (PresentationStory story : this.getStories(workbook)) {
                String sourceId = story.getId();
                if (sourceId == null || "".equals(id) || !sourceId.equals(id)) continue;
                return story;
            }
        }
        return null;
    }

    public PresentationStory createStory(IWorkbook workbook) {
        if (workbook != null) {
            IWorkbookExtensionElement storiesEle = PresentationStoryManager.getStoriesElement(workbook);
            IWorkbookExtensionElement storyEle = (IWorkbookExtensionElement)storiesEle.createChild("story");
            storyEle.setAttribute("id", Core.getIdFactory().createId());
            List<PresentationStory> stories = this.getStories(workbook);
            PresentationStory story = new PresentationStory(storyEle);
            story.setName(String.valueOf(PresentationMessages.Story) + " " + (stories.size() + 1));
            stories.add(story);
            this.fireStoryEvent(story, "addStory");
            return story;
        }
        return null;
    }

    public void addStory(IWorkbook workbook, PresentationStory story) {
        this.addStory(workbook, story, -1);
    }

    public void addStory(IWorkbook workbook, PresentationStory story, int index) {
        if (workbook != null) {
            List<PresentationStory> stories = this.getStories(workbook);
            IWorkbookExtensionElement storiesEle = PresentationStoryManager.getStoriesElement(workbook);
            if (index > -1 && index < stories.size()) {
                if (!stories.contains(story)) {
                    stories.add(index, story);
                }
                storiesEle.addChild((IExtensionElement)story.getImplementation(), index);
            } else {
                if (!stories.contains(story)) {
                    stories.add(story);
                }
                storiesEle.addChild((IExtensionElement)story.getImplementation(), -1);
            }
            this.fireStoryEvent(story, "addStory");
        }
    }

    public void deleteStory(IWorkbook workbook, PresentationStory story) {
        if (workbook == null || story == null) {
            return;
        }
        IWorkbookExtensionElement storiesEle = PresentationStoryManager.getStoriesElement(workbook);
        storiesEle.deleteChild((IExtensionElement)story.getImplementation());
        List<PresentationStory> stories = this.getStories(workbook);
        if (stories.contains(story)) {
            stories.remove(story);
        }
        this.fireStoryEvent(story, "addStory");
    }

    public void registerStoryEventListener(IPresentationEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unregisterStoryEventListener(IPresentationEventListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void fireStoryEvent(PresentationStory story, String type) {
        PresentationEvent event = new PresentationEvent(story, type);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).handleEvent(event);
            ++i;
        }
    }

    private static IWorkbookExtensionElement getStoriesElement(IWorkbook workbook) {
        IWorkbookExtensionElement contentEle;
        IWorkbookExtensionElement storiesEle;
        IWorkbookExtensionManager extensionManager = (IWorkbookExtensionManager)workbook.getAdapter(IWorkbookExtensionManager.class);
        IWorkbookExtension extension = extensionManager.getExtension("org.xmind.ui.presentation.stories");
        if (extension == null) {
            extension = extensionManager.createExtension("org.xmind.ui.presentation.stories");
        }
        if ((storiesEle = (IWorkbookExtensionElement)(contentEle = extension.getContent()).getFirstChild("stories")) == null) {
            storiesEle = (IWorkbookExtensionElement)contentEle.createChild("stories");
        }
        return storiesEle;
    }
}

