/*
 * Decompiled with CFR 0.152.
 */
package com.apple.dnssd;

import java.io.UnsupportedEncodingException;

public class TXTRecord {
    protected static final byte kAttrSep = 61;
    protected byte[] fBytes;

    public TXTRecord() {
        this.fBytes = new byte[0];
    }

    public TXTRecord(byte[] initBytes) {
        this.fBytes = (byte[])initBytes.clone();
    }

    public void set(String key, String value) {
        byte[] valBytes = value != null ? value.getBytes() : null;
        this.set(key, valBytes);
    }

    public void set(String key, byte[] value) {
        byte[] keyBytes;
        int valLen = value != null ? value.length : 0;
        try {
            keyBytes = key.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < keyBytes.length) {
            if (keyBytes[i] == 61) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        if (keyBytes.length + valLen >= 255) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int prevLoc = this.remove(key);
        if (prevLoc == -1) {
            prevLoc = this.size();
        }
        this.insert(keyBytes, value, prevLoc);
    }

    protected void insert(byte[] keyBytes, byte[] value, int index) {
        byte[] oldBytes = this.fBytes;
        int valLen = value != null ? value.length : 0;
        int insertion = 0;
        int i = 0;
        while (i < index && insertion < this.fBytes.length) {
            insertion += 0xFF & this.fBytes[insertion] + 1;
            ++i;
        }
        int avLen = keyBytes.length + valLen + (value != null ? 1 : 0);
        int newLen = avLen + oldBytes.length + 1;
        this.fBytes = new byte[newLen];
        System.arraycopy(oldBytes, 0, this.fBytes, 0, insertion);
        int secondHalfLen = oldBytes.length - insertion;
        System.arraycopy(oldBytes, insertion, this.fBytes, newLen - secondHalfLen, secondHalfLen);
        this.fBytes[insertion] = (byte)avLen;
        System.arraycopy(keyBytes, 0, this.fBytes, insertion + 1, keyBytes.length);
        if (value != null) {
            this.fBytes[insertion + 1 + keyBytes.length] = 61;
            System.arraycopy(value, 0, this.fBytes, insertion + keyBytes.length + 2, valLen);
        }
    }

    public int remove(String key) {
        int avStart = 0;
        int i = 0;
        while (avStart < this.fBytes.length) {
            String s;
            byte avLen = this.fBytes[avStart];
            if (key.length() <= avLen && (key.length() == avLen || this.fBytes[avStart + key.length() + 1] == 61) && key.compareToIgnoreCase(s = new String(this.fBytes, avStart + 1, key.length())) == 0) {
                byte[] oldBytes = this.fBytes;
                this.fBytes = new byte[oldBytes.length - avLen - 1];
                System.arraycopy(oldBytes, 0, this.fBytes, 0, avStart);
                System.arraycopy(oldBytes, avStart + avLen + 1, this.fBytes, avStart, oldBytes.length - avStart - avLen - 1);
                return i;
            }
            avStart += 0xFF & avLen + 1;
            ++i;
        }
        return -1;
    }

    public int size() {
        int i = 0;
        int avStart = 0;
        while (avStart < this.fBytes.length) {
            avStart += 0xFF & this.fBytes[avStart] + 1;
            ++i;
        }
        return i;
    }

    public boolean contains(String key) {
        String s = null;
        int i = 0;
        while ((s = this.getKey(i)) != null) {
            if (key.compareToIgnoreCase(s) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getKey(int index) {
        int avStart = 0;
        int i = 0;
        while (i < index && avStart < this.fBytes.length) {
            avStart += this.fBytes[avStart] + 1;
            ++i;
        }
        if (avStart < this.fBytes.length) {
            int avLen = this.fBytes[avStart];
            int aLen = 0;
            aLen = 0;
            while (aLen < avLen) {
                if (this.fBytes[avStart + aLen + 1] == 61) break;
                ++aLen;
            }
            return new String(this.fBytes, avStart + 1, aLen);
        }
        return null;
    }

    public byte[] getValue(int index) {
        int avStart = 0;
        byte[] value = null;
        int i = 0;
        while (i < index && avStart < this.fBytes.length) {
            avStart += this.fBytes[avStart] + 1;
            ++i;
        }
        if (avStart < this.fBytes.length) {
            int avLen = this.fBytes[avStart];
            int aLen = 0;
            aLen = 0;
            while (aLen < avLen) {
                if (this.fBytes[avStart + aLen + 1] == 61) {
                    value = new byte[avLen - aLen - 1];
                    System.arraycopy(this.fBytes, avStart + aLen + 2, value, 0, avLen - aLen - 1);
                    break;
                }
                ++aLen;
            }
        }
        return value;
    }

    public String getValueAsString(int index) {
        byte[] value = this.getValue(index);
        return value != null ? new String(value) : null;
    }

    public byte[] getValue(String forKey) {
        String s = null;
        int i = 0;
        while ((s = this.getKey(i)) != null) {
            if (forKey.compareToIgnoreCase(s) == 0) {
                return this.getValue(i);
            }
            ++i;
        }
        return null;
    }

    public String getValueAsString(String forKey) {
        byte[] val = this.getValue(forKey);
        return val != null ? new String(val) : null;
    }

    public byte[] getRawBytes() {
        return (byte[])this.fBytes.clone();
    }

    public String toString() {
        String a;
        String result = null;
        int i = 0;
        while ((a = this.getKey(i)) != null) {
            String av = String.valueOf(String.valueOf(i)) + "={" + a;
            String val = this.getValueAsString(i);
            av = val != null ? String.valueOf(av) + "=" + val + "}" : String.valueOf(av) + "}";
            result = result == null ? av : String.valueOf(result) + ", " + av;
            ++i;
        }
        return result != null ? result : "";
    }
}

