/* roughAli.c was originally generated by the autoSql program, which also 
 * generated roughAli.h and roughAli.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "jksql.h"
#include "roughAli.h"


void roughAliStaticLoad(char **row, struct roughAli *ret)
/* Load a row from roughAli table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->otherStart = sqlUnsigned(row[6]);
ret->otherEnd = sqlUnsigned(row[7]);
}

struct roughAli *roughAliLoad(char **row)
/* Load a roughAli from row fetched with select * from roughAli
 * from database.  Dispose of this with roughAliFree(). */
{
struct roughAli *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->otherStart = sqlUnsigned(row[6]);
ret->otherEnd = sqlUnsigned(row[7]);
return ret;
}

struct roughAli *roughAliLoadAll(char *fileName) 
/* Load all roughAli from a tab-separated file.
 * Dispose of this with roughAliFreeList(). */
{
struct roughAli *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = roughAliLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct roughAli *roughAliCommaIn(char **pS, struct roughAli *ret)
/* Create a roughAli out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new roughAli */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->otherStart = sqlUnsignedComma(&s);
ret->otherEnd = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void roughAliFree(struct roughAli **pEl)
/* Free a single dynamically allocated roughAli such as created
 * with roughAliLoad(). */
{
struct roughAli *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freez(pEl);
}

void roughAliFreeList(struct roughAli **pList)
/* Free a list of dynamically allocated roughAli's */
{
struct roughAli *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    roughAliFree(&el);
    }
*pList = NULL;
}

void roughAliOutput(struct roughAli *el, FILE *f, char sep, char lastSep) 
/* Print out roughAli.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->otherStart);
fputc(sep,f);
fprintf(f, "%u", el->otherEnd);
fputc(lastSep,f);
}

