# hgGene.sql was originally generated by the autoSql program, which also 
# generated hgGene.c and hgGene.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#A gene finding program.
CREATE TABLE geneFinder (
    id int unsigned not null,	# Unique ID
    name varchar(255) not null,	# Name of gene finder
              #Indices
    PRIMARY KEY(id)
);

#A gene prediction
CREATE TABLE hgGene (
    id int unsigned not null,	# Unique ID
    name varchar(255) not null,	# Name of gene
    geneFinder int unsigned not null,	# Program that made prediction
    startBac int unsigned not null,	# Bac this starts in
    startPos int unsigned not null,	# Position within bac where starts
    endBac int unsigned not null,	# Bac this ends in
    endPos int unsigned not null,	# Position withing bac where ends
    orientation tinyint not null,	# Orientation relative to start bac
    transcriptCount int unsigned not null,	# Number of transcripts
    transcripts longblob not null,	# Array of transcripts
              #Indices
    PRIMARY KEY(id),
    index(name(12)),
    index(startBac,startPos),
    index(endBac,endPos)
);

#A transcript prediction
CREATE TABLE hgTranscript (
    id int unsigned not null,	# Unique ID
    name varchar(255) not null,	# Name of transcript
    hgGene int unsigned not null,	# Gene this is in
    startBac int unsigned not null,	# Bac this starts in
    startPos int unsigned not null,	# Position within bac where starts
    endBac int unsigned not null,	# Bac this ends in
    endPos int unsigned not null,	# Position withing bac where ends
    cdsStartBac int unsigned not null,	# Start of coding region.
    cdsStartPos int unsigned not null,	# Start of coding region.
    cdsEndBac int unsigned not null,	# End of coding region.
    cdsEndPos int unsigned not null,	# End of coding region.
    orientation tinyint not null,	# Orientation relative to start bac
    exonCount int unsigned not null,	# Number of exons
    exonStartBacs longblob not null,	# Exon start positions
    exonStartPos longblob not null,	# Exon start positions
    exonEndBacs longblob not null,	# Exon start positions
    exonEndPos longblob not null,	# Exon start positions
              #Indices
    PRIMARY KEY(id),
    index(name),
    index(hgGene),
    index(startBac,startPos),
    index(endBac,endPos)
);
