# genMapDb.sql was originally generated by the autoSql program, which also 
# generated genMapDb.c and genMapDb.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Clones positioned on the assembly by U Penn (V. Cheung)
CREATE TABLE genMapDb (
    chrom varchar(255) not null,	# Chromosome or 'unknown'
    chromStart int not null,	# Start position in chrom - negative 1 if unpositioned
    chromEnd int unsigned not null,	# End position in chrom
    name varchar(255) not null,	# Name of Clone
    score int unsigned not null,	# Score - always 1000
    strand char(1) not null,	# + or -
    accT7 varchar(255) not null,	# Accession number for T7 BAC end sequence
    startT7 int unsigned not null,	# Start position in chrom for T7 end sequence
    endT7 int unsigned not null,	# End position in chrom for T7 end sequence
    strandT7 char(1) not null,	# + or -
    accSP6 varchar(255) not null,	# Accession number for SP6 BAC end sequence
    startSP6 int unsigned not null,	# Start position in chrom for SP6 end sequence
    endSP6 int unsigned not null,	# End position in chrom for SP6 end sequence
    strandSP6 char(1) not null,	# + or -
    stsMarker varchar(255) not null,	# Name of STS marker found in clone
    stsStart int unsigned not null,	# Start position in chrom for STS marker
    stsEnd int unsigned not null,	# End position in chrom for STS marker
              #Indices
    INDEX(chrom,chromStart),
    INDEX(name)
);
