/* landmark.h was originally generated by the autoSql program, which also 
 * generated landmark.c and landmark.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef LANDMARK_H
#define LANDMARK_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define LANDMARK_NUM_COLS 7

struct landmark
/* track for regulatory regions and other landmarks from locus experts */
    {
    struct landmark *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom */
    unsigned chromEnd;	/* End position in chrom */
    char *name;	/* name of landmark */
    unsigned landmarkId;	/* unique ID to identify this landmark */
    char *landmarkType;	/* type of landmark: HSS, promoter, .. */
    unsigned short bin; /* A field to speed indexing */
    };

void landmarkStaticLoad(char **row, struct landmark *ret);
/* Load a row from landmark table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct landmark *landmarkLoad(char **row);
/* Load a landmark from row fetched with select * from landmark
 * from database.  Dispose of this with landmarkFree(). */

struct landmark *landmarkLoadAll(char *fileName);
/* Load all landmark from whitespace-separated file.
 * Dispose of this with landmarkFreeList(). */

struct landmark *landmarkLoadAllByChar(char *fileName, char chopper);
/* Load all landmark from chopper separated file.
 * Dispose of this with landmarkFreeList(). */

#define landmarkLoadAllByTab(a) landmarkLoadAllByChar(a, '\t');
/* Load all landmark from tab separated file.
 * Dispose of this with landmarkFreeList(). */

struct landmark *landmarkLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all landmark from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with landmarkFreeList(). */

void landmarkSaveToDb(struct sqlConnection *conn, struct landmark *el, char *tableName, int updateSize);
/* Save landmark as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use landmarkSaveToDbEscaped() */

void landmarkSaveToDbEscaped(struct sqlConnection *conn, struct landmark *el, char *tableName, int updateSize);
/* Save landmark as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than landmarkSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct landmark *landmarkCommaIn(char **pS, struct landmark *ret);
/* Create a landmark out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new landmark */

void landmarkFree(struct landmark **pEl);
/* Free a single dynamically allocated landmark such as created
 * with landmarkLoad(). */

void landmarkFreeList(struct landmark **pList);
/* Free a list of dynamically allocated landmark's */

void landmarkOutput(struct landmark *el, FILE *f, char sep, char lastSep);
/* Print out landmark.  Separate fields with sep. Follow last field with lastSep. */

#define landmarkTabOut(el,f) landmarkOutput(el,f,'\t','\n');
/* Print out landmark as a line in a tab-separated file. */

#define landmarkCommaOut(el,f) landmarkOutput(el,f,',',',');
/* Print out landmark as a comma separated list including final comma. */

#define LANDMARKATTR_NUM_COLS 4

struct landmarkAttr
/* attributes associated with a landmark */
    {
    struct landmarkAttr *next;  /* Next in singly linked list. */
    unsigned landmarkId;	/* key into the landmark table */
    unsigned linkId;	/* key into the landmarkAttrLink table */
    char *attribute;	/* name of attribute being listed */
    char *attrVal;	/* value of this landmark attribute */
    };

void landmarkAttrStaticLoad(char **row, struct landmarkAttr *ret);
/* Load a row from landmarkAttr table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct landmarkAttr *landmarkAttrLoad(char **row);
/* Load a landmarkAttr from row fetched with select * from landmarkAttr
 * from database.  Dispose of this with landmarkAttrFree(). */

struct landmarkAttr *landmarkAttrLoadAll(char *fileName);
/* Load all landmarkAttr from whitespace-separated file.
 * Dispose of this with landmarkAttrFreeList(). */

struct landmarkAttr *landmarkAttrLoadAllByChar(char *fileName, char chopper);
/* Load all landmarkAttr from chopper separated file.
 * Dispose of this with landmarkAttrFreeList(). */

#define landmarkAttrLoadAllByTab(a) landmarkAttrLoadAllByChar(a, '\t');
/* Load all landmarkAttr from tab separated file.
 * Dispose of this with landmarkAttrFreeList(). */

struct landmarkAttr *landmarkAttrLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all landmarkAttr from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with landmarkAttrFreeList(). */

void landmarkAttrSaveToDb(struct sqlConnection *conn, struct landmarkAttr *el, char *tableName, int updateSize);
/* Save landmarkAttr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use landmarkAttrSaveToDbEscaped() */

void landmarkAttrSaveToDbEscaped(struct sqlConnection *conn, struct landmarkAttr *el, char *tableName, int updateSize);
/* Save landmarkAttr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than landmarkAttrSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct landmarkAttr *landmarkAttrCommaIn(char **pS, struct landmarkAttr *ret);
/* Create a landmarkAttr out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new landmarkAttr */

void landmarkAttrFree(struct landmarkAttr **pEl);
/* Free a single dynamically allocated landmarkAttr such as created
 * with landmarkAttrLoad(). */

void landmarkAttrFreeList(struct landmarkAttr **pList);
/* Free a list of dynamically allocated landmarkAttr's */

void landmarkAttrOutput(struct landmarkAttr *el, FILE *f, char sep, char lastSep);
/* Print out landmarkAttr.  Separate fields with sep. Follow last field with lastSep. */

#define landmarkAttrTabOut(el,f) landmarkAttrOutput(el,f,'\t','\n');
/* Print out landmarkAttr as a line in a tab-separated file. */

#define landmarkAttrCommaOut(el,f) landmarkAttrOutput(el,f,',',',');
/* Print out landmarkAttr as a comma separated list including final comma. */

#define LANDMARKATTRLINK_NUM_COLS 4

struct landmarkAttrLink
/* table to build links for landmarks */
    {
    struct landmarkAttrLink *next;  /* Next in singly linked list. */
    unsigned attrId;	/* key into the landmarkAttr table */
    char *raKey;	/* key into RA file, tells how to link */
    char *attrAcc;	/* accession used by link */
    char *displayVal;	/* how to display if different from acc */
    };

void landmarkAttrLinkStaticLoad(char **row, struct landmarkAttrLink *ret);
/* Load a row from landmarkAttrLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct landmarkAttrLink *landmarkAttrLinkLoad(char **row);
/* Load a landmarkAttrLink from row fetched with select * from landmarkAttrLink
 * from database.  Dispose of this with landmarkAttrLinkFree(). */

struct landmarkAttrLink *landmarkAttrLinkLoadAll(char *fileName);
/* Load all landmarkAttrLink from whitespace-separated file.
 * Dispose of this with landmarkAttrLinkFreeList(). */

struct landmarkAttrLink *landmarkAttrLinkLoadAllByChar(char *fileName, char chopper);
/* Load all landmarkAttrLink from chopper separated file.
 * Dispose of this with landmarkAttrLinkFreeList(). */

#define landmarkAttrLinkLoadAllByTab(a) landmarkAttrLinkLoadAllByChar(a, '\t');
/* Load all landmarkAttrLink from tab separated file.
 * Dispose of this with landmarkAttrLinkFreeList(). */

struct landmarkAttrLink *landmarkAttrLinkLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all landmarkAttrLink from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with landmarkAttrLinkFreeList(). */

void landmarkAttrLinkSaveToDb(struct sqlConnection *conn, struct landmarkAttrLink *el, char *tableName, int updateSize);
/* Save landmarkAttrLink as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use landmarkAttrLinkSaveToDbEscaped() */

void landmarkAttrLinkSaveToDbEscaped(struct sqlConnection *conn, struct landmarkAttrLink *el, char *tableName, int updateSize);
/* Save landmarkAttrLink as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than landmarkAttrLinkSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct landmarkAttrLink *landmarkAttrLinkCommaIn(char **pS, struct landmarkAttrLink *ret);
/* Create a landmarkAttrLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new landmarkAttrLink */

void landmarkAttrLinkFree(struct landmarkAttrLink **pEl);
/* Free a single dynamically allocated landmarkAttrLink such as created
 * with landmarkAttrLinkLoad(). */

void landmarkAttrLinkFreeList(struct landmarkAttrLink **pList);
/* Free a list of dynamically allocated landmarkAttrLink's */

void landmarkAttrLinkOutput(struct landmarkAttrLink *el, FILE *f, char sep, char lastSep);
/* Print out landmarkAttrLink.  Separate fields with sep. Follow last field with lastSep. */

#define landmarkAttrLinkTabOut(el,f) landmarkAttrLinkOutput(el,f,'\t','\n');
/* Print out landmarkAttrLink as a line in a tab-separated file. */

#define landmarkAttrLinkCommaOut(el,f) landmarkAttrLinkOutput(el,f,',',',');
/* Print out landmarkAttrLink as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* LANDMARK_H */

