/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.util;

import com.google.common.collect.Lists;
import com.google.jstestdriver.model.HandlerPathPrefix;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class HtmlWriter {
    public static String FRAMESET = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">";
    public static String QUIRKS = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    public static String STRICT = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/DTD/strict.dtd\">";
    private final Writer writer;
    private final HandlerPathPrefix prefix;
    private String dtd = null;
    private List<String> body = Lists.newLinkedList();

    public HtmlWriter(Writer writer, HandlerPathPrefix prefix) {
        this.writer = writer;
        this.prefix = prefix;
    }

    public HtmlWriter writeStrictDtd() {
        this.dtd = STRICT;
        return this;
    }

    public HtmlWriter writeQuirksDtd() {
        this.dtd = QUIRKS;
        return this;
    }

    public HtmlWriter startHead() {
        this.body.add("<html>");
        this.body.add("<head>");
        return this;
    }

    public HtmlWriter writeTitle(String title) {
        this.body.add("<title>");
        this.body.add(title);
        this.body.add("</title>");
        return this;
    }

    public HtmlWriter writeStyleSheet(String path) {
        this.body.add("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        this.body.add(this.prefix.prefixPath(path));
        this.body.add("\"/>");
        return this;
    }

    public HtmlWriter finishHead() {
        this.body.add("</head>");
        return this;
    }

    public HtmlWriter startBody() {
        this.body.add("<body>");
        return this;
    }

    public HtmlWriter writeIframe(String id, String src) {
        this.body.add("<iframe id=\"");
        this.body.add(id);
        this.body.add("\" src=\"");
        this.body.add(this.prefix.prefixPath(src));
        this.body.add("\" frameborder=\"0\"></iframe>");
        return this;
    }

    public HtmlWriter finishBody() {
        this.body.add("</body>");
        return this;
    }

    public HtmlWriter writeExternalScript(String path) {
        this.body.add("<script src=\"");
        this.body.add(this.prefix.prefixPath(path));
        this.body.add("\" type=\"text/javascript\"></script>");
        return this;
    }

    public void flush() throws IOException {
        this.body.add("</html>");
        this.writer.append(this.dtd);
        for (String fragment : this.body) {
            this.writer.write(fragment);
        }
        this.writer.flush();
    }

    public HtmlWriter writeScript(String script) {
        this.body.add("<script type=\"text/javascript\">");
        this.body.add(script);
        this.body.add("</script>");
        return this;
    }

    public HtmlWriter startFrameSet() {
        this.dtd = FRAMESET;
        this.body.add("<frameset rows='80,*' border=\"1\">");
        return this;
    }

    public HtmlWriter writeFrame(String id, String src) {
        this.body.add("<frame id=\"");
        this.body.add(id);
        this.body.add("\" src=\"");
        this.body.add(src);
        this.body.add("\" />");
        return this;
    }

    public HtmlWriter finishFrameSet() {
        this.body.add("</frameset>");
        return this;
    }
}

