/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.servlet.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingServlet
extends ProxyServlet.Transparent {
    private static final Logger logger = LoggerFactory.getLogger(ForwardingServlet.class);
    private static final int SKIP_FORWARD_INDEX = "/forward/".length();

    public ForwardingServlet(String defaultServer, int port) {
        super("forward", defaultServer, port);
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        super.service(req, resp);
    }

    protected URL proxyHttpURL(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
        return this.getForwardingUrl(scheme, serverName, serverPort, uri);
    }

    public URL getForwardingUrl(String scheme, String serverName, int serverPort, String uri) throws MalformedURLException {
        String server = uri.substring(SKIP_FORWARD_INDEX);
        String forwardUri = String.format("%s://%s", scheme, server);
        logger.debug(forwardUri);
        return new URL(forwardUri);
    }
}

