/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CompileVHDL {
    private static final boolean BIT_VECTOR_HACK = true;
    private static final int TOKEN_AMPERSAND = 0;
    private static final int TOKEN_APOSTROPHE = 1;
    private static final int TOKEN_LEFTBRACKET = 2;
    private static final int TOKEN_RIGHTBRACKET = 3;
    private static final int TOKEN_STAR = 4;
    private static final int TOKEN_PLUS = 5;
    private static final int TOKEN_COMMA = 6;
    private static final int TOKEN_MINUS = 7;
    private static final int TOKEN_PERIOD = 8;
    private static final int TOKEN_SLASH = 9;
    private static final int TOKEN_COLON = 10;
    private static final int TOKEN_SEMICOLON = 11;
    private static final int TOKEN_LT = 12;
    private static final int TOKEN_EQ = 13;
    private static final int TOKEN_GT = 14;
    private static final int TOKEN_VERTICALBAR = 15;
    private static final int TOKEN_ARROW = 16;
    private static final int TOKEN_DOUBLEDOT = 17;
    private static final int TOKEN_DOUBLESTAR = 18;
    private static final int TOKEN_VARASSIGN = 19;
    private static final int TOKEN_NE = 20;
    private static final int TOKEN_GE = 21;
    private static final int TOKEN_LE = 22;
    private static final int TOKEN_BOX = 23;
    private static final int TOKEN_UNKNOWN = 24;
    private static final int TOKEN_IDENTIFIER = 25;
    private static final int TOKEN_KEYWORD = 26;
    private static final int TOKEN_DECIMAL = 27;
    private static final int TOKEN_BASED = 28;
    private static final int TOKEN_CHAR = 29;
    private static final int TOKEN_STRING = 30;
    private static final int TOKEN_BIT_STRING = 31;
    private static final int KEY_ABS = 0;
    private static final int KEY_AFTER = 1;
    private static final int KEY_ALIAS = 2;
    private static final int KEY_AND = 3;
    private static final int KEY_ARCHITECTURE = 4;
    private static final int KEY_ARRAY = 5;
    private static final int KEY_ASSERTION = 6;
    private static final int KEY_ATTRIBUTE = 7;
    private static final int KEY_BEHAVIORAL = 8;
    private static final int KEY_BEGIN = 9;
    private static final int KEY_BODY = 10;
    private static final int KEY_CASE = 11;
    private static final int KEY_COMPONENT = 12;
    private static final int KEY_CONNECT = 13;
    private static final int KEY_CONSTANT = 14;
    private static final int KEY_CONVERT = 15;
    private static final int KEY_DOT = 16;
    private static final int KEY_DOWNTO = 17;
    private static final int KEY_ELSE = 18;
    private static final int KEY_ELSIF = 19;
    private static final int KEY_END = 20;
    private static final int KEY_ENTITY = 21;
    private static final int KEY_EXIT = 22;
    private static final int KEY_FOR = 23;
    private static final int KEY_FUNCTION = 24;
    private static final int KEY_GENERATE = 25;
    private static final int KEY_GENERIC = 26;
    private static final int KEY_IF = 27;
    private static final int KEY_IN = 28;
    private static final int KEY_INOUT = 29;
    private static final int KEY_IS = 30;
    private static final int KEY_LINKAGE = 31;
    private static final int KEY_LOOP = 32;
    private static final int KEY_MOD = 33;
    private static final int KEY_NAND = 34;
    private static final int KEY_NEXT = 35;
    private static final int KEY_NOR = 36;
    private static final int KEY_NOT = 37;
    private static final int KEY_NULL = 38;
    private static final int KEY_OF = 39;
    private static final int KEY_OR = 40;
    private static final int KEY_OTHERS = 41;
    private static final int KEY_OUT = 42;
    private static final int KEY_PACKAGE = 43;
    private static final int KEY_PORT = 44;
    private static final int KEY_RANGE = 45;
    private static final int KEY_RECORD = 46;
    private static final int KEY_REM = 47;
    private static final int KEY_REPORT = 48;
    private static final int KEY_RESOLVE = 49;
    private static final int KEY_RETURN = 50;
    private static final int KEY_SEVERITY = 51;
    private static final int KEY_SIGNAL = 52;
    private static final int KEY_STANDARD = 53;
    private static final int KEY_STATIC = 54;
    private static final int KEY_SUBTYPE = 55;
    private static final int KEY_THEN = 56;
    private static final int KEY_TO = 57;
    private static final int KEY_TYPE = 58;
    private static final int KEY_UNITS = 59;
    private static final int KEY_USE = 60;
    private static final int KEY_VARIABLE = 61;
    private static final int KEY_WHEN = 62;
    private static final int KEY_WHILE = 63;
    private static final int KEY_WITH = 64;
    private static final int KEY_XOR = 65;
    private static final int KEY_OPEN = 66;
    private static final int KEY_MAP = 67;
    private static final int KEY_ALL = 68;
    private static final int KEY_LIBRARY = 69;
    private static final boolean EXTERNALENTITIES = true;
    private static final boolean WARNFLAG = false;
    private static final int TOP_ENTITY_FLAG = 1;
    private static final int ENTITY_WRITTEN = 2;
    private static final int SYMBOL_ENTITY = 1;
    private static final int SYMBOL_BODY = 2;
    private static final int SYMBOL_TYPE = 3;
    private static final int SYMBOL_FPORT = 4;
    private static final int SYMBOL_COMPONENT = 5;
    private static final int SYMBOL_SIGNAL = 6;
    private static final int SYMBOL_INSTANCE = 7;
    private static final int SYMBOL_VARIABLE = 8;
    private static final int SYMBOL_LABEL = 9;
    private static final int SYMBOL_PACKAGE = 10;
    private static final int SYMBOL_CONSTANT = 11;
    private static final int DBMODE_IN = 1;
    private static final int DBMODE_OUT = 2;
    private static final int DBTYPE_SINGLE = 1;
    private static final int DBTYPE_ARRAY = 2;
    private static final int DBNAME_IDENTIFIER = 1;
    private static final int DBNAME_INDEXED = 2;
    private static final int DBNAME_CONCATENATED = 3;
    private static final int NOUNIT = 0;
    private static final int UNIT_INTERFACE = 1;
    private static final int UNIT_FUNCTION = 2;
    private static final int UNIT_PACKAGE = 3;
    private static final int UNIT_BODY = 4;
    private static final int UNIT_USE = 6;
    private static final int MODE_IN = 1;
    private static final int MODE_OUT = 2;
    private static final int MODE_DOTOUT = 3;
    private static final int MODE_INOUT = 4;
    private static final int MODE_LINKAGE = 5;
    private static final int BODYDECLARE_BASIC = 1;
    private static final int BODYDECLARE_COMPONENT = 2;
    private static final int BODYDECLARE_RESOLUTION = 3;
    private static final int BODYDECLARE_LOCAL = 4;
    private static final int NOBASICDECLARE = 0;
    private static final int BASICDECLARE_OBJECT = 1;
    private static final int BASICDECLARE_TYPE = 2;
    private static final int BASICDECLARE_SUBTYPE = 3;
    private static final int BASICDECLARE_CONVERSION = 4;
    private static final int BASICDECLARE_ATTRIBUTE = 5;
    private static final int BASICDECLARE_ATT_SPEC = 6;
    private static final int NOOBJECTDECLARE = 0;
    private static final int OBJECTDECLARE_CONSTANT = 1;
    private static final int OBJECTDECLARE_SIGNAL = 2;
    private static final int OBJECTDECLARE_VARIABLE = 3;
    private static final int OBJECTDECLARE_ALIAS = 4;
    private static final int TYPE_SCALAR = 1;
    private static final int TYPE_COMPOSITE = 2;
    private static final int COMPOSITE_ARRAY = 1;
    private static final int COMPOSITE_RECORD = 2;
    private static final int ARRAY_UNCONSTRAINED = 1;
    private static final int ARRAY_CONSTRAINED = 2;
    private static final int NOARCHSTATE = 0;
    private static final int ARCHSTATE_GENERATE = 1;
    private static final int ARCHSTATE_SIG_ASSIGN = 2;
    private static final int ARCHSTATE_IF = 3;
    private static final int ARCHSTATE_CASE = 4;
    private static final int ARCHSTATE_INSTANCE = 5;
    private static final int ARCHSTATE_NULL = 6;
    private static final int APORTLIST_NAME = 1;
    private static final int GENSCHEME_FOR = 0;
    private static final int GENSCHEME_IF = 1;
    private static final int NONAME = 0;
    private static final int NAME_SINGLE = 1;
    private static final int NAME_CONCATENATE = 2;
    private static final int NAME_ATTRIBUTE = 3;
    private static final int NOSINGLENAME = 0;
    private static final int SINGLENAME_SIMPLE = 1;
    private static final int SINGLENAME_SELECTED = 2;
    private static final int SINGLENAME_INDEXED = 3;
    private static final int SINGLENAME_SLICE = 4;
    private static final int PREFIX_NAME = 1;
    private static final int PREFIX_FUNCTION_CALL = 2;
    private static final int DISCRETERANGE_SUBTYPE = 1;
    private static final int DISCRETERANGE_RANGE = 2;
    private static final int RANGE_ATTRIBUTE = 1;
    private static final int RANGE_SIMPLE_EXPR = 2;
    private static final int NOLOGOP = 0;
    private static final int LOGOP_AND = 1;
    private static final int LOGOP_OR = 2;
    private static final int LOGOP_NAND = 3;
    private static final int LOGOP_NOR = 4;
    private static final int LOGOP_XOR = 5;
    private static final int NORELOP = 0;
    private static final int RELOP_EQ = 1;
    private static final int RELOP_NE = 2;
    private static final int RELOP_LT = 3;
    private static final int RELOP_LE = 4;
    private static final int RELOP_GT = 5;
    private static final int RELOP_GE = 6;
    private static final int NOADDOP = 0;
    private static final int ADDOP_ADD = 1;
    private static final int ADDOP_SUBTRACT = 2;
    private static final int NOMULOP = 0;
    private static final int MULOP_MULTIPLY = 1;
    private static final int MULOP_DIVIDE = 2;
    private static final int MULOP_MOD = 3;
    private static final int MULOP_REM = 4;
    private static final int NOMISCOP = 0;
    private static final int MISCOP_POWER = 1;
    private static final int MISCOP_ABS = 2;
    private static final int MISCOP_NOT = 3;
    private static final int NOPRIMARY = 0;
    private static final int PRIMARY_NAME = 1;
    private static final int PRIMARY_LITERAL = 2;
    private static final int PRIMARY_AGGREGATE = 3;
    private static final int PRIMARY_CONCATENATION = 4;
    private static final int PRIMARY_FUNCTION_CALL = 5;
    private static final int PRIMARY_TYPE_CONVERSION = 6;
    private static final int PRIMARY_QUALIFIED_EXPR = 7;
    private static final int PRIMARY_EXPRESSION = 8;
    private static final int NOLITERAL = 0;
    private static final int LITERAL_NUMERIC = 1;
    private static final int LITERAL_ENUMERATION = 2;
    private static final int LITERAL_STRING = 3;
    private static final int LITERAL_BIT_STRING = 4;
    private static String delimiterStr = "&'()*+,-./:;<=>|";
    private static String doubleDelimiterStr = "=>..**:=/=>=<=<>";
    private static VKeyword[] theKeywords = new VKeyword[]{new VKeyword("abs", 0), new VKeyword("after", 1), new VKeyword("alias", 2), new VKeyword("all", 68), new VKeyword("and", 3), new VKeyword("architecture", 4), new VKeyword("array", 5), new VKeyword("assertion", 6), new VKeyword("attribute", 7), new VKeyword("begin", 9), new VKeyword("behavioral", 8), new VKeyword("body", 10), new VKeyword("case", 11), new VKeyword("component", 12), new VKeyword("connect", 13), new VKeyword("constant", 14), new VKeyword("convert", 15), new VKeyword("dot", 16), new VKeyword("downto", 17), new VKeyword("else", 18), new VKeyword("elsif", 19), new VKeyword("end", 20), new VKeyword("entity", 21), new VKeyword("exit", 22), new VKeyword("for", 23), new VKeyword("function", 24), new VKeyword("generate", 25), new VKeyword("generic", 26), new VKeyword("if", 27), new VKeyword("in", 28), new VKeyword("inout", 29), new VKeyword("is", 30), new VKeyword("library", 69), new VKeyword("linkage", 31), new VKeyword("loop", 32), new VKeyword("map", 67), new VKeyword("mod", 33), new VKeyword("nand", 34), new VKeyword("next", 35), new VKeyword("nor", 36), new VKeyword("not", 37), new VKeyword("null", 38), new VKeyword("of", 39), new VKeyword("open", 66), new VKeyword("or", 40), new VKeyword("others", 41), new VKeyword("out", 42), new VKeyword("package", 43), new VKeyword("port", 44), new VKeyword("range", 45), new VKeyword("record", 46), new VKeyword("rem", 47), new VKeyword("report", 48), new VKeyword("resolve", 49), new VKeyword("return", 50), new VKeyword("severity", 51), new VKeyword("signal", 52), new VKeyword("standard", 53), new VKeyword("static", 54), new VKeyword("subtype", 55), new VKeyword("then", 56), new VKeyword("to", 57), new VKeyword("type", 58), new VKeyword("units", 59), new VKeyword("use", 60), new VKeyword("variable", 61), new VKeyword("when", 62), new VKeyword("while", 63), new VKeyword("with", 64), new VKeyword("xor", 65)};
    private Cell vhdlCell;
    private HashSet<String> identTable;
    private TokenList tListStart;
    private TokenList tListEnd;
    private int errorCount;
    private boolean hasErrors;
    private UnResList unResolvedList;
    private boolean hasError;
    private TokenList nextToken;
    private PTree pTree;
    private DBUnits theUnits;
    private SymbolList localSymbols;
    private SymbolList globalSymbols;
    private SymbolList instanceSymbols;
    private int forLoopLevel = 0;
    private int[] forLoopTags = new int[10];
    private static String[] power = new String[]{"gate power(p)", "set p=H@3", "t: delta=0"};
    private static String[] ground = new String[]{"gate ground(g)", "set g=L@3", "t: delta=0"};
    private static String[] pMOStran = new String[]{"function PMOStran(g, a1, a2)", "i: g, a1, a2", "o: a1, a2", "t: delta=1e-8"};
    private static String[] pMOStranWeak = new String[]{"function pMOStranWeak(g, a1, a2)", "i: g, a1, a2", "o: a1, a2", "t: delta=1e-8"};
    private static String[] nMOStran = new String[]{"function nMOStran(g, a1, a2)", "i: g, a1, a2", "o: a1, a2", "t: delta=1e-8"};
    private static String[] nMOStranWeak = new String[]{"function nMOStranWeak(g, a1, a2)", "i: g, a1, a2", "o: a1, a2", "t: delta=1e-8"};
    private static String[] inverter = new String[]{"gate inverter(a,z)", "t: delta=1.33e-9", "i: a=L o: z=H", "t: delta=1.07e-9", "i: a=H o: z=L", "t: delta=0", "i: a=X o: z=X", "load: a=1.0"};
    private static String[] buffer = new String[]{"gate buffer(in,out)", "t: delta=0.56e-9", "i: in=H o: out=H", "t: delta=0.41e-9", "i: in=L o: out=L", "t: delta=0", "i: in=X o: out=X"};
    private static String[] xor2 = new String[]{"model xor2(a,b,z)", "g1: xor2fun(a,b,out)", "g2: xor2buf(out,z)", "gate xor2fun(a,b,out)", "t: delta=1.33e-9", "i: a=L b=H o: out=H", "i: a=H b=L o: out=H", "t: delta=1.07e-9", "i: a=L b=L o: out=L", "i: a=H b=H o: out=L", "t: delta=0", "i:         o: out=X", "load: a=1.0 b=1.0", "gate xor2buf(in,out)", "t: delta=0.56e-9", "i: in=H    o: out=H", "t: delta=0.41e-9", "i: in=L    o: out=L", "t: delta=0", "i: in=X    o: out=X"};
    private static String[] JKFF = new String[]{"model jkff(j, k, clk, pr, clr, q, qbar)", "n: JKFFLOP(clk, j, k, q, qbar)", "function JKFFLOP(clk, j, k, q, qbar)", "i: clk, j, k", "o: q, qbar", "t: delta=1e-8"};
    private static String[] DFF = new String[]{"model dsff(d, clk, pr, q)", "n: DFFLOP(d, clk, q)", "function DFFLOP(d, clk, q)", "i: d, clk", "o: q", "t: delta=1e-8"};
    private static final int QNODE_SNAME = 0;
    private static final int QNODE_INAME = 1;
    private static final int QNODE_EXPORT = 1;
    private static final int QNODE_POWER = 2;
    private static final int QNODE_GROUND = 4;

    public CompileVHDL(Cell vhdlCell) {
        this.vhdlCell = vhdlCell;
        this.hasErrors = true;
        String[] strings = vhdlCell.getTextViewContents();
        if (strings == null) {
            System.out.println("Cell " + vhdlCell.describe(true) + " has no text in it");
            return;
        }
        this.unResolvedList = null;
        this.identTable = new HashSet();
        this.errorCount = 0;
        this.doScanner(strings);
        if (this.doParser(this.tListStart)) {
            return;
        }
        if (this.doSemantic()) {
            return;
        }
        this.hasErrors = false;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public List<String> getQUISCNetlist(Library destLib, boolean isIncludeDateAndVersionInOutput) {
        if (this.hasErrors) {
            return null;
        }
        List<String> netlistStrings = this.genQuisc(destLib, isIncludeDateAndVersionInOutput);
        return netlistStrings;
    }

    public List<String> getALSNetlist(Library destLib) {
        if (this.hasErrors) {
            return null;
        }
        Library behaveLib = null;
        List<String> netlistStrings = this.genALS(destLib, behaveLib);
        return netlistStrings;
    }

    private void doScanner(String[] strings) {
        String buf = "";
        int bufPos = 0;
        int lineNum = 0;
        boolean space = false;
        block19: while (true) {
            int end;
            if (bufPos >= buf.length()) {
                if (lineNum >= strings.length) {
                    return;
                }
                buf = strings[lineNum++];
                bufPos = 0;
                space = true;
            } else {
                space = Character.isWhitespace(buf.charAt(bufPos));
            }
            while (bufPos < buf.length() && Character.isWhitespace(buf.charAt(bufPos))) {
                ++bufPos;
            }
            if (bufPos >= buf.length()) continue;
            char c = buf.charAt(bufPos);
            if (Character.isLetter(c)) {
                char eChar;
                for (end = bufPos; end < buf.length() && (Character.isLetterOrDigit(eChar = buf.charAt(end)) || eChar == '_'); ++end) {
                }
                VKeyword key = CompileVHDL.isKeyword(buf.substring(bufPos, end));
                if (key != null) {
                    new TokenList(26, key, lineNum, space);
                } else {
                    String ident = buf.substring(bufPos, end);
                    this.identTable.add(ident);
                    new TokenList(25, ident, lineNum, space);
                }
                bufPos = end;
                continue;
            }
            if (TextUtils.isDigit(c)) {
                char eChar;
                for (end = bufPos + 1; end < buf.length() && (TextUtils.isDigit(eChar = buf.charAt(end)) || eChar == '_'); ++end) {
                }
                new TokenList(27, buf.substring(bufPos, end), lineNum, space);
                bufPos = end;
                continue;
            }
            switch (c) {
                case '\"': {
                    for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n'; ++end) {
                        if (buf.charAt(end) != '\"') continue;
                        if (end + 1 >= buf.length() || buf.charAt(end + 1) != '\"') break;
                        ++end;
                    }
                    String newString = buf.substring(bufPos + 1, end);
                    newString.replaceAll("\"\"", "\"");
                    new TokenList(30, newString, lineNum, space);
                    if (buf.charAt(end) == '\"') {
                        // empty if block
                    }
                    bufPos = ++end;
                    continue block19;
                }
                case '&': {
                    new TokenList(0, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '\'': {
                    if (bufPos + 2 < buf.length() && buf.charAt(bufPos + 2) == '\'') {
                        new TokenList(29, new Character(buf.charAt(bufPos + 1)), lineNum, space);
                        bufPos += 3;
                        continue block19;
                    }
                    ++bufPos;
                    continue block19;
                }
                case '(': {
                    new TokenList(2, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case ')': {
                    new TokenList(3, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '*': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '*') {
                        new TokenList(18, null, lineNum, space);
                        bufPos += 2;
                        continue block19;
                    }
                    new TokenList(4, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '+': {
                    new TokenList(5, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case ',': {
                    new TokenList(6, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '-': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '-') {
                        bufPos = buf.length();
                        continue block19;
                    }
                    new TokenList(7, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '.': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '.') {
                        new TokenList(17, null, lineNum, space);
                        bufPos += 2;
                        continue block19;
                    }
                    new TokenList(8, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '/': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '=') {
                        new TokenList(20, null, lineNum, space);
                        bufPos += 2;
                        continue block19;
                    }
                    new TokenList(9, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case ':': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '=') {
                        new TokenList(19, null, lineNum, space);
                        bufPos += 2;
                        continue block19;
                    }
                    new TokenList(10, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case ';': {
                    new TokenList(11, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '<': {
                    if (bufPos + 1 < buf.length()) {
                        if (buf.charAt(bufPos + 1) == '=') {
                            new TokenList(22, null, lineNum, space);
                            bufPos += 2;
                            continue block19;
                        }
                        if (buf.charAt(bufPos + 1) == '>') {
                            new TokenList(23, null, lineNum, space);
                            bufPos += 2;
                            continue block19;
                        }
                    }
                    new TokenList(12, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '=': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '>') {
                        new TokenList(16, null, lineNum, space);
                        bufPos += 2;
                        continue block19;
                    }
                    new TokenList(13, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '>': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '=') {
                        new TokenList(21, null, lineNum, space);
                        bufPos += 2;
                        continue block19;
                    }
                    new TokenList(14, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
                case '|': {
                    new TokenList(15, null, lineNum, space);
                    ++bufPos;
                    continue block19;
                }
            }
            new TokenList(24, null, lineNum, space);
            ++bufPos;
        }
    }

    public static VKeyword isKeyword(String tString) {
        tString = TextUtils.canonicString(tString);
        int base = 0;
        int num = theKeywords.length;
        int aIndex = num >> 1;
        while (num != 0) {
            int check2 = tString.compareTo(CompileVHDL.theKeywords[base + aIndex].name);
            if (check2 == 0) {
                return theKeywords[base + aIndex];
            }
            if (check2 < 0) {
                num = aIndex;
                aIndex = num >> 1;
                continue;
            }
            base += aIndex + 1;
            aIndex = (num -= aIndex + 1) >> 1;
        }
        return null;
    }

    private boolean doParser(TokenList tList) {
        this.hasError = false;
        this.pTree = null;
        PTree endunit = null;
        this.nextToken = tList;
        try {
            while (this.nextToken != null) {
                if (this.nextToken.token == 26) {
                    int type = 0;
                    VKeyword vk = (VKeyword)this.nextToken.pointer;
                    Object pointer = null;
                    switch (vk.num) {
                        case 69: {
                            this.parseToSemicolon();
                            break;
                        }
                        case 21: {
                            type = 1;
                            pointer = this.parseInterface();
                            break;
                        }
                        case 4: {
                            type = 4;
                            pointer = this.parseBody();
                            break;
                        }
                        case 43: {
                            type = 3;
                            pointer = this.parsePackage();
                            break;
                        }
                        case 60: {
                            type = 6;
                            pointer = this.parseUse();
                            break;
                        }
                        default: {
                            this.reportErrorMsg(this.nextToken, "No entry keyword - entity, architectural, behavioral");
                            this.nextToken = this.nextToken.next;
                        }
                    }
                    if (type == 0) continue;
                    PTree newUnit = new PTree();
                    newUnit.type = type;
                    newUnit.pointer = pointer;
                    newUnit.next = null;
                    if (endunit == null) {
                        this.pTree = endunit = newUnit;
                        continue;
                    }
                    endunit.next = newUnit;
                    endunit = newUnit;
                    continue;
                }
                this.reportErrorMsg(this.nextToken, "No entry keyword - entity, architectural, behavioral");
                this.nextToken = this.nextToken.next;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.hasError;
    }

    private VInterface parseInterface() throws ParseException {
        this.getNextToken();
        TokenList name = null;
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
        } else {
            name = this.nextToken;
        }
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 30)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword IS");
        }
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 44)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword PORT");
        }
        this.getNextToken();
        if (this.nextToken.token != 2) {
            this.reportErrorMsg(this.nextToken, "Expecting a left bracket");
        }
        this.getNextToken();
        FPortList ports = this.parseFormalPortList();
        if (ports == null) {
            this.reportErrorMsg(this.nextToken, "Interface must have ports");
        }
        if (this.nextToken.token != 3) {
            this.reportErrorMsg(this.nextToken, "Expecting a right bracket");
        }
        this.getNextToken();
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        } else {
            this.getNextToken();
        }
        if (!this.isKeySame(this.nextToken, 20)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword END");
        }
        this.getNextToken();
        if (this.nextToken.token == 25) {
            if (!this.nextToken.pointer.equals(name.pointer)) {
                this.reportErrorMsg(this.nextToken, "Unmatched entity identifier names");
            }
            this.getNextToken();
        }
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.nextToken = this.nextToken.next;
        VInterface interfacef = new VInterface();
        interfacef.name = name;
        interfacef.ports = ports;
        interfacef.interfacef = null;
        return interfacef;
    }

    private Body parseBody() throws ParseException {
        this.getNextToken();
        TokenList bodyName = null;
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
        } else {
            bodyName = this.nextToken;
        }
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 39)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword OF");
        }
        this.getNextToken();
        SimpleName entityName = this.parseSimpleName();
        if (!this.isKeySame(this.nextToken, 30)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword IS");
        }
        this.getNextToken();
        BodyDeclare bodyDeclare = this.parseBodyDeclare();
        if (!this.isKeySame(this.nextToken, 9)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword BEGIN");
        }
        this.getNextToken();
        Statements statements = this.parseSetOfStatements();
        if (!this.isKeySame(this.nextToken, 20)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword END");
        }
        this.getNextToken();
        if (this.nextToken.token == 25) {
            if (!this.nextToken.pointer.equals(bodyName.pointer)) {
                this.reportErrorMsg(this.nextToken, "Body name mismatch");
            }
            this.getNextToken();
        }
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.nextToken = this.nextToken.next;
        Body body = new Body();
        body.name = bodyName;
        body.entity = entityName;
        body.bodyDeclare = bodyDeclare;
        body.statements = statements;
        return body;
    }

    private Package parsePackage() throws ParseException {
        Package vPackage = null;
        if (!this.isKeySame(this.nextToken, 43)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword PACKAGE");
            this.getNextToken();
            return vPackage;
        }
        this.getNextToken();
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
            this.getNextToken();
            return vPackage;
        }
        TokenList identifier = this.nextToken;
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 30)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword IS");
            this.getNextToken();
            return vPackage;
        }
        this.getNextToken();
        PackagedPart declarePart = this.parsePackageDeclarePart();
        if (!this.isKeySame(this.nextToken, 20)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword END");
            this.getNextToken();
            return vPackage;
        }
        this.getNextToken();
        if (this.nextToken.token == 25) {
            if (!this.nextToken.pointer.equals(identifier.pointer)) {
                this.reportErrorMsg(this.nextToken, "Name mismatch");
                this.getNextToken();
                return vPackage;
            }
            this.getNextToken();
        }
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
            this.getNextToken();
            return vPackage;
        }
        this.getNextToken();
        vPackage = new Package();
        vPackage.name = identifier;
        vPackage.declare = declarePart;
        return vPackage;
    }

    private Use parseUse() throws ParseException {
        Use use = null;
        if (!this.isKeySame(this.nextToken, 60)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword USE");
            this.getNextToken();
            return use;
        }
        this.getNextToken();
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Bad unit name for use clause");
            this.getNextToken();
            return use;
        }
        use = new Use();
        use.unit = this.nextToken;
        use.next = null;
        Use endUse = use;
        this.getNextToken();
        while (true) {
            if (this.nextToken.token != 8) {
                this.reportErrorMsg(this.nextToken, "Expecting period");
                break;
            }
            this.getNextToken();
            if (this.isKeySame(this.nextToken, 68)) {
                this.getNextToken();
                break;
            }
            if (this.nextToken.token != 25) {
                this.reportErrorMsg(this.nextToken, "Bad unit name for use clause");
                break;
            }
            this.getNextToken();
        }
        while (this.nextToken.token == 6) {
            this.getNextToken();
            if (this.nextToken.token != 25) {
                this.reportErrorMsg(this.nextToken, "Bad unit name for use clause");
                this.getNextToken();
                return use;
            }
            Use newUse = new Use();
            newUse.unit = this.nextToken;
            newUse.next = null;
            endUse.next = newUse;
            endUse = newUse;
            this.getNextToken();
            if (this.nextToken.token == 8) {
                this.getNextToken();
            } else {
                this.reportErrorMsg(this.nextToken, "Expecting period");
            }
            if (this.isKeySame(this.nextToken, 68)) {
                this.getNextToken();
                continue;
            }
            this.reportErrorMsg(this.nextToken, "Expecting keyword ALL");
        }
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.getNextToken();
        return use;
    }

    private PackagedPart parsePackageDeclarePart() throws ParseException {
        PackagedPart dPart = null;
        if (this.isKeySame(this.nextToken, 20)) {
            this.reportErrorMsg(this.nextToken, "No Package declarative part");
            return dPart;
        }
        BasicDeclare dItem = this.parseBasicDeclare();
        dPart = new PackagedPart();
        dPart.item = dItem;
        dPart.next = null;
        PackagedPart endPart = dPart;
        while (!this.isKeySame(this.nextToken, 20)) {
            dItem = this.parseBasicDeclare();
            PackagedPart newpart = new PackagedPart();
            newpart.item = dItem;
            newpart.next = null;
            endPart.next = newpart;
            endPart = newpart;
        }
        return dPart;
    }

    private Statements parseSetOfStatements() throws ParseException {
        Statements statements = null;
        Statements endState = null;
        while (!this.isKeySame(this.nextToken, 20)) {
            int type = 0;
            Object pointer = null;
            if (!this.isKeySame(this.nextToken, 11)) {
                if (this.isKeySame(this.nextToken, 38)) {
                    type = 6;
                    pointer = null;
                    this.getNextToken();
                    if (this.nextToken.token != 11) {
                        this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
                    }
                    this.getNextToken();
                } else if (this.nextToken.token == 25 && this.nextToken.next != null && this.nextToken.next.token == 10) {
                    TokenList label = this.nextToken;
                    this.getNextToken();
                    this.getNextToken();
                    if (this.isKeySame(this.nextToken, 27)) {
                        type = 1;
                        pointer = this.parseGenerate(label, 1);
                    } else if (this.isKeySame(this.nextToken, 23)) {
                        type = 1;
                        pointer = this.parseGenerate(label, 0);
                    } else {
                        this.nextToken = label;
                        type = 5;
                        pointer = this.parseInstance();
                    }
                }
            }
            if (type != 0) {
                Statements newState = new Statements();
                newState.type = type;
                newState.pointer = pointer;
                newState.next = null;
                if (endState == null) {
                    statements = endState = newState;
                    continue;
                }
                endState.next = newState;
                endState = newState;
                continue;
            }
            this.reportErrorMsg(this.nextToken, "Invalid ARCHITECTURAL statement");
            this.nextToken = this.nextToken.next;
            break;
        }
        return statements;
    }

    private VInstance parseInstance() throws ParseException {
        VInstance inst = null;
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
            this.getNextToken();
            return inst;
        }
        TokenList name = this.nextToken;
        this.getNextToken();
        if (this.nextToken.token == 10) {
            this.getNextToken();
        } else {
            this.nextToken = name;
            name = null;
        }
        SimpleName entity = this.parseSimpleName();
        if (this.isKeySame(this.nextToken, 44)) {
            this.getNextToken();
        } else {
            this.reportErrorMsg(this.nextToken, "Expecting keyword PORT");
        }
        if (this.isKeySame(this.nextToken, 67)) {
            this.getNextToken();
        } else {
            this.reportErrorMsg(this.nextToken, "Expecting keyword MAP");
        }
        if (this.nextToken.token != 2) {
            this.reportErrorMsg(this.nextToken, "Expecting a left bracket");
        }
        this.getNextToken();
        APortList ports = this.parseActualPortList();
        if (this.nextToken.token != 3) {
            this.reportErrorMsg(this.nextToken, "Expecting a right bracket");
        }
        this.getNextToken();
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.getNextToken();
        inst = new VInstance();
        inst.name = name;
        inst.entity = entity;
        inst.ports = ports;
        return inst;
    }

    private APortList parseActualPortList() throws ParseException {
        APortList lastPort = null;
        APortList apList = new APortList();
        apList.type = 1;
        if (this.nextToken.token != 6 && this.nextToken.token != 3) {
            if (this.isKeySame(this.nextToken, 66)) {
                apList.pointer = null;
                this.getNextToken();
            } else {
                apList.pointer = this.parseName();
                if (this.nextToken.token == 16) {
                    this.getNextToken();
                    apList.pointer = this.parseName();
                }
            }
        } else {
            this.reportErrorMsg(this.nextToken, "No identifier in port list");
        }
        apList.next = null;
        lastPort = apList;
        while (this.nextToken.token == 6) {
            this.getNextToken();
            APortList newPort = new APortList();
            newPort.type = 1;
            if (this.nextToken.token != 6 && this.nextToken.token != 3) {
                if (this.isKeySame(this.nextToken, 66)) {
                    newPort.pointer = null;
                    this.getNextToken();
                } else {
                    newPort.pointer = this.parseName();
                    if (this.nextToken.token == 16) {
                        this.getNextToken();
                        newPort.pointer = this.parseName();
                    }
                }
            } else {
                this.reportErrorMsg(this.nextToken, "No identifier in port list");
            }
            newPort.next = null;
            lastPort.next = newPort;
            lastPort = newPort;
        }
        return apList;
    }

    private Generate parseGenerate(TokenList label, int gScheme) throws ParseException {
        Generate gen = null;
        if (gScheme == 0) {
            if (!this.isKeySame(this.nextToken, 23)) {
                this.reportErrorMsg(this.nextToken, "Expecting keyword FOR");
            }
        } else if (!this.isKeySame(this.nextToken, 27)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword IF");
        }
        GenScheme scheme = new GenScheme();
        scheme.scheme = gScheme == 0 ? 0 : 1;
        scheme.identifier = null;
        scheme.range = null;
        scheme.condition = null;
        this.getNextToken();
        if (gScheme == 0) {
            if (this.nextToken.token != 25) {
                this.reportErrorMsg(this.nextToken, "Expecting an identifier");
            } else {
                scheme.identifier = this.nextToken;
            }
            this.getNextToken();
            if (!this.isKeySame(this.nextToken, 28)) {
                this.reportErrorMsg(this.nextToken, "Expecting keyword IN");
            }
            this.getNextToken();
            scheme.range = this.parseDiscreteRange();
        } else {
            scheme.condition = this.parseExpression();
        }
        if (!this.isKeySame(this.nextToken, 25)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword GENERATE");
        }
        this.getNextToken();
        Statements states = this.parseSetOfStatements();
        if (!this.isKeySame(this.nextToken, 20)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword END");
        }
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 25)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword GENERATE");
        }
        this.getNextToken();
        if (label != null && this.nextToken.token == 25) {
            if (!label.pointer.equals(this.nextToken.pointer)) {
                this.reportErrorMsg(this.nextToken, "Label mismatch");
            }
            this.getNextToken();
        }
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.getNextToken();
        gen = new Generate();
        gen.label = label;
        gen.genScheme = scheme;
        gen.statements = states;
        return gen;
    }

    private BodyDeclare parseBodyDeclare() throws ParseException {
        BodyDeclare body = null;
        BodyDeclare endBody = null;
        Object pointer = null;
        int type = 0;
        while (!this.isKeySame(this.nextToken, 9)) {
            if (this.isKeySame(this.nextToken, 12)) {
                type = 2;
                pointer = this.parseComponent();
            } else if (this.isKeySame(this.nextToken, 49)) {
                type = 3;
                pointer = null;
                this.getNextToken();
            } else if (this.isKeySame(this.nextToken, 24)) {
                type = 4;
                pointer = null;
                this.getNextToken();
            } else {
                type = 1;
                pointer = this.parseBasicDeclare();
            }
            BodyDeclare newBody = new BodyDeclare();
            newBody.type = type;
            newBody.pointer = pointer;
            newBody.next = null;
            if (endBody == null) {
                body = endBody = newBody;
                continue;
            }
            endBody.next = newBody;
            endBody = newBody;
        }
        return body;
    }

    private BasicDeclare parseBasicDeclare() throws ParseException {
        BasicDeclare basic = null;
        int type = 0;
        Object pointer = null;
        if (this.isKeySame(this.nextToken, 58)) {
            type = 2;
            pointer = this.parseType();
        } else {
            type = 1;
            pointer = this.parseObjectDeclare();
        }
        if (type != 0) {
            basic = new BasicDeclare();
            basic.type = type;
            basic.pointer = pointer;
        } else {
            this.getNextToken();
        }
        return basic;
    }

    private Type parseType() throws ParseException {
        Type type = null;
        if (!this.isKeySame(this.nextToken, 58)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword TYPE");
            this.getNextToken();
            return type;
        }
        this.getNextToken();
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
            this.getNextToken();
            return type;
        }
        TokenList ident = this.nextToken;
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 30)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword IS");
            this.getNextToken();
            return type;
        }
        this.getNextToken();
        Composite pointer = null;
        int typeDefine = 0;
        if (this.isKeySame(this.nextToken, 5)) {
            typeDefine = 2;
            pointer = this.parseCompositeType();
        } else if (this.isKeySame(this.nextToken, 46)) {
            typeDefine = 2;
            pointer = this.parseCompositeType();
        } else if (this.isKeySame(this.nextToken, 45)) {
            typeDefine = 1;
            pointer = null;
        } else if (this.nextToken.token == 2) {
            typeDefine = 1;
            pointer = null;
        } else {
            this.reportErrorMsg(this.nextToken, "Invalid type definition");
            this.getNextToken();
            return type;
        }
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
            this.getNextToken();
            return type;
        }
        this.getNextToken();
        type = new Type();
        type.identifier = ident;
        type.type = typeDefine;
        type.pointer = pointer;
        return type;
    }

    private Composite parseCompositeType() throws ParseException {
        Composite compo = null;
        Array pointer = null;
        int type = 0;
        if (this.isKeySame(this.nextToken, 5)) {
            type = 1;
            pointer = this.parseArrayType();
        } else if (this.isKeySame(this.nextToken, 46)) {
            type = 2;
            pointer = null;
        } else {
            this.reportErrorMsg(this.nextToken, "Invalid composite type");
            this.getNextToken();
            return compo;
        }
        compo = new Composite();
        compo.type = type;
        compo.pointer = pointer;
        return compo;
    }

    private Array parseArrayType() throws ParseException {
        Array array = null;
        if (!this.isKeySame(this.nextToken, 5)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword ARRAY");
            this.getNextToken();
            return array;
        }
        this.getNextToken();
        if (this.nextToken.token != 2) {
            this.reportErrorMsg(this.nextToken, "Expecting a left bracket");
            this.getNextToken();
            return array;
        }
        this.getNextToken();
        IndexConstraint iConstraint = new IndexConstraint();
        iConstraint.discrete = this.parseDiscreteRange();
        iConstraint.next = null;
        IndexConstraint endconstraint = iConstraint;
        while (this.nextToken.token == 6) {
            this.getNextToken();
            IndexConstraint newConstraint = new IndexConstraint();
            newConstraint.discrete = this.parseDiscreteRange();
            newConstraint.next = null;
            endconstraint.next = newConstraint;
            endconstraint = newConstraint;
        }
        if (this.nextToken.token != 3) {
            this.reportErrorMsg(this.nextToken, "Expecting a right bracket");
            this.getNextToken();
            return array;
        }
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 39)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword OF");
            this.getNextToken();
            return array;
        }
        this.getNextToken();
        SubTypeInd subType = this.parseSubtypeIndication();
        array = new Array();
        array.type = 2;
        Constrained constr = new Constrained();
        array.pointer = constr;
        constr.constraint = iConstraint;
        constr.subType = subType;
        return array;
    }

    private DiscreteRange parseDiscreteRange() throws ParseException {
        DiscreteRange dRange = new DiscreteRange();
        dRange.type = 2;
        dRange.pointer = this.parseRange();
        return dRange;
    }

    private Range parseRange() throws ParseException {
        Range range2 = new Range();
        range2.type = 2;
        range2.pointer = this.parseRangeSimple();
        return range2;
    }

    private RangeSimple parseRangeSimple() throws ParseException {
        RangeSimple sRange = new RangeSimple();
        sRange.start = this.parseSimpleExpression();
        if (this.isKeySame(this.nextToken, 57) || this.isKeySame(this.nextToken, 17)) {
            this.getNextToken();
        } else {
            this.reportErrorMsg(this.nextToken, "Expecting keyword TO or DOWNTO");
            this.getNextToken();
        }
        sRange.end = this.parseSimpleExpression();
        return sRange;
    }

    private ObjectDeclare parseObjectDeclare() throws ParseException {
        ObjectDeclare object = null;
        int type = 0;
        Object pointer = null;
        if (this.isKeySame(this.nextToken, 14)) {
            type = 1;
            pointer = this.parseConstantDeclare();
        } else if (this.isKeySame(this.nextToken, 52)) {
            type = 2;
            pointer = this.parseSignalDeclare();
        } else if (!this.isKeySame(this.nextToken, 61) && !this.isKeySame(this.nextToken, 2)) {
            this.reportErrorMsg(this.nextToken, "Invalid object declaration");
        }
        if (type != 0) {
            object = new ObjectDeclare();
            object.type = type;
            object.pointer = pointer;
        } else {
            this.getNextToken();
        }
        return object;
    }

    private ConstantDeclare parseConstantDeclare() throws ParseException {
        ConstantDeclare constant = null;
        this.getNextToken();
        TokenList ident = null;
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
        } else {
            ident = this.nextToken;
        }
        this.getNextToken();
        if (this.nextToken.token != 10) {
            this.reportErrorMsg(this.nextToken, "Expecting a colon");
        }
        this.getNextToken();
        SubTypeInd ind = this.parseSubtypeIndication();
        if (this.nextToken.token != 19) {
            this.reportErrorMsg(this.nextToken, "Expecting variable assignment symbol");
        }
        this.getNextToken();
        Expression expr = this.parseExpression();
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.getNextToken();
        constant = new ConstantDeclare();
        constant.identifier = ident;
        constant.subType = ind;
        constant.expression = expr;
        return constant;
    }

    private SignalDeclare parseSignalDeclare() throws ParseException {
        this.getNextToken();
        IdentList signalList = this.parseIdentList();
        if (this.nextToken.token != 10) {
            this.reportErrorMsg(this.nextToken, "Expecting a colon");
        }
        this.getNextToken();
        SubTypeInd ind = this.parseSubtypeIndication();
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.getNextToken();
        SignalDeclare signal = new SignalDeclare();
        signal.names = signalList;
        signal.subType = ind;
        return signal;
    }

    private SubTypeInd parseSubtypeIndication() throws ParseException {
        VName type = this.parseName();
        SubTypeInd ind = new SubTypeInd();
        ind.type = type;
        return ind;
    }

    private VComponent parseComponent() throws ParseException {
        VComponent compo = null;
        this.getNextToken();
        TokenList entity = null;
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
        } else {
            entity = this.nextToken;
        }
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 44)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword PORT");
        } else {
            this.getNextToken();
        }
        if (this.nextToken.token != 2) {
            this.reportErrorMsg(this.nextToken, "Expecting a left bracket");
        }
        this.getNextToken();
        FPortList ports = this.parseFormalPortList();
        if (this.nextToken.token != 3) {
            this.reportErrorMsg(this.nextToken, "Expecting a right bracket");
        }
        this.getNextToken();
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 20)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword END");
        }
        this.getNextToken();
        if (!this.isKeySame(this.nextToken, 12)) {
            this.reportErrorMsg(this.nextToken, "Expecting keyword COMPONENT");
        }
        this.getNextToken();
        if (this.nextToken.token != 11) {
            this.reportErrorMsg(this.nextToken, "Expecting a semicolon");
        }
        this.getNextToken();
        compo = new VComponent();
        compo.name = entity;
        compo.ports = ports;
        return compo;
    }

    private FPortList parseFormalPortList() throws ParseException {
        IdentList iList = this.parseIdentList();
        if (iList == null) {
            return null;
        }
        if (this.nextToken.token != 10) {
            this.reportErrorMsg(this.nextToken, "Expecting a colon");
            return null;
        }
        this.getNextToken();
        int mode = this.parsePortMode();
        VName type = this.parseName();
        FPortList ports = new FPortList();
        ports.names = iList;
        ports.mode = mode;
        ports.type = type;
        ports.next = null;
        FPortList endPort = ports;
        while (this.nextToken.token == 11) {
            this.getNextToken();
            iList = this.parseIdentList();
            if (iList == null) {
                return null;
            }
            if (this.nextToken.token != 10) {
                this.reportErrorMsg(this.nextToken, "Expecting a colon");
                return null;
            }
            this.getNextToken();
            mode = this.parsePortMode();
            type = this.parseName();
            FPortList newPort = new FPortList();
            newPort.names = iList;
            newPort.mode = mode;
            newPort.type = type;
            newPort.next = null;
            endPort.next = newPort;
            endPort = newPort;
        }
        return ports;
    }

    private int parsePortMode() throws ParseException {
        int mode = 1;
        if (this.nextToken.token == 26) {
            switch (((VKeyword)this.nextToken.pointer).num) {
                case 28: {
                    this.getNextToken();
                    break;
                }
                case 42: {
                    mode = 2;
                    this.getNextToken();
                    break;
                }
                case 29: {
                    mode = 4;
                    this.getNextToken();
                    break;
                }
                case 31: {
                    mode = 5;
                    this.getNextToken();
                    break;
                }
            }
        }
        return mode;
    }

    private VName parseName() throws ParseException {
        int type = 0;
        Object pointer = this.parseSingleName();
        switch (this.nextToken.token) {
            case 0: {
                type = 2;
                ConcatenatedName concat2 = new ConcatenatedName();
                concat2.name = pointer;
                concat2.next = null;
                pointer = concat2;
                while (this.nextToken.token == 0) {
                    ConcatenatedName concat22;
                    this.getNextToken();
                    SingleName pointer2 = this.parseSingleName();
                    concat2.next = concat22 = new ConcatenatedName();
                    concat22.name = pointer2;
                    concat22.next = null;
                    concat2 = concat22;
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                type = 1;
            }
        }
        VName name = null;
        if (type != 0) {
            name = new VName();
            name.type = type;
            name.pointer = pointer;
        } else {
            this.getNextToken();
        }
        return name;
    }

    private SingleName parseSingleName() throws ParseException {
        int type = 0;
        SingleName sName = null;
        Object pointer = this.parseSimpleName();
        if (this.nextToken.last.space) {
            type = 1;
        } else {
            switch (this.nextToken.token) {
                case 8: {
                    break;
                }
                case 2: {
                    this.getNextToken();
                    type = 3;
                    VName nPtr = new VName();
                    nPtr.type = 1;
                    SingleName sName2 = new SingleName();
                    nPtr.pointer = sName2;
                    sName2.type = 1;
                    sName2.pointer = pointer;
                    pointer = this.parseIndexedName(1, nPtr);
                    if (this.nextToken.token != 3) {
                        this.reportErrorMsg(this.nextToken, "Expecting a right bracket");
                    }
                    this.getNextToken();
                    break;
                }
                default: {
                    type = 1;
                }
            }
        }
        if (type != 0) {
            sName = new SingleName();
            sName.type = type;
            sName.pointer = pointer;
        } else {
            this.getNextToken();
        }
        return sName;
    }

    private SimpleName parseSimpleName() throws ParseException {
        SimpleName sName = null;
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
            this.getNextToken();
            return sName;
        }
        sName = new SimpleName();
        sName.identifier = this.nextToken;
        this.getNextToken();
        return sName;
    }

    private IndexedName parseIndexedName(int preType, VName prePtr) throws ParseException {
        Prefix prefix = new Prefix();
        prefix.type = preType;
        prefix.pointer = prePtr;
        IndexedName ind = new IndexedName();
        ind.prefix = prefix;
        ind.exprList = new ExprList();
        ind.exprList.expression = this.parseExpression();
        ind.exprList.next = null;
        ExprList eList = ind.exprList;
        if (this.isKeySame(this.nextToken, 57)) {
            this.getNextToken();
            eList.direction = 1;
            eList.expressionRangeEnd = this.parseExpression();
        } else if (this.isKeySame(this.nextToken, 17)) {
            this.getNextToken();
            eList.direction = -1;
            eList.expressionRangeEnd = this.parseExpression();
        }
        while (this.nextToken.token == 6) {
            this.getNextToken();
            ExprList newEList = new ExprList();
            newEList.expression = this.parseExpression();
            newEList.next = null;
            eList.next = newEList;
            eList = newEList;
            if (this.isKeySame(this.nextToken, 57)) {
                this.getNextToken();
                eList.direction = 1;
                eList.expressionRangeEnd = this.parseExpression();
                continue;
            }
            if (!this.isKeySame(this.nextToken, 17)) continue;
            this.getNextToken();
            eList.direction = 1;
            eList.expressionRangeEnd = this.parseExpression();
        }
        return ind;
    }

    private Expression parseExpression() throws ParseException {
        Expression exp = new Expression();
        exp.relation = this.parseRelation();
        exp.next = null;
        int key = 0;
        int logOp = 0;
        if (this.nextToken.token == 26) {
            key = ((VKeyword)this.nextToken.pointer).num;
            switch (key) {
                case 3: {
                    logOp = 1;
                    break;
                }
                case 40: {
                    logOp = 2;
                    break;
                }
                case 34: {
                    logOp = 3;
                    break;
                }
                case 36: {
                    logOp = 4;
                    break;
                }
                case 65: {
                    logOp = 5;
                    break;
                }
            }
        }
        if (logOp != 0) {
            exp.next = this.parseMoreRelations(key, logOp);
        }
        return exp;
    }

    private Relation parseRelation() throws ParseException {
        int relOp = 0;
        Relation relation = new Relation();
        relation.simpleExpr = this.parseSimpleExpression();
        relation.relOperator = 0;
        relation.simpleExpr2 = null;
        switch (this.nextToken.token) {
            case 13: {
                relOp = 1;
                break;
            }
            case 20: {
                relOp = 2;
                break;
            }
            case 12: {
                relOp = 3;
                break;
            }
            case 22: {
                relOp = 4;
                break;
            }
            case 14: {
                relOp = 5;
                break;
            }
            case 21: {
                relOp = 6;
            }
        }
        if (relOp != 0) {
            relation.relOperator = relOp;
            this.getNextToken();
            relation.simpleExpr2 = this.parseSimpleExpression();
        }
        return relation;
    }

    private MRelations parseMoreRelations(int key, int logOp) throws ParseException {
        MRelations more = null;
        if (this.isKeySame(this.nextToken, key)) {
            this.getNextToken();
            more = new MRelations();
            more.logOperator = logOp;
            more.relation = this.parseRelation();
            more.next = this.parseMoreRelations(key, logOp);
        }
        return more;
    }

    private SimpleExpr parseSimpleExpression() throws ParseException {
        SimpleExpr exp = new SimpleExpr();
        if (this.nextToken.token == 5) {
            exp.sign = 1;
            this.getNextToken();
        } else if (this.nextToken.token == 7) {
            exp.sign = -1;
            this.getNextToken();
        } else {
            exp.sign = 1;
        }
        exp.term = this.parseTerm();
        exp.next = this.parseMoreTerms();
        return exp;
    }

    private Term parseTerm() throws ParseException {
        Term term = new Term();
        term.factor = this.parseFactor();
        term.next = this.parseMoreFactors();
        return term;
    }

    private MFactors parseMoreFactors() throws ParseException {
        MFactors more = null;
        int mulOp = 0;
        if (this.nextToken.token == 4) {
            mulOp = 1;
        } else if (this.nextToken.token == 9) {
            mulOp = 2;
        } else if (this.isKeySame(this.nextToken, 33)) {
            mulOp = 3;
        } else if (this.isKeySame(this.nextToken, 47)) {
            mulOp = 4;
        }
        if (mulOp != 0) {
            this.getNextToken();
            more = new MFactors();
            more.mulOperator = mulOp;
            more.factor = this.parseFactor();
            more.next = this.parseMoreFactors();
        }
        return more;
    }

    private Factor parseFactor() throws ParseException {
        Factor factor = null;
        Primary primary = null;
        Primary primary2 = null;
        int miscOp = 0;
        if (this.isKeySame(this.nextToken, 0)) {
            miscOp = 2;
            this.getNextToken();
            primary = this.parsePrimary();
        } else if (this.isKeySame(this.nextToken, 37)) {
            miscOp = 3;
            this.getNextToken();
            primary = this.parsePrimary();
        } else {
            primary = this.parsePrimary();
            if (this.nextToken.token == 18) {
                miscOp = 1;
                this.getNextToken();
                primary2 = this.parsePrimary();
            }
        }
        factor = new Factor();
        factor.primary = primary;
        factor.miscOperator = miscOp;
        factor.primary2 = primary2;
        return factor;
    }

    private Primary parsePrimary() throws ParseException {
        int type = 0;
        Object pointer = null;
        Primary primary = null;
        switch (this.nextToken.token) {
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                type = 2;
                pointer = this.parseLiteral();
                break;
            }
            case 25: {
                type = 1;
                pointer = this.parseName();
                break;
            }
            case 2: {
                this.getNextToken();
                type = 8;
                pointer = this.parseExpression();
                if (this.nextToken.token != 3) {
                    this.reportErrorMsg(this.nextToken, "Expecting a right bracket");
                }
                this.getNextToken();
                break;
            }
        }
        if (type != 0) {
            primary = new Primary();
            primary.type = type;
            primary.pointer = pointer;
        }
        return primary;
    }

    private Literal parseLiteral() throws ParseException {
        Literal literal = null;
        Integer pointer = null;
        int type = 0;
        switch (this.nextToken.token) {
            case 27: {
                type = 1;
                pointer = this.parseDecimal();
                break;
            }
            case 28: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
        }
        if (type != 0) {
            literal = new Literal();
            literal.type = type;
            literal.pointer = pointer;
        }
        return literal;
    }

    private Integer parseDecimal() throws ParseException {
        int value = TextUtils.atoi((String)this.nextToken.pointer);
        this.getNextToken();
        return new Integer(value);
    }

    private MTerms parseMoreTerms() throws ParseException {
        MTerms more = null;
        int addOp = 0;
        if (this.nextToken.token == 5) {
            addOp = 1;
        } else if (this.nextToken.token == 7) {
            addOp = 2;
        }
        if (addOp != 0) {
            this.getNextToken();
            more = new MTerms();
            more.addOperator = addOp;
            more.term = this.parseTerm();
            more.next = this.parseMoreTerms();
        }
        return more;
    }

    private IdentList parseIdentList() throws ParseException {
        if (this.nextToken.token != 25) {
            this.reportErrorMsg(this.nextToken, "Expecting an identifier");
            this.getNextToken();
            return null;
        }
        IdentList newIList = new IdentList();
        newIList.identifier = this.nextToken;
        newIList.next = null;
        IdentList iList = newIList;
        IdentList iListEnd = newIList;
        this.getNextToken();
        while (this.nextToken.token == 6) {
            this.getNextToken();
            if (this.nextToken.token != 25) {
                this.reportErrorMsg(this.nextToken, "Expecting an identifier");
                this.getNextToken();
                return null;
            }
            newIList = new IdentList();
            newIList.identifier = this.nextToken;
            newIList.next = null;
            iListEnd.next = newIList;
            iListEnd = newIList;
            this.getNextToken();
        }
        return iList;
    }

    private void parseToSemicolon() throws ParseException {
        do {
            this.getNextToken();
        } while (this.nextToken.token != 11);
        this.getNextToken();
    }

    private void getNextToken() throws ParseException {
        if (this.nextToken.next == null) {
            this.reportErrorMsg(this.nextToken, "Unexpected termination within block");
            throw new ParseException();
        }
        this.nextToken = this.nextToken.next;
    }

    private boolean isKeySame(TokenList tokenPtr, int key) {
        if (tokenPtr.token != 26) {
            return false;
        }
        return ((VKeyword)tokenPtr.pointer).num == key;
    }

    private void reportErrorMsg(TokenList tList, String errMsg) {
        int i;
        this.hasError = true;
        ++this.errorCount;
        if (this.errorCount == 30) {
            System.out.println("TOO MANY ERRORS...PRINTING NO MORE");
        }
        if (this.errorCount >= 30) {
            return;
        }
        if (tList == null) {
            System.out.println("ERROR " + errMsg);
            return;
        }
        System.out.println("ERROR on line " + tList.lineNum + ", " + errMsg + ":");
        TokenList tStart = tList;
        while (tStart.last != null && tStart.last.lineNum == tList.lineNum) {
            tStart = tStart.last;
        }
        int pointer = 0;
        StringBuffer buffer = new StringBuffer();
        while (tStart != null && tStart.lineNum == tList.lineNum) {
            i = buffer.length();
            if (tStart == tList) {
                pointer = i;
            }
            if (tStart.token < 16) {
                char chr = delimiterStr.charAt(tStart.token);
                buffer.append(chr);
            } else if (tStart.token < 24) {
                int start = 2 * (tStart.token - 16);
                buffer.append(doubleDelimiterStr.substring(start, start + 2));
            } else {
                switch (tStart.token) {
                    case 30: {
                        buffer.append("\"" + tStart.pointer + "\" ");
                        break;
                    }
                    case 26: {
                        buffer.append(((VKeyword)tStart.pointer).name);
                        break;
                    }
                    case 25: {
                        buffer.append(tStart.pointer);
                        break;
                    }
                    case 29: {
                        buffer.append(((Character)tStart.pointer).charValue());
                    }
                    case 27: {
                        buffer.append(tStart.pointer);
                        break;
                    }
                    default: {
                        if (tStart.pointer == null) break;
                        buffer.append(tStart.pointer);
                    }
                }
            }
            if (tStart.space) {
                buffer.append(" ");
            }
            tStart = tStart.next;
        }
        System.out.println(buffer.toString());
        buffer = new StringBuffer();
        for (i = 0; i < pointer; ++i) {
            buffer.append(" ");
        }
        System.out.println(buffer.toString() + "^");
    }

    private boolean doSemantic() {
        this.hasError = false;
        this.theUnits = new DBUnits();
        this.theUnits.interfaces = null;
        DBInterface endInterface = null;
        this.theUnits.bodies = null;
        DBBody endBody = null;
        this.localSymbols = this.pushSymbols(null);
        this.globalSymbols = this.pushSymbols(null);
        this.createDefaultType(this.localSymbols);
        SymbolList sSymbols = this.localSymbols;
        this.localSymbols = this.pushSymbols(this.localSymbols);
        PTree unit = this.pTree;
        while (unit != null) {
            switch (unit.type) {
                case 1: {
                    DBInterface interfacef = this.semInterface((VInterface)unit.pointer);
                    if (interfacef == null) break;
                    if (endInterface == null) {
                        this.theUnits.interfaces = endInterface = interfacef;
                    } else {
                        endInterface.next = interfacef;
                        endInterface = interfacef;
                    }
                    this.localSymbols = this.pushSymbols(sSymbols);
                    break;
                }
                case 4: {
                    DBBody body = this.semBody((Body)unit.pointer);
                    if (endBody == null) {
                        this.theUnits.bodies = endBody = body;
                    } else {
                        endBody.next = body;
                        endBody = body;
                    }
                    this.localSymbols = this.pushSymbols(sSymbols);
                    break;
                }
                case 3: {
                    this.semPackage((Package)unit.pointer);
                    break;
                }
                case 6: {
                    this.semUse((Use)unit.pointer);
                    break;
                }
            }
            unit = unit.next;
        }
        return this.hasError;
    }

    private void semUse(Use use) {
        while (use != null) {
            SymbolTree symbol = this.searchSymbol((String)use.unit.pointer, this.globalSymbols);
            if (symbol != null) {
                if (symbol.type != 10) {
                    this.reportErrorMsg(use.unit, "Symbol is not a PACKAGE");
                } else {
                    this.addSymbol(symbol.value, 10, symbol.pointer, this.localSymbols);
                }
                symbol = this.searchSymbol((String)use.unit.pointer, this.globalSymbols);
                if (symbol == null) {
                    this.reportErrorMsg(use.unit, "Symbol is undefined");
                } else if (symbol.type != 10) {
                    this.reportErrorMsg(use.unit, "Symbol is not a PACKAGE");
                } else {
                    SymbolList newSymList = ((DBPackage)symbol.pointer).root;
                    newSymList.last = this.localSymbols;
                    this.localSymbols = newSymList;
                }
            }
            use = use.next;
        }
    }

    private void semPackage(Package vPackage) {
        if (vPackage == null) {
            return;
        }
        DBPackage dbPackage = null;
        if (this.searchSymbol((String)vPackage.name.pointer, this.globalSymbols) != null) {
            this.reportErrorMsg(vPackage.name, "Symbol previously defined");
        } else {
            dbPackage = new DBPackage();
            dbPackage.name = (String)vPackage.name.pointer;
            dbPackage.root = null;
            this.addSymbol(dbPackage.name, 10, dbPackage, this.globalSymbols);
        }
        this.localSymbols = this.pushSymbols(this.localSymbols);
        PackagedPart part = vPackage.declare;
        while (part != null) {
            this.semBasicDeclare(part.item);
            part = part.next;
        }
        if (dbPackage != null) {
            dbPackage.root = this.localSymbols;
        }
        this.localSymbols = this.popSymbols(this.localSymbols);
    }

    private DBBody semBody(Body body) {
        DBBody dbBody = null;
        if (body == null) {
            return dbBody;
        }
        if (this.searchSymbol((String)body.name.pointer, this.globalSymbols) != null) {
            this.reportErrorMsg(body.name, "Body previously defined");
            return dbBody;
        }
        dbBody = new DBBody();
        dbBody.name = (String)body.name.pointer;
        dbBody.entity = null;
        dbBody.declare = null;
        dbBody.statements = null;
        dbBody.parent = null;
        dbBody.sameParent = null;
        dbBody.next = null;
        this.addSymbol(dbBody.name, 2, dbBody, this.globalSymbols);
        SymbolTree symbol = this.searchSymbol((String)body.entity.identifier.pointer, this.globalSymbols);
        if (symbol == null) {
            this.reportErrorMsg(body.entity.identifier, "Reference to undefined entity");
            return dbBody;
        }
        if (symbol.type != 1) {
            this.reportErrorMsg(body.entity.identifier, "Symbol is not an entity");
            return dbBody;
        }
        dbBody.entity = symbol.value;
        dbBody.parent = (DBInterface)symbol.pointer;
        if (symbol.pointer != null) {
            dbBody.sameParent = ((DBInterface)symbol.pointer).bodies;
            ((DBInterface)symbol.pointer).bodies = dbBody;
        }
        SymbolList tempSymbols = this.localSymbols;
        SymbolList endSymbol = this.localSymbols;
        if (symbol.pointer != null) {
            while (endSymbol.last != null) {
                endSymbol = endSymbol.last;
            }
            endSymbol.last = ((DBInterface)symbol.pointer).symbols;
        }
        this.localSymbols = this.pushSymbols(this.localSymbols);
        this.instanceSymbols = this.pushSymbols(this.instanceSymbols);
        dbBody.declare = this.semBodyDeclare(body.bodyDeclare);
        dbBody.statements = this.semSetOfStatements(body.statements);
        this.localSymbols = tempSymbols;
        this.instanceSymbols = this.popSymbols(this.instanceSymbols);
        endSymbol.last = null;
        return dbBody;
    }

    private DBStatements semSetOfStatements(Statements state) {
        if (state == null) {
            return null;
        }
        DBStatements dbStates = new DBStatements();
        dbStates.instances = null;
        DBInstance endInstance = null;
        while (state != null) {
            switch (state.type) {
                case 5: {
                    DBInstance newInstance = this.semInstance((VInstance)state.pointer);
                    if (endInstance == null) {
                        dbStates.instances = endInstance = newInstance;
                        break;
                    }
                    endInstance.next = newInstance;
                    endInstance = newInstance;
                    break;
                }
                case 1: {
                    DBStatements newState = this.semGenerate((Generate)state.pointer);
                    if (newState == null) break;
                    DBInstance newInstance = newState.instances;
                    while (newInstance != null) {
                        if (endInstance == null) {
                            dbStates.instances = endInstance = newInstance;
                        } else {
                            endInstance.next = newInstance;
                            endInstance = newInstance;
                        }
                        newInstance = newInstance.next;
                    }
                    break;
                }
            }
            state = state.next;
        }
        return dbStates;
    }

    private DBStatements semGenerate(Generate gen) {
        GenScheme scheme;
        DBStatements dbStates = null;
        if (gen == null) {
            return dbStates;
        }
        if (gen.label != null && this.forLoopLevel == 0) {
            if (this.searchSymbol((String)gen.label.pointer, this.localSymbols) != null) {
                this.reportErrorMsg(gen.label, "Symbol previously defined");
            } else {
                this.addSymbol((String)gen.label.pointer, 9, null, this.localSymbols);
            }
        }
        if ((scheme = gen.genScheme) == null) {
            return dbStates;
        }
        switch (scheme.scheme) {
            case 0: {
                this.forLoopTags[++this.forLoopLevel] = 0;
                this.localSymbols = this.pushSymbols(this.localSymbols);
                SymbolTree symbol = this.addSymbol((String)scheme.identifier.pointer, 8, null, this.localSymbols);
                DBDiscreteRange dRange = this.semDiscreteRange(scheme.range);
                if (dRange.start > dRange.end) {
                    int temp = dRange.end;
                    dRange.end = dRange.start;
                    dRange.start = temp;
                }
                DBStatements oldStates = null;
                DBInstance endInst = null;
                for (int temp = dRange.start; temp <= dRange.end; ++temp) {
                    symbol.pointer = new Integer(temp);
                    dbStates = this.semSetOfStatements(gen.statements);
                    int n = this.forLoopLevel;
                    this.forLoopTags[n] = this.forLoopTags[n] + 1;
                    if (dbStates == null) continue;
                    if (oldStates == null) {
                        oldStates = dbStates;
                        endInst = dbStates.instances;
                        if (endInst == null) continue;
                        while (endInst.next != null) {
                            endInst = endInst.next;
                        }
                        continue;
                    }
                    DBInstance inst = dbStates.instances;
                    while (inst != null) {
                        if (endInst == null) {
                            oldStates.instances = endInst = inst;
                        } else {
                            endInst.next = inst;
                            endInst = inst;
                        }
                        inst = inst.next;
                    }
                }
                dbStates = oldStates;
                this.localSymbols = this.popSymbols(this.localSymbols);
                --this.forLoopLevel;
                break;
            }
            case 1: {
                if (this.evalExpression(scheme.condition) == 0) break;
                dbStates = this.semSetOfStatements(gen.statements);
            }
        }
        return dbStates;
    }

    private DBInstance semInstance(VInstance inst) {
        DBInstance dbInst = null;
        if (inst == null) {
            return dbInst;
        }
        String iKey = null;
        if (this.forLoopLevel > 0) {
            iKey = inst.name == null ? "no_name" : (String)inst.name.pointer;
            for (int i = 1; i <= this.forLoopLevel; ++i) {
                iKey = iKey + "_" + this.forLoopTags[i];
            }
        } else {
            iKey = (String)inst.name.pointer;
        }
        dbInst = new DBInstance();
        dbInst.name = iKey;
        dbInst.compo = null;
        dbInst.ports = null;
        DBAPortList endDBAPort = null;
        dbInst.next = null;
        if (this.searchSymbol(dbInst.name, this.instanceSymbols) != null) {
            this.reportErrorMsg(inst.name, "Instance name previously defined");
        } else {
            this.addSymbol(dbInst.name, 7, dbInst, this.instanceSymbols);
        }
        DBComponents compo = null;
        SymbolTree symbol = this.searchSymbol((String)inst.entity.identifier.pointer, this.localSymbols);
        if (symbol == null) {
            this.reportErrorMsg(inst.entity.identifier, "Instance references undefined component");
        } else if (symbol.type != 5) {
            this.reportErrorMsg(inst.entity.identifier, "Symbol is not a component reference");
        } else {
            dbInst.compo = compo = (DBComponents)symbol.pointer;
            int iPortNum = 0;
            APortList apList = inst.ports;
            while (apList != null) {
                ++iPortNum;
                apList = apList.next;
            }
            int cPortNum = 0;
            DBPortList pList = compo.ports;
            while (pList != null) {
                ++cPortNum;
                pList = pList.next;
            }
            if (iPortNum != cPortNum) {
                this.reportErrorMsg(this.getNameToken((VName)inst.ports.pointer), "Instance has different number of ports than component (instance has " + iPortNum + ", component has " + cPortNum + ")");
                return null;
            }
        }
        DBPortList pList = null;
        if (compo != null) {
            pList = compo.ports;
        }
        APortList apList = inst.ports;
        while (apList != null) {
            DBAPortList dbAPort = new DBAPortList();
            dbAPort.name = null;
            dbAPort.port = pList;
            if (pList != null) {
                pList = pList.next;
            }
            dbAPort.flags = 0;
            dbAPort.next = null;
            if (endDBAPort == null) {
                dbInst.ports = endDBAPort = dbAPort;
            } else {
                endDBAPort.next = dbAPort;
                endDBAPort = dbAPort;
            }
            if (apList.pointer != null) {
                dbAPort.name = this.semName((VName)apList.pointer);
                this.semAPortCheck((VName)apList.pointer);
            }
            apList = apList.next;
        }
        return dbInst;
    }

    private DBName semName(VName name) {
        DBName dbName = null;
        if (name == null) {
            return dbName;
        }
        switch (name.type) {
            case 1: {
                dbName = this.semSingleName((SingleName)name.pointer);
                break;
            }
            case 2: {
                dbName = this.semConcatenatedName((ConcatenatedName)name.pointer);
                break;
            }
        }
        return dbName;
    }

    private DBName semConcatenatedName(ConcatenatedName name) {
        DBName dbName = null;
        if (name == null) {
            return dbName;
        }
        dbName = new DBName();
        dbName.name = null;
        dbName.type = 3;
        dbName.pointer = null;
        dbName.dbType = null;
        DBNameList end = null;
        ConcatenatedName cat2 = name;
        while (cat2 != null) {
            DBNameList newNL = new DBNameList();
            newNL.name = this.semSingleName(cat2.name);
            newNL.next = null;
            if (end != null) {
                end.next = newNL;
                end = newNL;
            } else {
                end = newNL;
                dbName.pointer = newNL;
            }
            cat2 = cat2.next;
        }
        return dbName;
    }

    private DBName semSingleName(SingleName name) {
        DBName dbName = null;
        if (name == null) {
            return dbName;
        }
        switch (name.type) {
            case 1: {
                dbName = new DBName();
                dbName.name = (String)((SimpleName)name.pointer).identifier.pointer;
                dbName.type = 1;
                dbName.pointer = null;
                dbName.dbType = this.getType(dbName.name);
                break;
            }
            case 3: {
                dbName = this.semIndexedName((IndexedName)name.pointer);
                break;
            }
        }
        return dbName;
    }

    private DBName semIndexedName(IndexedName name) {
        DBName dbName = null;
        if (name == null) {
            return dbName;
        }
        DBLType type = this.getType(this.getPrefixIdent(name.prefix));
        if (type == null) {
            this.reportErrorMsg(this.getPrefixToken(name.prefix), "No type specified");
            return dbName;
        }
        if (type.type != 2) {
            this.reportErrorMsg(this.getPrefixToken(name.prefix), "Must be of constrained array type");
            return dbName;
        }
        dbName = new DBName();
        dbName.name = this.getPrefixIdent(name.prefix);
        dbName.type = 2;
        dbName.pointer = null;
        dbName.dbType = type;
        DBIndexRange indexR = (DBIndexRange)type.pointer;
        DBExprList dbExpr = null;
        DBExprList endExpr = null;
        ExprList expr = name.exprList;
        while (expr != null && indexR != null) {
            int value = this.evalExpression(expr.expression);
            if (!this.isInDiscreteRange(value, indexR.dRange)) {
                this.reportErrorMsg(this.getPrefixToken(name.prefix), "Index is out of range");
                return dbName;
            }
            DBExprList nExpr = new DBExprList();
            nExpr.value = value;
            nExpr.next = null;
            if (endExpr == null) {
                dbExpr = endExpr = nExpr;
            } else {
                endExpr.next = nExpr;
                endExpr = nExpr;
            }
            indexR = indexR.next;
            expr = expr.next;
        }
        dbName.pointer = dbExpr;
        return dbName;
    }

    private boolean isInDiscreteRange(int value, DBDiscreteRange discrete) {
        boolean inRange = false;
        if (discrete == null) {
            return inRange;
        }
        int start = discrete.start;
        int end = discrete.end;
        if (start > end) {
            int temp = end;
            end = start;
            start = temp;
        }
        if (value >= start && value <= end) {
            inRange = true;
        }
        return inRange;
    }

    private DBLType getType(String ident) {
        SymbolTree symbol;
        DBLType type = null;
        if (ident != null && (symbol = this.searchSymbol(ident, this.localSymbols)) != null) {
            type = this.getSymbolType(symbol);
        }
        return type;
    }

    private DBLType getSymbolType(SymbolTree symbol) {
        DBLType type = null;
        if (symbol == null) {
            return type;
        }
        switch (symbol.type) {
            case 4: {
                DBPortList fPort = (DBPortList)symbol.pointer;
                if (fPort == null) break;
                type = fPort.type;
                break;
            }
            case 6: {
                DBSignals signal = (DBSignals)symbol.pointer;
                if (signal == null) break;
                type = signal.type;
                break;
            }
            case 3: {
                type = (DBLType)symbol.pointer;
                break;
            }
        }
        return type;
    }

    private void semAPortCheck(VName name) {
        switch (name.type) {
            case 1: {
                this.semAPortCheckSingleName((SingleName)name.pointer);
                break;
            }
            case 2: {
                ConcatenatedName cat2 = (ConcatenatedName)name.pointer;
                while (cat2 != null) {
                    this.semAPortCheckSingleName(cat2.name);
                    cat2 = cat2.next;
                }
                break;
            }
        }
    }

    private void semAPortCheckSingleName(SingleName sName) {
        switch (sName.type) {
            case 1: {
                SimpleName simName = (SimpleName)sName.pointer;
                String ident = (String)simName.identifier.pointer;
                SymbolTree symbol = this.searchSymbol(ident, this.localSymbols);
                if (symbol != null && (symbol.type == 4 || symbol.type == 6)) break;
                this.reportErrorMsg(simName.identifier, "Instance port has reference to unknown port");
                break;
            }
            case 3: {
                IndexedName iName = (IndexedName)sName.pointer;
                String ident = this.getPrefixIdent(iName.prefix);
                SymbolTree symbol = this.searchSymbol(ident, this.localSymbols);
                if (symbol == null) {
                    symbol = this.searchSymbol(ident, this.localSymbols);
                }
                if (symbol != null && (symbol.type == 4 || symbol.type == 6)) break;
                this.reportErrorMsg(this.getPrefixToken(iName.prefix), "Instance port has reference to unknown port");
                break;
            }
        }
    }

    private DBBodyDelcare semBodyDeclare(BodyDeclare declare) {
        DBBodyDelcare dbDeclare = null;
        if (declare == null) {
            return dbDeclare;
        }
        dbDeclare = new DBBodyDelcare();
        dbDeclare.components = null;
        DBComponents endComponent = null;
        dbDeclare.bodySignals = null;
        DBSignals endSignal = null;
        while (declare != null) {
            switch (declare.type) {
                case 1: {
                    DBSignals newSignals = this.semBasicDeclare((BasicDeclare)declare.pointer);
                    if (newSignals == null) break;
                    if (endSignal == null) {
                        dbDeclare.bodySignals = endSignal = newSignals;
                    } else {
                        endSignal.next = newSignals;
                        endSignal = newSignals;
                    }
                    while (endSignal.next != null) {
                        endSignal = endSignal.next;
                    }
                    break;
                }
                case 2: {
                    DBComponents newComponent = this.semComponent((VComponent)declare.pointer);
                    if (newComponent == null) break;
                    if (endComponent == null) {
                        dbDeclare.components = endComponent = newComponent;
                        break;
                    }
                    endComponent.next = newComponent;
                    endComponent = newComponent;
                    break;
                }
            }
            declare = declare.next;
        }
        return dbDeclare;
    }

    private DBComponents semComponent(VComponent compo) {
        DBComponents dbComp = null;
        if (compo == null) {
            return dbComp;
        }
        if (this.searchFSymbol((String)compo.name.pointer, this.localSymbols) != null) {
            this.reportErrorMsg(compo.name, "Identifier previously defined");
            return dbComp;
        }
        dbComp = new DBComponents();
        dbComp.name = (String)compo.name.pointer;
        dbComp.ports = null;
        dbComp.next = null;
        this.addSymbol(dbComp.name, 5, dbComp, this.localSymbols);
        this.localSymbols = this.pushSymbols(this.localSymbols);
        dbComp.ports = this.semFormalPortList(compo.ports);
        this.localSymbols = this.popSymbols(this.localSymbols);
        return dbComp;
    }

    private SymbolList popSymbols(SymbolList oldSymList) {
        if (oldSymList == null) {
            System.out.println("ERROR - trying to pop nonexistant symbol list.");
            return null;
        }
        SymbolList newSymList = oldSymList.last;
        return newSymList;
    }

    private DBSignals semBasicDeclare(BasicDeclare declare) {
        DBSignals dbSignal = null;
        if (declare == null) {
            return dbSignal;
        }
        switch (declare.type) {
            case 1: {
                dbSignal = this.semObjectDeclare((ObjectDeclare)declare.pointer);
                break;
            }
            case 2: {
                this.semTypeDeclare((Type)declare.pointer);
                break;
            }
        }
        return dbSignal;
    }

    private void semTypeDeclare(Type type) {
        DBLType dbType = null;
        if (type == null) {
            return;
        }
        if (this.searchSymbol((String)type.identifier.pointer, this.localSymbols) != null) {
            this.reportErrorMsg(type.identifier, "Identifier previously defined");
            return;
        }
        switch (type.type) {
            case 1: {
                break;
            }
            case 2: {
                dbType = this.semCompositeType((Composite)type.pointer);
                break;
            }
        }
        if (dbType != null) {
            dbType.name = (String)type.identifier.pointer;
            this.addSymbol(dbType.name, 3, dbType, this.localSymbols);
        }
    }

    private DBLType semCompositeType(Composite composite) {
        DBLType dbType = null;
        if (composite == null) {
            return dbType;
        }
        switch (composite.type) {
            case 1: {
                dbType = this.semArrayType((Array)composite.pointer);
                break;
            }
            case 2: {
                break;
            }
        }
        return dbType;
    }

    private DBLType semArrayType(Array array) {
        DBLType dbType = null;
        if (array == null) {
            return dbType;
        }
        switch (array.type) {
            case 1: {
                break;
            }
            case 2: {
                dbType = this.semConstrainedArray((Constrained)array.pointer);
                break;
            }
        }
        return dbType;
    }

    private DBLType semConstrainedArray(Constrained constr) {
        DBLType dbType = null;
        if (constr == null) {
            return dbType;
        }
        dbType = new DBLType();
        dbType.name = null;
        dbType.type = 2;
        DBIndexRange endRange = null;
        dbType.pointer = null;
        dbType.subType = null;
        IndexConstraint indexC = constr.constraint;
        while (indexC != null) {
            DBIndexRange newRange = new DBIndexRange();
            newRange.dRange = this.semDiscreteRange(indexC.discrete);
            newRange.next = null;
            if (endRange == null) {
                endRange = newRange;
                dbType.pointer = newRange;
            } else {
                endRange.next = newRange;
                endRange = newRange;
            }
            indexC = indexC.next;
        }
        dbType.subType = this.semSubtypeIndication(constr.subType);
        return dbType;
    }

    private DBLType semSubtypeIndication(SubTypeInd subType) {
        DBLType dbType = null;
        if (subType == null) {
            return dbType;
        }
        dbType = this.semTypeMark(subType.type);
        return dbType;
    }

    private DBLType semTypeMark(VName name) {
        DBLType dbType = null;
        if (name == null) {
            return dbType;
        }
        SymbolTree symbol = this.searchSymbol(this.getNameIdent(name), this.localSymbols);
        if (symbol == null || symbol.type != 3) {
            this.reportErrorMsg(this.getNameToken(name), "Bad type");
        } else {
            dbType = (DBLType)symbol.pointer;
        }
        return dbType;
    }

    private DBDiscreteRange semDiscreteRange(DiscreteRange discrete) {
        DBDiscreteRange dbRange = null;
        if (discrete == null) {
            return dbRange;
        }
        switch (discrete.type) {
            case 1: {
                break;
            }
            case 2: {
                dbRange = this.semRange((Range)discrete.pointer);
                break;
            }
        }
        return dbRange;
    }

    private DBDiscreteRange semRange(Range range2) {
        DBDiscreteRange dbRange = null;
        if (range2 == null) {
            return dbRange;
        }
        switch (range2.type) {
            case 1: {
                break;
            }
            case 2: {
                RangeSimple rSimp = (RangeSimple)range2.pointer;
                if (rSimp == null) break;
                dbRange = new DBDiscreteRange();
                dbRange.start = this.evalSimpleExpr(rSimp.start);
                dbRange.end = this.evalSimpleExpr(rSimp.end);
                break;
            }
        }
        return dbRange;
    }

    private DBSignals semObjectDeclare(ObjectDeclare declare) {
        DBSignals signals = null;
        if (declare == null) {
            return signals;
        }
        switch (declare.type) {
            case 2: {
                signals = this.semSignalDeclare((SignalDeclare)declare.pointer);
                break;
            }
            case 1: {
                this.semConstantDeclare((ConstantDeclare)declare.pointer);
                break;
            }
        }
        return signals;
    }

    private void semConstantDeclare(ConstantDeclare constant) {
        if (constant == null) {
            return;
        }
        if (this.searchFSymbol((String)constant.identifier.pointer, this.localSymbols) != null) {
            this.reportErrorMsg(constant.identifier, "Symbol previously defined");
        } else {
            int value = this.evalExpression(constant.expression);
            this.addSymbol((String)constant.identifier.pointer, 11, new Integer(value), this.localSymbols);
        }
    }

    private int evalExpression(Expression expr) {
        if (expr == null) {
            return 0;
        }
        int value = this.evalRelation(expr.relation);
        if (expr.next != null && value != 0) {
            value = 1;
        }
        MRelations more = expr.next;
        while (more != null) {
            int value2 = this.evalRelation(more.relation);
            if (value2 != 0) {
                value2 = 1;
            }
            switch (more.logOperator) {
                case 1: {
                    value &= value2;
                    break;
                }
                case 2: {
                    value |= value2;
                    break;
                }
                case 3: {
                    value = ~(value & value2);
                    break;
                }
                case 4: {
                    value = ~(value | value2);
                    break;
                }
                case 5: {
                    value ^= value2;
                    break;
                }
            }
            more = more.next;
        }
        return value;
    }

    private int evalRelation(Relation relation) {
        if (relation == null) {
            return 0;
        }
        int value = this.evalSimpleExpr(relation.simpleExpr);
        if (relation.relOperator != 0) {
            int value2 = this.evalSimpleExpr(relation.simpleExpr2);
            switch (relation.relOperator) {
                case 1: {
                    if (value == value2) {
                        value = 1;
                        break;
                    }
                    value = 0;
                    break;
                }
                case 2: {
                    if (value != value2) {
                        value = 1;
                        break;
                    }
                    value = 0;
                    break;
                }
                case 3: {
                    if (value < value2) {
                        value = 1;
                        break;
                    }
                    value = 0;
                    break;
                }
                case 4: {
                    if (value <= value2) {
                        value = 1;
                        break;
                    }
                    value = 0;
                    break;
                }
                case 5: {
                    if (value > value2) {
                        value = 1;
                        break;
                    }
                    value = 0;
                    break;
                }
                case 6: {
                    if (value >= value2) {
                        value = 1;
                        break;
                    }
                    value = 0;
                    break;
                }
            }
        }
        return value;
    }

    private int evalSimpleExpr(SimpleExpr expr) {
        if (expr == null) {
            return 0;
        }
        int value = this.evalTerm(expr.term) * expr.sign;
        MTerms more = expr.next;
        while (more != null) {
            int value2 = this.evalTerm(more.term);
            switch (more.addOperator) {
                case 1: {
                    value += value2;
                    break;
                }
                case 2: {
                    value -= value2;
                    break;
                }
            }
            more = more.next;
        }
        return value;
    }

    private int evalTerm(Term term) {
        if (term == null) {
            return 0;
        }
        int value = this.evalFactor(term.factor);
        MFactors more = term.next;
        while (more != null) {
            int value2 = this.evalFactor(more.factor);
            switch (more.mulOperator) {
                case 1: {
                    value *= value2;
                    break;
                }
                case 2: {
                    value /= value2;
                    break;
                }
                case 3: {
                    value %= value2;
                    break;
                }
                case 4: {
                    value -= value / value2 * value2;
                    break;
                }
            }
            more = more.next;
        }
        return value;
    }

    private int evalFactor(Factor factor) {
        if (factor == null) {
            return 0;
        }
        int value = this.evalPrimary(factor.primary);
        switch (factor.miscOperator) {
            case 1: {
                int value2 = this.evalPrimary(factor.primary2);
                while (value2-- != 0) {
                    value += value;
                }
                break;
            }
            case 2: {
                value = Math.abs(value);
                break;
            }
            case 3: {
                if (value != 0) {
                    value = 0;
                    break;
                }
                value = 1;
                break;
            }
        }
        return value;
    }

    private int evalPrimary(Primary primary) {
        if (primary == null) {
            return 0;
        }
        int value = 0;
        block0 : switch (primary.type) {
            case 2: {
                Literal literal = (Literal)primary.pointer;
                if (literal == null) break;
                switch (literal.type) {
                    case 1: {
                        value = (Integer)literal.pointer;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                value = this.evalName((VName)primary.pointer);
                break;
            }
            case 8: {
                value = this.evalExpression((Expression)primary.pointer);
                break;
            }
        }
        return value;
    }

    private int evalName(VName name) {
        if (name == null) {
            return 0;
        }
        int value = 0;
        SymbolTree symbol = this.searchSymbol(this.getNameIdent(name), this.localSymbols);
        if (symbol == null) {
            this.reportErrorMsg(this.getNameToken(name), "Symbol is undefined");
            return value;
        }
        if (symbol.type == 8) {
            if (symbol.pointer instanceof Integer) {
                value = (Integer)symbol.pointer;
            }
        } else if (symbol.type == 11) {
            value = (Integer)symbol.pointer;
        } else {
            this.reportErrorMsg(this.getNameToken(name), "Cannot evaluate value of symbol");
            return value;
        }
        return value;
    }

    private DBSignals semSignalDeclare(SignalDeclare signal) {
        DBSignals signals = null;
        if (signal == null) {
            return signals;
        }
        String type = this.getNameIdent(signal.subType.type);
        SymbolTree symbol = this.searchSymbol(type, this.localSymbols);
        if (symbol == null || symbol.type != 3) {
            this.reportErrorMsg(this.getNameToken(signal.subType.type), "Bad type");
        } else if (type.equalsIgnoreCase("bit_vector") && signal.subType.type.type == 1) {
            SingleName singleName = (SingleName)signal.subType.type.pointer;
            if (singleName.type == 3) {
                IndexedName indexedName = (IndexedName)singleName.pointer;
                symbol = new SymbolTree();
                DBLType dt = new DBLType();
                symbol.pointer = dt;
                dt.type = 2;
                DBIndexRange endRange = null;
                ExprList eList = indexedName.exprList;
                while (eList != null) {
                    DBIndexRange newRange = new DBIndexRange();
                    newRange.dRange = new DBDiscreteRange();
                    newRange.dRange.start = this.evalSimpleExpr(eList.expression.relation.simpleExpr);
                    int n = newRange.dRange.end = eList.expressionRangeEnd != null ? this.evalSimpleExpr(eList.expressionRangeEnd.relation.simpleExpr) : newRange.dRange.start;
                    if (endRange == null) {
                        endRange = newRange;
                        dt.pointer = newRange;
                    } else {
                        endRange.next = newRange;
                        endRange = newRange;
                    }
                    eList = eList.next;
                }
            }
        }
        IdentList sig = signal.names;
        while (sig != null) {
            if (this.searchSymbol((String)sig.identifier.pointer, this.localSymbols) != null) {
                this.reportErrorMsg(sig.identifier, "Signal previously defined");
            } else {
                DBSignals newSignal = new DBSignals();
                newSignal.name = (String)sig.identifier.pointer;
                newSignal.type = symbol != null ? (DBLType)symbol.pointer : null;
                newSignal.next = signals;
                signals = newSignal;
                this.addSymbol(newSignal.name, 6, newSignal, this.localSymbols);
            }
            sig = sig.next;
        }
        return signals;
    }

    private DBInterface semInterface(VInterface interfacef) {
        DBInterface dbInter = null;
        if (interfacef == null) {
            return dbInter;
        }
        if (this.searchSymbol((String)interfacef.name.pointer, this.globalSymbols) != null) {
            this.reportErrorMsg(interfacef.name, "Entity previously defined");
        } else {
            dbInter = new DBInterface();
            dbInter.name = (String)interfacef.name.pointer;
            dbInter.ports = null;
            dbInter.flags = 0;
            dbInter.bodies = null;
            dbInter.symbols = null;
            dbInter.next = null;
            this.addSymbol(dbInter.name, 1, dbInter, this.globalSymbols);
            this.localSymbols = this.pushSymbols(this.localSymbols);
            dbInter.ports = this.semFormalPortList(interfacef.ports);
            SymbolList endSymbol = this.localSymbols;
            while (endSymbol.last.last != null) {
                endSymbol = endSymbol.last;
            }
            endSymbol.last = null;
            dbInter.symbols = this.localSymbols;
        }
        return dbInter;
    }

    private DBPortList semFormalPortList(FPortList port) {
        DBPortList dbPorts = null;
        DBPortList endPort = null;
        while (port != null) {
            switch (port.mode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    this.reportErrorMsg(port.names.identifier, "Unknown port mode");
                }
            }
            String symName = this.getNameIdent(port.type);
            SymbolTree symbol = this.searchSymbol(symName, this.localSymbols);
            if (symbol == null || symbol.type != 3) {
                this.reportErrorMsg(this.getNameToken(port.type), "Unknown port name (" + symName + ")");
            } else if (symName.equalsIgnoreCase("bit_vector") && port.type.type == 1) {
                SingleName singleName = (SingleName)port.type.pointer;
                if (singleName.type == 3) {
                    IndexedName indexedName = (IndexedName)singleName.pointer;
                    symbol = new SymbolTree();
                    DBLType dt = new DBLType();
                    symbol.pointer = dt;
                    dt.type = 2;
                    DBIndexRange endRange = null;
                    ExprList eList = indexedName.exprList;
                    while (eList != null) {
                        DBIndexRange newRange = new DBIndexRange();
                        newRange.dRange = new DBDiscreteRange();
                        newRange.dRange.start = this.evalSimpleExpr(eList.expression.relation.simpleExpr);
                        int n = newRange.dRange.end = eList.expressionRangeEnd != null ? this.evalSimpleExpr(eList.expressionRangeEnd.relation.simpleExpr) : newRange.dRange.start;
                        if (endRange == null) {
                            endRange = newRange;
                            dt.pointer = newRange;
                        } else {
                            endRange.next = newRange;
                            endRange = newRange;
                        }
                        eList = eList.next;
                    }
                }
            }
            IdentList names = port.names;
            while (names != null) {
                if (this.searchFSymbol((String)names.identifier.pointer, this.localSymbols) != null) {
                    this.reportErrorMsg(names.identifier, "Duplicate port name in port list");
                } else {
                    DBPortList newPort = new DBPortList();
                    newPort.name = (String)names.identifier.pointer;
                    newPort.mode = port.mode;
                    newPort.type = symbol != null ? (DBLType)symbol.pointer : null;
                    newPort.flags = 0;
                    newPort.next = null;
                    if (endPort == null) {
                        dbPorts = endPort = newPort;
                    } else {
                        endPort.next = newPort;
                        endPort = newPort;
                    }
                    this.addSymbol(newPort.name, 4, newPort, this.localSymbols);
                }
                names = names.next;
            }
            port = port.next;
        }
        return dbPorts;
    }

    private TokenList getNameToken(VName name) {
        TokenList token = null;
        if (name == null) {
            return token;
        }
        block0 : switch (name.type) {
            case 1: {
                SingleName singl = (SingleName)name.pointer;
                switch (singl.type) {
                    case 1: {
                        token = ((SimpleName)singl.pointer).identifier;
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                    case 3: {
                        token = this.getPrefixToken(((IndexedName)singl.pointer).prefix);
                        break block0;
                    }
                }
                break;
            }
        }
        return token;
    }

    private TokenList getPrefixToken(Prefix prefix) {
        TokenList token = null;
        if (prefix == null) {
            return token;
        }
        switch (prefix.type) {
            case 1: {
                token = this.getNameToken((VName)prefix.pointer);
                break;
            }
        }
        return token;
    }

    private SymbolTree searchSymbol(String ident, SymbolList symList) {
        String lcIdent = TextUtils.canonicString(ident);
        while (symList != null) {
            SymbolTree node = symList.sym.get(lcIdent);
            if (node != null) {
                return node;
            }
            symList = symList.last;
        }
        return null;
    }

    private SymbolTree searchFSymbol(String ident, SymbolList symList) {
        SymbolTree node;
        if (symList != null && (node = symList.sym.get(TextUtils.canonicString(ident))) != null) {
            return node;
        }
        return null;
    }

    private String getNameIdent(VName name) {
        String iTable = null;
        if (name == null) {
            return iTable;
        }
        block0 : switch (name.type) {
            case 1: {
                SingleName singl = (SingleName)name.pointer;
                switch (singl.type) {
                    case 1: {
                        iTable = (String)((SimpleName)singl.pointer).identifier.pointer;
                        break block0;
                    }
                    case 3: {
                        iTable = this.getPrefixIdent(((IndexedName)singl.pointer).prefix);
                        break block0;
                    }
                }
                break;
            }
        }
        return iTable;
    }

    private String getPrefixIdent(Prefix prefix) {
        String iTable = null;
        if (prefix == null) {
            return iTable;
        }
        switch (prefix.type) {
            case 1: {
                iTable = this.getNameIdent((VName)prefix.pointer);
                break;
            }
        }
        return iTable;
    }

    private void createDefaultType(SymbolList symbols) {
        this.identTable.add("BIT");
        this.addSymbol("BIT", 3, null, symbols);
        this.identTable.add("std_logic");
        this.addSymbol("std_logic", 3, null, symbols);
        this.identTable.add("bit_vector");
        this.addSymbol("bit_vector", 3, null, symbols);
    }

    private SymbolTree addSymbol(String value, int type, Object pointer, SymbolList symList) {
        SymbolTree symbol = new SymbolTree();
        symbol.value = value;
        symbol.type = type;
        symbol.pointer = pointer;
        symList.sym.put(TextUtils.canonicString(value), symbol);
        return symbol;
    }

    private SymbolList pushSymbols(SymbolList oldSymList) {
        SymbolList newSymList = new SymbolList();
        newSymList.sym = new HashMap();
        newSymList.last = oldSymList;
        return newSymList;
    }

    private List<String> genALS(Library destLib, Library behaveLib) {
        Cell basenp = this.vhdlCell;
        ArrayList<String> netlist = new ArrayList<String>();
        netlist.add("#*************************************************");
        netlist.add("#  ALS Netlist file");
        netlist.add("#");
        if (User.isIncludeDateAndVersionInOutput()) {
            netlist.add("#  File Creation:    " + TextUtils.formatDate(new Date()));
        }
        netlist.add("#-------------------------------------------------");
        netlist.add("");
        DBInterface topInterface = this.findTopInterface(this.theUnits);
        if (topInterface == null) {
            System.out.println("ERROR - Cannot find interface to rename main.");
        } else {
            DBInterface interfacef = this.theUnits.interfaces;
            while (interfacef != null) {
                interfacef.flags &= 0xFFFFFFFD;
                interfacef = interfacef.next;
            }
            this.genALSInterface(topInterface, basenp.getName(), netlist);
        }
        netlist.add("#********* End of netlist *******************");
        int total = 0;
        UnResList uList = this.unResolvedList;
        while (uList != null) {
            ++total;
            String gate = uList.interfacef;
            if (this.addNetlist(destLib, gate, netlist)) {
                uList.numRef = 0;
                --total;
            } else if (behaveLib != null && behaveLib != destLib && this.addNetlist(behaveLib, gate, netlist)) {
                uList.numRef = 0;
                --total;
            } else if (gate.equals("PMOStran")) {
                this.dumpFunction(gate, pMOStran, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("pMOStranWeak")) {
                this.dumpFunction(gate, pMOStranWeak, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("nMOStran")) {
                this.dumpFunction(gate, nMOStran, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("nMOStranWeak")) {
                this.dumpFunction(gate, nMOStranWeak, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("inverter")) {
                this.dumpFunction(gate, inverter, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("buffer")) {
                this.dumpFunction(gate, buffer, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.startsWith("and") && TextUtils.isDigit(gate.charAt(3))) {
                this.genFunction("and", true, false, TextUtils.atoi(gate.substring(3)), netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.startsWith("nand") && TextUtils.isDigit(gate.charAt(4))) {
                this.genFunction("and", true, true, TextUtils.atoi(gate.substring(4)), netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.startsWith("or") && TextUtils.isDigit(gate.charAt(2))) {
                this.genFunction("or", false, false, TextUtils.atoi(gate.substring(2)), netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.startsWith("nor") && TextUtils.isDigit(gate.charAt(3))) {
                this.genFunction("or", false, true, TextUtils.atoi(gate.substring(3)), netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("xor2")) {
                this.dumpFunction(gate, xor2, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("power")) {
                this.dumpFunction(gate, power, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("ground")) {
                this.dumpFunction(gate, ground, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("jkff")) {
                this.dumpFunction(gate, JKFF, netlist);
                uList.numRef = 0;
                --total;
            } else if (gate.equals("dsff")) {
                this.dumpFunction(gate, DFF, netlist);
                uList.numRef = 0;
                --total;
            }
            uList = uList.next;
        }
        if (total > 0) {
            System.out.println("*****  UNRESOLVED REFERENCES *****");
            uList = this.unResolvedList;
            while (uList != null) {
                if (uList.numRef > 0) {
                    System.out.println(uList.interfacef + ", " + uList.numRef + " time(s)");
                }
                uList = uList.next;
            }
        }
        return netlist;
    }

    private boolean addNetlist(Library lib, String name, List<String> netlist) {
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Variable var;
            Cell np = it.next();
            if (np.getView() != View.NETLISTALS) continue;
            StringBuffer infstr = new StringBuffer();
            String cellName = np.getName();
            for (int i = 0; i < cellName.length(); ++i) {
                char chr = cellName.charAt(i);
                if (TextUtils.isLetterOrDigit(chr)) {
                    infstr.append(chr);
                    continue;
                }
                infstr.append("_");
            }
            String key = infstr.toString();
            if (!name.equalsIgnoreCase(key) || (var = np.getVar(Cell.CELL_TEXT_KEY)) == null) continue;
            String[] strings = (String[])var.getObject();
            netlist.add("");
            for (int i = 0; i < strings.length; ++i) {
                netlist.add(strings[i]);
            }
            return true;
        }
        return false;
    }

    private void genFunction(String name, boolean isand, boolean isneg, int inputs, List<String> netlist) {
        int i;
        String modelName = "";
        if (isneg) {
            modelName = "n";
        }
        modelName = isand ? modelName + "and" : modelName + "or";
        modelName = modelName + inputs;
        netlist.add("");
        netlist.add("# Built-in model for " + modelName);
        StringBuffer infstr = new StringBuffer();
        infstr.append("model " + modelName + "(");
        for (i = 1; i <= inputs; ++i) {
            if (i > 1) {
                infstr.append(",");
            }
            infstr.append("a" + i);
        }
        infstr.append(",z)");
        netlist.add(infstr.toString());
        infstr = new StringBuffer();
        infstr.append("g1: " + modelName + "fun(");
        for (i = 1; i <= inputs; ++i) {
            if (i > 1) {
                infstr.append(",");
            }
            infstr.append("a" + i);
        }
        if (!isneg) {
            infstr.append(",out)");
        } else {
            infstr.append(",z)");
        }
        netlist.add(infstr.toString());
        if (!isneg) {
            netlist.add("g2: " + modelName + "buf(out,z)");
        }
        infstr = new StringBuffer();
        infstr.append("gate " + modelName + "fun(");
        for (i = 1; i <= inputs; ++i) {
            if (i > 1) {
                infstr.append(",");
            }
            infstr.append("a" + i);
        }
        infstr.append(",z)");
        netlist.add(infstr.toString());
        netlist.add("t: delta=1.33e-9");
        for (i = 1; i <= inputs; ++i) {
            infstr = new StringBuffer();
            infstr.append("i: a" + i);
            if (isand) {
                infstr.append("=L o: z=H");
            } else {
                infstr.append("=H o: z=L");
            }
            netlist.add(infstr.toString());
        }
        netlist.add("t: delta=1.07e-9");
        infstr = new StringBuffer();
        infstr.append("i:");
        for (i = 1; i <= inputs; ++i) {
            if (isand) {
                infstr.append(" a" + i + "=H");
                continue;
            }
            infstr.append(" a" + i + "=L");
        }
        if (isand) {
            infstr.append(" o: z=L");
        } else {
            infstr.append(" o: z=H");
        }
        netlist.add(infstr.toString());
        netlist.add("t: delta=0");
        netlist.add("i: o: z=X");
        infstr = new StringBuffer();
        infstr.append("load:");
        for (i = 1; i <= inputs; ++i) {
            infstr.append(" a" + i + "=1.0");
        }
        netlist.add(infstr.toString());
        if (!isneg) {
            netlist.add("gate " + modelName + "buf(in,out)");
            netlist.add("t: delta=0.56e-9");
            netlist.add("i: in=H    o: out=L");
            netlist.add("t: delta=0.41e-9");
            netlist.add("i: in=L    o: out=H");
            netlist.add("t: delta=0");
            netlist.add("i: in=X    o: out=X");
        }
    }

    private void dumpFunction(String name, String[] model, List<String> netlist) {
        netlist.add("");
        netlist.add("# Built-in model for " + name);
        for (int i = 0; i < model.length; ++i) {
            netlist.add(model[i]);
        }
    }

    private void genALSInterface(DBInterface interfacef, String name, List<String> netlist) {
        if ((interfacef.flags & 2) != 0) {
            return;
        }
        interfacef.flags |= 2;
        if (interfacef.bodies != null && interfacef.bodies.statements != null) {
            DBInstance inst = interfacef.bodies.statements.instances;
            while (inst != null) {
                SymbolTree symbol = this.searchSymbol(inst.compo.name, this.globalSymbols);
                if (symbol == null) {
                    this.addToUnresolved(inst.compo.name);
                } else if (symbol.pointer != null) {
                    this.genALSInterface((DBInterface)symbol.pointer, inst.compo.name, netlist);
                }
                inst = inst.next;
            }
        }
        int generic = 0;
        boolean power_flag = false;
        boolean ground_flag = false;
        StringBuffer infstr = new StringBuffer("model ");
        for (int i = 0; i < name.length(); ++i) {
            char chr = name.charAt(i);
            if (TextUtils.isLetterOrDigit(chr)) {
                infstr.append(chr);
                continue;
            }
            infstr.append('_');
        }
        infstr.append("(");
        boolean first = true;
        DBPortList port = interfacef.ports;
        while (port != null) {
            if (port.type == null || port.type.type == 1) {
                if (!first) {
                    infstr.append(", ");
                }
                infstr.append(port.name);
                first = false;
            } else {
                int i;
                DBIndexRange iRange = (DBIndexRange)port.type.pointer;
                DBDiscreteRange dRange = iRange.dRange;
                if (dRange.start > dRange.end) {
                    for (i = dRange.start; i >= dRange.end; --i) {
                        if (!first) {
                            infstr.append(", ");
                        }
                        infstr.append(port.name + "[" + i + "]");
                        first = false;
                    }
                } else {
                    for (i = dRange.start; i <= dRange.end; ++i) {
                        if (!first) {
                            infstr.append(", ");
                        }
                        infstr.append(port.name + "[" + i + "]");
                        first = false;
                    }
                }
            }
            port = port.next;
        }
        infstr.append(")");
        netlist.add(infstr.toString());
        if (interfacef.bodies != null && interfacef.bodies.statements != null) {
            DBInstance inst = interfacef.bodies.statements.instances;
            while (inst != null) {
                infstr = new StringBuffer();
                infstr.append(inst.name);
                infstr.append(": ");
                infstr.append(inst.compo.name);
                infstr.append("(");
                first = true;
                DBAPortList aPort = inst.ports;
                while (aPort != null) {
                    if (aPort.name != null) {
                        if (aPort.name.type == 3) {
                            DBNameList cat2 = (DBNameList)aPort.name.pointer;
                            while (cat2 != null) {
                                String ident = cat2.name.name;
                                if (ImmutableExport.isNamedPower(ident)) {
                                    power_flag = true;
                                } else if (ImmutableExport.isNamedGround(ident)) {
                                    ground_flag = true;
                                }
                                first = this.genAPort(infstr, first, cat2.name);
                                cat2 = cat2.next;
                            }
                        } else {
                            String ident = aPort.name.name;
                            if (ImmutableExport.isNamedPower(ident)) {
                                power_flag = true;
                            } else if (ImmutableExport.isNamedGround(ident)) {
                                ground_flag = true;
                            }
                            first = this.genAPort(infstr, first, aPort.name);
                        }
                    } else if (aPort.port.type != null && aPort.port.type.type == 2) {
                        int i;
                        DBIndexRange iRange = (DBIndexRange)aPort.port.type.pointer;
                        DBDiscreteRange dRange = iRange.dRange;
                        if (dRange.start > dRange.end) {
                            for (i = dRange.start; i >= dRange.end; --i) {
                                if (!first) {
                                    infstr.append(", ");
                                }
                                infstr.append("n" + generic++);
                                first = false;
                            }
                        } else {
                            for (i = dRange.start; i <= dRange.end; ++i) {
                                if (!first) {
                                    infstr.append(", ");
                                }
                                infstr.append("n" + generic++);
                                first = false;
                            }
                        }
                    } else {
                        if (!first) {
                            infstr.append(", ");
                        }
                        infstr.append("n" + generic++);
                        first = false;
                    }
                    aPort = aPort.next;
                }
                infstr.append(")");
                netlist.add(infstr.toString());
                inst = inst.next;
            }
        }
        if (power_flag) {
            netlist.add("set power = H@3");
        } else if (ground_flag) {
            netlist.add("set ground = L@3");
        }
        netlist.add("");
    }

    private boolean genAPort(StringBuffer infstr, boolean first, DBName name) {
        if (name.type == 2) {
            if (!first) {
                infstr.append(", ");
            }
            infstr.append(name.name + ((DBExprList)name.pointer).value);
            first = false;
        } else if (name.dbType != null && name.dbType.type == 2) {
            DBIndexRange iRange = (DBIndexRange)name.dbType.pointer;
            DBDiscreteRange dRange = iRange.dRange;
            if (dRange.start > dRange.end) {
                for (int i = dRange.start; i >= dRange.end; --i) {
                    if (!first) {
                        infstr.append(", ");
                    }
                    infstr.append(name.name + "[" + i + "]");
                    first = false;
                }
            } else {
                for (int i = dRange.start; i <= dRange.end; ++i) {
                    if (!first) {
                        infstr.append(", ");
                    }
                    infstr.append(name.name + "[" + i + "]");
                    first = false;
                }
            }
        } else {
            if (!first) {
                infstr.append(", ");
            }
            infstr.append(name.name);
            first = false;
        }
        return first;
    }

    private List<String> genQuisc(Library destLib, boolean isIncludeDateAndVersionInOutput) {
        ArrayList<String> netlist = new ArrayList<String>();
        netlist.add("!*************************************************");
        netlist.add("!  QUISC Command file");
        netlist.add("!");
        if (isIncludeDateAndVersionInOutput) {
            netlist.add("!  File Creation:    " + TextUtils.formatDate(new Date()));
        }
        netlist.add("!-------------------------------------------------");
        netlist.add("");
        DBInterface topInterface = this.findTopInterface(this.theUnits);
        if (topInterface == null) {
            System.out.println("ERROR - Cannot find top interface.");
        } else {
            DBInterface interfacef = this.theUnits.interfaces;
            while (interfacef != null) {
                interfacef.flags &= 0xFFFFFFFD;
                interfacef = interfacef.next;
            }
            this.genQuiscInterface(topInterface, netlist);
        }
        netlist.add("!********* End of command file *******************");
        Library cellLib = Library.findLibrary("sclib");
        int total = 0;
        UnResList uList = this.unResolvedList;
        while (uList != null) {
            char chr;
            int i;
            String name;
            StringBuffer sb;
            Cell np;
            boolean found = false;
            Iterator<Cell> it = destLib.getCells();
            while (it.hasNext()) {
                np = it.next();
                sb = new StringBuffer();
                name = np.getName();
                for (i = 0; i < name.length(); ++i) {
                    chr = name.charAt(i);
                    if (Character.isLetterOrDigit(chr)) {
                        sb.append(chr);
                        continue;
                    }
                    sb.append('_');
                }
                if (!uList.interfacef.equalsIgnoreCase(sb.toString())) continue;
                found = true;
                break;
            }
            if (!found && cellLib != null) {
                it = cellLib.getCells();
                while (it.hasNext()) {
                    np = it.next();
                    sb = new StringBuffer();
                    name = np.getName();
                    for (i = 0; i < name.length(); ++i) {
                        chr = name.charAt(i);
                        if (Character.isLetterOrDigit(chr)) {
                            sb.append(chr);
                            continue;
                        }
                        sb.append('_');
                    }
                    if (!uList.interfacef.equalsIgnoreCase(sb.toString())) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                uList.numRef = 0;
            } else {
                ++total;
            }
            uList = uList.next;
        }
        if (total > 0) {
            System.out.println("*****  UNRESOLVED REFERENCES *****");
            uList = this.unResolvedList;
            while (uList != null) {
                if (uList.numRef > 0) {
                    System.out.println(uList.interfacef + ", " + uList.numRef + " time(s)");
                }
                uList = uList.next;
            }
        }
        return netlist;
    }

    private DBInterface findTopInterface(DBUnits units) {
        DBInterface interfacef = units.interfaces;
        while (interfacef != null) {
            interfacef.flags &= 0xFFFFFFFE;
            interfacef = interfacef.next;
        }
        DBBody body = units.bodies;
        while (body != null) {
            if (body.declare != null) {
                DBComponents compo = body.declare.components;
                while (compo != null) {
                    SymbolTree symbol = this.searchSymbol(compo.name, this.globalSymbols);
                    if (symbol != null && symbol.pointer != null) {
                        ((DBInterface)symbol.pointer).flags |= 1;
                    }
                    compo = compo.next;
                }
            }
            body = body.next;
        }
        interfacef = units.interfaces;
        while (interfacef != null && (interfacef.flags & 1) != 0) {
            interfacef = interfacef.next;
        }
        return interfacef;
    }

    private void genQuiscInterface(DBInterface interfacef, List<String> netlist) {
        QPORT qPort;
        int i;
        int size2;
        DBDiscreteRange dRange;
        DBIndexRange iRange;
        QNODE newQNode;
        DBInstance inst;
        if ((interfacef.flags & 2) != 0) {
            return;
        }
        interfacef.flags |= 2;
        if (interfacef.bodies != null && interfacef.bodies.statements != null) {
            inst = interfacef.bodies.statements.instances;
            while (inst != null) {
                SymbolTree symbol = this.searchSymbol(inst.compo.name, this.globalSymbols);
                if (symbol == null || symbol.pointer == null) {
                    this.addToUnresolved(inst.compo.name);
                } else {
                    this.genQuiscInterface((DBInterface)symbol.pointer, netlist);
                }
                inst = inst.next;
            }
        }
        netlist.add("create cell " + interfacef.name);
        if (interfacef.bodies != null && interfacef.bodies.statements != null) {
            inst = interfacef.bodies.statements.instances;
            while (inst != null) {
                netlist.add("create instance " + inst.name + " " + inst.compo.name);
                inst = inst.next;
            }
        }
        QNODE qNodes = null;
        QNODE lastNode = null;
        DBPortList fPort = interfacef.ports;
        while (fPort != null) {
            if (fPort.type == null || fPort.type.type == 1) {
                newQNode = new QNODE();
                newQNode.name = fPort.name;
                newQNode.nameType = 0;
                newQNode.size = 0;
                newQNode.start = 0;
                newQNode.end = 0;
                newQNode.table = null;
                newQNode.flags = ImmutableExport.isNamedPower(newQNode.name) ? 3 : (ImmutableExport.isNamedGround(newQNode.name) ? 5 : 1);
                newQNode.mode = fPort.mode;
                newQNode.ports = null;
                newQNode.next = null;
                if (lastNode == null) {
                    qNodes = lastNode = newQNode;
                } else {
                    lastNode.next = newQNode;
                    lastNode = newQNode;
                }
            } else {
                newQNode = new QNODE();
                newQNode.name = fPort.name;
                newQNode.nameType = 1;
                newQNode.flags = 1;
                newQNode.mode = fPort.mode;
                newQNode.ports = null;
                newQNode.next = null;
                if (lastNode == null) {
                    qNodes = lastNode = newQNode;
                } else {
                    lastNode.next = newQNode;
                    lastNode = newQNode;
                }
                iRange = (DBIndexRange)fPort.type.pointer;
                dRange = iRange.dRange;
                newQNode.start = dRange.start;
                newQNode.end = dRange.end;
                size2 = 1;
                if (dRange.start > dRange.end) {
                    size2 = dRange.start - dRange.end + 1;
                } else if (dRange.start < dRange.end) {
                    size2 = dRange.end - dRange.start + 1;
                }
                newQNode.size = size2;
                newQNode.table = new QPORT[size2];
                for (i = 0; i < size2; ++i) {
                    newQNode.table[i] = null;
                }
            }
            fPort = fPort.next;
        }
        if (interfacef.bodies != null && interfacef.bodies.declare != null) {
            DBSignals signal = interfacef.bodies.declare.bodySignals;
            while (signal != null) {
                if (signal.type == null || signal.type.type == 1) {
                    newQNode = new QNODE();
                    newQNode.name = signal.name;
                    newQNode.nameType = 0;
                    newQNode.size = 0;
                    newQNode.start = 0;
                    newQNode.end = 0;
                    newQNode.table = null;
                    newQNode.flags = ImmutableExport.isNamedPower(signal.name) ? 2 : (ImmutableExport.isNamedGround(signal.name) ? 4 : 0);
                    newQNode.mode = 0;
                    newQNode.ports = null;
                    newQNode.next = null;
                    if (lastNode == null) {
                        qNodes = lastNode = newQNode;
                    } else {
                        lastNode.next = newQNode;
                        lastNode = newQNode;
                    }
                } else {
                    newQNode = new QNODE();
                    newQNode.name = signal.name;
                    newQNode.nameType = 1;
                    newQNode.flags = 0;
                    newQNode.mode = 0;
                    newQNode.ports = null;
                    newQNode.next = null;
                    if (lastNode == null) {
                        qNodes = lastNode = newQNode;
                    } else {
                        lastNode.next = newQNode;
                        lastNode = newQNode;
                    }
                    iRange = (DBIndexRange)signal.type.pointer;
                    dRange = iRange.dRange;
                    newQNode.start = dRange.start;
                    newQNode.end = dRange.end;
                    size2 = 1;
                    if (dRange.start > dRange.end) {
                        size2 = dRange.start - dRange.end + 1;
                    } else if (dRange.start < dRange.end) {
                        size2 = dRange.end - dRange.start + 1;
                    }
                    newQNode.size = size2;
                    newQNode.table = new QPORT[size2];
                    for (i = 0; i < size2; ++i) {
                        newQNode.table[i] = null;
                    }
                }
                signal = signal.next;
            }
        }
        if (interfacef.bodies != null && interfacef.bodies.statements != null) {
            DBInstance inst2 = interfacef.bodies.statements.instances;
            while (inst2 != null) {
                DBAPortList aPort = inst2.ports;
                while (aPort != null) {
                    if (aPort.name != null) {
                        switch (aPort.name.type) {
                            case 1: {
                                this.addIdentAPort(aPort.name, aPort.port, 0, inst2, qNodes);
                                break;
                            }
                            case 2: {
                                this.addIndexedAPort(aPort.name, aPort.port, 0, inst2, qNodes);
                                break;
                            }
                            case 3: {
                                int offset = 0;
                                DBNameList cat2 = (DBNameList)aPort.name.pointer;
                                while (cat2 != null) {
                                    if (cat2.name.type == 1) {
                                        this.addIdentAPort(cat2.name, aPort.port, offset, inst2, qNodes);
                                    } else {
                                        this.addIndexedAPort(cat2.name, aPort.port, offset, inst2, qNodes);
                                    }
                                    offset += this.querySize(cat2.name);
                                    cat2 = cat2.next;
                                }
                                break;
                            }
                            default: {
                                System.out.println("ERROR - unknown name type on actual port.");
                            }
                        }
                    }
                    aPort = aPort.next;
                }
                inst2 = inst2.next;
            }
        }
        QNODE newQNode2 = qNodes;
        while (newQNode2 != null) {
            if (newQNode2.nameType == 0) {
                QPORT qPort2 = newQNode2.ports;
                if (qPort2 != null) {
                    if ((newQNode2.flags & 2) != 0) {
                        while (qPort2 != null) {
                            if (!ImmutableExport.isNamedPower(qPort2.portName)) {
                                netlist.add("connect " + qPort2.instName + " " + qPort2.portName + " power");
                            }
                            qPort2 = qPort2.next;
                        }
                    } else if ((newQNode2.flags & 4) != 0) {
                        while (qPort2 != null) {
                            if (!ImmutableExport.isNamedGround(qPort2.portName)) {
                                netlist.add("connect " + qPort2.instName + " " + qPort2.portName + " ground");
                            }
                            qPort2 = qPort2.next;
                        }
                    } else {
                        QPORT qPort22 = qPort2.next;
                        while (qPort22 != null) {
                            netlist.add("connect " + qPort2.instName + " " + qPort2.portName + " " + qPort22.instName + " " + qPort22.portName);
                            qPort22 = qPort22.next;
                        }
                    }
                }
            } else {
                for (int i2 = 0; i2 < newQNode2.size; ++i2) {
                    QPORT qPort3 = newQNode2.table[i2];
                    if (qPort3 == null) continue;
                    QPORT qPort2 = qPort3.next;
                    while (qPort2 != null) {
                        netlist.add("connect " + qPort3.instName + " " + qPort3.portName + " " + qPort2.instName + " " + qPort2.portName);
                        qPort2 = qPort2.next;
                    }
                }
            }
            newQNode2 = newQNode2.next;
        }
        newQNode2 = qNodes;
        while (newQNode2 != null) {
            if ((newQNode2.flags & 7) == 1) {
                if (newQNode2.nameType == 0) {
                    QPORT qPort4 = newQNode2.ports;
                    if (qPort4 != null) {
                        String inOut = "";
                        switch (newQNode2.mode) {
                            case 1: {
                                inOut = " input";
                                break;
                            }
                            case 2: {
                                inOut = " output";
                            }
                        }
                        netlist.add("export " + qPort4.instName + " " + qPort4.portName + " " + newQNode2.name + inOut);
                    } else {
                        System.out.println("ERROR - no export for " + newQNode2.name);
                    }
                } else {
                    for (int i3 = 0; i3 < newQNode2.size; ++i3) {
                        int indexC = 0;
                        indexC = newQNode2.start > newQNode2.end ? newQNode2.start - i3 : newQNode2.start + i3;
                        qPort = newQNode2.table[i3];
                        if (qPort != null) {
                            String inOut = "";
                            switch (newQNode2.mode) {
                                case 1: {
                                    inOut = " input";
                                    break;
                                }
                                case 2: {
                                    inOut = " output";
                                }
                            }
                            netlist.add("export " + qPort.instName + " " + qPort.portName + " " + newQNode2.name + "[" + indexC + "]" + inOut);
                            continue;
                        }
                        System.out.println("ERROR - no export for " + newQNode2.name + "[" + indexC + "]");
                    }
                }
            }
            newQNode2 = newQNode2.next;
        }
        netlist.add("extract");
        newQNode2 = qNodes;
        while (newQNode2 != null) {
            if ((newQNode2.flags & 7) == 0) {
                if (newQNode2.nameType == 0) {
                    QPORT qPort5 = newQNode2.ports;
                    if (qPort5 != null) {
                        netlist.add("set node-name " + qPort5.instName + " " + qPort5.portName + " " + newQNode2.name);
                    }
                } else {
                    for (int i4 = 0; i4 < newQNode2.size; ++i4) {
                        int indexC = 0;
                        indexC = newQNode2.start > newQNode2.end ? newQNode2.start - i4 : newQNode2.start + i4;
                        qPort = newQNode2.table[i4];
                        if (qPort == null) continue;
                        netlist.add("set node-name " + qPort.instName + " " + qPort.portName + " " + newQNode2.name + "[" + indexC + "]");
                    }
                }
            }
            newQNode2 = newQNode2.next;
        }
        netlist.add("");
    }

    private int querySize(DBName name) {
        int size2 = 0;
        if (name != null) {
            block0 : switch (name.type) {
                case 1: {
                    if (name.dbType != null) {
                        switch (name.dbType.type) {
                            case 1: {
                                size2 = 1;
                                break;
                            }
                            case 2: {
                                DBIndexRange iRange = (DBIndexRange)name.dbType.pointer;
                                if (iRange != null) {
                                    DBDiscreteRange dRange = iRange.dRange;
                                    if (dRange == null) break block0;
                                    size2 = dRange.start > dRange.end ? dRange.start - dRange.end : dRange.end - dRange.start;
                                    ++size2;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    size2 = 1;
                    break;
                }
                case 2: {
                    size2 = 1;
                    break;
                }
            }
        }
        return size2;
    }

    private void addIdentAPort(DBName name, DBPortList port, int offset, DBInstance inst, QNODE qNodes) {
        if (name.dbType != null && name.dbType.type == 2) {
            DBDiscreteRange dRange;
            DBIndexRange iRange = (DBIndexRange)name.dbType.pointer;
            if (iRange != null && (dRange = iRange.dRange) != null) {
                int delta = 0;
                if (dRange.start > dRange.end) {
                    delta = -1;
                } else if (dRange.start < dRange.end) {
                    delta = 1;
                }
                int i = dRange.start - delta;
                int offset2 = 0;
                do {
                    QPORT newPort = this.createQPort(inst.name, port, offset + offset2);
                    this.addQPortToQNode(newPort, name.name, 1, i += delta, qNodes);
                    ++offset2;
                } while (i != dRange.end);
            }
        } else {
            QPORT newPort = this.createQPort(inst.name, port, offset);
            this.addQPortToQNode(newPort, name.name, 0, 0, qNodes);
        }
    }

    private void addIndexedAPort(DBName name, DBPortList port, int offset, DBInstance inst, QNODE qNodes) {
        QPORT newPort = this.createQPort(inst.name, port, offset);
        int indexC = ((DBExprList)name.pointer).value;
        this.addQPortToQNode(newPort, name.name, 1, indexC, qNodes);
    }

    private QPORT createQPort(String iname, DBPortList port, int offset) {
        QPORT newPort = new QPORT();
        newPort.instName = iname;
        newPort.next = null;
        newPort.portName = port.type != null && port.type.type == 2 ? port.name + "[" + offset + "]" : port.name;
        return newPort;
    }

    private void addQPortToQNode(QPORT port, String ident, int type, int indexC, QNODE qNodes) {
        QNODE node = qNodes;
        while (node != null) {
            if (node.name.equalsIgnoreCase(ident) && node.nameType == type) {
                if (type == 0) {
                    port.next = node.ports;
                    node.ports = port;
                    return;
                }
                int tindex = node.start > node.end ? node.start - indexC : indexC - node.start;
                if (tindex >= 0 && tindex < node.size) {
                    port.next = node.table[tindex];
                    node.table[tindex] = port;
                    return;
                }
            }
            node = node.next;
        }
        System.out.println("WARNING node " + ident + " not found");
    }

    private void addToUnresolved(String name) {
        UnResList uList = this.unResolvedList;
        while (uList != null) {
            if (uList.interfacef.equals(name)) {
                ++uList.numRef;
                return;
            }
            uList = uList.next;
        }
        uList = new UnResList();
        uList.interfacef = name;
        uList.numRef = 1;
        uList.next = this.unResolvedList;
        this.unResolvedList = uList;
    }

    private static class QPORT {
        String instName;
        String portName;
        QPORT next;

        private QPORT() {
        }
    }

    private static class QNODE {
        String name;
        int nameType;
        int start;
        int end;
        int size;
        QPORT[] table;
        int flags;
        int mode;
        QPORT ports;
        QNODE next;

        private QNODE() {
        }
    }

    private class ParseException
    extends Exception {
        private ParseException() {
        }
    }

    private static class Literal {
        int type;
        Object pointer;

        private Literal() {
        }
    }

    private static class Primary {
        int type;
        Object pointer;

        private Primary() {
        }
    }

    private static class MFactors {
        int mulOperator;
        Factor factor;
        MFactors next;

        private MFactors() {
        }
    }

    private static class Factor {
        Primary primary;
        int miscOperator;
        Primary primary2;

        private Factor() {
        }
    }

    private static class MTerms {
        int addOperator;
        Term term;
        MTerms next;

        private MTerms() {
        }
    }

    private static class Term {
        Factor factor;
        MFactors next;

        private Term() {
        }
    }

    private static class SimpleExpr {
        int sign;
        Term term;
        MTerms next;

        private SimpleExpr() {
        }
    }

    private static class MRelations {
        int logOperator;
        Relation relation;
        MRelations next;

        private MRelations() {
        }
    }

    private static class Relation {
        SimpleExpr simpleExpr;
        int relOperator;
        SimpleExpr simpleExpr2;

        private Relation() {
        }
    }

    private static class Expression {
        Relation relation;
        MRelations next;

        private Expression() {
        }
    }

    private static class ConcatenatedName {
        SingleName name;
        ConcatenatedName next;

        private ConcatenatedName() {
        }
    }

    private static class RangeSimple {
        SimpleExpr start;
        SimpleExpr end;

        private RangeSimple() {
        }
    }

    private static class Range {
        int type;
        Object pointer;

        private Range() {
        }
    }

    private static class DiscreteRange {
        int type;
        Object pointer;

        private DiscreteRange() {
        }
    }

    private static class ExprList {
        Expression expression;
        int direction;
        Expression expressionRangeEnd;
        ExprList next;

        private ExprList() {
        }
    }

    private static class IndexedName {
        Prefix prefix;
        ExprList exprList;

        private IndexedName() {
        }
    }

    private static class Prefix {
        int type;
        Object pointer;

        private Prefix() {
        }
    }

    private static class SimpleName {
        TokenList identifier;

        private SimpleName() {
        }
    }

    private static class SingleName {
        int type;
        Object pointer;

        private SingleName() {
        }
    }

    private static class VName {
        int type;
        Object pointer;

        private VName() {
        }
    }

    private static class GenScheme {
        int scheme;
        TokenList identifier;
        DiscreteRange range;
        Expression condition;

        private GenScheme() {
        }
    }

    private static class Generate {
        TokenList label;
        GenScheme genScheme;
        Statements statements;

        private Generate() {
        }
    }

    private static class APortList {
        int type;
        Object pointer;
        APortList next;

        private APortList() {
        }
    }

    private static class VInstance {
        TokenList name;
        SimpleName entity;
        APortList ports;

        private VInstance() {
        }
    }

    private static class Statements {
        int type;
        Object pointer;
        Statements next;

        private Statements() {
        }
    }

    private static class IndexConstraint {
        DiscreteRange discrete;
        IndexConstraint next;

        private IndexConstraint() {
        }
    }

    private static class Constrained {
        IndexConstraint constraint;
        SubTypeInd subType;

        private Constrained() {
        }
    }

    private static class Array {
        int type;
        Object pointer;

        private Array() {
        }
    }

    private static class Composite {
        int type;
        Object pointer;

        private Composite() {
        }
    }

    private static class Type {
        TokenList identifier;
        int type;
        Object pointer;

        private Type() {
        }
    }

    private static class SubTypeInd {
        VName type;

        private SubTypeInd() {
        }
    }

    private static class ConstantDeclare {
        TokenList identifier;
        SubTypeInd subType;
        Expression expression;

        private ConstantDeclare() {
        }
    }

    private static class VComponent {
        TokenList name;
        FPortList ports;

        private VComponent() {
        }
    }

    private static class SignalDeclare {
        IdentList names;
        SubTypeInd subType;

        private SignalDeclare() {
        }
    }

    private static class ObjectDeclare {
        int type;
        Object pointer;

        private ObjectDeclare() {
        }
    }

    private static class BasicDeclare {
        int type;
        Object pointer;

        private BasicDeclare() {
        }
    }

    private static class BodyDeclare {
        int type;
        Object pointer;
        BodyDeclare next;

        private BodyDeclare() {
        }
    }

    private static class Body {
        TokenList name;
        SimpleName entity;
        BodyDeclare bodyDeclare;
        Statements statements;

        private Body() {
        }
    }

    private static class IdentList {
        TokenList identifier;
        IdentList next;

        private IdentList() {
        }
    }

    private static class FPortList {
        IdentList names;
        int mode;
        VName type;
        FPortList next;

        private FPortList() {
        }
    }

    private static class VInterface {
        TokenList name;
        FPortList ports;
        Object interfacef;

        private VInterface() {
        }
    }

    private static class Use {
        TokenList unit;
        Use next;

        private Use() {
        }
    }

    private static class PackagedPart {
        BasicDeclare item;
        PackagedPart next;

        private PackagedPart() {
        }
    }

    private static class Package {
        TokenList name;
        PackagedPart declare;
        List packagedParts;

        private Package() {
        }
    }

    private static class PTree {
        int type;
        Object pointer;
        PTree next;

        private PTree() {
        }
    }

    private static class DBNameList {
        DBName name;
        DBNameList next;

        private DBNameList() {
        }
    }

    private static class DBIndexRange {
        DBDiscreteRange dRange;
        DBIndexRange next;

        private DBIndexRange() {
        }
    }

    private static class DBDiscreteRange {
        int start;
        int end;

        private DBDiscreteRange() {
        }
    }

    private static class DBExprList {
        int value;
        DBExprList next;

        private DBExprList() {
        }
    }

    private static class DBName {
        String name;
        int type;
        Object pointer;
        DBLType dbType;

        private DBName() {
        }
    }

    private static class DBAPortList {
        DBName name;
        DBPortList port;
        int flags;
        DBAPortList next;

        private DBAPortList() {
        }
    }

    private static class DBInstance {
        String name;
        DBComponents compo;
        DBAPortList ports;
        DBInstance next;

        private DBInstance() {
        }
    }

    private static class DBStatements {
        DBInstance instances;

        private DBStatements() {
        }
    }

    private static class DBSignals {
        String name;
        DBLType type;
        DBSignals next;

        private DBSignals() {
        }
    }

    private static class DBComponents {
        String name;
        DBPortList ports;
        DBComponents next;

        private DBComponents() {
        }
    }

    private static class DBBodyDelcare {
        DBComponents components;
        DBSignals bodySignals;

        private DBBodyDelcare() {
        }
    }

    private static class DBBody {
        String name;
        String entity;
        DBBodyDelcare declare;
        DBStatements statements;
        DBInterface parent;
        DBBody sameParent;
        DBBody next;

        private DBBody() {
        }
    }

    private static class DBLType {
        String name;
        int type;
        Object pointer;
        DBLType subType;

        private DBLType() {
        }
    }

    private static class DBPortList {
        String name;
        int mode;
        DBLType type;
        int flags;
        DBPortList next;

        private DBPortList() {
        }
    }

    private static class DBInterface {
        String name;
        DBPortList ports;
        Object interfacef;
        int flags;
        DBBody bodies;
        SymbolList symbols;
        DBInterface next;

        private DBInterface() {
        }
    }

    private static class DBPackage {
        String name;
        SymbolList root;

        private DBPackage() {
        }
    }

    private static class DBUnits {
        DBInterface interfaces;
        DBBody bodies;

        private DBUnits() {
        }
    }

    private static class UnResList {
        String interfacef;
        int numRef;
        UnResList next;

        private UnResList() {
        }
    }

    private static class SymbolList {
        HashMap<String, SymbolTree> sym;
        SymbolList last;
        SymbolList next;

        private SymbolList() {
        }
    }

    private static class SymbolTree {
        String value;
        int type;
        Object pointer;
        int seen;

        private SymbolTree() {
        }
    }

    private class TokenList {
        int token;
        Object pointer;
        boolean space;
        int lineNum;
        TokenList next;
        TokenList last;

        TokenList(int token, Object pointer, int lineNum, boolean space) {
            this.token = token;
            this.pointer = pointer;
            this.lineNum = lineNum;
            this.space = true;
            this.next = null;
            this.last = CompileVHDL.this.tListEnd;
            if (CompileVHDL.this.tListEnd == null) {
                CompileVHDL.this.tListStart = (CompileVHDL.this.tListEnd = this);
            } else {
                ((CompileVHDL)CompileVHDL.this).tListEnd.space = space;
                ((CompileVHDL)CompileVHDL.this).tListEnd.next = this;
                CompileVHDL.this.tListEnd = this;
            }
        }
    }

    private static class VKeyword {
        String name;
        int num;

        VKeyword(String name, int num) {
            this.name = name;
            this.num = num;
        }
    }
}

