/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.math.DBMath;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class AbstractTextDescriptor
implements Serializable {
    static final long VTPOSITION = 15L;
    static final int VTPOSITIONSH = 0;
    static final int VTPOSCENT = 0;
    static final int VTPOSUP = 1;
    static final int VTPOSDOWN = 2;
    static final int VTPOSLEFT = 3;
    static final int VTPOSRIGHT = 4;
    static final int VTPOSUPLEFT = 5;
    static final int VTPOSUPRIGHT = 6;
    static final int VTPOSDOWNLEFT = 7;
    static final int VTPOSDOWNRIGHT = 8;
    static final int VTPOSBOXED = 9;
    static final long VTDISPLAYPART = 48L;
    static final int VTDISPLAYPARTSH = 4;
    static final int VTDISPLAYVALUE = 0;
    static final int VTDISPLAYNAMEVALUE = 2;
    static final int VTDISPLAYNAMEVALINH = 1;
    static final int VTDISPLAYNAMEVALINHALL = 3;
    static final long VTITALIC = 64L;
    static final long VTBOLD = 128L;
    static final long VTUNDERLINE = 256L;
    static final long VTISPARAMETER = 512L;
    static final long VTINTERIOR = 1024L;
    static final long VTINHERIT = 2048L;
    static final long VTXOFF = 0x1FF000L;
    static final int VTXOFFSH = 12;
    static final long VTXOFFNEG = 0x200000L;
    static final long VTYOFF = 2143289344L;
    static final int VTYOFFSH = 22;
    static final long VTYOFFNEG = 0x80000000L;
    static final int VTOFFMASKWID = 9;
    static final long VTSIZE = 0x7FFF00000000L;
    static final int VTSIZESH = 32;
    static final long VTFACE = 17873661021126656L;
    static final int VTFACESH = 47;
    static final int VTMAXFACE = 127;
    static final long VTROTATION = 0xC0000000000000L;
    static final int VTROTATIONSH = 54;
    static final long VTOFFSCALE = 0x1F00000000000000L;
    static final int VTOFFSCALESH = 56;
    static final long VTUNITS = -2305843009213693952L;
    static final int VTUNITSHMASK = 7;
    static final int VTUNITSSH = 61;
    static final int VTUNITSNONE = 0;
    static final int VTUNITSRES = 1;
    static final int VTUNITSCAP = 2;
    static final int VTUNITSIND = 3;
    static final int VTUNITSCUR = 4;
    static final int VTUNITSVOLT = 5;
    static final int VTUNITSDIST = 6;
    static final int VTUNITSTIME = 7;
    static final int VTOFFMAX = 511;
    static final int VTSCALEMAX = 31;
    static long VTSEMANTIC = -2305843009213690368L;
    static final int VDISPLAY = 64;

    AbstractTextDescriptor() {
    }

    public int hashCode() {
        return this.lowLevelGet0() ^ this.lowLevelGet1() ^ this.getColorIndex() ^ this.getDisplay().hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof AbstractTextDescriptor) {
            AbstractTextDescriptor td = (AbstractTextDescriptor)anObject;
            return this.lowLevelGet() == td.lowLevelGet() && this.getColorIndex() == td.getColorIndex() && this.getDisplay() == td.getDisplay();
        }
        return false;
    }

    public abstract long lowLevelGet();

    public int lowLevelGet0() {
        return (int)this.lowLevelGet();
    }

    public int lowLevelGet1() {
        return (int)(this.lowLevelGet() >> 32);
    }

    private int getField(long mask, int shift) {
        return (int)((this.lowLevelGet() & mask) >> shift);
    }

    private boolean isFlag(long mask) {
        return (this.lowLevelGet() & mask) != 0L;
    }

    public abstract Display getDisplay();

    public boolean isDisplay() {
        return this.getDisplay() == Display.SHOWN;
    }

    public Position getPos() {
        int pos = this.getField(15L, 0);
        if (pos >= Position.getNumPositions()) {
            pos = 0;
        }
        return Position.getPositionAt(pos);
    }

    public boolean isAbsoluteSize() {
        int textSize = this.getField(0x7FFF00000000L, 32);
        return textSize > 0 && textSize <= 63;
    }

    public Size getSize() {
        int textSize = this.getField(0x7FFF00000000L, 32);
        if (textSize == 0) {
            return Size.newRelSize(1.0);
        }
        if (textSize <= 63) {
            return Size.newAbsSize(textSize);
        }
        int sizeValue = textSize >> 6;
        double size2 = (double)sizeValue * 0.25;
        return Size.newRelSize(size2);
    }

    public static int getDefaultFontSize() {
        return 14;
    }

    public double getTrueSize(EditWindow0 wnd) {
        if (wnd != null) {
            return this.getTrueSize(wnd.getScale(), wnd);
        }
        int textSize = this.getField(0x7FFF00000000L, 32);
        double trueSize = textSize > 0 && textSize <= 63 ? (double)textSize : 14.0;
        return trueSize * User.getGlobalTextScale();
    }

    public double getTrueSize(double scale, EditWindow0 wnd) {
        int textSize = this.getField(0x7FFF00000000L, 32);
        double trueSize = textSize == 0 ? scale : (textSize <= 63 ? (double)textSize : (double)(textSize >> 6) * 0.25 * scale);
        return trueSize * (wnd == null ? User.getGlobalTextScale() : wnd.getGlobalTextScale());
    }

    public int getFace() {
        return this.getField(17873661021126656L, 47);
    }

    public Font getFont(EditWindow0 wnd, int minimalTextSize) {
        ActiveFont af;
        int fontIndex;
        int fontStyle = 0;
        String fontName = wnd == null ? User.getDefaultFont() : wnd.getDefaultFont();
        int size2 = (int)this.getTrueSize(wnd);
        if (size2 <= 0) {
            size2 = 1;
        }
        if (size2 < minimalTextSize) {
            return null;
        }
        if (this.isItalic()) {
            fontStyle |= 2;
        }
        if (this.isBold()) {
            fontStyle |= 1;
        }
        if ((fontIndex = this.getFace()) != 0 && (af = ActiveFont.findActiveFont(fontIndex)) != null) {
            fontName = af.getName();
        }
        Font font = new Font(fontName, fontStyle, size2);
        return font;
    }

    public static Font getDefaultFont(EditWindow0 wnd) {
        String fontName = wnd == null ? User.getDefaultFont() : wnd.getDefaultFont();
        return new Font(fontName, 0, TextDescriptor.getDefaultFontSize());
    }

    public static GlyphVector getGlyphs(String text, Font font) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        GlyphVector gv = font.createGlyphVector(frc, text);
        return gv;
    }

    public Rotation getRotation() {
        return Rotation.getRotationAt(this.getField(0xC0000000000000L, 54));
    }

    public DispPos getDispPart() {
        return DispPos.getShowStylesAt(this.getField(48L, 4));
    }

    public boolean isItalic() {
        return this.isFlag(64L);
    }

    public boolean isBold() {
        return this.isFlag(128L);
    }

    public boolean isUnderline() {
        return this.isFlag(256L);
    }

    public boolean isInterior() {
        return this.isFlag(1024L);
    }

    public boolean isInherit() {
        return this.isFlag(2048L);
    }

    public boolean isParam() {
        return this.isFlag(512L);
    }

    public double getXOff() {
        int offset = this.getField(0x1FF000L, 12);
        if (this.isFlag(0x200000L)) {
            offset = -offset;
        }
        int scale = this.getOffScale() + 1;
        return (double)offset * (double)scale / 4.0;
    }

    public double getYOff() {
        int offset = this.getField(2143289344L, 22);
        if (this.isFlag(0x80000000L)) {
            offset = -offset;
        }
        int scale = this.getOffScale() + 1;
        return (double)offset * (double)scale / 4.0;
    }

    private int getOffScale() {
        return this.getField(0x1F00000000000000L, 56);
    }

    public Unit getUnit() {
        return Unit.getUnitAt(this.getField(-2305843009213693952L, 61) & 7);
    }

    public abstract int getColorIndex();

    public static enum TextType {
        NODE("Node", 4),
        ARC("Arc", 4),
        PORT("Port", 4),
        EXPORT("Export", 8),
        ANNOTATION("Annotation", 4),
        INSTANCE("Instance", 16),
        CELL("Cell", 4);

        private final String purpose;
        private final TextDescriptor factoryTextDescriptor;

        public String getKey(String prefix) {
            return prefix + this.purpose;
        }

        public TextDescriptor getFactoryTextDescriptor() {
            return this.factoryTextDescriptor;
        }

        private TextType(String purpose, int initialSize) {
            this.purpose = purpose;
            MutableTextDescriptor mtd = new MutableTextDescriptor();
            mtd.setRelSize((double)initialSize * 0.25);
            mtd.setDisplay(true);
            this.factoryTextDescriptor = TextDescriptor.newTextDescriptor(mtd);
        }
    }

    public static class ActiveFont {
        private String fontName;
        private int index = ++indexCount;
        private static int indexCount = 0;
        private static final Map<String, ActiveFont> fontMap = new HashMap<String, ActiveFont>();
        private static final List<ActiveFont> fontList = new ArrayList<ActiveFont>();

        private ActiveFont(String fontName) {
            this.fontName = fontName;
            fontMap.put(fontName, this);
            fontList.add(this);
        }

        public static int getMaxIndex() {
            return indexCount;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.fontName;
        }

        public static ActiveFont findActiveFont(String fontName) {
            ActiveFont af = fontMap.get(fontName);
            if (af != null) {
                return af;
            }
            if (indexCount >= 127) {
                System.out.println("Too many fonts. Using default instead of " + fontName);
                return null;
            }
            return new ActiveFont(fontName);
        }

        public static ActiveFont findActiveFont(int index) {
            if (index <= 0) {
                return null;
            }
            if (index > fontList.size()) {
                return null;
            }
            ActiveFont af = fontList.get(index - 1);
            return af;
        }

        public String toString() {
            return this.fontName;
        }
    }

    public static class Unit {
        private final String description;
        private final String name;
        private final String postfixChar;
        private final int index;
        private static final List<Unit> units = new ArrayList<Unit>();
        public static final Unit NONE = new Unit("none", 0, "", "");
        public static final Unit RESISTANCE = new Unit("resistance", 1, "Ohm", "o");
        public static final Unit CAPACITANCE = new Unit("capacitance", 2, "Farad", "f");
        public static final Unit INDUCTANCE = new Unit("inductance", 3, "Henry", "h");
        public static final Unit CURRENT = new Unit("current", 4, "Ampere", "a");
        public static final Unit VOLTAGE = new Unit("voltage", 5, "Volt", "v");
        public static final Unit DISTANCE = new Unit("distance", 6, "Meter", "m");
        public static final Unit TIME = new Unit("time", 7, "Second", "s");

        private Unit(String description, int index, String name, String postfixChar) {
            this.description = description;
            this.index = index;
            this.name = name;
            this.postfixChar = postfixChar;
            units.add(index, this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getPostfixChar() {
            return this.postfixChar;
        }

        public static int getNumUnits() {
            return units.size();
        }

        public static Unit getUnitAt(int index) {
            return units.get(index);
        }

        public static Iterator<Unit> getUnits() {
            return Collections.unmodifiableList(units).iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Rotation {
        private final int angle;
        private final int index;
        private final String name;
        private static final List<Rotation> rotations = new ArrayList<Rotation>();
        public static final Rotation ROT0 = new Rotation(0, 0, "None");
        public static final Rotation ROT90 = new Rotation(90, 1, "90 degrees counterclockwise");
        public static final Rotation ROT180 = new Rotation(180, 2, "180 degrees");
        public static final Rotation ROT270 = new Rotation(270, 3, "90 degrees clockwise");

        private Rotation(int angle, int index, String name) {
            this.angle = angle;
            this.index = index;
            this.name = name;
            rotations.add(index, this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.name;
        }

        public int getAngle() {
            return this.angle;
        }

        public static Rotation getRotation(int angle) {
            for (Rotation rot : rotations) {
                if (rot.getAngle() != angle) continue;
                return rot;
            }
            return null;
        }

        public static int getNumRotations() {
            return rotations.size();
        }

        public static Rotation getRotationAt(int index) {
            return rotations.get(index);
        }

        public static Iterator<Rotation> getRotations() {
            return Collections.unmodifiableList(rotations).iterator();
        }

        public String toString() {
            return "Text Rotation " + this.angle;
        }
    }

    public static class Size {
        public static final int TXTMINPOINTS = 1;
        public static final int TXTMAXPOINTS = 63;
        public static final double TXTMINQGRID = 0.25;
        public static final double TXTMAXQGRID = 127.75;
        private static final int DEFAULT_FONT_SIZE = 14;
        static final int TXTQGRIDSH = 6;
        private final boolean absolute;
        private final double size;
        private final int bits;

        private Size(double size2, boolean absolute) {
            this.size = size2;
            this.absolute = absolute;
            this.bits = absolute ? (int)size2 : (int)(size2 * 4.0) << 6;
        }

        int getBits() {
            return this.bits;
        }

        public static Size newAbsSize(int size2) {
            if (size2 < 1 || size2 > 63) {
                return null;
            }
            return new Size(size2, true);
        }

        public static boolean isValidRelSize(double size2) {
            return !(size2 < 0.25) && !(size2 > 127.75);
        }

        public static Size newRelSize(double size2) {
            if (!Size.isValidRelSize(size2)) {
                return null;
            }
            return new Size(size2, false);
        }

        public double getSize() {
            return this.size;
        }

        public boolean isAbsolute() {
            return this.absolute;
        }

        public boolean equals(Object that) {
            if (that instanceof Size) {
                Size other = (Size)that;
                return this.absolute == other.absolute && DBMath.doublesEqual(this.size, other.size);
            }
            return false;
        }

        public String toString() {
            return "Text Size";
        }
    }

    public static class DispPos {
        private final String name;
        private final int index;
        private static final List<DispPos> positions = new ArrayList<DispPos>();
        public static final DispPos VALUE = new DispPos("value", 0);
        public static final DispPos NAMEVALUE = new DispPos("name=value", 2);

        private DispPos(String name, int index) {
            this.name = name;
            this.index = index;
            positions.add(this);
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static int getNumShowStyles() {
            return positions.size();
        }

        public static DispPos getShowStylesAt(int index) {
            for (DispPos d : positions) {
                if (d.index != index) continue;
                return d;
            }
            return NAMEVALUE;
        }

        public static Iterator<DispPos> getShowStyles() {
            return Collections.unmodifiableList(positions).iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Position {
        private final String name;
        private final int index;
        private final Poly.Type pt;
        private static final List<Position> positions = new ArrayList<Position>();
        public static final Position CENT = new Position("centered", 0, Poly.Type.TEXTCENT);
        public static final Position UP = new Position("bottom", 1, Poly.Type.TEXTBOT);
        public static final Position DOWN = new Position("top", 2, Poly.Type.TEXTTOP);
        public static final Position LEFT = new Position("right", 3, Poly.Type.TEXTRIGHT);
        public static final Position RIGHT = new Position("left", 4, Poly.Type.TEXTLEFT);
        public static final Position UPLEFT = new Position("lower-right", 5, Poly.Type.TEXTBOTRIGHT);
        public static final Position UPRIGHT = new Position("lower-left", 6, Poly.Type.TEXTBOTLEFT);
        public static final Position DOWNLEFT = new Position("upper-right", 7, Poly.Type.TEXTTOPRIGHT);
        public static final Position DOWNRIGHT = new Position("upper-left", 8, Poly.Type.TEXTTOPLEFT);
        public static final Position BOXED = new Position("boxed", 9, Poly.Type.TEXTBOX);

        private Position(String name, int index, Poly.Type pt) {
            this.name = name;
            this.index = index;
            this.pt = pt;
            positions.add(index, this);
        }

        public int getIndex() {
            return this.index;
        }

        public Poly.Type getPolyType() {
            return this.pt;
        }

        public Position align(int dx, int dy) {
            Position p = this;
            if (dx > 0) {
                if (p == CENT || p == RIGHT || p == LEFT) {
                    p = RIGHT;
                } else if (p == UP || p == UPRIGHT || p == UPLEFT) {
                    p = UPRIGHT;
                } else if (p == DOWN || p == DOWNRIGHT || p == DOWNLEFT) {
                    p = DOWNRIGHT;
                }
            } else if (dx < 0) {
                if (p == CENT || p == RIGHT || p == LEFT) {
                    p = LEFT;
                } else if (p == UP || p == UPRIGHT || p == UPLEFT) {
                    p = UPLEFT;
                } else if (p == DOWN || p == DOWNRIGHT || p == DOWNLEFT) {
                    p = DOWNLEFT;
                }
            }
            if (dy > 0) {
                if (p == CENT || p == UP || p == DOWN) {
                    p = UP;
                } else if (p == RIGHT || p == UPRIGHT || p == DOWNRIGHT) {
                    p = UPRIGHT;
                } else if (p == LEFT || p == UPLEFT || p == DOWNLEFT) {
                    p = UPLEFT;
                }
            } else if (dy < 0) {
                if (p == CENT || p == UP || p == DOWN) {
                    p = DOWN;
                } else if (p == RIGHT || p == UPRIGHT || p == DOWNRIGHT) {
                    p = DOWNRIGHT;
                } else if (p == LEFT || p == UPLEFT || p == DOWNLEFT) {
                    p = DOWNLEFT;
                }
            }
            return p;
        }

        public static Position getPosition(Poly.Type type) {
            for (Position pos : positions) {
                if (type != pos.pt) continue;
                return pos;
            }
            return CENT;
        }

        public static int getNumPositions() {
            return positions.size();
        }

        public static Position getPositionAt(int index) {
            return positions.get(index);
        }

        public static Iterator<Position> getPositions() {
            return Collections.unmodifiableList(positions).iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Display {
        NONE,
        HIDDEN,
        SHOWN;

    }
}

