/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.netbeans.junit.Log;
import org.netbeans.junit.diff.Diff;

public class Manager {
    public static final String JUNIT_PROPERTIES_FILENAME = "junit.properties";
    public static final String JUNIT_PROPERTIES_LOCATION_PROPERTY = "junit.properties.file";
    protected static final String PROP_DIFF_IMPL = "nbjunit.diff.impl";
    protected static final String DEFAULT_DIFF_IMPL = "org.netbeans.junit.diff.SimpleDiff";
    protected static Diff systemDiff = null;
    protected static Properties fPreferences = null;
    public static final String NBJUNIT_WORKDIR = "nbjunit.workdir";
    public static final String NBJUNIT_HOME = "nbjunit.home";

    private Manager() {
    }

    public static Diff getSystemDiff() {
        if (null == systemDiff) {
            Manager.readProperties();
            String string = fPreferences.getProperty(PROP_DIFF_IMPL);
            systemDiff = Manager.instantiateDiffImpl(string);
            if (null == systemDiff && !string.equals(DEFAULT_DIFF_IMPL)) {
                systemDiff = Manager.instantiateDiffImpl(DEFAULT_DIFF_IMPL);
            }
        }
        return systemDiff;
    }

    public static String getWorkDirPath() {
        String string = System.getProperty(NBJUNIT_WORKDIR);
        if (string == null) {
            Manager.readProperties();
            string = fPreferences.getProperty(NBJUNIT_WORKDIR);
        }
        string = string != null ? string.replace('/', File.separatorChar) : System.getProperty("java.io.tmpdir") + File.separatorChar + "tests-" + System.getProperty("user.name");
        return string;
    }

    public static String getNbJUnitHomePath() throws IOException {
        String string = System.getProperty(NBJUNIT_HOME);
        if (string == null) {
            Manager.readProperties();
            string = fPreferences.getProperty(NBJUNIT_HOME);
        }
        if (string != null) {
            string = string.replace('/', File.separatorChar);
            return string;
        }
        throw new IOException("Cannot determine NbJUnit home. Please make sure you have nbjunit.home propery set in your junit.properties file.");
    }

    public static File getNbJUnitHome() throws IOException {
        File file = Manager.normalizeFile(new File(Manager.getNbJUnitHomePath()));
        if (file.isDirectory()) {
            return file;
        }
        throw new IOException("Property nbjunit.home does not point to nbjunit home.");
    }

    protected static Diff instantiateDiffImpl(String string) {
        Diff diff;
        block5: {
            diff = null;
            Object var3_2 = null;
            Class[] classArray = null;
            try {
                classArray = new Class[]{Class.forName("java.lang.String")};
                Class<?> clazz = Class.forName(string);
                var3_2 = clazz.newInstance();
                if (!(var3_2 instanceof Diff)) break block5;
                diff = var3_2;
                Enumeration<?> enumeration = fPreferences.propertyNames();
                while (enumeration.hasMoreElements()) {
                    Method method;
                    String string2 = (String)enumeration.nextElement();
                    if (string2.equals(PROP_DIFF_IMPL) || !string2.startsWith(PROP_DIFF_IMPL)) continue;
                    String string3 = "set" + string2.substring(PROP_DIFF_IMPL.length() + 1);
                    try {
                        method = clazz.getMethod(string3, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        System.out.println("The method " + string3 + " not fond in class " + string + ".");
                        method = null;
                    }
                    if (null == method) continue;
                    method.invoke((Object)diff, fPreferences.getProperty(string2, ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return diff;
    }

    private static File getPreferencesFile() {
        Object object;
        String string = System.getProperty(JUNIT_PROPERTIES_LOCATION_PROPERTY);
        if (string != null && ((File)(object = new File(string))).exists()) {
            return object;
        }
        object = System.getProperty("user.home");
        return new File((String)object, JUNIT_PROPERTIES_FILENAME);
    }

    protected static void readProperties() {
        try {
            File file = Manager.getPreferencesFile();
            fPreferences = new Properties(fPreferences);
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                fPreferences.load(fileInputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File normalizeFile(File file) {
        Runnable runnable = Log.internalLog();
        try {
            Comparable<URI> comparable;
            if (System.getProperty("os.name").startsWith("Windows")) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    Logger.getLogger(Manager.class.getName()).warning("getCanonicalFile() on file " + file + " failed: " + iOException);
                    file = file.getAbsoluteFile();
                }
            } else {
                comparable = file.toURI().normalize();
                file = new File((URI)comparable).getAbsoluteFile();
            }
            comparable = file;
            return comparable;
        }
        finally {
            runnable.run();
        }
    }

    static {
        fPreferences = new Properties();
        fPreferences.put(PROP_DIFF_IMPL, DEFAULT_DIFF_IMPL);
    }
}

