/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.Helpers;

public final class CodePoint {
    private final int value;

    public static CodePoint valueOf(int value) {
        if (0 <= value && value < 128) {
            return CodePointCache.cache[value];
        }
        return new CodePoint(value);
    }

    private CodePoint(int value) {
        if (!Character.isValidCodePoint(value) || 55296 <= value && value <= 57343) {
            throw new IllegalArgumentException("Code point out of range: " + value);
        }
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CodePoint)) {
            return false;
        }
        return this.value == ((CodePoint)obj).value;
    }

    public static int hashCode(int value) {
        return Integer.hashCode(value);
    }

    public int hashCode() {
        return CodePoint.hashCode(this.value);
    }

    public int value() {
        return this.value;
    }

    public String toString() {
        return Helpers.ToCharLiteral(this.value);
    }

    private static class CodePointCache {
        static final int MAX_CACHE_KEY = 128;
        static final CodePoint[] cache = new CodePoint[128];

        private CodePointCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                CodePointCache.cache[i] = new CodePoint(i);
            }
        }
    }
}

