/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * LocServerPanel.java
 *
 * Created on 16 juil. 2009, 00:23:54
 */

package bt747.j2se_view;

import net.sf.bt747.j2se.app.utils.Utils;

import bt747.model.AppSettings;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.sys.Generic;

/**
 *
 * @author Mario
 */
public class LocationServerPanel extends javax.swing.JPanel implements
        bt747.model.ModelListener {
    /**
     * 
     */
    private static final long serialVersionUID = -3642905028556757106L;
    private Model m;
    private J2SEAppController c;

    /** Creates new form LocServerPanel */
    public LocationServerPanel() {
        initComponents();
    }

    /**
     * Called by BT747Main upon completion of the application startup.
     * 
     * @param pC
     *            the application controller
     */
    public void init(final J2SEAppController pC) {
        c = pC;
        m = c.getModel();
        m.addListener(this);
        initAppData();
    }

    private int locationsServed;
    private int locationsFailed;
    
    /**
     * Initialize the data this concrete Panel is working with and which is
     * not yet setup by BT747Main.
     */
    private void initAppData() {
        tfHostname.setText(m.getStringOpt(AppSettings.POS_SRV_HOSTNAME));
        tfPort.setText("" + m.getIntOpt(AppSettings.POS_SRV_PORT));
        tfFile.setText(m.getStringOpt(AppSettings.POS_SRV_FILE));
        tfPeriod.setText("" + m.getIntOpt(AppSettings.POS_SRV_PERIOD));
        tfUsername.setText(m.getStringOpt(AppSettings.POS_SRV_USER));
        tfPassword.setText(m.getStringOpt(AppSettings.POS_SRV_PASS));
        cbServeOnConnect.setSelected(m
                .getBooleanOpt(AppSettings.POS_SRV_AUTOSTART));
        locationsServed = 0;
        locationsFailed = 0;
    }

    private final String getString(final String org) {
        return J2SEAppController.getString(org);
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see bt747.model.ModelListener#modelEvent(bt747.model.ModelEvent)
     */
    public void modelEvent(final ModelEvent e) {
        final int type = e.getType();
        switch (type) {
        case ModelEvent.CONNECTED:
        case ModelEvent.DISCONNECTED:
            break;
        case ModelEvent.POS_SRV_FAILURE:
            locationsFailed++;
            locationsServed++;
            break;
        case ModelEvent.POS_SRV_SUCCESS:
            locationsServed++;
            try {
            lbVisualizeServing.setText(Utils.format(
                        getString("INFOLOCATIONS"), locationsServed,
                        locationsFailed));
            } catch (Exception b) {
                Generic.debug("Problem in 'INFOLOCATIONS' text", b);
            }
            break;
        }
    }

    private void locationServingParametersChanged() {
        if (c.isLocationServingActive()) {
            c.setBooleanOpt(AppSettings.POS_SRV_AUTOSTART, false);
            cbServeOnConnect.setSelected(false);
            c.stopGPSPositionServing();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {//GEN-BEGIN:initComponents

        pnLocationServer = new javax.swing.JPanel();
        lbHostname = new javax.swing.JLabel();
        tfHostname = new javax.swing.JTextField();
        lbPort = new javax.swing.JLabel();
        tfPort = new javax.swing.JTextField();
        lbFile = new javax.swing.JLabel();
        tfFile = new javax.swing.JTextField();
        tfPeriod = new javax.swing.JTextField();
        lbPeriod = new javax.swing.JLabel();
        tfUsername = new javax.swing.JTextField();
        lbUsername = new javax.swing.JLabel();
        tfPassword = new javax.swing.JPasswordField();
        lbPassword = new javax.swing.JLabel();
        cbServeOnConnect = new javax.swing.JCheckBox();
        lbServeOnConnect = new javax.swing.JLabel();
        lbVisualizeServing = new javax.swing.JLabel();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("bt747/j2se_view/Bundle"); // NOI18N
        pnLocationServer.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("LocServerPanel.jPanel1.border.title"))); // NOI18N
        pnLocationServer.setToolTipText(bundle.getString("LocServerPanel.jPanel1.toolTipText")); // NOI18N

        lbHostname.setLabelFor(tfHostname);
        lbHostname.setText(bundle.getString("LocServerPanel.lbHostname.text")); // NOI18N
        lbHostname.setToolTipText(bundle.getString("LocServerPanel.lbHostname.toolTipText")); // NOI18N

        tfHostname.setText(bundle.getString("LocationServerPanel.tfHostname.text")); // NOI18N
        tfHostname.setMinimumSize(new java.awt.Dimension(200, 20));
        tfHostname.setPreferredSize(new java.awt.Dimension(200, 20));
        tfHostname.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tfHostnameFocusLost(evt);
            }
        });

        lbPort.setLabelFor(tfPort);
        lbPort.setText(bundle.getString("LocServerPanel.lbPort.text")); // NOI18N
        lbPort.setToolTipText(bundle.getString("LocServerPanel.lbPort.toolTipText")); // NOI18N

        tfPort.setInputVerifier(J2SEAppController.IntVerifier);
        tfPort.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tfPortFocusLost(evt);
            }
        });

        lbFile.setLabelFor(tfFile);
        lbFile.setText(bundle.getString("LocServerPanel.lbFile.text")); // NOI18N
        lbFile.setToolTipText(bundle.getString("LocServerPanel.lbFile.toolTipText")); // NOI18N

        tfFile.setText(bundle.getString("LocationServerPanel.tfFile.text")); // NOI18N
        tfFile.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tfFileFocusLost(evt);
            }
        });

        tfPeriod.setText(bundle.getString("LocationServerPanel.tfPeriod.text")); // NOI18N
        tfPeriod.setInputVerifier(J2SEAppController.IntVerifier);
        tfPeriod.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tfPeriodActionPerformed(evt);
            }
        });
        tfPeriod.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tfPeriodFocusLost(evt);
            }
        });

        lbPeriod.setLabelFor(tfPeriod);
        lbPeriod.setText(bundle.getString("LocServerPanel.lbPeriod.text")); // NOI18N
        lbPeriod.setToolTipText(bundle.getString("LocServerPanel.lbPeriod.toolTipText")); // NOI18N

        tfUsername.setText(bundle.getString("LocationServerPanel.tfUsername.text")); // NOI18N
        tfUsername.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tfUsernameFocusLost(evt);
            }
        });

        lbUsername.setLabelFor(tfUsername);
        lbUsername.setText(bundle.getString("LocServerPanel.lbUsername.text")); // NOI18N
        lbUsername.setToolTipText(bundle.getString("LocServerPanel.lbUsername.toolTipText")); // NOI18N

        tfPassword.setText(bundle.getString("LocationServerPanel.tfPassword.text")); // NOI18N
        tfPassword.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tfPasswordFocusLost(evt);
            }
        });

        lbPassword.setLabelFor(tfPassword);
        lbPassword.setText(bundle.getString("LocServerPanel.lbPassword.text")); // NOI18N
        lbPassword.setToolTipText(bundle.getString("LocServerPanel.lbPassword.toolTipText")); // NOI18N

        cbServeOnConnect.setText(bundle.getString("LocServerPanel.cbServeOnConnect.text")); // NOI18N
        cbServeOnConnect.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                cbServeOnConnectItemStateChanged(evt);
            }
        });

        lbServeOnConnect.setText(bundle.getString("LocServerPanel.lbServeOnConnect.text")); // NOI18N
        lbServeOnConnect.setToolTipText(bundle.getString("LocServerPanel.lbServeOnConnect.toolTipText")); // NOI18N

        org.jdesktop.layout.GroupLayout pnLocationServerLayout = new org.jdesktop.layout.GroupLayout(pnLocationServer);
        pnLocationServer.setLayout(pnLocationServerLayout);
        pnLocationServerLayout.setHorizontalGroup(
            pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnLocationServerLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(pnLocationServerLayout.createSequentialGroup()
                        .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(lbHostname)
                            .add(lbPort)
                            .add(lbFile)
                            .add(lbPeriod)
                            .add(lbUsername)
                            .add(lbPassword)
                            .add(lbServeOnConnect))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(cbServeOnConnect)
                            .add(tfPassword, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(tfHostname, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(tfPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(tfFile, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(tfPeriod, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(tfUsername, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(lbVisualizeServing))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnLocationServerLayout.linkSize(new java.awt.Component[] {tfFile, tfHostname, tfPassword, tfPeriod, tfPort, tfUsername}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        pnLocationServerLayout.setVerticalGroup(
            pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnLocationServerLayout.createSequentialGroup()
                .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbHostname)
                    .add(tfHostname, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbPort)
                    .add(tfPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbFile)
                    .add(tfFile, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbPeriod)
                    .add(tfPeriod, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbUsername)
                    .add(tfUsername, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(tfPassword, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lbPassword))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnLocationServerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cbServeOnConnect)
                    .add(lbServeOnConnect))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(lbVisualizeServing)
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnLocationServer, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnLocationServer, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
    }//GEN-END:initComponents

    private void tfHostnameFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tfHostnameFocusLost
        if (!m.getStringOpt(AppSettings.POS_SRV_HOSTNAME).equals(
                tfHostname.getText())) {
            c
                    .setStringOpt(AppSettings.POS_SRV_HOSTNAME, tfHostname
                            .getText());
            this.locationServingParametersChanged();
        }
    }//GEN-LAST:event_tfHostnameFocusLost

    private void tfPortFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tfPortFocusLost
        int p = 80; // default for parse problem
        try {
            p = Integer.parseInt(tfPort.getText());
        } catch (NumberFormatException nfe) {
            // User has entered somethin weird
            // TODO "real" error handling
            tfPort.setText("80");
        }
        if (m.getIntOpt(AppSettings.POS_SRV_PORT) != p) {
            c.setIntOpt(AppSettings.POS_SRV_PORT, p);
            this.locationServingParametersChanged();
        }

    }//GEN-LAST:event_tfPortFocusLost

    private void tfFileFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tfFileFocusLost
        if (!m.getStringOpt(AppSettings.POS_SRV_FILE)
                .equals(tfFile.getText())) {
            c.setStringOpt(AppSettings.POS_SRV_FILE, tfFile.getText());
            this.locationServingParametersChanged();
        }
    }//GEN-LAST:event_tfFileFocusLost

    private void tfPeriodFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tfPeriodFocusLost
        int p = 300; // seconds, default for parse problem
        try {
                p = Integer.parseInt(tfPeriod.getText());
        } catch (NumberFormatException nfe) {
                // User has entered somethin weird
                // TODO "real" error handling
                tfPeriod.setText("300");
        }
        if (m.getIntOpt(AppSettings.POS_SRV_PERIOD) != p) {
                c.setIntOpt(AppSettings.POS_SRV_PERIOD, p);
                this.locationServingParametersChanged();
        }
    }//GEN-LAST:event_tfPeriodFocusLost

    private void tfUsernameFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tfUsernameFocusLost
        if (!m.getStringOpt(AppSettings.POS_SRV_USER).equals(
                tfUsername.getText())) {
            c.setStringOpt(AppSettings.POS_SRV_USER, tfUsername.getText());
            this.locationServingParametersChanged();
        }
    }//GEN-LAST:event_tfUsernameFocusLost

    private void tfPasswordFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tfPasswordFocusLost
        if (!m.getStringOpt(AppSettings.POS_SRV_PASS).equals(
                String.valueOf(tfPassword.getPassword()))) {
            c.setStringOpt(AppSettings.POS_SRV_PASS, String.copyValueOf(tfPassword.getPassword()));
            this.locationServingParametersChanged();
        }
    }//GEN-LAST:event_tfPasswordFocusLost

    private void cbServeOnConnectItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cbServeOnConnectItemStateChanged
        if (m.getBooleanOpt(AppSettings.POS_SRV_AUTOSTART) != cbServeOnConnect
                .isSelected()) {
            c.setBooleanOpt(AppSettings.POS_SRV_AUTOSTART, cbServeOnConnect
                    .isSelected());
        }
        if (cbServeOnConnect.isSelected()) {
            // Checkbox is set.
            lbVisualizeServing.setText("");
            c.startGPSPositionServing();
        } else {
            // Checkbox is not set
            c.stopGPSPositionServing();
        }
    }//GEN-LAST:event_cbServeOnConnectItemStateChanged

    private void tfPeriodActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tfPeriodActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_tfPeriodActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbServeOnConnect;
    private javax.swing.JLabel lbFile;
    private javax.swing.JLabel lbHostname;
    private javax.swing.JLabel lbPassword;
    private javax.swing.JLabel lbPeriod;
    private javax.swing.JLabel lbPort;
    private javax.swing.JLabel lbServeOnConnect;
    private javax.swing.JLabel lbUsername;
    private javax.swing.JLabel lbVisualizeServing;
    private javax.swing.JPanel pnLocationServer;
    private javax.swing.JTextField tfFile;
    private javax.swing.JTextField tfHostname;
    private javax.swing.JPasswordField tfPassword;
    private javax.swing.JTextField tfPeriod;
    private javax.swing.JTextField tfPort;
    private javax.swing.JTextField tfUsername;
    // End of variables declaration//GEN-END:variables

}
