/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * FilesPanel.java
 *
 * Created on 21 janv. 2009, 23:00:15
 */

package bt747.j2se_view;

import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JTable;
import javax.swing.table.TableColumn;

import bt747.j2se_view.model.LogFileTableModel;
import bt747.j2se_view.model.MapWaypoint;
import bt747.j2se_view.model.PositionData;
import bt747.j2se_view.popupmenu.LogFilePopupMenu;
import bt747.j2se_view.popupmenu.POIActionHandler;
import bt747.model.Controller;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;

/**
 *
 * @author Mario
 */
@SuppressWarnings("serial")
public class FilesPanel extends javax.swing.JPanel implements ModelListener, POIActionHandler {

    private final LogFileTableModel logFileModel = new LogFileTableModel();
    private final FileTablePanel fileTablePanel = new FileTablePanel();
    private WaypointMapKit map;
    
    /** Creates new form FilesPanel */
    public FilesPanel() {
        initComponents();
    }

    private J2SEAppController c;
    private J2SEAppModel m;

    public void init(final J2SEAppController pC) {
        c = pC;
        m = c.getAppModel();
        map.init(c);
        map.setZoomSliderVisible(false);
        map.setMiniMapVisible(false);
        logFileModel.setLogfileInfos(Model.logFiles);
        fileTablePanel.init(pC);
        fileTablePanel.setPOIActionHandler(this);
        tbLogFile.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        final FontMetrics fm = tbLogFile.getFontMetrics(tbLogFile.getFont());
        for (int i = tbLogFile.getColumnCount() - 1; i >= 0; i--) {
            final TableColumn col = tbLogFile.getColumnModel().getColumn(i);
            col.setPreferredWidth(logFileModel.getPreferredWidth(fm, i) + 4);
        }
        new LogFilePopupMenu(this,tbLogFile);

        m.addListener(this);
        
        m.getPositionData().addPropertyChangeListener(
                PositionData.WAYPOINTSELECTED, wpSelectedListener);
    }

    public void modelEvent(final ModelEvent e) {
        switch (e.getType()) {
        case ModelEvent.UPDATE_LOG_FILE_LIST:
            logFileModel.notifyUpdate();
            break;
        }
    }
    
    public void addPosition(Object e) {
    	if(e instanceof MapWaypoint) {
    		MapWaypoint w = (MapWaypoint) e;
    		if(!w.getGpsRecord().hasPosition()) {
    			w.setPosition(map.getCenterPosition());
    		}
    	}
    }
    
    private final PropertyChangeListener wpSelectedListener = new PropertyChangeListener() {

        public void propertyChange(PropertyChangeEvent evt) {
            try {
                final MapWaypoint w = (MapWaypoint) evt.getNewValue();
                map.setZoom(5);
            } catch (Exception e) {
                bt747.sys.Generic.debug("Waypoint selection", e);
                // TODO: handle exception
            }
        }
    };

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {//GEN-BEGIN:initComponents

        spFileTablePanel = new javax.swing.JScrollPane(fileTablePanel);
        map = new WaypointMapKit();
        jSplitPane1 = new javax.swing.JSplitPane();
        jSplitPane1.setBottomComponent(spFileTablePanel);
        jSplitPane2 = new javax.swing.JSplitPane();
        jSplitPane2.setRightComponent(map);
        spLogFile = new javax.swing.JScrollPane();
        tbLogFile = new javax.swing.JTable();

        jSplitPane1.setBorder(null);
        jSplitPane1.setDividerLocation(100);
        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setOneTouchExpandable(true);

        jSplitPane2.setOneTouchExpandable(true);

        tbLogFile.setModel(logFileModel);
        tbLogFile.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_NEXT_COLUMN);
        spLogFile.setViewportView(tbLogFile);

        jSplitPane2.setTopComponent(spLogFile);

        jSplitPane1.setLeftComponent(jSplitPane2);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 124, Short.MAX_VALUE)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jSplitPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 124, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 97, Short.MAX_VALUE)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jSplitPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 97, Short.MAX_VALUE))
        );
    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JScrollPane spFileTablePanel;
    private javax.swing.JScrollPane spLogFile;
    private javax.swing.JTable tbLogFile;
    // End of variables declaration//GEN-END:variables

}
