// ********************************************************************
// *** BT 747 ***
// *** April 14, 2007 ***
// *** (c)2007 Mario De Weerd ***
// *** m.deweerd@ieee.org ***
// *** ********************************************************** ***
// *** Software is provided "AS IS," without a warranty of any ***
// *** kind. ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES,***
// *** INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS ***
// *** FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY ***
// *** EXCLUDED. THE ENTIRE RISK ARISING OUT OF USING THE SOFTWARE ***
// *** IS ASSUMED BY THE USER. ***
// *** See the GNU General Public License Version 3 for details. ***
// *** *********************************************************** ***
package bt747.j2se_view;

import java.awt.Component;

import net.sf.bt747.j2se.app.utils.Utils;

import gps.log.out.CommonOut;
import gps.mvc.MtkController;
import gps.mvc.MtkModel;


import bt747.model.AppSettings;
import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.interfaces.BT747Int;

/**
 * 
 * @author Mario De Weerd
 */
public final class AgpsPanel extends javax.swing.JPanel
        implements ModelListener {

    /**
     * 
     */
    private static final long serialVersionUID = 9139717181351131626L;

    private J2SEAppController c;
    private Model m;

    /** Creates new form AdvancedDeviceSettingsPanel */
    public AgpsPanel() {
        initComponents();

    }

    public void init(final J2SEAppController pC) {
        c = pC;
        m = c.getModel();
        m.addListener(this);

        txtAgpsUrl.setVisible(false);
        updateConnected();
        updateAppURL();
    }

    private final void updateAppURL() {
        txtAgpsUrl.setText(m.getStringOpt(AppSettings.AGPSURL));
    }
    
    public void modelEvent(final ModelEvent e) {
        // TODO Auto-generated method stub
        final int type = e.getType();
        switch (type) {
        case ModelEvent.CONNECTED:
        case ModelEvent.DISCONNECTED:
            updateConnected();
            break;
        case ModelEvent.SETTING_CHANGE:
            switch (Integer.parseInt((String)e.getArg())) {
            case AppSettings.AGPSURL:
                txtAgpsUrl.setText(m.getStringOpt(AppSettings.AGPSURL));
                break;
            default:
                break;
            }
            break;
        case ModelEvent.DATA_UPDATE:
            switch(((BT747Int)e.getArg()).getValue()) {
            case MtkModel.DATA_AGPS_STORED_RANGE:
                updateAgps();
                break;
            }
            break;
        }
    }

    
   
    private final void updateAgps() {
        final Component[] components = { lbAgpsUrl, txtAgpsUrl, btClearAgpsData };
        final MtkModel mtk = m.mtkModel();
        final boolean hasAgps = mtk.hasAgps();
        for (final Component panel : components) {
            J2SEAppController.enableComponentHierarchy(panel, hasAgps);
        }
        btUploadAgpsData.setEnabled(hasAgps && m.isConnected());
        if (mtk.hasAgps()) {
            final String text1 = Utils.format(J2SEAppController
                    .getString("AGPSINFO1"), mtk.getAgpsDataCount(),
                    CommonOut.getDateTimeStr(mtk.getAgpsStartTime()),
                    CommonOut.getDateTimeStr(mtk.getAgpsEndTime()));
            final String text2 = Utils.format(J2SEAppController
                    .getString("AGPSINFO2"), CommonOut.getDateTimeStr(mtk
                    .getAgpsStart2Time()), CommonOut.getDateTimeStr(mtk
                    .getAgpsEnd2Time()));
            txtAgpsInfo1.setText(text1);
            txtAgpsInfo2.setText(text2);
        }
        txtAgpsInfo1.setVisible(mtk.hasAgps());
        txtAgpsInfo2.setVisible(mtk.hasAgps());
        //osmAccountPanel.setVisible(false);
        btDownloadAgpsData.setVisible(false);
    }

    private final void updateConnected() {
        final Component[] components = {};
        for (final Component panel : components) {
            J2SEAppController
                    .enableComponentHierarchy(panel, m.isConnected());
        }
        updateAgps();
    }


    /**
     * This method is called from within the constructor to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {//GEN-BEGIN:initComponents

        agpsPanel = new javax.swing.JPanel();
        txtAgpsUrl = new javax.swing.JTextField();
        lbAgpsUrl = new javax.swing.JLabel();
        btUploadAgpsData = new javax.swing.JButton();
        btDownloadAgpsData = new javax.swing.JButton();
        txtAgpsInfo1 = new javax.swing.JLabel();
        txtAgpsInfo2 = new javax.swing.JLabel();
        btClearAgpsData = new javax.swing.JButton();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("bt747/j2se_view/Bundle"); // NOI18N
        agpsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("AgpsPanel.agpsPanel.border.title"))); // NOI18N

        txtAgpsUrl.setText(bundle.getString("AgpsPanel.txtAgpsUrl.text")); // NOI18N
        txtAgpsUrl.setToolTipText(bundle.getString("AgpsPanel.txtAgpsUrl.toolTipText")); // NOI18N
        txtAgpsUrl.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                txtAgpsUrlFocusLost(evt);
            }
        });

        lbAgpsUrl.setText(bundle.getString("AgpsPanel.lbAgpsUrl.text")); // NOI18N

        btUploadAgpsData.setText(bundle.getString("AgpsPanel.btUploadAgpsData.text")); // NOI18N
        btUploadAgpsData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btUploadAgpsDataActionPerformed(evt);
            }
        });

        btDownloadAgpsData.setText(bundle.getString("AgpsPanel.btDownloadAgpsData.text")); // NOI18N

        txtAgpsInfo1.setText(bundle.getString("AgpsPanel.txtAgpsInfo1.text")); // NOI18N

        txtAgpsInfo2.setText(bundle.getString("AgpsPanel.txtAgpsInfo2.text")); // NOI18N

        btClearAgpsData.setText(bundle.getString("AgpsPanel.btClearAgpsData.text")); // NOI18N
        btClearAgpsData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btClearAgpsDataActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout agpsPanelLayout = new org.jdesktop.layout.GroupLayout(agpsPanel);
        agpsPanel.setLayout(agpsPanelLayout);
        agpsPanelLayout.setHorizontalGroup(
            agpsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(agpsPanelLayout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(agpsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(agpsPanelLayout.createSequentialGroup()
                        .add(lbAgpsUrl)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(txtAgpsUrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 351, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(agpsPanelLayout.createSequentialGroup()
                        .add(btUploadAgpsData)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btClearAgpsData)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btDownloadAgpsData))
                    .add(txtAgpsInfo1)
                    .add(txtAgpsInfo2)))
        );
        agpsPanelLayout.setVerticalGroup(
            agpsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(agpsPanelLayout.createSequentialGroup()
                .add(agpsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbAgpsUrl)
                    .add(txtAgpsUrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(agpsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(btUploadAgpsData)
                    .add(btClearAgpsData)
                    .add(btDownloadAgpsData))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(txtAgpsInfo1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(txtAgpsInfo2))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(agpsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(agpsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
    }//GEN-END:initComponents

    private void txtAgpsUrlFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_txtAgpsUrlFocusLost
        c.setStringOpt(AppSettings.AGPSURL,txtAgpsUrl.getText());
    }//GEN-LAST:event_txtAgpsUrlFocusLost

    private void btUploadAgpsDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btUploadAgpsDataActionPerformed
        c.downloadAndUploadAgpsData();
    }//GEN-LAST:event_btUploadAgpsDataActionPerformed

    private void btClearAgpsDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btClearAgpsDataActionPerformed
        c.gpsCmd(MtkController.CMD_EPO_CLEAR);
    }//GEN-LAST:event_btClearAgpsDataActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel agpsPanel;
    private javax.swing.JButton btClearAgpsData;
    private javax.swing.JButton btDownloadAgpsData;
    private javax.swing.JButton btUploadAgpsData;
    private javax.swing.JLabel lbAgpsUrl;
    private javax.swing.JLabel txtAgpsInfo1;
    private javax.swing.JLabel txtAgpsInfo2;
    private javax.swing.JTextField txtAgpsUrl;
    // End of variables declaration//GEN-END:variables

}
