/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.sys.Time;

public class Random {
    public static final int IA = 16807;
    public static final int IM = Integer.MAX_VALUE;
    public static final int IQ = 127773;
    public static final int IR = 2836;
    public static final int ZERO_SEED_REPLACEMENT = 234123;
    private int seed;

    public Random() {
        Time t = new Time();
        this.seed = t.hour * 60 * 60 + t.minute * 60 + t.second + 100 * t.millis;
    }

    public Random(int _seed) {
        this.seed = _seed << 1 >>> 1;
        if (this.seed == 0) {
            this.seed = 234123;
        }
    }

    public int getRandom(int n) {
        return this.nextInt(n);
    }

    protected int next(int bits) {
        int k = this.seed / 127773;
        this.seed = 16807 * (this.seed - k * 127773) - 2836 * k;
        if (this.seed < 0) {
            this.seed += Integer.MAX_VALUE;
        }
        return this.seed >> 31 - bits;
    }

    public double nextDouble() {
        return (double)this.next(24) / 1.6777216E7;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            return -1;
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public char rand(char s, char e) {
        return (char)this.rand((int)s, (int)e);
    }

    public int rand(int s, int e) {
        int rnd;
        if (s > e) {
            int t = e;
            e = s;
            s = t;
        } else if (s == e) {
            ++e;
        }
        while (s > (rnd = this.nextInt(e)) || rnd > e) {
        }
        return rnd;
    }
}

