/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.io.DataStream;
import waba.sys.Settings;
import waba.util.ElementNotFoundError;
import waba.util.IntVector;

public class IntHashtable {
    public static int INVALID = Integer.MIN_VALUE;
    protected Entry[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;
    public int collisions;

    public IntHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0) {
            initialCapacity = 5;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashtable(DataStream ds) {
        this.table = new Entry[ds.readInt()];
        this.loadFactor = ds.readFloat();
        this.threshold = ds.readInt();
        int n = ds.readInt();
        int i = 0;
        while (i < n) {
            this.put(ds.readInt(), ds.readInt());
            ++i;
        }
    }

    public void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public boolean exists(int key) {
        int index = (key & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int get(int key) throws ElementNotFoundError {
        int index = (key & Integer.MAX_VALUE) % this.table.length;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Key not found: " + key);
        }
        return INVALID;
    }

    public IntVector getKeys() {
        return this.getKeysOrValues(true);
    }

    private IntVector getKeysOrValues(boolean isKeys) {
        int[] array = new int[this.count];
        int len = this.table.length;
        int n = 0;
        int i = 0;
        while (i < len) {
            Entry entry = this.table[i];
            while (entry != null) {
                array[n++] = isKeys ? entry.key : entry.value;
                entry = entry.next;
            }
            ++i;
        }
        return new IntVector(array);
    }

    public IntVector getValues() {
        return this.getKeysOrValues(false);
    }

    public int put(int key, int value) {
        if (key == INVALID || value == INVALID) {
            return INVALID;
        }
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                int old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        Entry e2 = new Entry();
        e2.key = key;
        e2.value = value;
        e2.next = tab[index];
        if (e2.next != null) {
            ++this.collisions;
        }
        tab[index] = e2;
        ++this.count;
        return INVALID;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldTable = this.table;
        int newCapacity = ((oldCapacity << 1) + oldCapacity >> 1) + 1;
        if (Settings.onDevice) {
            if (oldCapacity == 16382) {
                newCapacity = 20000;
            } else if (newCapacity > 16382) {
                newCapacity = 16382;
            }
        }
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public int remove(int key) throws ElementNotFoundError {
        Entry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        if (Settings.useExceptions) {
            throw new ElementNotFoundError("Key not found: " + key);
        }
        return INVALID;
    }

    public void saveTo(DataStream ds) {
        ds.writeInt(this.table.length);
        ds.writeFloat(this.loadFactor);
        ds.writeInt(this.threshold);
        ds.writeInt(this.count);
        int len = this.table.length;
        Entry entry = null;
        int i = 0;
        while (i < len) {
            entry = this.table[i];
            if (entry != null) {
                ds.writeInt(entry.key);
                ds.writeInt(entry.value);
                while (entry.next != null) {
                    entry = entry.next;
                    ds.writeInt(entry.key);
                    ds.writeInt(entry.value);
                }
            }
            ++i;
        }
    }

    public int size() {
        return this.count;
    }

    protected static class Entry {
        int key;
        int value;
        Entry next;

        protected Entry() {
        }
    }
}

