/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Time;

public class Date {
    public static String[] monthNames = new String[]{"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private int day;
    private int month;
    private int year;
    private static int epochYear = 1920;
    public boolean wasDateValid;
    private static int[] parts = new int[3];
    private static int[][] part2idx;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final boolean FORWARD = true;
    public static final boolean BACKWARD = false;
    private static byte[] monthDays;

    static {
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[0];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 2;
        nArray3[1] = 1;
        nArrayArray[3] = nArray3;
        part2idx = nArrayArray;
        byte[] byArray = new byte[13];
        byArray[1] = 31;
        byArray[2] = 28;
        byArray[3] = 31;
        byArray[4] = 30;
        byArray[5] = 31;
        byArray[6] = 30;
        byArray[7] = 31;
        byArray[8] = 31;
        byArray[9] = 30;
        byArray[10] = 31;
        byArray[11] = 30;
        byArray[12] = 31;
        monthDays = byArray;
    }

    public Date() {
        this.setToday();
    }

    public Date(int sentDate) {
        this.day = sentDate % 100;
        this.month = sentDate / 100 % 100;
        this.year = sentDate / 10000;
        this.verifyDate();
    }

    public Date(int sentDay, int sentMonth, int sentYear) {
        this.day = sentDay;
        this.month = sentMonth;
        this.year = sentYear;
        this.verifyDate();
    }

    public Date(String strDate) {
        this(strDate, Settings.dateFormat);
    }

    public Date(String strDate, byte dateFormat) {
        if (strDate != null && strDate.length() > 0) {
            char[] chars = strDate.toCharArray();
            int j = 0;
            int n = chars.length;
            int[] p = parts;
            int start = 0;
            int len = 0;
            int i = 0;
            while (i < n) {
                char c = chars[i];
                if (c >= '0' && c <= '9') {
                    ++len;
                } else {
                    if (j == 2) {
                        j = 3;
                        break;
                    }
                    p[j++] = Convert.toInt(new String(chars, start, len));
                    start += len + 1;
                    len = 0;
                }
                ++i;
            }
            if (j == 2) {
                p[j++] = Convert.toInt(new String(chars, start, len));
                this.day = p[part2idx[dateFormat][0]];
                this.month = p[part2idx[dateFormat][1]];
                this.year = p[part2idx[dateFormat][2]];
            }
        }
        this.verifyDate();
    }

    public Date(Time t) {
        this.day = t.day;
        this.month = t.month;
        this.year = t.year;
        this.verifyDate();
    }

    public void advance(int numberDays) {
        int numberofDays = this.getJulianDay() + numberDays;
        int y = 0;
        int i = epochYear;
        while (numberofDays >= 366) {
            if (numberofDays == 366 && i % 4 == 0) break;
            if (i % 4 == 0) {
                numberofDays -= 366;
                ++y;
            } else {
                numberofDays -= 365;
                ++y;
            }
            ++i;
        }
        this.year = epochYear + y;
        i = 1;
        while (numberofDays > this.getDaysInMonth(i)) {
            numberofDays -= this.getDaysInMonth(i);
            ++i;
        }
        this.month = i;
        this.day = numberofDays;
        if (!this.doesDateExist()) {
            this.month = 1;
            this.day = 1;
            this.year = 1983;
        }
    }

    public void advanceMonth() {
        this.advanceMonth(true);
    }

    public void advanceMonth(boolean direction) {
        if (direction) {
            ++this.month;
            if (this.month == 13) {
                ++this.year;
                this.month = 1;
            }
        } else {
            --this.month;
            if (this.month == 0) {
                --this.year;
                this.month = 12;
            }
        }
        this.day = 1;
        if (!this.doesDateExist()) {
            this.month = 1;
            this.day = 1;
            this.year = 1983;
        }
    }

    public void advanceWeek() {
        this.advanceWeek(true);
    }

    public void advanceWeek(boolean direction) {
        this.advance(-1 * this.getDayOfWeek());
        this.advance(direction ? 7 : -7);
        if (!this.doesDateExist()) {
            this.month = 1;
            this.day = 1;
            this.year = 1983;
        }
    }

    private boolean doesDateExist() {
        if (this.year >= 0 && this.year < 20) {
            this.year += 2000;
        } else if (this.year >= 20 && this.year < 100) {
            this.year += 1900;
        }
        return this.day > 0 && this.month >= 1 && this.month <= 12 && this.day <= this.getDaysInMonth() && this.year >= epochYear && this.year < 3000;
    }

    public boolean equals(Object sentDate) {
        if (sentDate instanceof Date) {
            return this.getDateInt() == ((Date)sentDate).getDateInt();
        }
        return sentDate == this;
    }

    public static String formatDate(int day, int month, int year) {
        return Date.formatDate(day, month, year, Settings.dateFormat);
    }

    public static String formatDate(int day, int month, int year, byte dateFormat) {
        int i1 = day;
        int i2 = month;
        int i3 = year;
        if (dateFormat == 1) {
            i1 = month;
            i2 = day;
            i3 = year;
        } else if (dateFormat == 3) {
            i1 = year;
            i2 = month;
            i3 = day;
        }
        return String.valueOf(Convert.zeroPad(Convert.toString(i1), 2)) + Settings.dateSeparator + Convert.zeroPad(Convert.toString(i2), 2) + Settings.dateSeparator + Convert.zeroPad(Convert.toString(i3), 2);
    }

    public String formatDayMonth() {
        int i1 = this.day;
        int i2 = this.month;
        if (Settings.dateFormat != 2) {
            i1 = this.month;
            i2 = this.day;
        }
        return String.valueOf(Convert.zeroPad(Convert.toString(i1), 2)) + Settings.dateSeparator + Convert.zeroPad(Convert.toString(i2), 2);
    }

    public String getDate() {
        return Date.formatDate(this.day, this.month, this.year);
    }

    public int getDateInt() {
        return this.year * 10000 + this.month * 100 + this.day;
    }

    public int getDay() {
        return this.day;
    }

    public int getDayOfWeek() {
        int yy = this.year;
        int a = (yy - 1582) * 365;
        int b = (yy - 1581) / 4;
        int c = (yy - 1501) / 100;
        int d = (yy - 1201) / 400;
        int mm = this.month;
        int e = (mm - 1) * 31;
        int f = this.day;
        int g = (mm + 7) / 10;
        int h = (int)(((float)mm * 0.4f + 2.3f) * (float)g);
        int i = 1 / (yy % 4 + 1) * g;
        int j = 1 / (yy % 100 + 1) * g;
        int k = 1 / (yy % 400 + 1) * g;
        int l = a + b - c + d + e + f - h + i - j + k + 5;
        int m = l % 7;
        return m > 0 ? m - 1 : 6;
    }

    private int getDaysFromMonth() {
        int numberofDays = 0;
        int i = this.month - 1;
        while (i >= 1) {
            numberofDays += this.getDaysInMonth(i);
            --i;
        }
        return numberofDays;
    }

    public int getDaysInMonth() {
        return this.getDaysInMonth(this.month);
    }

    public int getDaysInMonth(int month) {
        return Date.getDaysInMonth(month, this.year);
    }

    public static int getDaysInMonth(int month, int year) {
        if (month != 2) {
            return monthDays[month];
        }
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        return leap ? 29 : 28;
    }

    public int getJulianDay() {
        int numberofDays = (this.year - epochYear) * 365 + this.getNumLeapDays(this.year) - this.getNumLeapDays(epochYear);
        numberofDays += this.getDaysFromMonth();
        return numberofDays += this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public static String getMonthName(int m) {
        if (m >= 1 && m <= 12) {
            return monthNames[m];
        }
        return "";
    }

    private int getNumLeapDays(int iYear) {
        int div4 = (iYear + 3) / 4;
        int div100 = (iYear + 99) / 100;
        int div400 = (iYear + 399) / 400;
        return div4 - div100 + div400;
    }

    public int getWeek() {
        int w = this.getJulianDay() / 7 % 52;
        if (w == 0) {
            w = 52;
        }
        return w;
    }

    public int getYear() {
        return this.year;
    }

    public boolean isAfter(Date sentDate) {
        return this.getDateInt() > sentDate.getDateInt();
    }

    public boolean isBefore(Date sentDate) {
        return this.getDateInt() < sentDate.getDateInt();
    }

    public void setToday() {
        Time tTime = new Time();
        this.day = tTime.day;
        this.month = tTime.month;
        this.year = tTime.year;
        this.wasDateValid = true;
    }

    public String toString() {
        return Date.formatDate(this.day, this.month, this.year);
    }

    public String toString(byte format) {
        return Date.formatDate(this.day, this.month, this.year, format);
    }

    private void verifyDate() {
        boolean ok = this.doesDateExist();
        if (!ok) {
            this.setToday();
        }
        this.wasDateValid = ok;
    }
}

