/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.sys.Settings;
import waba.ui.Button;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.PenEvent;
import waba.ui.Timer;
import waba.ui.Window;

public class ScrollBar
extends Container {
    public static final byte VERTICAL = 1;
    public static final byte HORIZONTAL = 2;
    private int maximum = 100;
    private int minimum = 0;
    private int blockIncrement = 50;
    private int unitIncrement = 1;
    private int value;
    private int visibleItems = 50;
    private double valuesPerPixel;
    private int dragBarSize;
    private int btnWH;
    private Button btnInc;
    private Button btnDec;
    private int startDragPos = -1;
    private boolean verticalBar;
    private int dragBarPos;
    private boolean liveScrolling;
    private int size;
    private int dragBarMax;
    private int dragBarMin;
    private Color bColor;
    private Color sbColor;
    private Color sfColor;
    private Color sbColorDis;
    private Color[] fourColors = new Color[4];
    public static int extraArrowSize;
    public int minDragBarSize = 5 * Settings.screenHeight / 160;
    private ControlEvent buttonScrollEvent = new ControlEvent(300, null);
    private Timer autoScrollTimer;
    private Control autoScrollTarget;
    private boolean buttonScroll;
    private int autoScrollBarPos;
    public static int INITIAL_DELAY;
    public static int AUTO_DELAY;

    static {
        INITIAL_DELAY = 600;
        AUTO_DELAY = 100;
    }

    public ScrollBar() {
        this(1);
    }

    public ScrollBar(byte orientation) {
        this.verticalBar = orientation == 1;
        this.btnDec = Button.createArrowButton(this.verticalBar ? (byte)1 : 3, this.fmH * 3 / 11 + extraArrowSize, Color.BLACK);
        this.btnInc = Button.createArrowButton(this.verticalBar ? (byte)2 : 4, this.fmH * 3 / 11 + extraArrowSize, Color.BLACK);
        this.btnInc.focusTraversable = false;
        this.btnDec.focusTraversable = false;
        this.add(this.btnDec);
        this.add(this.btnInc);
        this.btnDec.setBorder(Control.uiPalm ? (byte)0 : 2);
        this.btnInc.setBorder(Control.uiPalm ? (byte)0 : 2);
        this.started = true;
    }

    public void clear() {
        this.setValue(this.clearValueInt);
    }

    private void disableAutoScroll() {
        this.removeTimer(this.autoScrollTimer);
        this.autoScrollTimer = null;
        this.autoScrollTarget = null;
        if (this.buttonScroll) {
            this.buttonScroll = false;
            this.enableButtons();
        }
    }

    private void enableButtons() {
        Control foc;
        boolean b = true;
        Window win = this.getParentWindow();
        if (!this.buttonScroll) {
            b = this.enabled && this.value > this.minimum;
            this.btnDec.setEnabled(b);
        }
        if (!b && win != null && win.getFocus() == this.btnDec) {
            this.requestFocus();
        }
        if (!this.buttonScroll) {
            b = this.enabled && this.value + this.visibleItems < this.maximum;
            this.btnInc.setEnabled(b);
        }
        Control control = foc = win == null ? null : win.getFocus();
        if (!(b || foc != null && foc != this.btnDec && foc != this.btnInc)) {
            this.requestFocus();
            if (!b && win != null && win.getFocus() == this.btnInc) {
                this.requestFocus();
            }
        }
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getPreferredHeight() {
        return this.verticalBar ? this.btnDec.getPreferredWidth() << 1 : this.btnDec.getPreferredHeight();
    }

    public int getPreferredWidth() {
        return this.verticalBar ? this.btnDec.getPreferredWidth() : this.btnDec.getPreferredHeight() << 1;
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getValue() {
        return this.value;
    }

    public int getVisibleItems() {
        return this.visibleItems;
    }

    private void onAutoScroll() {
        if (this.autoScrollBarPos < this.dragBarPos) {
            this.value -= this.blockIncrement / 2;
        } else if (this.autoScrollBarPos > this.dragBarPos + this.dragBarSize) {
            this.value += this.blockIncrement / 2;
        } else {
            this.startDragPos = this.autoScrollBarPos - this.dragBarPos;
            this.disableAutoScroll();
        }
    }

    protected void onBoundsChanged() {
        this.size = this.verticalBar ? this.height : this.width;
        this.btnWH = this.verticalBar ? this.width : this.height;
        this.btnDec.setRect(0, 0, this.btnWH, this.btnWH);
        this.btnInc.setRect(this.verticalBar ? 0 : this.size - this.btnWH, this.verticalBar ? this.size - this.btnWH : 0, this.btnWH, this.btnWH);
        this.dragBarPos = this.dragBarMin;
        this.recomputeParams(false);
    }

    protected void onColorsChanged(boolean colorsChanged) {
        if (colorsChanged) {
            this.btnDec.setBackForeColors(this.backColor, this.foreColor);
            this.btnInc.setBackForeColors(this.backColor, this.foreColor);
        }
        if (Control.uiPalm) {
            this.bColor = this.backColor;
            this.sbColor = this.getForeColor();
            this.sbColorDis = this.sbColor.brighter();
            this.sfColor = this.enabled ? this.sbColor.brighter() : this.sbColor;
        } else {
            this.bColor = this.getBackColor().brighter();
        }
        if (this.parent != null && this.bColor.equ == this.parent.getBackColor().equ) {
            this.bColor = this.bColor.getCursorColor();
        }
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
    }

    public void onEvent(Event event) {
        int oldValue = this.value;
        boolean mustPostEvent = false;
        switch (event.type) {
            case 303: {
                if (this.autoScrollTimer == null) break;
                if (this.autoScrollTarget == this) {
                    this.autoScrollTimer.millis = AUTO_DELAY;
                    this.onAutoScroll();
                    break;
                }
                this.autoScrollTimer.millis = AUTO_DELAY;
                this.postEvent(this.buttonScrollEvent);
                break;
            }
            case 300: {
                if (event.target == this.btnDec) {
                    this.value = Math.max(this.minimum, this.value - this.unitIncrement);
                    event.consumed = true;
                    if (this.buttonScroll) break;
                    this.requestFocus();
                    break;
                }
                if (event.target != this.btnInc) break;
                this.value = Math.min(this.maximum, this.value + this.unitIncrement);
                event.consumed = true;
                if (this.buttonScroll) break;
                this.requestFocus();
                break;
            }
            case 200: {
                if (event.target == this) {
                    int pos;
                    this.autoScrollTimer = this.addTimer(INITIAL_DELAY);
                    this.autoScrollTarget = this;
                    this.autoScrollBarPos = pos = this.verticalBar ? ((PenEvent)event).y : ((PenEvent)event).x;
                    if (pos < this.dragBarPos) {
                        this.value -= this.blockIncrement;
                        break;
                    }
                    if (pos > this.dragBarPos + this.dragBarSize) {
                        this.value += this.blockIncrement;
                        break;
                    }
                    this.startDragPos = pos - this.dragBarPos;
                    break;
                }
                if (event.target != this.btnInc && event.target != this.btnDec) break;
                this.autoScrollTimer = this.addTimer(INITIAL_DELAY);
                this.autoScrollTarget = (Control)event.target;
                this.buttonScroll = true;
                this.buttonScrollEvent.target = this.autoScrollTarget;
                break;
            }
            case 203: {
                if (this.startDragPos != -1) {
                    int pos = this.verticalBar ? ((PenEvent)event).y : ((PenEvent)event).x;
                    this.dragBarPos = pos - this.startDragPos;
                    if (this.dragBarPos < this.dragBarMin) {
                        this.dragBarPos = this.dragBarMin;
                    } else if (this.dragBarPos > this.dragBarMax) {
                        this.dragBarPos = this.dragBarMax;
                    }
                    if (this.dragBarPos == this.dragBarMax) {
                        this.value = Math.max(0, this.maximum - this.visibleItems);
                    } else {
                        this.value = (int)((double)(this.dragBarPos - this.dragBarMin) / this.valuesPerPixel);
                        if (this.unitIncrement != 1) {
                            this.value = this.value / this.unitIncrement * this.unitIncrement;
                        }
                        this.value += this.minimum;
                    }
                }
                this.autoScrollBarPos = this.verticalBar ? ((PenEvent)event).y : ((PenEvent)event).x;
                break;
            }
            case 202: {
                if (this.autoScrollTimer != null) {
                    this.disableAutoScroll();
                }
                this.startDragPos = -1;
                mustPostEvent = this.btnDec.enabled || this.btnInc.enabled;
                break;
            }
            case 100: {
                KeyEvent ke = (KeyEvent)event;
                if (ke.isPrevKey()) {
                    if (this.btnDec.enabled) {
                        this.value -= Settings.keyboardFocusTraversable ? this.unitIncrement : this.blockIncrement;
                    }
                    event.consumed = true;
                    mustPostEvent = true;
                    break;
                }
                if (ke.isNextKey()) {
                    if (this.btnInc.enabled) {
                        this.value += Settings.keyboardFocusTraversable ? this.unitIncrement : this.blockIncrement;
                    }
                    event.consumed = true;
                    mustPostEvent = true;
                    break;
                }
                if (!ke.isActionKey()) break;
                this.parent.requestFocus();
                Control.isHighlighting = true;
                break;
            }
        }
        if (this.value != oldValue) {
            if (this.value > this.maximum - this.visibleItems) {
                this.value = this.maximum - this.visibleItems;
                this.removeTimer(this.autoScrollTimer);
            } else if (this.value <= this.minimum) {
                this.value = this.minimum;
                this.removeTimer(this.autoScrollTimer);
            }
            if (this.value != oldValue) {
                this.recomputeParams(true);
                if (this.liveScrolling || mustPostEvent) {
                    this.postEvent(new ControlEvent(300, this));
                }
                this.repaint();
            }
        } else if (mustPostEvent) {
            this.parent.postEvent(new ControlEvent(300, this));
            Control.isHighlighting = false;
        }
    }

    public void onPaint(Graphics g) {
        if (Control.uiPalm) {
            g.setBackColor(this.backColor);
            g.fillRect(0, 0, this.width, this.height);
            g.setBackColor(this.btnDec.enabled || this.btnInc.enabled ? this.sbColor : this.sbColorDis);
            g.setForeColor(this.sfColor);
            int h = Settings.screenWidth == 320 ? 5 : 3;
            int c = this.btnWH >> 1;
            int s = this.btnWH - h >> 1;
            if (this.verticalBar) {
                g.drawLine(c, this.btnWH, c, this.size - this.btnWH);
                g.fillRect(s, this.dragBarPos, h, this.dragBarSize);
            } else {
                g.drawLine(this.btnWH, c, this.size - this.btnWH, c);
                g.fillRect(this.dragBarPos, s, this.dragBarSize, h);
            }
        } else {
            int k = this.size - (this.btnWH << 1);
            if (k <= 0) {
                return;
            }
            g.setBackColor(this.bColor);
            if (this.verticalBar) {
                g.fillRect(0, this.btnWH, this.btnWH, k);
            } else {
                g.fillRect(this.btnWH, 0, k, this.btnWH);
            }
            g.setBackColor(this.backColor);
            if (Control.uiFlat) {
                g.setForeColor(this.fourColors[2]);
                g.drawRect(0, 0, this.width, this.height);
            }
            if (this.verticalBar) {
                if (Control.uiVista && this.enabled) {
                    g.fill3dRect(0, this.dragBarPos, this.width, this.dragBarSize, this.backColor, false, true);
                } else {
                    g.fillRect(0, this.dragBarPos, this.width, this.dragBarSize);
                }
                g.draw3dRect(0, this.dragBarPos, this.width, this.dragBarSize, Control.uiVista ? (byte)4 : 3, false, false, this.fourColors);
                if (Control.uiFlat || Control.uiVista) {
                    k = this.dragBarPos + (this.dragBarSize >> 1);
                    g.drawLine(3, k, this.width - 4, k);
                    if (this.dragBarSize > this.minDragBarSize) {
                        g.drawLine(3, k - 2, this.width - 4, k - 2);
                        g.drawLine(3, k + 2, this.width - 4, k + 2);
                    }
                }
            } else {
                if (Control.uiVista && this.enabled) {
                    g.fill3dRect(this.dragBarPos, 0, this.dragBarSize, this.height, this.backColor, false, false);
                } else {
                    g.fillRect(this.dragBarPos, 0, this.dragBarSize, this.height);
                }
                g.draw3dRect(this.dragBarPos, 0, this.dragBarSize, this.height, Control.uiVista ? (byte)4 : 3, false, false, this.fourColors);
                if (Control.uiFlat || Control.uiVista) {
                    k = this.dragBarPos + (this.dragBarSize >> 1);
                    g.drawLine(k, 3, k, this.height - 4);
                    if (this.dragBarSize > this.minDragBarSize) {
                        g.drawLine(k - 2, 3, k - 2, this.height - 4);
                        g.drawLine(k + 2, 3, k + 2, this.height - 4);
                    }
                }
            }
        }
    }

    private void recomputeParams(boolean justValue) {
        if (this.size <= 0) {
            return;
        }
        if (!justValue) {
            int delta = Math.max(this.visibleItems, this.maximum - this.minimum);
            int barArea = this.size - (this.btnWH << 1);
            if (Control.uiFlat) {
                barArea += 2;
            }
            this.valuesPerPixel = (double)barArea / (double)delta;
            this.dragBarSize = Math.min(barArea, (int)(this.valuesPerPixel * (double)this.visibleItems) + 1);
            if (this.dragBarSize < this.minDragBarSize) {
                this.dragBarSize = this.minDragBarSize;
            }
            this.dragBarMin = !Control.uiFlat ? this.btnWH : this.btnWH - 1;
            this.dragBarMax = this.size - this.dragBarMin - this.dragBarSize;
        }
        this.dragBarPos = Math.min(this.dragBarMax, this.dragBarMin + (int)(this.valuesPerPixel * (double)(this.value - this.minimum) + 0.5));
        this.enableButtons();
    }

    public void setBlockIncrement(int i) {
        this.blockIncrement = i;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            if (this.foreDis == null) {
                this.backDis = this.backColor.darker();
                this.foreDis = this.foreColor.brighter();
            }
            this.btnDec.setEnabled(enabled && this.value > this.minimum);
            this.btnInc.setEnabled(enabled && this.value + this.visibleItems < this.maximum);
            this.onColorsChanged(false);
            this.repaint();
        }
    }

    public void setHighlighting() {
    }

    public void setLiveScrolling(boolean liveScrolling) {
        this.liveScrolling = liveScrolling;
    }

    public void setMaximum(int i) {
        if (i != this.maximum) {
            this.maximum = i;
            if (this.value > i) {
                this.value = i;
            }
            this.recomputeParams(false);
        }
    }

    public void setMinimum(int i) {
        if (i != this.minimum) {
            this.minimum = i;
            if (this.value < i) {
                this.value = i;
            }
            this.recomputeParams(false);
            this.repaint();
        }
    }

    public void setUnitIncrement(int i) {
        this.unitIncrement = i;
        this.repaint();
    }

    public void setValue(int i) {
        if (i != this.value) {
            this.value = this.visibleItems + i + this.minimum <= this.maximum ? i : this.maximum - this.visibleItems;
            this.recomputeParams(true);
            this.repaint();
        }
    }

    public void setValues(int newValue, int newVisibleItems, int newMinimum, int newMaximum) {
        this.maximum = newMaximum;
        this.minimum = newMinimum;
        this.blockIncrement = this.visibleItems = Math.max(newVisibleItems, 1);
        this.value = this.visibleItems + newValue + this.minimum <= this.maximum ? newValue : this.maximum - this.visibleItems;
        if (this.value < this.minimum) {
            this.value = this.minimum;
        }
        this.recomputeParams(false);
        this.repaint();
    }

    public void setVisibleItems(int i) {
        this.visibleItems = i;
        if (this.visibleItems <= 0) {
            this.visibleItems = 1;
        }
        this.blockIncrement = this.visibleItems;
        this.recomputeParams(false);
        this.repaint();
    }
}

