/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Graphics;
import waba.fx.Image;
import waba.sys.Settings;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.MainWindow;
import waba.ui.Timer;
import waba.ui.UIColors;
import waba.ui.Window;

public class Keypad
extends Control {
    private static Keypad kp;
    public static String[] numberKeyset;
    public static String[] defaultKeyset;
    public static int CLOSE_TIMEOUT;
    public static int X_ALIGN;
    public static int Y_ALIGN;
    public static int Y_ALIGN_ALT;
    public static final int MODE_LOWER = 0;
    public static final int MODE_UPPER = 1;
    public static final int MODE_NUMBER = 2;
    public static int mode;
    private char[][] charsL;
    private char[][] charsU;
    private char[][] chars;
    private short[][] posxL;
    private short[][] posxU;
    private short[][] posx;
    private int lastKey = -1;
    private int lastIndex;
    private Timer timer;
    private KeyEvent ke = new KeyEvent();
    private Image backImg;
    private Graphics backG;
    private int hashW;
    private char[] numberKeys;
    private short[] numberKeyX;

    static {
        numberKeyset = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        defaultKeyset = new String[]{" 0", ".,'?!\"1-()@/:", "abc2\u00e1\u00e3\u00e2\u00e0\u00e7", "def3\u00e9\u00ea", "ghi4\u00ed", "jkl5", "mno6\u00f3\u00f5\u00f4", "pqrs7$", "tuv8\u00fa\u00fc", "wxyz9"};
        CLOSE_TIMEOUT = 1200;
        X_ALIGN = 120000;
        Y_ALIGN = 149997;
        Y_ALIGN_ALT = 140003;
        mode = 0;
    }

    private Keypad() {
        this.setFocusLess(true);
        this.setVisible(false);
        this.ke.type = 100;
        this.setKeys(defaultKeyset);
        this.modeChanged();
        this.backColor = UIColors.keypadBack;
        this.foreColor = UIColors.keypadFore;
        try {
            this.backImg = new Image(Settings.screenWidth, this.fmH + 2);
            this.backG = this.backImg.getGraphics();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.backImg = null;
        }
        MainWindow.mainWindowInstance.add(this);
    }

    private void close() {
        this.removeTimer(false);
        this.setVisible(false);
        this.restoreBack();
    }

    private void drawCursor() {
        short[] px = this.lastKey == -13 ? this.numberKeyX : this.posx[this.lastKey];
        short xx = px[this.lastIndex];
        MainWindow.myg0.drawCursor(xx + 1 + this.x, this.y + 1, px[this.lastIndex + 1] - xx, this.fmH);
    }

    public static Keypad getInstance() {
        if (kp == null) {
            kp = new Keypad();
        }
        return kp;
    }

    public void handleKey(int key) {
        if (key == 35 && this.numberKeys != null && this.numberKeys.length == 1) {
            this.postKeyEvent(this.numberKeys[0]);
            if (this.visible) {
                this.restoreBack();
                this.reposition(0);
                this.removeTimer(false);
            }
        } else if (key == 35 && this.numberKeys == null) {
            mode = (mode + 1) % 3;
            this.modeChanged();
            if (this.visible) {
                this.restoreBack();
                this.reposition(0);
                this.removeTimer(true);
            }
        } else if (key >= 48 && key <= 57 && this.chars[key - 48].length == 1) {
            this.postKeyEvent(this.chars[key - 48][0]);
            this.removeTimer(false);
        } else if (mode == 2 || key == 42) {
            this.postKeyEvent(key == 42 ? 75011 : key);
            this.removeTimer(false);
        } else {
            key -= 48;
            this.removeTimer(true);
            boolean wasVisible = this.visible;
            if (!wasVisible) {
                this.lastKey = -1;
            }
            if (key != this.lastKey) {
                if (wasVisible) {
                    this.restoreBack();
                    if (this.lastKey != -1) {
                        this.postKeyEvent(this.lastKey == -13 ? this.numberKeys[this.lastIndex] : this.chars[this.lastKey][this.lastIndex]);
                    }
                }
                this.lastIndex = 0;
                this.lastKey = key;
                this.reposition(0);
            } else if (wasVisible) {
                this.drawCursor();
                if (++this.lastIndex == (key == -13 ? this.numberKeys.length : this.chars[key].length)) {
                    this.lastIndex = 0;
                }
                this.drawCursor();
            }
        }
    }

    private void modeChanged() {
        this.chars = mode == 0 ? this.charsL : this.charsU;
        this.posx = mode == 0 ? this.posxL : this.posxU;
    }

    public void onEvent(Event e) {
        if (e.type == 303 && this.timer != null && this.timer.triggered) {
            this.close();
            if (mode != 2 && this.lastKey >= 0 && this.lastIndex >= 0) {
                this.postKeyEvent(this.chars[this.lastKey][this.lastIndex]);
            } else if (this.lastKey == -13) {
                this.postKeyEvent(this.numberKeys[this.lastIndex]);
            }
        }
    }

    public void onPaint(Graphics g) {
        g.setBackColor(this.backColor);
        g.setForeColor(this.foreColor);
        g.fillRect(0, 0, this.width, this.height);
        g.drawRect(0, 0, this.width, this.height);
        if (mode == 2) {
            g.drawText("#", 2, 2);
        } else if (this.lastKey >= 0 || this.lastKey == -13) {
            char[] chars = this.lastKey == -13 ? this.numberKeys : this.chars[this.lastKey];
            short[] px = this.lastKey == -13 ? this.numberKeyX : this.posx[this.lastKey];
            int n = chars.length;
            int i = 0;
            while (i < n) {
                g.drawText(chars, i, 1, px[i] + 3, 1);
                ++i;
            }
            this.drawCursor();
        }
    }

    private void postKeyEvent(int c) {
        Control focus = Window.topMost.getFocus();
        if (focus != null) {
            this.ke.target = focus;
            this.ke.key = c;
            focus.postEvent(this.ke);
        }
    }

    private void removeTimer(boolean addAgain) {
        if (this.timer != null) {
            this.removeTimer(this.timer);
        }
        this.timer = addAgain ? this.addTimer(CLOSE_TIMEOUT) : null;
    }

    private void reposition(int chance) {
        int ypos;
        int n = ypos = chance == 1 ? Y_ALIGN_ALT : Y_ALIGN;
        if (mode == 2) {
            this.setRect(X_ALIGN, ypos, this.hashW + 4, this.fmH + 2);
        } else {
            short[] px = this.lastKey == -13 ? this.numberKeyX : this.posx[this.lastKey];
            this.setRect(X_ALIGN, ypos, px[px.length - 1] + 2, this.fmH + 2);
        }
        Control focus = Window.topMost.getFocus();
        if (focus != null && focus.getRect().intersects(this.getRect()) && chance < 3) {
            this.reposition(chance + 1);
        } else {
            if (!this.visible) {
                this.saveBack();
            }
            this.setVisible(true);
            Window.getTopMost().validate();
            this.repaintNow();
        }
    }

    private void restoreBack() {
        if (this.backImg != null) {
            MainWindow.myg0.copyRect(this.backImg, this.x, 0, this.width, this.height, this.x, this.y);
        } else {
            Window.repaintActiveWindows(0);
        }
    }

    private void saveBack() {
        if (this.backImg != null) {
            this.backG.copyRect(MainWindow.mainWindowInstance, 0, this.y, Settings.screenWidth, this.height, 0, 0);
        }
    }

    public void setKeys(String[] newKeyset) {
        if (newKeyset == null) {
            newKeyset = defaultKeyset;
        }
        int ni = newKeyset.length;
        this.posxL = new short[ni][];
        this.posxU = new short[ni][];
        this.charsL = new char[ni][];
        this.charsU = new char[ni][];
        int i = ni - 1;
        while (i >= 0) {
            String keys = newKeyset[i];
            int nj = keys.length();
            this.posxL[i] = new short[nj + 1];
            this.posxU[i] = new short[nj + 1];
            this.charsL[i] = keys.toCharArray();
            this.charsU[i] = keys.toUpperCase().toCharArray();
            short[] pxl = this.posxL[i];
            short[] pxu = this.posxU[i];
            int j = 0;
            while (j < nj) {
                int w = this.fm.getCharWidth(this.charsL[i][j]);
                pxl[j + 1] = (short)(pxl[j] + w + 2);
                w = this.fm.getCharWidth(this.charsU[i][j]);
                pxu[j + 1] = (short)(pxu[j] + w + 2);
                ++j;
            }
            --i;
        }
        this.hashW = this.fm.getCharWidth('#');
        this.modeChanged();
    }

    public void setNumberKeys(String nk) {
        if (nk == null) {
            this.numberKeyX = null;
            this.numberKeys = null;
        } else {
            this.numberKeys = nk.toCharArray();
            short[] pxl = this.numberKeyX = new short[this.numberKeys.length + 1];
            int j = 0;
            while (j < this.numberKeys.length) {
                int w = this.fm.getCharWidth(this.numberKeys[j]);
                pxl[j + 1] = (short)(pxl[j] + w + 4);
                ++j;
            }
        }
    }
}

