/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Rect;
import waba.sys.Settings;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.PushButtonGroup;
import waba.ui.UIColors;
import waba.ui.Window;

public class Keyboard
extends Window {
    private Control destControl;
    private Rect destRect;
    private Container destCont;
    private PushButtonGroup[] pbs = new PushButtonGroup[6];
    private KeyEvent ke = new KeyEvent();
    private byte[] rows = new byte[]{4, 4, 4, 3, 1, 1};
    public static int[] px = new int[]{110001, 119996, 129999, 120000, 110001, 129999};
    public static int[] py = new int[]{190004, 180000, 180000, 190004, 149998, 149998};
    public static byte[] ig = new byte[]{8, 4, 7, 5, 6, 7};
    public static int[] extraH = new int[]{8, 8, 8, 6, 2, 2};
    public static final int KEYBOARD_ON_UNPOP = Event.getNextAvailableEventId();
    public static final int KEYBOARD_POST_UNPOP = Event.getNextAvailableEventId();
    private boolean isCaps;
    private boolean isShift;
    public static final int NUMERIC_PAD = 0;
    public static final int SYMBOLS_PAD = 1;
    public static final int ACCENT_PAD = 2;
    public static final int TEXT_PAD = 3;
    public static final int CAPS_PAD = 4;
    public static final int SPECIAL_PAD = 5;
    public static final int LANG_NORMAL = 1;
    public static final int LANG_HEBREW = 2;
    public static final int LANG_GERMAN = 3;
    public static final int LANG_TURKISH = 4;
    public static String[][] names = new String[][]{{"1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "0", ","}, {"+", "$", "&", "(", ")", "-", "#", "@", "[", "]", "*", "%", "|", "{", "}", "/", "=", "\\", "<", ">"}, {"\u00e1", "\u00e0", "\u00e3", "\u00e0", "\u00e2", "\u00e9", "\u00ea", "\u00e8", "\u00ed", "\u00f3", "\u00f4", "\u00f5", "\u00f6", "\u00fa", "\u00e7", "\u00f1"}, {"q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "'", "_", "a", "s", "d", "f", "g", "h", "j", "k", "l", ":", "~", "^", "z", "x", "c", "v", "b", "n", "m", "!", "?", ";", "\"", "`"}, {"Caps", "Shift"}, {"                  ", "\u00ab", "Done"}};
    public static String[][] namesUp = new String[][]{null, null, null, null, null, null};

    public Keyboard() {
        super(" Keyboard ", (byte)1);
        int w;
        this.highResPrepared = true;
        if (Settings.isColor) {
            this.setBackColor(UIColors.keyboardBack);
        }
        if ((w = Settings.screenWidth) == 320 || w == 176) {
            Keyboard.names[5][0] = "                ";
        }
        if (Control.uiCE) {
            Keyboard.names[5][0] = names[5][0].substring(w == 240 ? 4 : 2);
        }
        this.setDoubleBuffer(true);
    }

    private void cancelShift() {
        if (this.isShift) {
            this.isShift = false;
            this.pbs[4].setSelected(-1);
            this.updateShiftPad(false);
        }
    }

    private void convertToUpper() {
        int i;
        String[] from = names[2];
        String[] to = new String[from.length];
        try {
            i = from.length - 1;
            while (i >= 0) {
                to[i] = from[i].toUpperCase();
                --i;
            }
        }
        catch (NullPointerException nullPointerException) {}
        Keyboard.namesUp[2] = to;
        from = names[3];
        to = new String[from.length];
        try {
            i = from.length - 1;
            while (i >= 0) {
                to[i] = from[i].toUpperCase();
                --i;
            }
        }
        catch (NullPointerException nullPointerException) {}
        Keyboard.namesUp[3] = to;
    }

    private void insertKey(int key) {
        this.ke.key = key;
        this.destControl.onEvent(this.ke);
    }

    protected void loadBehind(boolean release) {
        super.loadBehind(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(Event event) {
        switch (event.type) {
            case 100: {
                switch (((KeyEvent)event).key) {
                    case 76000: 
                    case 76001: {
                        this.unpop();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 300: {
                PushButtonGroup pb;
                int sel;
                if (!(event.target instanceof PushButtonGroup) || (sel = (pb = (PushButtonGroup)event.target).getSelected()) < 0) return;
                String st = pb.getSelectedCaption();
                if (pb.appId == 5 || pb.appId == 4) {
                    int key = -1;
                    switch (st.charAt(0)) {
                        case 'D': {
                            pb.setSelected(-1);
                            this.unpop();
                            break;
                        }
                        case ' ': {
                            key = 32;
                            break;
                        }
                        case 'S': {
                            this.isShift ^= true;
                            this.isCaps = false;
                            break;
                        }
                        case 'C': {
                            this.isCaps ^= true;
                            this.isShift = false;
                            break;
                        }
                        default: {
                            key = 75011;
                        }
                    }
                    if (key != -1) {
                        this.insertKey(key);
                        return;
                    }
                    if (pb.appId != 4) return;
                    this.updateShiftPad(this.isShift || this.isCaps);
                    return;
                }
                this.insertKey(st.charAt(0));
                this.cancelShift();
                return;
            }
        }
    }

    protected void onPopup() {
        int i;
        boolean is320;
        this.destControl = Window.topMost.getFocus();
        this.destRect = this.destControl.getRect();
        this.destCont = this.destControl.getParent();
        boolean bl = is320 = Settings.screenWidth == 320;
        if (this.pbs[0] == null) {
            int ng;
            Color[] colors = null;
            if (Settings.isColor) {
                colors = new Color[]{UIColors.keyboardFore, UIColors.keyboardFore, UIColors.keyboardFore, UIColors.keyboardFore, UIColors.keyboardAction, UIColors.keyboardAction};
            }
            if (Control.uiCE) {
                px[0] = px[0] - 1;
                px[4] = px[4] - 1;
            }
            int n = ng = Control.uiCE ? -2 : -1;
            if (is320) {
                i = 0;
                while (i < this.pbs.length) {
                    int n2 = i;
                    ig[n2] = (byte)(ig[n2] << 1);
                    int n3 = i++;
                    extraH[n3] = extraH[n3] << 1;
                }
                px[1] = px[1] - 4;
            }
            i = 0;
            while (i < this.pbs.length) {
                this.pbs[i] = new PushButtonGroup(names[i], false, -1, i != 5 ? ng : 2, ig[i], this.rows[i], i < 4, i != 4 ? (byte)1 : 2);
                this.add(this.pbs[i]);
                if (colors != null) {
                    this.pbs[i].setBackColor(colors[i]);
                }
                this.pbs[i].appId = i;
                this.pbs[i].setFocusLess(true);
                ++i;
            }
            this.convertToUpper();
        }
        this.add(this.destControl);
        int hh = this.pbs[0].getPreferredHeight() + this.pbs[3].getPreferredHeight() + this.pbs[4].getPreferredHeight() + this.destControl.getPreferredHeight() + this.getPreferredHeight() + (is320 ? 50 : 34);
        int ww = this.pbs[3].getPreferredWidth() + 6;
        this.setRect(120000, 120000, ww, hh);
        this.destControl.setRect(120000, 140002, Math.min(this.destRect.width, this.width - 10), 100000);
        i = 0;
        while (i < this.pbs.length) {
            this.pbs[i].setRect(px[i], py[i], 100000, 100000 + extraH[i]);
            ++i;
        }
        if (this.imgCovered != null) {
            this.imgCovered.free();
            this.imgCovered = null;
        }
        this.saveBehind();
        this.ke.target = this.destControl;
    }

    protected void onUnpop() {
        this.destControl.onEvent(new ControlEvent(KEYBOARD_ON_UNPOP, this.destControl));
        this.destControl.setRect(this.destRect.x, this.destRect.y, this.destRect.width, this.destRect.height);
        this.destCont.add(this.destControl);
    }

    protected void onWindowPaintFinished() {
        this.destControl.requestFocus();
    }

    protected void postUnpop() {
        this.destControl.onEvent(new ControlEvent(KEYBOARD_POST_UNPOP, this.destControl));
        this.postPressedEvent();
    }

    public static void setLanguage(int lang) {
        switch (lang) {
            case 2: {
                String[] newKeys = new String[28];
                int i = 0;
                while (i < 27) {
                    newKeys[i] = String.valueOf((char)(224 + i));
                    ++i;
                }
                Keyboard.names[2] = newKeys;
                Keyboard.px[1] = 190002;
                break;
            }
            case 3: {
                Keyboard.names[2] = new String[]{String.valueOf('\u00e4'), String.valueOf('\u00c4'), String.valueOf('\u00f6'), String.valueOf('\u00d6'), String.valueOf('\u00fc'), String.valueOf('\u00dc'), String.valueOf('\u00df'), null};
                Keyboard.names[3][5] = "z";
                Keyboard.names[3][24] = "y";
                break;
            }
            case 4: {
                Keyboard.names[2] = new String[]{String.valueOf('\u00c7'), String.valueOf('\u00d0'), String.valueOf('\u00d6'), String.valueOf('\u00dc'), String.valueOf('\u00dd'), String.valueOf('\u00de'), String.valueOf('\u00e7'), String.valueOf('\u00f0'), String.valueOf('\u00f6'), String.valueOf('\u00fc'), String.valueOf('\u00fd'), String.valueOf('\u00fe')};
                break;
            }
        }
    }

    private void updateShiftPad(boolean shift) {
        this.pbs[3].names = shift ? namesUp[3] : names[3];
        this.pbs[2].names = shift ? namesUp[2] : names[2];
        this.pbs[3].repaint();
        this.pbs[2].repaint();
    }
}

