/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.sys.Settings;
import waba.ui.Button;
import waba.ui.Container;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.ListBox;
import waba.ui.PenEvent;
import waba.ui.PopList;
import waba.ui.UIColors;

public class ComboBox
extends Container {
    protected PopList pop;
    private Button btn;
    private boolean armed;
    private boolean opened;
    private int btnW;
    private Color bColor;
    private Color fColor;
    private Color[] fourColors = new Color[4];
    private boolean recomputePopRect = true;
    public boolean fullHeight;
    public boolean fullWidth;
    public static int extraArrowSize;

    public ComboBox() {
        this((Object[])null);
    }

    public ComboBox(ListBox userListBox) {
        this(new PopList(userListBox));
    }

    public ComboBox(PopList userPopList) {
        this.pop = userPopList;
        this.btn = Button.createArrowButton((byte)2, this.fmH * (Control.uiFlat || Control.uiVista ? 2 : 3) / 11 + extraArrowSize, Color.BLACK);
        if (!Control.uiCE) {
            this.btn.setBorder((byte)0);
        }
        this.btn.focusTraversable = false;
        super.add(this.btn);
        this.started = true;
    }

    public ComboBox(Object[] items) {
        this(new ListBox(items));
    }

    public void add(Object item) {
        this.pop.lb.add(item);
        this.recomputePopRect = true;
        this.repaint();
    }

    public void add(Control control) {
    }

    public void add(Object[] items) {
        this.pop.lb.add(items);
        this.recomputePopRect = true;
        this.repaint();
    }

    public void clear() {
        this.select(this.clearValueInt);
    }

    public void enableHorizScroll() {
        this.pop.lb.enableHorizScroll();
    }

    public Object getItemAt(int i) {
        return this.pop.lb.getItemAt(i);
    }

    public Object[] getItems() {
        return this.pop.lb.getItems();
    }

    public int getPreferredHeight() {
        return this.fmH + Edit.prefHs[Settings.uiStyle];
    }

    public int getPreferredWidth() {
        return this.pop.getPreferredWidth() + 1;
    }

    public int getSelectedIndex() {
        return this.pop.lb.selectedIndex;
    }

    public Object getSelectedItem() {
        return this.pop.lb.getSelectedItem();
    }

    public int indexOf(Object name) {
        return this.pop.lb.indexOf(name);
    }

    public void insert(Object item, int index) {
        this.pop.lb.insert(item, index);
        this.recomputePopRect = true;
        this.repaint();
    }

    protected void onBoundsChanged() {
        Rect r = this.getAbsoluteRect();
        this.pop.setRect(r.x, r.y, this.width, this.height);
        this.btnW = this.btn.getPreferredWidth();
        switch (Settings.uiStyle) {
            case 1: {
                this.btn.setRect(0, 0, this.btnW, this.height - 1);
                break;
            }
            case 0: {
                this.btn.setRect(this.width - this.btnW - 2, 2, this.btnW, this.height - 4);
                break;
            }
            default: {
                this.btn.setRect(this.width - this.btnW - 3, 1, this.btnW + 2, this.height - 2);
            }
        }
        this.recomputePopRect = true;
    }

    protected void onColorsChanged(boolean colorsChanged) {
        this.bColor = UIColors.sameColors ? this.backColor : this.getBackColor().brighter();
        this.fColor = this.getForeColor();
        if (colorsChanged) {
            this.btn.setBackForeColors(Control.uiFlat || Control.uiVista ? this.bColor : this.backColor, this.foreColor);
            this.pop.lb.setBackForeColors(this.backColor, this.foreColor);
        }
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
    }

    public void onEvent(Event event) {
        if (this.opened && event.type != 499) {
            return;
        }
        switch (event.type) {
            case 498: {
                if (event.target == this.getParentWindow()) {
                    this.onBoundsChanged();
                } else {
                    this.recomputePopRect = true;
                }
                this.repaint();
                break;
            }
            case 203: {
                PenEvent pe = (PenEvent)event;
                boolean inside = this.contains(this.x + pe.x, this.y + pe.y);
                if (event.target != this || inside == this.armed || this.pop.lb.itemCount <= 0) break;
                this.armed = inside;
                if (Control.uiPalm) {
                    this.repaint();
                    break;
                }
                this.btn.press(this.armed);
                break;
            }
            case 200: {
                if (event.target != this || this.armed || this.pop.lb.itemCount <= 0) break;
                if (Control.uiPalm) {
                    this.repaint();
                } else {
                    this.btn.press(true);
                }
                this.armed = true;
                break;
            }
            case 202: {
                PenEvent pe = (PenEvent)event;
                boolean inside = this.contains(this.x + pe.x, this.y + pe.y);
                if (event.target != this || !inside || !this.armed) break;
                if (Control.uiPalm) {
                    this.repaint();
                } else {
                    this.btn.press(false);
                }
                this.armed = false;
                this.opened = true;
                this.popupPop();
                break;
            }
            case 499: {
                if (event.target != this.pop) break;
                this.opened = false;
                this.repaintNow();
                this.postEvent(new ControlEvent(300, this));
                break;
            }
            case 300: {
                if (event.target != this.btn || this.pop.lb.itemCount <= 0) break;
                this.btn.appId = this.appId;
                event.consumed = true;
                this.requestFocus();
                this.popupPop();
                break;
            }
            case 301: 
            case 302: {
                if (event.target != this.btn) break;
                event.target = this;
                break;
            }
            case 101: {
                this.btn.simulatePress();
                this.popupPop();
                break;
            }
        }
    }

    protected void onFontChanged() {
        if (this.pop != null) {
            this.pop.setFont(this.font);
        }
    }

    public void onPaint(Graphics g) {
        if (Control.uiVista && this.enabled) {
            g.fill3dRect(0, 0, this.width, this.height, this.bColor, false, false);
        } else if (Control.uiPalm && this.armed) {
            g.setBackColor(this.btn.aColor);
            g.fillRect(this.btnW, 0, this.width - this.btnW, this.height);
        } else {
            g.setBackColor(this.bColor);
            g.fillRect(0, 0, this.width, this.height);
        }
        if (Control.uiPalm) {
            g.setClip(this.btnW, 0, this.width - this.btnW - 1, this.height - 1);
        } else {
            g.draw3dRect(0, 0, this.width, this.height, (byte)4, false, false, this.fourColors);
            g.setClip(2, 2, this.width - this.btnW - 3, this.height - 4);
        }
        if (this.pop.lb.itemCount > 0 && this.pop.lb.selectedIndex >= 0) {
            g.setForeColor(Control.uiPalm && this.armed ? this.bColor : this.fColor);
            this.pop.lb.drawItem(g, this.pop.lb.selectedIndex, Control.uiPalm ? this.btnW + 3 : 3, this.height - this.fmH >> 1);
        }
    }

    public void popupPop() {
        if (this.recomputePopRect) {
            this.recomputePopRect = false;
            Rect r = this.getAbsoluteRect();
            this.pop.fullHeight = this.fullHeight;
            this.pop.fullWidth = this.fullWidth;
            this.pop.setRect(r.x, r.y, this.width, this.height);
            int sel = this.pop.lb.selectedIndex;
            this.pop.lb.selectedIndex = -2;
            this.pop.lb.select(sel);
        }
        this.pop.popupModal();
        this.pop.lb.requestFocus();
    }

    public void qsort() {
        this.pop.lb.qsort();
        this.select(-1);
    }

    public void remove(int itemIndex) {
        this.pop.lb.remove(itemIndex);
        this.recomputePopRect = true;
        this.repaint();
    }

    public void remove(Object item) {
        this.pop.lb.remove(item);
        this.recomputePopRect = true;
        this.repaint();
    }

    public void remove(Control control) {
    }

    public void removeAll() {
        this.pop.lb.removeAll();
        this.recomputePopRect = true;
        this.repaint();
    }

    public void select(int i) {
        this.pop.lb.select(i);
        this.repaint();
    }

    public void select(Object name) {
        this.pop.lb.select(name);
    }

    public void selectLast() {
        this.pop.lb.selectLast();
        this.repaintNow();
    }

    public void setCursorColor(Color color) {
        this.pop.lb.setCursorColor(color);
    }

    public void setItemAt(int i, Object s) {
        this.pop.lb.setItemAt(i, s);
        this.recomputePopRect = true;
        this.repaint();
    }

    public int size() {
        return this.pop.lb.itemCount;
    }
}

