/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.IOError;
import waba.io.NativeMethods4JDK;
import waba.io.Stream;
import waba.sys.Settings;
import waba.sys.Time;

public class File
extends Stream {
    protected String path;
    Object jfile;
    Object jraf;
    public int lastError;
    public static final int DONT_OPEN = 0;
    public static final int READ_ONLY = 1;
    public static final int WRITE_ONLY = 2;
    public static final int READ_WRITE = 3;
    public static final int CREATE = 4;
    public static final byte TIME_ALL = 15;
    public static final byte TIME_CREATED = 1;
    public static final byte TIME_MODIFIED = 2;
    public static final byte TIME_ACCESSED = 4;
    public static final int ATTR_ARCHIVE = 1;
    public static final int ATTR_HIDDEN = 2;
    public static final int ATTR_READ_ONLY = 4;
    public static final int ATTR_SYSTEM = 8;
    public static String[] winceVols = new String[]{"\\Storage Card2\\", "\\Storage Card1\\", "\\SD Card\\", "\\Storage Card\\", "\\SD-MMCard\\", "\\CF Card\\"};

    public File(String path) {
        this(path, 0, -1);
    }

    public File(String path, int mode) {
        this(path, mode, -1);
    }

    public File(String path, int mode, int slot) {
        this.path = path;
        NativeMethods4JDK.fileCreate(this, path, mode, slot);
    }

    public boolean close() {
        return NativeMethods4JDK.fileClose(this);
    }

    public boolean createDir() {
        return NativeMethods4JDK.fileCreateDir(this);
    }

    public boolean delete() {
        return NativeMethods4JDK.fileDelete(this);
    }

    public boolean exists() {
        return NativeMethods4JDK.fileExists(this);
    }

    public void finalize() {
    }

    public int getAttributes() {
        return NativeMethods4JDK.fileGetAttributes(this);
    }

    public static File getCardVolume() {
        if (Settings.platform.equals("WindowsCE") || Settings.platform.equals("PocketPC")) {
            int i = winceVols.length - 1;
            while (i >= 0) {
                File f = new File(winceVols[i]);
                if (f.isDir()) {
                    return f;
                }
                --i;
            }
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public int getSize() {
        return NativeMethods4JDK.fileGetSize(this);
    }

    public Time getTime(byte whichTime) {
        return NativeMethods4JDK.fileGetTime(this, whichTime);
    }

    public static boolean isAvailable() {
        return NativeMethods4JDK.fileIsAvailable();
    }

    public static boolean isCardInserted(int slot) {
        return NativeMethods4JDK.fileIsInserted(slot);
    }

    public boolean isDir() {
        return NativeMethods4JDK.fileIsDir(this);
    }

    public boolean isOpen() {
        return NativeMethods4JDK.fileIsOpen(this);
    }

    public String[] listFiles() {
        return NativeMethods4JDK.fileListFiles(this);
    }

    public int readBytes(byte[] b, int off, int len) {
        return NativeMethods4JDK.fileReadBytes(this, b, off, len);
    }

    public boolean rename(String path) {
        return NativeMethods4JDK.fileRename(this, path);
    }

    public void setAttributes(int attr) {
        NativeMethods4JDK.fileSetAttributes(this, attr);
    }

    public boolean setPos(int pos) throws IOError {
        boolean ok = NativeMethods4JDK.fileSetPos(this, pos);
        if (!ok && Settings.useExceptions) {
            throw new IOError("Set pos failed for " + pos + (!this.isOpen() ? ". Reason: the File is closed" : ". Possible reason: there are two instances of the same file, and one instance is blocking the other."));
        }
        return ok;
    }

    public void setSize(int newSize) {
        NativeMethods4JDK.fileSetSize(this, newSize);
    }

    public void setTime(byte whichTime, Time time) {
        NativeMethods4JDK.fileSetTime(this, whichTime, time);
    }

    public int writeBytes(byte[] b, int off, int len) {
        return NativeMethods4JDK.fileWriteBytes(this, b, off, len);
    }
}

