/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.Stream;
import waba.sys.Convert;
import waba.sys.Vm;

public class DataStream
extends Stream {
    protected Stream stream;
    protected byte[] b = new byte[4];
    protected static byte[] bytes = new byte[128];

    public DataStream(Stream stream) {
        this.stream = stream;
    }

    public boolean close() {
        if (this.stream != null) {
            return this.stream.close();
        }
        return true;
    }

    public Stream getStream() {
        return this.stream;
    }

    public boolean isOpen() {
        return this.stream.isOpen();
    }

    public final int pad(int n) {
        if (bytes.length < n) {
            bytes = new byte[n + 16];
        }
        int i = 0;
        while (i < n) {
            DataStream.bytes[i] = 0;
            ++i;
        }
        return this.stream.writeBytes(bytes, 0, n);
    }

    public final boolean readBoolean() {
        this.stream.readBytes(this.b, 0, 1);
        return this.b[0] != 0;
    }

    public final byte readByte() {
        this.stream.readBytes(this.b, 0, 1);
        return this.b[0];
    }

    public final int readBytes(byte[] buf) {
        return this.stream.readBytes(buf, 0, buf.length);
    }

    public final int readBytes(byte[] buf, int start, int count) {
        return this.stream.readBytes(buf, start, count);
    }

    public String readCString() {
        int size = 0;
        while (true) {
            this.stream.readBytes(this.b, 0, 1);
            if (this.b[0] == 0) break;
            if (size == bytes.length) {
                byte[] temp = new byte[bytes.length + 16];
                Vm.copyArray(bytes, 0, temp, 0, size);
                bytes = temp;
            }
            DataStream.bytes[size++] = this.b[0];
        }
        return new String(Convert.charConverter.bytes2chars(bytes, 0, size));
    }

    public char readChar() {
        this.stream.readBytes(this.b, 0, 2);
        return (char)((this.b[0] & 0xFF) << 8 | this.b[1] & 0xFF);
    }

    public final char[] readChars() {
        int len = this.readUnsignedShort();
        char[] chars = new char[len];
        int i = 0;
        while (--len >= 0) {
            this.stream.readBytes(this.b, 0, 2);
            chars[i] = (char)((this.b[0] & 0xFF) << 8 | this.b[1] & 0xFF);
            ++i;
        }
        return chars;
    }

    public final double readDouble() {
        return Convert.longBitsToDouble(this.readLong());
    }

    public final float readFloat() {
        return Convert.toFloatBitwise(this.readInt());
    }

    public final int readInt() {
        this.stream.readBytes(this.b, 0, 4);
        return (this.b[0] & 0xFF) << 24 | (this.b[1] & 0xFF) << 16 | (this.b[2] & 0xFF) << 8 | this.b[3] & 0xFF;
    }

    public final int readIntLE() {
        this.stream.readBytes(this.b, 0, 4);
        return (this.b[3] & 0xFF) << 24 | (this.b[2] & 0xFF) << 16 | (this.b[1] & 0xFF) << 8 | this.b[0] & 0xFF;
    }

    public final long readLong() {
        long l1 = this.readInt();
        long l2 = this.readInt();
        long ll = (l1 << 32) + l2;
        if (l2 < 0L) {
            ll += 0x100000000L;
        }
        return ll;
    }

    public final short readShort() {
        this.stream.readBytes(this.b, 0, 2);
        return (short)((this.b[0] & 0xFF) << 8 | this.b[1] & 0xFF);
    }

    public final short readShortLE() {
        this.stream.readBytes(this.b, 0, 2);
        return (short)((this.b[1] & 0xFF) << 8 | this.b[0] & 0xFF);
    }

    public final String readString() {
        int len = this.readUnsignedShort();
        if (len == 0) {
            return "";
        }
        if (bytes.length < len) {
            bytes = new byte[len + 16];
        }
        this.readBytes(bytes, 0, len);
        return new String(Convert.charConverter.bytes2chars(bytes, 0, len));
    }

    public final String[] readStringArray() {
        int size = this.readUnsignedShort();
        String[] a = new String[size];
        int i = 0;
        while (i < size) {
            a[i] = this.readString();
            ++i;
        }
        return a;
    }

    public final int readUnsignedByte() {
        this.stream.readBytes(this.b, 0, 1);
        return this.b[0] & 0xFF;
    }

    public final int readUnsignedShort() {
        if (this.stream.readBytes(this.b, 0, 2) < 0) {
            return 0;
        }
        return (this.b[0] & 0xFF) << 8 | this.b[1] & 0xFF;
    }

    public final void skip(int n) {
        if (bytes.length < n) {
            bytes = new byte[n];
        }
        this.stream.readBytes(bytes, 0, n);
    }

    public final int writeBoolean(boolean bool) {
        this.b[0] = bool ? (byte)1 : 0;
        return this.stream.writeBytes(this.b, 0, 1);
    }

    public final int writeByte(byte by) {
        this.b[0] = by;
        return this.stream.writeBytes(this.b, 0, 1);
    }

    public final int writeByte(int by) {
        this.b[0] = (byte)(by & 0xFF);
        return this.stream.writeBytes(this.b, 0, 1);
    }

    public final int writeBytes(byte[] buf) {
        return this.stream.writeBytes(buf, 0, buf.length);
    }

    public final int writeBytes(byte[] buf, int start, int count) {
        return this.stream.writeBytes(buf, start, count);
    }

    public final int writeCString(String s) {
        if (s == null) {
            return this.writeByte(0);
        }
        int n = 0;
        char[] ac = s.toCharArray();
        byte[] c = Convert.charConverter.chars2bytes(ac, 0, ac.length);
        if (c.length <= Short.MAX_VALUE) {
            n += this.stream.writeBytes(c, 0, c.length);
        }
        return n += this.writeByte(0);
    }

    public int writeChar(char c) {
        this.b[1] = (byte)(c & 0xFF);
        c = (char)(c >> 8);
        this.b[0] = (byte)(c & 0xFF);
        return this.stream.writeBytes(this.b, 0, 2);
    }

    public final int writeChars(char[] chars, int start, int len) {
        if (len < 0) {
            int n = len = chars == null ? 0 : chars.length;
        }
        if ((len -= start) < 0 || len > Short.MAX_VALUE) {
            len = 0;
        }
        int n = this.writeShort(len);
        while (--len >= 0) {
            int c = chars[start++];
            this.b[1] = (byte)(c & 0xFF);
            this.b[0] = (byte)((c >>= 8) & 0xFF);
            n += this.stream.writeBytes(this.b, 0, 2);
        }
        return n;
    }

    public final int writeDouble(double d) {
        return this.writeLong(Convert.doubleToLongBits(d));
    }

    public final int writeFloat(float f) {
        return this.writeInt(Convert.toIntBitwise(f));
    }

    public final int writeInt(int i) {
        this.b[3] = (byte)(i & 0xFF);
        this.b[2] = (byte)((i >>= 8) & 0xFF);
        this.b[1] = (byte)((i >>= 8) & 0xFF);
        this.b[0] = (byte)((i >>= 8) & 0xFF);
        return this.stream.writeBytes(this.b, 0, 4);
    }

    public final int writeIntLE(int i) {
        this.b[0] = (byte)(i & 0xFF);
        this.b[1] = (byte)((i >>= 8) & 0xFF);
        this.b[2] = (byte)((i >>= 8) & 0xFF);
        this.b[3] = (byte)((i >>= 8) & 0xFF);
        return this.stream.writeBytes(this.b, 0, 4);
    }

    public final int writeLong(long l) {
        return this.writeInt((int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL)) + this.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    public final int writeShort(int i) {
        this.b[1] = (byte)(i & 0xFF);
        this.b[0] = (byte)((i >>= 8) & 0xFF);
        return this.stream.writeBytes(this.b, 0, 2);
    }

    public final int writeShortLE(int i) {
        this.b[0] = (byte)(i & 0xFF);
        this.b[1] = (byte)((i >>= 8) & 0xFF);
        return this.stream.writeBytes(this.b, 0, 2);
    }

    public final int writeString(String s) {
        int len;
        int n = 0;
        if (s != null && (len = s.length()) > 0 && len <= Short.MAX_VALUE) {
            char[] ac = s.toCharArray();
            byte[] c = Convert.charConverter.chars2bytes(ac, 0, ac.length);
            n += this.writeShort(c.length);
            n += this.stream.writeBytes(c, 0, c.length);
        } else {
            n += this.writeShort(0);
        }
        return n;
    }

    public final int writeStringArray(String[] v) {
        int n = 0;
        if (v == null || v.length == 0) {
            n += this.writeShort(0);
        } else {
            n += this.writeShort(v.length);
            int i = 0;
            while (i < v.length) {
                n += this.writeString(v[i]);
                ++i;
            }
        }
        return n;
    }
}

