/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.Stream;
import waba.sys.Settings;
import waba.sys.Vm;

public class ByteArrayStream
extends Stream {
    private int pos;
    private byte[] buffer;
    private int len;

    public ByteArrayStream(int size) {
        this(new byte[size]);
    }

    public ByteArrayStream(byte[] buffer) {
        this.buffer = buffer;
        if (buffer != null) {
            this.len = buffer.length;
        }
    }

    public int available() {
        return this.len - this.pos;
    }

    public boolean close() {
        return true;
    }

    public int count() {
        return this.pos;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] getCopy() {
        byte[] b = new byte[this.pos];
        Vm.copyArray(this.buffer, 0, b, 0, this.pos);
        return b;
    }

    public boolean isOpen() {
        return this.buffer != null;
    }

    public void mark() {
        this.len = this.pos;
        this.pos = 0;
    }

    public int readBytes(byte[] buf, int start, int count) {
        int remains = this.len - this.pos;
        if (count > remains) {
            if (remains <= 0) {
                return 0;
            }
            count = remains;
        }
        Vm.copyArray(this.buffer, this.pos, buf, start, count);
        this.pos += count;
        return count;
    }

    public void reset() {
        this.pos = 0;
        this.len = this.buffer.length;
    }

    public int reuse() {
        int shifted = this.pos;
        if (this.pos > 0) {
            Vm.copyArray(this.buffer, this.pos, this.buffer, 0, this.len - this.pos);
            this.pos = 0;
        }
        return shifted;
    }

    public void setPos(int newPos) {
        this.pos = newPos;
    }

    public void setSize(int newSize, boolean copyOldData) {
        if (this.len < newSize) {
            byte[] buf = this.buffer;
            this.buffer = new byte[newSize];
            this.len = this.buffer.length;
            if (copyOldData) {
                Vm.copyArray(buf, 0, this.buffer, 0, this.pos);
            }
        }
    }

    public int skipBytes(int count) {
        int off = this.pos + count;
        if (off < 0 || off > this.len) {
            return -1;
        }
        this.pos += count;
        return count;
    }

    public int writeBytes(byte[] buf, int start, int count) {
        if (this.len < count + this.pos) {
            int size = (count + this.pos) * 12 / 10;
            if (size > 65480 && Settings.onDevice) {
                size = 65480;
            }
            byte[] newBuffer = new byte[size];
            Vm.copyArray(this.buffer, 0, newBuffer, 0, this.pos);
            this.buffer = newBuffer;
            this.len = this.buffer.length;
        }
        Vm.copyArray(buf, start, this.buffer, this.pos, count);
        this.pos += count;
        return count;
    }
}

