/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import java.applet.AudioClip;
import java.io.FileInputStream;
import java.io.InputStream;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;
import waba.applet.Applet;
import waba.applet.JavaBridge;
import waba.applet.UserFont;
import waba.fx.Color;
import waba.fx.Font;
import waba.fx.FontMetrics;
import waba.fx.Graphics;
import waba.fx.Image;
import waba.fx.Palette;
import waba.fx.SoundClip;
import waba.fx.SoundClipEvent;
import waba.io.ByteArrayStream;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.util.ElementNotFoundError;
import waba.util.Hashtable;

public final class NativeMethods4JDK {
    static final int NO_TOUCHUP = 0;
    static final int BRITE_TOUCHUP = 1;
    static final int CTRST_TOUCHUP = 2;
    static final int CTRSTBRITE_TOUCHUP = 3;
    private static boolean doDither;
    private static int[] colorTable;
    private static int[] convPalette;
    private static int scale;
    private static int maxColorIndex;
    private static int baseIndex;
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static int[] default256Palette;
    private static boolean toneErrDisplayed;
    private static boolean soundEnabled;
    private static Hashtable htClips;

    static {
        toneErrDisplayed = false;
        soundEnabled = true;
        htClips = new Hashtable(10);
    }

    private static int GET_BLUE(int rgb) {
        return rgb & 0xFF;
    }

    private static int GET_GREEN(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    private static int GET_RED(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    private static void ImageLoadBMPCompressed(Image obj, byte[] p) {
        int maxColors = Settings.maxColors;
        boolean isColor = Settings.isColor;
        int displayBPP = Applet.bpp;
        if (p[0] != 66 || p[1] != 77) {
            JavaBridge.print("Error in Image: not a bmp file!");
            return;
        }
        int bitmapOffset = NativeMethods4JDK.inGetUint(p, 10);
        int infoSize = NativeMethods4JDK.inGetUint(p, 14);
        if (infoSize != 40) {
            JavaBridge.print("Error in Image: old style bmp");
            return;
        }
        obj.width = NativeMethods4JDK.inGetUint(p, 18);
        obj.height = NativeMethods4JDK.inGetUint(p, 22);
        if (obj.width > 65535 || obj.height > 65535 || obj.width <= 0 || obj.height <= 0) {
            JavaBridge.print("Error in Image: bad width/height");
            return;
        }
        int bmpBPP = NativeMethods4JDK.inGetUint16(p, 28);
        if (bmpBPP == 24) {
            JavaBridge.print("Error in Image: support for 24 bits bitmap was removed because the pics gets too large");
            return;
        }
        int compression = NativeMethods4JDK.inGetUint(p, 30);
        NativeMethods4JDK.inGetUint(p, 34);
        int usedColors = NativeMethods4JDK.inGetUint(p, 46);
        if (usedColors == 0) {
            usedColors = 1 << bmpBPP;
        }
        baseIndex = displayBPP >= 8 && usedColors == 16 ? 231 : 0;
        doDither = displayBPP < 8 && bmpBPP > displayBPP;
        boolean confirmDithering = displayBPP < 8;
        boolean storePalette = displayBPP >= 8 && !doDither;
        colorTable = new int[storePalette ? 256 : 1 << bmpBPP];
        if (storePalette && usedColors != 256) {
            Vm.copyArray(NativeMethods4JDK.getDefault256Palette(), 0, colorTable, 0, 256);
        }
        int i = 0;
        int j = 54;
        while (i < usedColors) {
            int color;
            NativeMethods4JDK.colorTable[NativeMethods4JDK.baseIndex + i] = color = NativeMethods4JDK.inGetUint(p, j) & 0xFFFFFF;
            if (confirmDithering && !doDither && (NativeMethods4JDK.GET_RED(color) != NativeMethods4JDK.GET_GREEN(color) || NativeMethods4JDK.GET_RED(color) != NativeMethods4JDK.GET_BLUE(color))) {
                doDither = true;
            }
            ++i;
            j += 4;
        }
        if (!isColor || doDither) {
            if (maxColors == 16) {
                convPalette = Palette.default16PaletteScr2Dev;
                scale = 4;
                maxColorIndex = 15;
            } else {
                convPalette = Palette.default4PaletteScr2Dev;
                scale = 6;
                maxColorIndex = 3;
            }
        }
        if (bmpBPP == 1 && colorTable[0] == 0xFFFFFF) {
            NativeMethods4JDK.colorTable[1] = 0xFFFFFF;
            NativeMethods4JDK.colorTable[0] = 0;
        }
        obj.pixels = new int[obj.height][obj.width];
        if (compression == 0) {
            NativeMethods4JDK.readRGB(obj, obj.width, obj.height, bmpBPP, p, bitmapOffset);
        } else {
            NativeMethods4JDK.readRLE(obj, obj.height, p, bitmapOffset, compression == 1);
        }
        if (isColor) {
            obj.palRGBs = colorTable;
        }
    }

    static void computeContrastTable(byte[] table, byte level) {
        double factor;
        int i = 0;
        if (level < 0) {
            if ((level = (byte)(level + 127)) <= 0) {
                level = 1;
            }
            factor = (double)level / 127.0;
        } else {
            if ((level = (byte)(127 - level)) <= 0) {
                level = 1;
            }
            factor = 127.0 / (double)level;
        }
        do {
            byte v;
            table[i] = v = (byte)((int)(127.0 * Math.pow((double)i / 127.0, factor)) & 0xFF);
            table[255 - i] = (byte)(255 - v);
        } while (++i < 128);
    }

    private static int convertToGray(int x, int y, int index) {
        int rgb = colorTable[index];
        int r = NativeMethods4JDK.GET_RED(rgb);
        int g = NativeMethods4JDK.GET_GREEN(rgb);
        int b = NativeMethods4JDK.GET_BLUE(rgb);
        int med = (r + g + b) / 3;
        int ind = med >> scale;
        return maxColorIndex - ind;
    }

    static void fontCreate(Font obj) {
    }

    static void fontMetricsCreate(FontMetrics obj) {
        UserFont uf = JavaBridge.getFontMetrics(obj.font);
        if (uf != null) {
            obj.ascent = uf.ascent;
            obj.descent = uf.descent;
            obj.leading = uf.leading;
        }
    }

    static int fontMetricsGetCharWidth(FontMetrics obj, char c) {
        return JavaBridge.getFontMetrics(obj.font).charWidth(c);
    }

    static int fontMetricsGetTextWidth(FontMetrics obj, String s) {
        return JavaBridge.getFontMetrics(obj.font).stringWidth(s);
    }

    static int fontMetricsGetTextWidth(FontMetrics obj, char[] chars, int start, int count) {
        return NativeMethods4JDK.fontMetricsGetTextWidth(obj, new String(chars, start, count));
    }

    static int[] getDefault256Palette() {
        if (default256Palette == null) {
            int[] palAux = new int[]{0x111111, 0x222222, 0x444444, 0x555555, 0x777777, 0x888888, 0xAAAAAA, 0xBBBBBB, 0xDDDDDD, 0xEEEEEE, 0xC0C0C0, 0x800000, 0x800080, 32768, 32896};
            int i = 0;
            int[] newpal = new int[256];
            int[] nArray = new int[6];
            nArray[1] = 51;
            nArray[2] = 102;
            nArray[3] = 153;
            nArray[4] = 204;
            nArray[5] = 255;
            int[] samples = nArray;
            int[] nArray2 = new int[6];
            nArray2[1] = 13056;
            nArray2[2] = 26112;
            nArray2[3] = 39168;
            nArray2[4] = 52224;
            nArray2[5] = 65280;
            int[] samples8 = nArray2;
            int[] nArray3 = new int[6];
            nArray3[1] = 0x330000;
            nArray3[2] = 0x660000;
            nArray3[3] = 0x990000;
            nArray3[4] = 0xCC0000;
            nArray3[5] = 0xFF0000;
            int[] samples16 = nArray3;
            int[] nArray4 = new int[6];
            nArray4[0] = 120;
            nArray4[1] = 114;
            nArray4[2] = 108;
            nArray4[3] = 12;
            nArray4[4] = 6;
            int[] steps = nArray4;
            int r = 5;
            while (r >= 0) {
                int g = 5;
                while (g >= 0) {
                    int b = 5;
                    while (b >= 0) {
                        newpal[i + steps[b]] = samples16[r] | samples8[g] | samples[b];
                        --b;
                    }
                    --g;
                    ++i;
                }
                --r;
                i += 12;
            }
            Vm.copyArray(palAux, 0, newpal, 215, 15);
            newpal[255] = 393219;
            default256Palette = newpal;
        }
        return default256Palette;
    }

    private static int getUnsignedByte(byte b) {
        return b & 0xFF;
    }

    static void imageChangeColors(Image obj, int fromR, int fromG, int fromB, int toR, int toG, int toB) {
        int nx = obj.pixels[0].length;
        int ny = obj.pixels.length;
        int cf = Color.getColor(fromR, fromG, fromB).getRGB();
        int ct = Color.getColor(toR, toG, toB).getRGB();
        int x = 0;
        while (x < nx) {
            int y = 0;
            while (y < ny) {
                if (obj.pixels[y][x] == cf) {
                    obj.pixels[y][x] = ct;
                }
                ++y;
            }
            ++x;
        }
    }

    static void imageCreate(Image obj) {
        obj.pixels = new int[obj.height][obj.width];
    }

    static void imageFree(Image obj) {
        obj.height = 0;
        obj.width = 0;
        obj.pixels = null;
    }

    static void imageGetPixelRow(Image obj, byte[] fillIn, int y) {
        int x = 0;
        while (x < obj.width) {
            fillIn[x] = (byte)obj.savingPal.getColorIndex(Color.getColor(obj.pixels[y][x]));
            ++x;
        }
    }

    static Image imageGetRotatedScaledInstance(Image obj, int scale, int angle, Color fill) {
        int cosine;
        int rawCosine;
        int rawSine;
        int sine;
        int backColor;
        int n = backColor = fill == null ? obj.transparentPixel : Palette.SystemPalette.getColorIndex(fill);
        if ((angle %= 360) % 90 == 0) {
            if (angle < 0) {
                angle += 360;
            }
            switch (angle) {
                case 0: {
                    sine = 0;
                    rawSine = 0;
                    rawCosine = 65536;
                    cosine = 0x640000 / scale;
                    break;
                }
                case 90: {
                    rawSine = 65536;
                    cosine = 0;
                    rawCosine = 0;
                    sine = 0x640000 / scale;
                    break;
                }
                case 180: {
                    sine = 0;
                    rawSine = 0;
                    rawCosine = -65536;
                    cosine = -6553600 / scale;
                    break;
                }
                default: {
                    rawSine = -65536;
                    cosine = 0;
                    rawCosine = 0;
                    sine = -6553600 / scale;
                    break;
                }
            }
        } else {
            double rad = (double)angle * 0.0174532925;
            rawSine = (int)(Math.sin(rad) * 65536.0);
            rawCosine = (int)(Math.cos(rad) * 65536.0);
            sine = rawSine * 100 / scale;
            cosine = rawCosine * 100 / scale;
        }
        int hIn = obj.height;
        int wIn = obj.width;
        int[] cornersX = new int[3];
        int[] cornersY = new int[3];
        int xMin = 0;
        int yMin = 0;
        int xMax = 0;
        int yMax = 0;
        cornersX[0] = wIn * rawCosine >> 16;
        cornersY[0] = wIn * rawSine >> 16;
        cornersX[2] = -hIn * rawSine >> 16;
        cornersY[2] = hIn * rawCosine >> 16;
        cornersX[1] = cornersX[0] + cornersX[2];
        cornersY[1] = cornersY[0] + cornersY[2];
        int i = 2;
        while (i >= 0) {
            if (cornersX[i] < xMin) {
                xMin = cornersX[i];
            } else if (cornersX[i] > xMax) {
                xMax = cornersX[i];
            }
            if (cornersY[i] < yMin) {
                yMin = cornersY[i];
            } else if (cornersY[i] > yMax) {
                yMax = cornersY[i];
            }
            --i;
        }
        int wOut = (xMax - xMin) * scale / 100;
        int hOut = (yMax - yMin) * scale / 100;
        Image imageOut = new Image(wOut, hOut);
        if (imageOut == null) {
            return null;
        }
        int x0 = ((wIn << 16) - ((xMax - xMin) * rawCosine - (yMax - yMin) * rawSine) - 1) / 2;
        int y0 = ((hIn << 16) - ((xMax - xMin) * rawSine + (yMax - yMin) * rawCosine) - 1) / 2;
        int[][] pixelsIn = obj.pixels;
        int l = 0;
        while (l < hOut) {
            int x = x0;
            int y = y0;
            int[] lineOut = imageOut.pixels[l];
            int iOut = 0;
            int i2 = wOut;
            while (--i2 >= 0) {
                int u = x >> 16;
                int v = y >> 16;
                lineOut[iOut++] = u >= 0 && u < wIn && v >= 0 && v < hIn ? pixelsIn[v][u] : backColor;
                x += cosine;
                y += sine;
            }
            x0 -= sine;
            y0 += cosine;
            ++l;
        }
        return imageOut;
    }

    static Image imageGetScaledInstance(Image obj, int newWidth, int newHeight) {
        int h = newHeight << 1;
        int hi = obj.height << 1;
        int hf = obj.height / h;
        int wf = 0;
        int w = newWidth << 1;
        int wi = obj.width << 1;
        Image scaledImage = new Image(newWidth, newHeight);
        scaledImage.palRGBs = obj.palRGBs;
        int[][] dstImageData = scaledImage.pixels;
        int[][] srcImageData = obj.pixels;
        int y = 0;
        while (y < newHeight) {
            wf = obj.width / w;
            int[] dstImageY = dstImageData[y];
            int[] srcImageY = srcImageData[hf / h];
            int x = 0;
            while (x < newWidth) {
                dstImageY[x] = srcImageY[wf / w];
                ++x;
                wf += wi;
            }
            ++y;
            hf += hi;
        }
        return scaledImage;
    }

    /*
     * Exception decompiling
     */
    static Image imageGetTouchedUpInstance(Image obj, byte brightness, byte contrast) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void imageLoad(Image obj, String path) {
        byte[] bytes = JavaBridge.readBytes(path);
        if (bytes == null) {
            ByteArrayStream bas = null;
            try {
                bas = (ByteArrayStream)waba.sys.NativeMethods4JDK.htAttachedFiles.get(path.toLowerCase());
            }
            catch (ElementNotFoundError elementNotFoundError) {}
            if (bas != null) {
                bytes = bas.getBuffer();
            } else {
                JavaBridge.print("ERROR: can't open image file " + path);
                return;
            }
        }
        try {
            NativeMethods4JDK.ImageLoadBMPCompressed(obj, bytes);
        }
        catch (Exception e) {
            JavaBridge.print("ERROR: when loading Image " + path + ". Trace appears below.");
            e.printStackTrace();
        }
    }

    static void imageParse(Image obj, byte[] fullBmpDescription) {
        try {
            NativeMethods4JDK.ImageLoadBMPCompressed(obj, fullBmpDescription);
        }
        catch (Exception e) {
            JavaBridge.print("ERROR: when parsing Image with " + fullBmpDescription.length + " bytes. Trace appears below.");
            e.printStackTrace();
        }
    }

    private static int inGetUint(byte[] bytes, int off) {
        return (bytes[off + 3] & 0xFF) << 24 | (bytes[off + 2] & 0xFF) << 16 | (bytes[off + 1] & 0xFF) << 8 | bytes[off] & 0xFF;
    }

    private static int inGetUint16(byte[] bytes, int off) {
        return (bytes[off + 1] & 0xFF) << 8 | bytes[off] & 0xFF;
    }

    static int[] paletteGetCurrentPalette(Palette obj) {
        return Graphics.currentPalette;
    }

    private static void readRGB(Image obj, int width, int height, int bpp, byte[] in, int offset) {
        JavaBridge.print("reading " + (doDither ? "and dithering " : "") + "rgb " + bpp + "bpp");
        int pixelsPerByte = 8 / bpp;
        int bitMask = (1 << bpp) - 1;
        int[] bitShifts = new int[8];
        int whichBit = 0;
        int div = 32 / bpp;
        width = (width + div - 1) / div * div;
        int i = 0;
        while (i < pixelsPerByte) {
            bitShifts[i] = 8 - (i + 1) * bpp;
            ++i;
        }
        if (pixelsPerByte == 1) {
            int h = height - 1;
            while (h >= 0) {
                int w = 0;
                while (w < width) {
                    NativeMethods4JDK.setRGB32(obj, w, h, NativeMethods4JDK.getUnsignedByte(in[offset++]));
                    ++w;
                }
                --h;
            }
        } else {
            int currByte = NativeMethods4JDK.getUnsignedByte(in[offset++]);
            int h = height - 1;
            while (h >= 0) {
                int w = 0;
                while (w < width) {
                    NativeMethods4JDK.setRGB32(obj, w, h, currByte >> bitShifts[whichBit] & bitMask);
                    if (++whichBit >= pixelsPerByte) {
                        whichBit = 0;
                        if (offset < in.length) {
                            currByte = NativeMethods4JDK.getUnsignedByte(in[offset++]);
                        }
                    }
                    ++w;
                }
                --h;
            }
        }
    }

    private static void readRLE(Image obj, int height, byte[] in, int offset, boolean rle8) {
        int colors0 = 0;
        int colors1 = 0;
        int x = 0;
        int y = height - 1;
        JavaBridge.print("reading " + (doDither ? "and converting " : "") + (rle8 ? "rle8" : "rle4"));
        block5: while (true) {
            int len;
            int val;
            int esc;
            if ((esc = NativeMethods4JDK.getUnsignedByte(in[offset++])) != 0) {
                if (rle8) {
                    colors0 = NativeMethods4JDK.getUnsignedByte(in[offset++]);
                    while (true) {
                        if (esc-- <= 0) continue block5;
                        NativeMethods4JDK.setRGB32(obj, x++, y, colors0);
                    }
                }
                val = NativeMethods4JDK.getUnsignedByte(in[offset++]);
                colors0 = val >> 4 & 0xF;
                colors1 = val & 0xF;
                len = 1;
                while (true) {
                    if (len > esc) continue block5;
                    NativeMethods4JDK.setRGB32(obj, x++, y, (len & 1) == 1 ? colors0 : colors1);
                    ++len;
                }
            }
            esc = NativeMethods4JDK.getUnsignedByte(in[offset++]);
            switch (esc) {
                case 0: {
                    x = 0;
                    --y;
                    continue block5;
                }
                case 1: {
                    return;
                }
                case 2: {
                    x += NativeMethods4JDK.getUnsignedByte(in[offset++]);
                    y -= NativeMethods4JDK.getUnsignedByte(in[offset++]);
                    continue block5;
                }
            }
            if (rle8) {
                len = esc;
                while (len-- > 0) {
                    NativeMethods4JDK.setRGB32(obj, x++, y, NativeMethods4JDK.getUnsignedByte(in[offset++]));
                }
                if ((esc & 1) == 0) continue;
                ++offset;
                continue;
            }
            len = 1;
            while (len <= esc) {
                if ((len & 1) == 1) {
                    val = NativeMethods4JDK.getUnsignedByte(in[offset++]);
                    colors0 = val >> 4 & 0xF;
                    colors1 = val & 0xF;
                    NativeMethods4JDK.setRGB32(obj, x++, y, colors0);
                } else {
                    NativeMethods4JDK.setRGB32(obj, x++, y, colors1);
                }
                ++len;
            }
            if ((esc + 1 >> 1 & 1) == 0) continue;
            ++offset;
        }
    }

    private static final void setRGB32(Image obj, int x, int y, int rgb) {
        if (x < obj.width) {
            obj.pixels[y][x] = doDither ? convPalette[NativeMethods4JDK.convertToGray(x, y, rgb)] : colorTable[baseIndex + rgb];
        }
    }

    static void soundBeep() {
        if (soundEnabled) {
            JavaBridge.beep();
        }
    }

    static void soundClipFree(SoundClip obj) {
        if (obj.loaded) {
            try {
                htClips.remove(obj);
            }
            catch (ElementNotFoundError elementNotFoundError) {}
            obj.loaded = false;
        }
    }

    static boolean soundClipPause(SoundClip obj, boolean enable) {
        throw new RuntimeException("not supported");
    }

    static boolean soundClipPlay(SoundClip obj, boolean wait) {
        Object audioClip = null;
        Applet applet = Applet.currentApplet;
        if (!obj.loaded) {
            try {
                audioClip = !applet.isApplication ? applet.getAudioClip(applet.getCodeBase(), obj.path) : new AudioStream((InputStream)new FileInputStream(obj.path));
                if (audioClip != null) {
                    htClips.put(obj, audioClip);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            obj.loaded = true;
        }
        try {
            audioClip = htClips.get(obj);
        }
        catch (ElementNotFoundError elementNotFoundError) {}
        if (audioClip == null) {
            return false;
        }
        obj.onEvent(new SoundClipEvent(550, obj));
        if (!applet.isApplication) {
            ((AudioClip)audioClip).play();
        } else {
            AudioPlayer.player.start((InputStream)((AudioStream)audioClip));
        }
        return true;
    }

    static boolean soundClipStop(SoundClip obj) {
        Object audioClip = null;
        try {
            audioClip = htClips.get(obj);
        }
        catch (ElementNotFoundError elementNotFoundError) {}
        if (audioClip == null) {
            return false;
        }
        if (!Applet.currentApplet.isApplication) {
            ((AudioClip)audioClip).stop();
        } else {
            AudioPlayer.player.stop((InputStream)((AudioStream)audioClip));
        }
        obj.onEvent(new SoundClipEvent(551, obj));
        return true;
    }

    static void soundSetEnabled(boolean on) {
        soundEnabled = on;
    }

    static void soundTone(int freq, int duration) {
        if (!toneErrDisplayed) {
            NativeMethods4JDK.soundBeep();
            JavaBridge.print("NOTICE: tones aren't supported under Java");
            toneErrDisplayed = true;
        }
    }
}

