/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.ISurface;
import waba.fx.ImageError;
import waba.fx.NativeMethods4JDK;
import waba.fx.Palette;
import waba.io.Catalog;
import waba.io.DataStream;
import waba.io.IOError;
import waba.io.ResizeRecord;
import waba.io.Stream;
import waba.sys.Settings;

public class Image
implements ISurface {
    protected int width;
    protected int height;
    public int transparentPixel = Color.WHITE_PIXEL;
    public int[] palRGBs;
    protected Palette savingPal;
    public int[][] pixels;
    public Color transparentColor = Color.WHITE;
    private static int[] rgbs8bpp;

    protected Image() {
    }

    public Image(int width, int height) {
        this.width = width;
        this.height = height;
        NativeMethods4JDK.imageCreate(this);
    }

    public Image(String path) {
        NativeMethods4JDK.imageLoad(this, path);
        if (this.width == 0 && Settings.useExceptions) {
            throw new ImageError("Could not load image, file not found: " + path);
        }
    }

    public Image(byte[] fullBmpDescription) {
        NativeMethods4JDK.imageParse(this, fullBmpDescription);
        if (this.width == 0 && Settings.useExceptions) {
            throw new ImageError(fullBmpDescription == null ? "Description is null" : "Error on bmp with " + fullBmpDescription.length + " bytes length description");
        }
    }

    public void applyPalette() {
        if (this.palRGBs != null) {
            Graphics._applyPalette(this.palRGBs, 0, this.palRGBs.length - 1);
        }
    }

    public void changeColors(Color from, Color to) {
        NativeMethods4JDK.imageChangeColors(this, from.red, from.green, from.blue, to.red, to.green, to.blue);
    }

    public int createBmp(DataStream ds) {
        boolean use8bppEmulation;
        boolean bl = use8bppEmulation = Settings.maxColors < 256 && Settings.platform.startsWith("PalmOS") && Settings.romVersion >= 0x5000000;
        int bpp = use8bppEmulation || Settings.maxColors >= 256 ? 8 : (Settings.maxColors == 16 ? 4 : 2);
        int div = 32 / bpp;
        int rowW = (this.width + div - 1) / div * div;
        int headerSize = 54;
        int[] rgbs = use8bppEmulation ? (rgbs8bpp != null ? rgbs8bpp : (rgbs8bpp = new Palette(256).toRGBArray(-1, -1))) : (bpp >= 8 && this.palRGBs != null ? this.palRGBs : Palette.getDeviceRGBs());
        int ncolors = rgbs.length;
        int paletteSize = ncolors * 4;
        int dataSize = rowW / (8 / bpp) * this.height;
        int totalSize = headerSize + paletteSize + dataSize;
        ds.writeByte(66);
        ds.writeByte(77);
        ds.writeIntLE(totalSize);
        ds.writeIntLE(0);
        ds.writeIntLE(headerSize + paletteSize);
        ds.writeIntLE(40);
        ds.writeIntLE(this.width);
        ds.writeIntLE(this.height);
        ds.writeShortLE(1);
        ds.writeShortLE(bpp);
        ds.writeIntLE(0);
        ds.writeIntLE(dataSize);
        ds.writeIntLE(2835);
        ds.writeIntLE(2835);
        ds.writeIntLE(rgbs.length);
        ds.writeIntLE(rgbs.length);
        if (!Settings.onDevice) {
            this.savingPal = new Palette(rgbs);
        }
        int i = 0;
        while (i < rgbs.length) {
            ds.writeIntLE(rgbs[i]);
            ++i;
        }
        byte[] row = new byte[rowW];
        dataSize = 0;
        switch (ncolors) {
            case 16: {
                int y = this.height - 1;
                while (y >= 0) {
                    this.getPixelRow(row, y);
                    int i2 = 0;
                    while (i2 < rowW) {
                        row[i2 >> 1] = (byte)(row[i2] << 4 | row[i2 + 1]);
                        i2 += 2;
                    }
                    ds.writeBytes(row, 0, rowW >> 1);
                    --y;
                }
                break;
            }
            case 4: {
                int y = this.height - 1;
                while (y >= 0) {
                    this.getPixelRow(row, y);
                    int i3 = 0;
                    while (i3 < rowW) {
                        row[i3 >> 2] = (byte)(row[i3] << 6 | row[i3 + 1] << 4 | row[i3 + 2] << 2 | row[i3 + 3]);
                        i3 += 4;
                    }
                    ds.writeBytes(row, 0, rowW >> 2);
                    --y;
                }
                break;
            }
            default: {
                int y = this.height - 1;
                while (y >= 0) {
                    this.getPixelRow(row, y);
                    dataSize += ds.writeBytes(row, 0, rowW);
                    --y;
                }
                break block0;
            }
        }
        return totalSize;
    }

    public void free() {
        NativeMethods4JDK.imageFree(this);
    }

    public Graphics getGraphics() {
        return new Graphics(this);
    }

    public int getHeight() {
        return this.height;
    }

    public Palette getPalette() {
        return this.palRGBs != null ? new Palette(this.palRGBs) : null;
    }

    protected void getPixelRow(byte[] fillIn, int y) {
        NativeMethods4JDK.imageGetPixelRow(this, fillIn, y);
    }

    public Image getRotatedScaledInstance(int scale, int angle, Color fill) {
        if (scale <= 0) {
            scale = 1;
        }
        if (fill == null && this.transparentPixel < 0) {
            fill = Color.WHITE;
        }
        return NativeMethods4JDK.imageGetRotatedScaledInstance(this, scale, angle, fill);
    }

    public Image getScaledInstance(int newWidth, int newHeight) {
        return newWidth == this.width && newHeight == this.height ? this : NativeMethods4JDK.imageGetScaledInstance(this, newWidth, newHeight);
    }

    public Image getTouchedUpInstance(byte brightness, byte contrast) {
        return NativeMethods4JDK.imageGetTouchedUpInstance(this, brightness, contrast);
    }

    public Color getTransparentColor() {
        if (this.transparentPixel < 0) {
            return null;
        }
        if (Settings.isHighColor) {
            return Color.getColor(this.transparentPixel);
        }
        Palette pal = this.palRGBs == null ? Palette.SystemPalette : new Palette(this.palRGBs);
        return pal.getColor(this.transparentPixel);
    }

    public int getWidth() {
        return this.width;
    }

    public void load(Stream inputStream) {
    }

    public int saveTo(Catalog cat, String name) {
        if (!(name = name.toLowerCase()).endsWith(".bmp")) {
            name = String.valueOf(name) + ".bmp";
        }
        int n = cat.getRecordCount();
        int index = -1;
        DataStream ds = new DataStream(cat);
        int i = 0;
        while (i < n) {
            try {
                String recName;
                if (cat.setRecordPos(i) && (recName = ds.readString()).compareTo(name) >= 0) {
                    if (name.equals(recName)) {
                        cat.deleteRecord();
                    }
                    index = i;
                    break;
                }
            }
            catch (IOError iOError) {}
            ++i;
        }
        if (index == -1) {
            index = n;
        }
        ResizeRecord rs = new ResizeRecord(cat, this.width * this.height + 1200);
        ds = new DataStream(rs);
        try {
            if (rs.startRecord(index)) {
                ds.writeString(name);
                n = this.createBmp(ds);
                rs.endRecord();
            } else {
                n = 0;
            }
        }
        catch (IOError iOError) {
            n = 0;
        }
        return n;
    }

    public Image scaledBy(float scaleX, float scaleY) {
        return scaleX == 1.0f && scaleY == 1.0f || scaleX <= 0.0f || scaleY <= 0.0f ? this : NativeMethods4JDK.imageGetScaledInstance(this, (int)((float)this.width * scaleX), (int)((float)this.height * scaleY));
    }

    public void setPalette(Palette pal) {
        this.palRGBs = pal.toRGBArray(-1, -1);
    }

    public void setTransparentColor(Color c) {
        if (c == null) {
            this.transparentPixel = -1;
        } else if (Settings.isHighColor) {
            this.transparentPixel = c.rgb;
        } else {
            Palette pal = this.palRGBs == null ? Palette.SystemPalette : new Palette(this.palRGBs);
            this.transparentPixel = pal.getColorIndex(c);
        }
        this.transparentColor = c;
    }
}

