/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.FontMetrics;
import waba.fx.NativeMethods4JDK;
import waba.util.ElementNotFoundError;
import waba.util.Hashtable;

public final class Font {
    public String name;
    public int style;
    public int size;
    Object hvUserFont;
    public FontMetrics fm;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int BIG_SIZE = 14;
    public static final int NORMAL_SIZE = 9;
    public static final String DEFAULT = "SW";
    private static Hashtable htFonts = new Hashtable(13);
    private static StringBuffer sb = new StringBuffer(30);

    public Font(String name, int style, int size) {
        Font f = Font.getFont(name, style == 1, size);
        if (f != this) {
            this.style = f.style;
            this.size = f.size;
            this.hvUserFont = f.hvUserFont;
            this.fm = f.fm;
            this.name = f.name;
        }
    }

    private Font(String name, boolean boldStyle, int size) {
        this.name = name;
        this.style = boldStyle ? 1 : 0;
        this.size = size;
        NativeMethods4JDK.fontCreate(this);
        this.fm = new FontMetrics(this, true);
    }

    public Font asBold() {
        return Font.getFont(this.name, true, this.size);
    }

    public static Font getFont(String name, boolean boldStyle, int size) {
        sb.setLength(0);
        String key = sb.append(name).append('|').append(boldStyle).append('|').append(size).toString();
        Font f = null;
        try {
            f = (Font)htFonts.get(key);
        }
        catch (ElementNotFoundError elementNotFoundError) {}
        if (f == null) {
            f = new Font(name, boldStyle, size);
            htFonts.put(key, f);
        }
        return f;
    }
}

