/*
 * Decompiled with CFR 0.152.
 */
package waba.applet;

import waba.applet.UserFont;
import waba.io.Catalog;
import waba.io.DataStream;
import waba.io.IOError;
import waba.sys.Settings;

public class UffUserFont
extends UserFont {
    public static final String UFF_NAMEPREFIX = "UFF";
    public static final String UFF_CREATORID = "UFFo";
    public static final String UFF_TYPEID = "DATA";
    String catalogName;
    public short nParts;
    public short[] recNo;
    public int[] uffFirstChar;
    public int[] uffLastChar;
    public UserFontRange[] ranges;
    public int recentRangeIndex;
    public int recentFirstChar;
    public int recentLastChar;

    public UffUserFont(String fontName) {
        if (fontName.charAt(fontName.length() - 2) != '_') {
            fontName = String.valueOf(fontName) + "_" + (Settings.screenWidth == 160 ? "L" : "H");
        }
        this.catalogName = String.valueOf(fontName) + "." + UFF_CREATORID + "." + UFF_TYPEID;
        Catalog c = new Catalog(this.catalogName, 1);
        if (c.isOpen()) {
            DataStream ds = new DataStream(c);
            try {
                c.setRecordPos(0);
                ds.readShort();
                ds.readString();
                ds.readShort();
                ds.readShort();
                ds.readString();
                this.fontType = ds.readShort();
                this.maxWidth = ds.readShort();
                this.kernMax = ds.readShort();
                this.nDescent = ds.readShort();
                this.fRectWidth = ds.readShort();
                this.fRectHeight = ds.readShort();
                this.ascent = ds.readShort();
                this.descent = ds.readShort();
                this.leading = ds.readShort();
                this.nParts = ds.readShort();
                this.recNo = new short[this.nParts];
                this.uffFirstChar = new int[this.nParts];
                this.uffLastChar = new int[this.nParts];
                this.ranges = new UserFontRange[this.nParts];
                int index = 0;
                while (index < this.nParts) {
                    this.recNo[index] = ds.readShort();
                    this.uffFirstChar[index] = ds.readInt();
                    this.uffLastChar[index] = ds.readInt();
                    ++index;
                }
            }
            catch (IOError iOError) {}
            c.close();
            this.loaded = true;
        }
    }

    public int charWidth(char ch) {
        int rindex = this.ensureRange(ch);
        if (rindex == -1) {
            return this.maxWidth >> 1;
        }
        UserFontRange range = this.ranges[rindex];
        int index = ch - this.recentFirstChar;
        int offset = range.bitIndexTable[index];
        return range.bitIndexTable[index + 1] - offset;
    }

    private int ensureRange(char ch) {
        if (ch <= this.recentLastChar && ch >= this.recentFirstChar) {
            return this.recentRangeIndex;
        }
        int rindex = -1;
        int low = 0;
        int hi = this.nParts - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            if (ch >= this.uffFirstChar[mid] && ch <= this.uffLastChar[mid]) {
                rindex = mid;
                break;
            }
            if (ch < this.uffFirstChar[mid]) {
                hi = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        if (rindex != -1) {
            if (this.ranges[rindex] == null) {
                Catalog c = new Catalog(this.catalogName, 1);
                if (c.isOpen()) {
                    DataStream ds = new DataStream(c);
                    UserFontRange range = this.ranges[rindex] = new UserFontRange();
                    try {
                        c.setRecordPos(this.recNo[rindex]);
                        range.rowWIB = ds.readInt();
                        int size = range.rowWIB * this.fRectHeight;
                        range.bitmapTable = new byte[size];
                        ds.readBytes(range.bitmapTable, 0, size);
                        size = this.uffLastChar[rindex] - this.uffFirstChar[rindex] + 1 + 1;
                        range.bitIndexTable = new int[size];
                        int i = 0;
                        while (i < size) {
                            range.bitIndexTable[i] = ds.readInt();
                            ++i;
                        }
                    }
                    catch (IOError iOError) {}
                    c.close();
                } else {
                    return -1;
                }
            }
            this.recentFirstChar = this.uffFirstChar[rindex];
            this.recentLastChar = this.uffLastChar[rindex];
            this.recentRangeIndex = rindex;
        }
        return rindex;
    }

    public void setCharBits(char ch, UserFont.CharBits bits) {
        int rindex = this.ensureRange(ch);
        if (rindex == -1 && ch != '\ufffd') {
            ch = (char)65533;
            rindex = this.ensureRange(ch);
        }
        if (rindex == -1 && ch != '\u0000') {
            ch = '\u0000';
            rindex = this.ensureRange(ch);
        }
        if (rindex == -1) {
            bits.width = 0;
        } else {
            int cindex = ch - this.recentFirstChar;
            UserFontRange range = this.ranges[rindex];
            bits.offset = range.bitIndexTable[cindex];
            bits.width = range.bitIndexTable[cindex + 1] - bits.offset;
            if (bits.width != 0) {
                bits.rowWIB = range.rowWIB;
                bits.charBitmapTable = range.bitmapTable;
            }
        }
    }

    public static class UserFontRange {
        public int rowWIB;
        public byte[] bitmapTable;
        public int[] bitIndexTable;
    }
}

