/*
 * Decompiled with CFR 0.152.
 */
package waba.applet;

import waba.applet.Queue;
import waba.applet.SWEvent;
import waba.ui.Event;
import waba.ui.MainWindow;

class SWEventThread
implements Runnable {
    protected MainWindow _win;
    protected static Queue _eventQueue;
    protected int _timerTickEvent;
    protected static int _invokeInEventThread;
    protected Thread _thread;

    static {
        _invokeInEventThread = Event.getNextAvailableEventId();
    }

    public SWEventThread(MainWindow win) {
        this._win = win;
        _eventQueue = new Queue();
    }

    public boolean eventAvailable() {
        return _eventQueue.getSize() > 0;
    }

    public Thread getThread() {
        return this._thread;
    }

    public void handleOneEvent() {
        SWEvent event = (SWEvent)_eventQueue.popWait(100);
        if (event != null) {
            if (event.type == _invokeInEventThread) {
                event.r.run();
                if (event.synch != null) {
                    Object object = event.synch;
                    synchronized (object) {
                        event.synch.notify();
                    }
                }
            } else {
                this._win._postEvent(event.type, event.key, event.x, event.y, event.modifiers, event.timestamp);
            }
        }
    }

    public void invokeInEventThread(boolean wait, Runnable r) {
        if (!wait) {
            _eventQueue.push(new SWEvent(_invokeInEventThread, r));
        } else {
            Thread current = Thread.currentThread();
            if (current.equals(this._thread)) {
                r.run();
            } else {
                Object synch;
                Object object = synch = new Object();
                synchronized (object) {
                    _eventQueue.push(new SWEvent(_invokeInEventThread, r, synch));
                    try {
                        synch.wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void pushEvent(int type, int key, int x, int y, int modifiers, int timestamp) {
        _eventQueue.push(new SWEvent(type, key, x, y, modifiers, timestamp));
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.handleOneEvent();
                }
            }
            catch (Throwable t) {
                System.out.println("---------------------------");
                System.out.println(">>>>>>> CAUGHT UNHANDLED EXCEPTION IN SuperWaba EVENT THREAD:");
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void setThread(Thread thread) {
        this._thread = thread;
    }
}

